#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Memoranda
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250228.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='memoranda'
GAME_NAME='Memoranda'

ARCHIVE_BASE_0_NAME='gog_memoranda_2.2.0.3.sh'
ARCHIVE_BASE_0_MD5='9671ebb592d4b4a028fd80f76e96c1a1'
ARCHIVE_BASE_0_SIZE='800000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.2.0.3'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/memoranda'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES='
runner'
CONTENT_GAME_DATA_FILES='
assets'

APP_MAIN_EXE='runner'
APP_MAIN_ICON='assets/icon.png'
## Work around a Mesa-related startup crash
## cf. https://gitlab.freedesktop.org/mesa/mesa/issues/1310
APP_MAIN_PRERUN='
# Work around a Mesa-related startup crash
# cf. https://gitlab.freedesktop.org/mesa/mesa/issues/1310
export radeonsi_sync_compile=true
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libssl.so.1.0.0
libstdc++.so.6
libX11.so.6
libXext.so.6
libXrandr.so.2
libXxf86vm.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Build a 512×512 icon from the 1024×1024 provided one

REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
convert"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

## Build a 512×512 icon from the 1024×1024 provided one
APP_MAIN_ICONS_LIST="$(application_icons_list 'APP_MAIN') APP_MAIN_ICON_512"
APP_MAIN_ICON_512='assets/icon_512.png'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	convert "$APP_MAIN_ICON" -resize 512 "$APP_MAIN_ICON_512"
)

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
