/*
 * Copyright (c) 2025 Aurélien Berthier
 * <aurelien.berthier@ls2n.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "pappsomspp/core/protein/protein.h"
#include "pappsomspp/core/amino_acid/aacode.h"

namespace pappso
{
namespace specpeptidoms
{

struct SpOMSAa
{
  std::uint8_t code;
  pappso::Enums::AminoAcidChar aa;
  double mass;
};

class SpOMSProtein : public std::vector<SpOMSAa>
{
  public:
  SpOMSProtein(const QString &description, const QString &sequence, const AaCode &aa_code);

  virtual ~SpOMSProtein();

  const QString getAccession() const;
  const QString &getCompleteDescription() const;
  const QString &getSequence() const;


  std::vector<SpOMSAa> sliced(std::size_t position, std::size_t length) const;

  private:
  QString m_description;
  QString m_sequence;
};
} // namespace specpeptidoms
} // namespace pappso
