% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour-manip.R
\name{colour_manip}
\alias{colour_manip}
\alias{col_shift}
\alias{col_lighter}
\alias{col_darker}
\alias{col_saturate}
\title{Colour manipulation}
\usage{
col_shift(col, amount = 10)

col_lighter(col, amount = 10)

col_darker(col, amount = 10)

col_saturate(col, amount = 10)
}
\arguments{
\item{col}{A character vector of colours or a colour palette function.}

\item{amount}{A numeric vector giving the change. The interpretation depends
on the function:
\itemize{
\item \code{col_shift()} takes a number between -360 and 360 for shifting hues in
HCL space.
\item \code{col_lighter()} and \code{col_darker()} take a number between -100 and 100 for
adding (or subtracting) to the lightness channel in HSL space.
\item \code{col_saturate()} takes a number between -100 and 100 for adding to the
saturation channel in HSL space. Negative numbers desaturate the colour.
}}
}
\value{
A vector of colours.
}
\description{
These are a set of convenience functions for standard colour manipulation
operations.
}
\details{
\code{col_shift()} considers the hue channel to be periodic, so adding 180 to
a colour with hue 270 will result in a colour with hue 90.
}
\examples{
col_shift("red", 180) # teal
col_lighter("red", 50) # light red
col_darker("red", 50) # dark red
col_saturate("red", -50) # brick-red
}
\seealso{
Other colour manipulation: 
\code{\link{alpha}()},
\code{\link{col2hcl}()},
\code{\link{col_mix}()},
\code{\link{muted}()}
}
\concept{colour manipulation}
