.\" *********************************** start of \input{common.tex}
.\" *********************************** end of \input{common.tex}
'\" t
.\" Manual page created with latex2man on Tue Aug 29 11:41:44 2023
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_INIT\\_LOCAL" "3libunwind" "29 August 2023" "Programming Library " "Programming Library "
.SH NAME
unw_init_local
\-\- initialize cursor for local unwinding 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_init_local(unw_cursor_t *c,
unw_context_t *ctxt);
.br
int
unw_init_local2(unw_cursor_t *c,
unw_context_t *ctxt,
int
flag);
.br
.PP
.SH DESCRIPTION

.PP
The unw_init_local()
routine initializes the unwind cursor 
pointed to by c
with the machine state in the context structure 
pointed to by ctxt\&.
As such, the machine state pointed to by 
ctxt
identifies the initial stack frame at which unwinding 
starts. The machine state is expected to be one provided by a call to 
unw_getcontext();
as such, the instruction pointer may point to 
the instruction after the last instruction of a function, and 
libunwind
will back\-up the instruction pointer before beginning 
a walk up the call stack. The machine state must remain valid for the 
duration for which the cursor c
is in use. 
.PP
The unw_init_local()
routine can be used only for unwinding in 
the address space of the current process (i.e., for local unwinding). 
For all other cases, unw_init_remote()
must be used instead. 
However, unwind performance may be better when using 
unw_init_local().
Also, unw_init_local()
is 
available even when UNW_LOCAL_ONLY
has been defined before 
including <libunwind.h>,
whereas unw_init_remote()
is not. 
.PP
If the unw_context_t
is known to be a signal frame (i.e., 
from the third argument in a sigaction handler on linux), 
unw_init_local2()
should be used for correct initialization 
on some platforms, passing the UNW_INIT_SIGNAL_FRAME
flag. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_init_local()
returns 0. 
Otherwise the negative value of one of the error codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_init_local()
is thread safe as well as safe to use from a 
signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EINVAL
 unw_init_local()
was called in a 
version of libunwind
which supports remote unwinding only 
(this normally happens when calling unw_init_local()
for a 
cross\-platform version of libunwind).
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_EBADREG
 A register needed by unw_init_local()
wasn\&'t accessible. 
.PP
.SH SEE ALSO

.PP
libunwind(3libunwind),
unw_init_remote(3libunwind)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
