#!/usr/bin/perl
use warnings;
use strict;

sub lambda ($) {
    my $t = shift @_;
    my $y;
    if ($t >= 0.0 && $t < 1.0) {$y = 1.0 - $t;}
    elsif ($t < 0.0 && $t > -1.0) {$y = 1.0 + $t;}
    else {$y = 0.0;}
    return $y;
};

sub f ($) {
    my $t = shift @_;
    return
      1.0*lambda($t+2.5)
      + 1.5*lambda($t)
      + (2.0/3.0)*lambda($t-0.5)
      + (-8.0/3.0)*lambda($t-2.75);
}

for (my $t = -4.5; $t < 4.6; $t += 0.25) {
    printf "%9.6f %9.6f\n", $t, f($t);
}

