// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// DO NOT EDIT THIS FILE! IT IS AUTOGENERATED
// FROM /src/coreclr/tools/Common/JitInterface/ThunkGenerator/InstructionSetDesc.txt
// using /src/coreclr/tools/Common/JitInterface/ThunkGenerator/gen.bat

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using Internal.TypeSystem;

namespace Internal.JitInterface
{
    public enum InstructionSet
    {
        ILLEGAL = 0,
        NONE = 63,
        ARM64_ArmBase = InstructionSet_ARM64.ArmBase,
        ARM64_AdvSimd = InstructionSet_ARM64.AdvSimd,
        ARM64_Aes = InstructionSet_ARM64.Aes,
        ARM64_Crc32 = InstructionSet_ARM64.Crc32,
        ARM64_Dp = InstructionSet_ARM64.Dp,
        ARM64_Rdm = InstructionSet_ARM64.Rdm,
        ARM64_Sha1 = InstructionSet_ARM64.Sha1,
        ARM64_Sha256 = InstructionSet_ARM64.Sha256,
        ARM64_Atomics = InstructionSet_ARM64.Atomics,
        ARM64_Vector64 = InstructionSet_ARM64.Vector64,
        ARM64_Vector128 = InstructionSet_ARM64.Vector128,
        ARM64_Dczva = InstructionSet_ARM64.Dczva,
        ARM64_Rcpc = InstructionSet_ARM64.Rcpc,
        ARM64_ArmBase_Arm64 = InstructionSet_ARM64.ArmBase_Arm64,
        ARM64_AdvSimd_Arm64 = InstructionSet_ARM64.AdvSimd_Arm64,
        ARM64_Aes_Arm64 = InstructionSet_ARM64.Aes_Arm64,
        ARM64_Crc32_Arm64 = InstructionSet_ARM64.Crc32_Arm64,
        ARM64_Dp_Arm64 = InstructionSet_ARM64.Dp_Arm64,
        ARM64_Rdm_Arm64 = InstructionSet_ARM64.Rdm_Arm64,
        ARM64_Sha1_Arm64 = InstructionSet_ARM64.Sha1_Arm64,
        ARM64_Sha256_Arm64 = InstructionSet_ARM64.Sha256_Arm64,
        X64_X86Base = InstructionSet_X64.X86Base,
        X64_SSE = InstructionSet_X64.SSE,
        X64_SSE2 = InstructionSet_X64.SSE2,
        X64_SSE3 = InstructionSet_X64.SSE3,
        X64_SSSE3 = InstructionSet_X64.SSSE3,
        X64_SSE41 = InstructionSet_X64.SSE41,
        X64_SSE42 = InstructionSet_X64.SSE42,
        X64_AVX = InstructionSet_X64.AVX,
        X64_AVX2 = InstructionSet_X64.AVX2,
        X64_AES = InstructionSet_X64.AES,
        X64_BMI1 = InstructionSet_X64.BMI1,
        X64_BMI2 = InstructionSet_X64.BMI2,
        X64_FMA = InstructionSet_X64.FMA,
        X64_LZCNT = InstructionSet_X64.LZCNT,
        X64_PCLMULQDQ = InstructionSet_X64.PCLMULQDQ,
        X64_POPCNT = InstructionSet_X64.POPCNT,
        X64_Vector128 = InstructionSet_X64.Vector128,
        X64_Vector256 = InstructionSet_X64.Vector256,
        X64_AVXVNNI = InstructionSet_X64.AVXVNNI,
        X64_MOVBE = InstructionSet_X64.MOVBE,
        X64_X86Serialize = InstructionSet_X64.X86Serialize,
        X64_X86Base_X64 = InstructionSet_X64.X86Base_X64,
        X64_SSE_X64 = InstructionSet_X64.SSE_X64,
        X64_SSE2_X64 = InstructionSet_X64.SSE2_X64,
        X64_SSE3_X64 = InstructionSet_X64.SSE3_X64,
        X64_SSSE3_X64 = InstructionSet_X64.SSSE3_X64,
        X64_SSE41_X64 = InstructionSet_X64.SSE41_X64,
        X64_SSE42_X64 = InstructionSet_X64.SSE42_X64,
        X64_AVX_X64 = InstructionSet_X64.AVX_X64,
        X64_AVX2_X64 = InstructionSet_X64.AVX2_X64,
        X64_AES_X64 = InstructionSet_X64.AES_X64,
        X64_BMI1_X64 = InstructionSet_X64.BMI1_X64,
        X64_BMI2_X64 = InstructionSet_X64.BMI2_X64,
        X64_FMA_X64 = InstructionSet_X64.FMA_X64,
        X64_LZCNT_X64 = InstructionSet_X64.LZCNT_X64,
        X64_PCLMULQDQ_X64 = InstructionSet_X64.PCLMULQDQ_X64,
        X64_POPCNT_X64 = InstructionSet_X64.POPCNT_X64,
        X64_AVXVNNI_X64 = InstructionSet_X64.AVXVNNI_X64,
        X64_MOVBE_X64 = InstructionSet_X64.MOVBE_X64,
        X64_X86Serialize_X64 = InstructionSet_X64.X86Serialize_X64,
        X86_X86Base = InstructionSet_X86.X86Base,
        X86_SSE = InstructionSet_X86.SSE,
        X86_SSE2 = InstructionSet_X86.SSE2,
        X86_SSE3 = InstructionSet_X86.SSE3,
        X86_SSSE3 = InstructionSet_X86.SSSE3,
        X86_SSE41 = InstructionSet_X86.SSE41,
        X86_SSE42 = InstructionSet_X86.SSE42,
        X86_AVX = InstructionSet_X86.AVX,
        X86_AVX2 = InstructionSet_X86.AVX2,
        X86_AES = InstructionSet_X86.AES,
        X86_BMI1 = InstructionSet_X86.BMI1,
        X86_BMI2 = InstructionSet_X86.BMI2,
        X86_FMA = InstructionSet_X86.FMA,
        X86_LZCNT = InstructionSet_X86.LZCNT,
        X86_PCLMULQDQ = InstructionSet_X86.PCLMULQDQ,
        X86_POPCNT = InstructionSet_X86.POPCNT,
        X86_Vector128 = InstructionSet_X86.Vector128,
        X86_Vector256 = InstructionSet_X86.Vector256,
        X86_AVXVNNI = InstructionSet_X86.AVXVNNI,
        X86_MOVBE = InstructionSet_X86.MOVBE,
        X86_X86Serialize = InstructionSet_X86.X86Serialize,
        X86_X86Base_X64 = InstructionSet_X86.X86Base_X64,
        X86_SSE_X64 = InstructionSet_X86.SSE_X64,
        X86_SSE2_X64 = InstructionSet_X86.SSE2_X64,
        X86_SSE3_X64 = InstructionSet_X86.SSE3_X64,
        X86_SSSE3_X64 = InstructionSet_X86.SSSE3_X64,
        X86_SSE41_X64 = InstructionSet_X86.SSE41_X64,
        X86_SSE42_X64 = InstructionSet_X86.SSE42_X64,
        X86_AVX_X64 = InstructionSet_X86.AVX_X64,
        X86_AVX2_X64 = InstructionSet_X86.AVX2_X64,
        X86_AES_X64 = InstructionSet_X86.AES_X64,
        X86_BMI1_X64 = InstructionSet_X86.BMI1_X64,
        X86_BMI2_X64 = InstructionSet_X86.BMI2_X64,
        X86_FMA_X64 = InstructionSet_X86.FMA_X64,
        X86_LZCNT_X64 = InstructionSet_X86.LZCNT_X64,
        X86_PCLMULQDQ_X64 = InstructionSet_X86.PCLMULQDQ_X64,
        X86_POPCNT_X64 = InstructionSet_X86.POPCNT_X64,
        X86_AVXVNNI_X64 = InstructionSet_X86.AVXVNNI_X64,
        X86_MOVBE_X64 = InstructionSet_X86.MOVBE_X64,
        X86_X86Serialize_X64 = InstructionSet_X86.X86Serialize_X64,
    }

    public enum InstructionSet_ARM64
    {
        ILLEGAL = InstructionSet.ILLEGAL,
        NONE = InstructionSet.NONE,
        ArmBase = 1,
        AdvSimd = 2,
        Aes = 3,
        Crc32 = 4,
        Dp = 5,
        Rdm = 6,
        Sha1 = 7,
        Sha256 = 8,
        Atomics = 9,
        Vector64 = 10,
        Vector128 = 11,
        Dczva = 12,
        Rcpc = 13,
        ArmBase_Arm64 = 14,
        AdvSimd_Arm64 = 15,
        Aes_Arm64 = 16,
        Crc32_Arm64 = 17,
        Dp_Arm64 = 18,
        Rdm_Arm64 = 19,
        Sha1_Arm64 = 20,
        Sha256_Arm64 = 21,
    }

    public enum InstructionSet_X64
    {
        ILLEGAL = InstructionSet.ILLEGAL,
        NONE = InstructionSet.NONE,
        X86Base = 1,
        SSE = 2,
        SSE2 = 3,
        SSE3 = 4,
        SSSE3 = 5,
        SSE41 = 6,
        SSE42 = 7,
        AVX = 8,
        AVX2 = 9,
        AES = 10,
        BMI1 = 11,
        BMI2 = 12,
        FMA = 13,
        LZCNT = 14,
        PCLMULQDQ = 15,
        POPCNT = 16,
        Vector128 = 17,
        Vector256 = 18,
        AVXVNNI = 19,
        MOVBE = 20,
        X86Serialize = 21,
        X86Base_X64 = 22,
        SSE_X64 = 23,
        SSE2_X64 = 24,
        SSE3_X64 = 25,
        SSSE3_X64 = 26,
        SSE41_X64 = 27,
        SSE42_X64 = 28,
        AVX_X64 = 29,
        AVX2_X64 = 30,
        AES_X64 = 31,
        BMI1_X64 = 32,
        BMI2_X64 = 33,
        FMA_X64 = 34,
        LZCNT_X64 = 35,
        PCLMULQDQ_X64 = 36,
        POPCNT_X64 = 37,
        AVXVNNI_X64 = 38,
        MOVBE_X64 = 39,
        X86Serialize_X64 = 40,
    }

    public enum InstructionSet_X86
    {
        ILLEGAL = InstructionSet.ILLEGAL,
        NONE = InstructionSet.NONE,
        X86Base = 1,
        SSE = 2,
        SSE2 = 3,
        SSE3 = 4,
        SSSE3 = 5,
        SSE41 = 6,
        SSE42 = 7,
        AVX = 8,
        AVX2 = 9,
        AES = 10,
        BMI1 = 11,
        BMI2 = 12,
        FMA = 13,
        LZCNT = 14,
        PCLMULQDQ = 15,
        POPCNT = 16,
        Vector128 = 17,
        Vector256 = 18,
        AVXVNNI = 19,
        MOVBE = 20,
        X86Serialize = 21,
        X86Base_X64 = 22,
        SSE_X64 = 23,
        SSE2_X64 = 24,
        SSE3_X64 = 25,
        SSSE3_X64 = 26,
        SSE41_X64 = 27,
        SSE42_X64 = 28,
        AVX_X64 = 29,
        AVX2_X64 = 30,
        AES_X64 = 31,
        BMI1_X64 = 32,
        BMI2_X64 = 33,
        FMA_X64 = 34,
        LZCNT_X64 = 35,
        PCLMULQDQ_X64 = 36,
        POPCNT_X64 = 37,
        AVXVNNI_X64 = 38,
        MOVBE_X64 = 39,
        X86Serialize_X64 = 40,
    }

    public struct InstructionSetFlags : IEnumerable<InstructionSet>
    {
        private ulong _flags;

        public IEnumerable<InstructionSet_ARM64> ARM64Flags => this.Select((x) => (InstructionSet_ARM64)x);

        public IEnumerable<InstructionSet_X64> X64Flags => this.Select((x) => (InstructionSet_X64)x);

        public IEnumerable<InstructionSet_X86> X86Flags => this.Select((x) => (InstructionSet_X86)x);

        public void AddInstructionSet(InstructionSet instructionSet)
        {
            _flags = _flags | (((ulong)1) << (int)instructionSet);
        }

        public void RemoveInstructionSet(InstructionSet instructionSet)
        {
            _flags = _flags & ~(((ulong)1) << (int)instructionSet);
        }

        public bool HasInstructionSet(InstructionSet instructionSet)
        {
            return (_flags & (((ulong)1) << (int)instructionSet)) != 0;
        }

        public bool Equals(InstructionSetFlags other)
        {
            return _flags == other._flags;
        }

        public void Add(InstructionSetFlags other)
        {
            _flags |= other._flags;
        }

        public void IntersectionWith(InstructionSetFlags other)
        {
            _flags &= other._flags;
        }

        public void Remove(InstructionSetFlags other)
        {
            _flags &= ~other._flags;
        }

        public bool IsEmpty()
        {
            return _flags == 0;
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }

        public IEnumerator<InstructionSet> GetEnumerator()
        {
            for (int i = 1; i < (int)InstructionSet.NONE; i ++)
            {
                InstructionSet instructionSet = (InstructionSet)i;
                if (HasInstructionSet(instructionSet))
                {
                    yield return instructionSet;
                }
            }
        }

        public void ExpandInstructionSetByImplication(TargetArchitecture architecture)
        {
            this = ExpandInstructionSetByImplicationHelper(architecture, this);
        }

        public static InstructionSet ConvertToImpliedInstructionSetForVectorInstructionSets(TargetArchitecture architecture, InstructionSet input)
        {
            switch(architecture)
            {
            case TargetArchitecture.ARM64:
                switch(input)
                {
                case InstructionSet.ARM64_Vector64: return InstructionSet.ARM64_AdvSimd;
                case InstructionSet.ARM64_Vector128: return InstructionSet.ARM64_AdvSimd;
                }
                break;
            case TargetArchitecture.X64:
                switch(input)
                {
                case InstructionSet.X64_Vector128: return InstructionSet.X64_SSE;
                case InstructionSet.X64_Vector256: return InstructionSet.X64_AVX;
                }
                break;
            case TargetArchitecture.X86:
                switch(input)
                {
                case InstructionSet.X86_Vector128: return InstructionSet.X86_SSE;
                case InstructionSet.X86_Vector256: return InstructionSet.X86_AVX;
                }
                break;
            }
            return input;
        }

        public static InstructionSetFlags ExpandInstructionSetByImplicationHelper(TargetArchitecture architecture, InstructionSetFlags input)
        {
            InstructionSetFlags oldflags = input;
            InstructionSetFlags resultflags = input;
            do
            {
                oldflags = resultflags;
                switch(architecture)
                {

                case TargetArchitecture.ARM64:
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Aes))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Aes_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Aes_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Aes);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Crc32))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Crc32_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Crc32_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Crc32);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Dp))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Dp_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Dp_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Dp);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Rdm))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Rdm_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Rdm_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Rdm);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha1))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha1_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha1_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha1);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha256))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha256_Arm64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha256_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha256);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Aes))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Crc32))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Dp))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Rdm))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha1))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha256))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Vector64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Vector128))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    break;

                case TargetArchitecture.X64:
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE2))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE2_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE3))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE3_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE3_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSSE3))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSSE3_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSSE3_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE41))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE41_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE41_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE41);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_BMI1))
                        resultflags.AddInstructionSet(InstructionSet.X64_BMI1_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_BMI1_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_BMI1);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_BMI2))
                        resultflags.AddInstructionSet(InstructionSet.X64_BMI2_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_BMI2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_BMI2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_FMA))
                        resultflags.AddInstructionSet(InstructionSet.X64_FMA_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_FMA_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_FMA);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_LZCNT))
                        resultflags.AddInstructionSet(InstructionSet.X64_LZCNT_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_LZCNT_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_LZCNT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_PCLMULQDQ))
                        resultflags.AddInstructionSet(InstructionSet.X64_PCLMULQDQ_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_PCLMULQDQ_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_PCLMULQDQ);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_POPCNT))
                        resultflags.AddInstructionSet(InstructionSet.X64_POPCNT_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_POPCNT_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_POPCNT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNI))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNI_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNI_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_MOVBE))
                        resultflags.AddInstructionSet(InstructionSet.X64_MOVBE_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_MOVBE_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_MOVBE);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Serialize))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Serialize_X64);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Serialize_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Serialize);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE2))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE3))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSSE3))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE41))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE41);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_BMI1))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_BMI2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_FMA))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_LZCNT))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_PCLMULQDQ))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_POPCNT))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_Vector128))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_Vector256))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNI))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_MOVBE))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Serialize))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    break;

                case TargetArchitecture.X86:
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE2))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE3))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSSE3))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE41))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE41);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AES))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_BMI1))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_BMI2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_FMA))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_LZCNT))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_PCLMULQDQ))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_POPCNT))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_Vector128))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_Vector256))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVXVNNI))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_MOVBE))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Serialize))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Base);
                    break;
                }
            } while (!oldflags.Equals(resultflags));

            return resultflags;
        }

        public void ExpandInstructionSetByReverseImplication(TargetArchitecture architecture)
        {
            this = ExpandInstructionSetByReverseImplicationHelper(architecture, this);
        }

        private static InstructionSetFlags ExpandInstructionSetByReverseImplicationHelper(TargetArchitecture architecture, InstructionSetFlags input)
        {
            InstructionSetFlags oldflags = input;
            InstructionSetFlags resultflags = input;
            do
            {
                oldflags = resultflags;
                switch(architecture)
                {

                case TargetArchitecture.ARM64:
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_ArmBase);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Aes_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Aes);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Crc32_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Crc32);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Dp_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Dp);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Rdm_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Rdm);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha1_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha1);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_Sha256_Arm64))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha256);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_AdvSimd);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Aes);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Crc32);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Dp);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Rdm);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha1);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Sha256);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Vector64);
                    if (resultflags.HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        resultflags.AddInstructionSet(InstructionSet.ARM64_Vector128);
                    break;

                case TargetArchitecture.X64:
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Base);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE3_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSSE3_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE41_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE41);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AES_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_BMI1_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_BMI1);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_BMI2_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_BMI2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_FMA_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_FMA);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_LZCNT_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_LZCNT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_PCLMULQDQ_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_PCLMULQDQ);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_POPCNT_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_POPCNT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVXVNNI_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_MOVBE_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_MOVBE);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Serialize_X64))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Serialize);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE2))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE3))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSSE3))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE41);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE41))
                        resultflags.AddInstructionSet(InstructionSet.X64_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_BMI1);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_BMI2);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_FMA);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_LZCNT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE2))
                        resultflags.AddInstructionSet(InstructionSet.X64_PCLMULQDQ);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X64_POPCNT);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE))
                        resultflags.AddInstructionSet(InstructionSet.X64_Vector128);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X64_Vector256);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X64_AVXVNNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X64_MOVBE);
                    if (resultflags.HasInstructionSet(InstructionSet.X64_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X64_X86Serialize);
                    break;

                case TargetArchitecture.X86:
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE2))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE3))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSSE3);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSSE3))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE41);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE41))
                        resultflags.AddInstructionSet(InstructionSet.X86_SSE42);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVX2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AES);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_BMI1);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_BMI2);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_FMA);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_LZCNT);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE2))
                        resultflags.AddInstructionSet(InstructionSet.X86_PCLMULQDQ);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X86_POPCNT);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE))
                        resultflags.AddInstructionSet(InstructionSet.X86_Vector128);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX))
                        resultflags.AddInstructionSet(InstructionSet.X86_Vector256);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_AVX2))
                        resultflags.AddInstructionSet(InstructionSet.X86_AVXVNNI);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_SSE42))
                        resultflags.AddInstructionSet(InstructionSet.X86_MOVBE);
                    if (resultflags.HasInstructionSet(InstructionSet.X86_X86Base))
                        resultflags.AddInstructionSet(InstructionSet.X86_X86Serialize);
                    break;
                }
            } while (!oldflags.Equals(resultflags));

            return resultflags;
        }

        private static Dictionary<(string, TargetArchitecture), string> AllInstructionSetGroups { get; } = new()
            {
                { ("x86-x64",    TargetArchitecture.X64),   "sse2" },
                { ("x86-x64",    TargetArchitecture.X86),   "sse2" },
                { ("x86-x64-v2", TargetArchitecture.X64),   "sse4.2 popcnt" },
                { ("x86-x64-v2", TargetArchitecture.X86),   "sse4.2 popcnt" },
                { ("x86-x64-v3", TargetArchitecture.X64),   "x86-x64-v2 avx2 bmi bmi2 lzcnt movbe fma" },
                { ("x86-x64-v3", TargetArchitecture.X86),   "x86-x64-v2 avx2 bmi bmi2 lzcnt movbe fma" },
                { ("skylake",    TargetArchitecture.X64),   "x86-x64-v3" },
                { ("skylake",    TargetArchitecture.X86),   "x86-x64-v3" },
                { ("armv8-a",    TargetArchitecture.ARM64), "neon" },
                { ("armv8.1-a",  TargetArchitecture.ARM64), "armv8-a lse crc rdma" },
                { ("armv8.2-a",  TargetArchitecture.ARM64), "armv8.1-a" },
                { ("armv8.3-a",  TargetArchitecture.ARM64), "armv8.2-a rcpc" },
                { ("armv8.4-a",  TargetArchitecture.ARM64), "armv8.3-a dotprod" },
                { ("armv8.5-a",  TargetArchitecture.ARM64), "armv8.4-a" },
                { ("armv8.6-a",  TargetArchitecture.ARM64), "armv8.5-a" },
                { ("apple-m1",   TargetArchitecture.ARM64), "armv8.5-a" },
            };

        public static IEnumerable<string> AllCpuNames =>
            AllInstructionSetGroups.Keys.Select(key => key.Item1).Distinct();

        public static IEnumerable<string> CpuNameToInstructionSets(string cpu, TargetArchitecture arch) =>
            AllInstructionSetGroups.TryGetValue((cpu, arch), out string value) ? value.Split(' ') : null;

        public struct InstructionSetInfo
        {
            public readonly string Name;
            public readonly string ManagedName;
            public readonly InstructionSet InstructionSet;
            public readonly bool Specifiable;

            public InstructionSetInfo(string name, string managedName, InstructionSet instructionSet, bool specifiable)
            {
                Name = name;
                ManagedName = managedName;
                InstructionSet = instructionSet;
                Specifiable = specifiable;
            }
        }

        public static IEnumerable<InstructionSetInfo> ArchitectureToValidInstructionSets(TargetArchitecture architecture)
        {
            switch (architecture)
            {

                case TargetArchitecture.ARM64:
                    yield return new InstructionSetInfo("base", "ArmBase", InstructionSet.ARM64_ArmBase, true);
                    yield return new InstructionSetInfo("neon", "AdvSimd", InstructionSet.ARM64_AdvSimd, true);
                    yield return new InstructionSetInfo("aes", "Aes", InstructionSet.ARM64_Aes, true);
                    yield return new InstructionSetInfo("crc", "Crc32", InstructionSet.ARM64_Crc32, true);
                    yield return new InstructionSetInfo("dotprod", "Dp", InstructionSet.ARM64_Dp, true);
                    yield return new InstructionSetInfo("rdma", "Rdm", InstructionSet.ARM64_Rdm, true);
                    yield return new InstructionSetInfo("sha1", "Sha1", InstructionSet.ARM64_Sha1, true);
                    yield return new InstructionSetInfo("sha2", "Sha256", InstructionSet.ARM64_Sha256, true);
                    yield return new InstructionSetInfo("lse", "", InstructionSet.ARM64_Atomics, true);
                    yield return new InstructionSetInfo("Vector64", "", InstructionSet.ARM64_Vector64, false);
                    yield return new InstructionSetInfo("Vector128", "", InstructionSet.ARM64_Vector128, false);
                    yield return new InstructionSetInfo("Dczva", "", InstructionSet.ARM64_Dczva, false);
                    yield return new InstructionSetInfo("rcpc", "", InstructionSet.ARM64_Rcpc, true);
                    break;

                case TargetArchitecture.X64:
                    yield return new InstructionSetInfo("base", "X86Base", InstructionSet.X64_X86Base, true);
                    yield return new InstructionSetInfo("sse", "Sse", InstructionSet.X64_SSE, true);
                    yield return new InstructionSetInfo("sse2", "Sse2", InstructionSet.X64_SSE2, true);
                    yield return new InstructionSetInfo("sse3", "Sse3", InstructionSet.X64_SSE3, true);
                    yield return new InstructionSetInfo("ssse3", "Ssse3", InstructionSet.X64_SSSE3, true);
                    yield return new InstructionSetInfo("sse4.1", "Sse41", InstructionSet.X64_SSE41, true);
                    yield return new InstructionSetInfo("sse4.2", "Sse42", InstructionSet.X64_SSE42, true);
                    yield return new InstructionSetInfo("avx", "Avx", InstructionSet.X64_AVX, true);
                    yield return new InstructionSetInfo("avx2", "Avx2", InstructionSet.X64_AVX2, true);
                    yield return new InstructionSetInfo("aes", "Aes", InstructionSet.X64_AES, true);
                    yield return new InstructionSetInfo("bmi", "Bmi1", InstructionSet.X64_BMI1, true);
                    yield return new InstructionSetInfo("bmi2", "Bmi2", InstructionSet.X64_BMI2, true);
                    yield return new InstructionSetInfo("fma", "Fma", InstructionSet.X64_FMA, true);
                    yield return new InstructionSetInfo("lzcnt", "Lzcnt", InstructionSet.X64_LZCNT, true);
                    yield return new InstructionSetInfo("pclmul", "Pclmulqdq", InstructionSet.X64_PCLMULQDQ, true);
                    yield return new InstructionSetInfo("popcnt", "Popcnt", InstructionSet.X64_POPCNT, true);
                    yield return new InstructionSetInfo("Vector128", "", InstructionSet.X64_Vector128, false);
                    yield return new InstructionSetInfo("Vector256", "", InstructionSet.X64_Vector256, false);
                    yield return new InstructionSetInfo("avxvnni", "AvxVnni", InstructionSet.X64_AVXVNNI, true);
                    yield return new InstructionSetInfo("movbe", "Movbe", InstructionSet.X64_MOVBE, true);
                    yield return new InstructionSetInfo("serialize", "X86Serialize", InstructionSet.X64_X86Serialize, true);
                    break;

                case TargetArchitecture.X86:
                    yield return new InstructionSetInfo("base", "X86Base", InstructionSet.X86_X86Base, true);
                    yield return new InstructionSetInfo("sse", "Sse", InstructionSet.X86_SSE, true);
                    yield return new InstructionSetInfo("sse2", "Sse2", InstructionSet.X86_SSE2, true);
                    yield return new InstructionSetInfo("sse3", "Sse3", InstructionSet.X86_SSE3, true);
                    yield return new InstructionSetInfo("ssse3", "Ssse3", InstructionSet.X86_SSSE3, true);
                    yield return new InstructionSetInfo("sse4.1", "Sse41", InstructionSet.X86_SSE41, true);
                    yield return new InstructionSetInfo("sse4.2", "Sse42", InstructionSet.X86_SSE42, true);
                    yield return new InstructionSetInfo("avx", "Avx", InstructionSet.X86_AVX, true);
                    yield return new InstructionSetInfo("avx2", "Avx2", InstructionSet.X86_AVX2, true);
                    yield return new InstructionSetInfo("aes", "Aes", InstructionSet.X86_AES, true);
                    yield return new InstructionSetInfo("bmi", "Bmi1", InstructionSet.X86_BMI1, true);
                    yield return new InstructionSetInfo("bmi2", "Bmi2", InstructionSet.X86_BMI2, true);
                    yield return new InstructionSetInfo("fma", "Fma", InstructionSet.X86_FMA, true);
                    yield return new InstructionSetInfo("lzcnt", "Lzcnt", InstructionSet.X86_LZCNT, true);
                    yield return new InstructionSetInfo("pclmul", "Pclmulqdq", InstructionSet.X86_PCLMULQDQ, true);
                    yield return new InstructionSetInfo("popcnt", "Popcnt", InstructionSet.X86_POPCNT, true);
                    yield return new InstructionSetInfo("Vector128", "", InstructionSet.X86_Vector128, false);
                    yield return new InstructionSetInfo("Vector256", "", InstructionSet.X86_Vector256, false);
                    yield return new InstructionSetInfo("avxvnni", "AvxVnni", InstructionSet.X86_AVXVNNI, true);
                    yield return new InstructionSetInfo("movbe", "Movbe", InstructionSet.X86_MOVBE, true);
                    yield return new InstructionSetInfo("serialize", "X86Serialize", InstructionSet.X86_X86Serialize, true);
                    break;
            }
        }

        public void Set64BitInstructionSetVariants(TargetArchitecture architecture)
        {
            switch (architecture)
            {

                case TargetArchitecture.ARM64:
                    if (HasInstructionSet(InstructionSet.ARM64_ArmBase))
                        AddInstructionSet(InstructionSet.ARM64_ArmBase_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_AdvSimd))
                        AddInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Aes))
                        AddInstructionSet(InstructionSet.ARM64_Aes_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Crc32))
                        AddInstructionSet(InstructionSet.ARM64_Crc32_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Dp))
                        AddInstructionSet(InstructionSet.ARM64_Dp_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Rdm))
                        AddInstructionSet(InstructionSet.ARM64_Rdm_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Sha1))
                        AddInstructionSet(InstructionSet.ARM64_Sha1_Arm64);
                    if (HasInstructionSet(InstructionSet.ARM64_Sha256))
                        AddInstructionSet(InstructionSet.ARM64_Sha256_Arm64);
                    break;

                case TargetArchitecture.X64:
                    if (HasInstructionSet(InstructionSet.X64_X86Base))
                        AddInstructionSet(InstructionSet.X64_X86Base_X64);
                    if (HasInstructionSet(InstructionSet.X64_SSE))
                        AddInstructionSet(InstructionSet.X64_SSE_X64);
                    if (HasInstructionSet(InstructionSet.X64_SSE2))
                        AddInstructionSet(InstructionSet.X64_SSE2_X64);
                    if (HasInstructionSet(InstructionSet.X64_SSE3))
                        AddInstructionSet(InstructionSet.X64_SSE3_X64);
                    if (HasInstructionSet(InstructionSet.X64_SSSE3))
                        AddInstructionSet(InstructionSet.X64_SSSE3_X64);
                    if (HasInstructionSet(InstructionSet.X64_SSE41))
                        AddInstructionSet(InstructionSet.X64_SSE41_X64);
                    if (HasInstructionSet(InstructionSet.X64_SSE42))
                        AddInstructionSet(InstructionSet.X64_SSE42_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX))
                        AddInstructionSet(InstructionSet.X64_AVX_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVX2))
                        AddInstructionSet(InstructionSet.X64_AVX2_X64);
                    if (HasInstructionSet(InstructionSet.X64_AES))
                        AddInstructionSet(InstructionSet.X64_AES_X64);
                    if (HasInstructionSet(InstructionSet.X64_BMI1))
                        AddInstructionSet(InstructionSet.X64_BMI1_X64);
                    if (HasInstructionSet(InstructionSet.X64_BMI2))
                        AddInstructionSet(InstructionSet.X64_BMI2_X64);
                    if (HasInstructionSet(InstructionSet.X64_FMA))
                        AddInstructionSet(InstructionSet.X64_FMA_X64);
                    if (HasInstructionSet(InstructionSet.X64_LZCNT))
                        AddInstructionSet(InstructionSet.X64_LZCNT_X64);
                    if (HasInstructionSet(InstructionSet.X64_PCLMULQDQ))
                        AddInstructionSet(InstructionSet.X64_PCLMULQDQ_X64);
                    if (HasInstructionSet(InstructionSet.X64_POPCNT))
                        AddInstructionSet(InstructionSet.X64_POPCNT_X64);
                    if (HasInstructionSet(InstructionSet.X64_AVXVNNI))
                        AddInstructionSet(InstructionSet.X64_AVXVNNI_X64);
                    if (HasInstructionSet(InstructionSet.X64_MOVBE))
                        AddInstructionSet(InstructionSet.X64_MOVBE_X64);
                    if (HasInstructionSet(InstructionSet.X64_X86Serialize))
                        AddInstructionSet(InstructionSet.X64_X86Serialize_X64);
                    break;

                case TargetArchitecture.X86:
                    break;
            }
        }

        public void Set64BitInstructionSetVariantsUnconditionally(TargetArchitecture architecture)
        {
            switch (architecture)
            {

                case TargetArchitecture.ARM64:
                    AddInstructionSet(InstructionSet.ARM64_ArmBase_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_AdvSimd_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Aes_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Crc32_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Dp_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Rdm_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Sha1_Arm64);
                    AddInstructionSet(InstructionSet.ARM64_Sha256_Arm64);
                    break;

                case TargetArchitecture.X64:
                    AddInstructionSet(InstructionSet.X64_X86Base_X64);
                    AddInstructionSet(InstructionSet.X64_SSE_X64);
                    AddInstructionSet(InstructionSet.X64_SSE2_X64);
                    AddInstructionSet(InstructionSet.X64_SSE3_X64);
                    AddInstructionSet(InstructionSet.X64_SSSE3_X64);
                    AddInstructionSet(InstructionSet.X64_SSE41_X64);
                    AddInstructionSet(InstructionSet.X64_SSE42_X64);
                    AddInstructionSet(InstructionSet.X64_AVX_X64);
                    AddInstructionSet(InstructionSet.X64_AVX2_X64);
                    AddInstructionSet(InstructionSet.X64_AES_X64);
                    AddInstructionSet(InstructionSet.X64_BMI1_X64);
                    AddInstructionSet(InstructionSet.X64_BMI2_X64);
                    AddInstructionSet(InstructionSet.X64_FMA_X64);
                    AddInstructionSet(InstructionSet.X64_LZCNT_X64);
                    AddInstructionSet(InstructionSet.X64_PCLMULQDQ_X64);
                    AddInstructionSet(InstructionSet.X64_POPCNT_X64);
                    AddInstructionSet(InstructionSet.X64_AVXVNNI_X64);
                    AddInstructionSet(InstructionSet.X64_MOVBE_X64);
                    AddInstructionSet(InstructionSet.X64_X86Serialize_X64);
                    break;

                case TargetArchitecture.X86:
                    AddInstructionSet(InstructionSet.X86_X86Base_X64);
                    AddInstructionSet(InstructionSet.X86_SSE_X64);
                    AddInstructionSet(InstructionSet.X86_SSE2_X64);
                    AddInstructionSet(InstructionSet.X86_SSE3_X64);
                    AddInstructionSet(InstructionSet.X86_SSSE3_X64);
                    AddInstructionSet(InstructionSet.X86_SSE41_X64);
                    AddInstructionSet(InstructionSet.X86_SSE42_X64);
                    AddInstructionSet(InstructionSet.X86_AVX_X64);
                    AddInstructionSet(InstructionSet.X86_AVX2_X64);
                    AddInstructionSet(InstructionSet.X86_AES_X64);
                    AddInstructionSet(InstructionSet.X86_BMI1_X64);
                    AddInstructionSet(InstructionSet.X86_BMI2_X64);
                    AddInstructionSet(InstructionSet.X86_FMA_X64);
                    AddInstructionSet(InstructionSet.X86_LZCNT_X64);
                    AddInstructionSet(InstructionSet.X86_PCLMULQDQ_X64);
                    AddInstructionSet(InstructionSet.X86_POPCNT_X64);
                    AddInstructionSet(InstructionSet.X86_AVXVNNI_X64);
                    AddInstructionSet(InstructionSet.X86_MOVBE_X64);
                    AddInstructionSet(InstructionSet.X86_X86Serialize_X64);
                    break;
            }
        }
    }
}
