## How to contribute to the Futhark compiler

* See [Get Involved](https://futhark-lang.org/getinvolved.html) on
  the main website.

* Read [HACKING.md](HACKING.md)

* Read [STYLE.md](STYLE.md)

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub
  under [Issues](https://github.com/diku-dk/futhark/issues).

* If you're unable to find an open issue addressing the problem, [open
  a new one](https://github.com/diku-dk/futhark/issues/new). Be sure
  to include a **title and clear description**, as much relevant
  information as possible, and a **code sample** or an **executable
  test case** demonstrating the expected behavior that is not
  occurring.

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and
  solution. Include the relevant issue number if applicable.

* Before submitting, please read the [Style Guide](STYLE.md) to know
  more about coding conventions and benchmarks.

#### **Do you intend to add a new feature or change an existing one?**

* Open an issue to start a discussion (or join Gitter or IRC).  It's
  best to talk these things through before spending a lot of time
  writing code.

#### **Do you have questions about the source code?**

* Ask any question about the code base on Gitter or IRC (#futhark on
  Libera.Chat).  Please don't open GitHub issues just to ask questions.
