/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2009 Apogee Instruments, Inc. 
* \class Aspen 
* \brief Derived class for the alta g series cameras 
* 
*/ 


#ifndef ASPEN_INCLUDE_H__ 
#define ASPEN_INCLUDE_H__ 

#include "CamGen2Base.h" 
#include <string>

class DLL_EXPORT Aspen : public CamGen2Base
{ 
    public: 
        Aspen();

        virtual ~Aspen(); 

        void OpenConnection( const std::string & ioType,
             const std::string & DeviceAddr,
             const uint16_t FirmwareRev,
             const uint16_t Id );

        void CloseConnection();

        void StartExposure( double Duration, bool IsLight );

        int32_t GetNumAdChannels();


		/*! 
         * Returns an ethernet's camera MAC address.  Will throw
         * an std::runtime_error exception if the call is made on a
         * USB camera.
         * \exception std::runtime_error
         */
        std::string GetMacAddress();

        void Init();

        Apg::FanMode GetFanMode();
        void SetFanMode( Apg::FanMode mode, bool PreCondCheck = true );

        /*! 
         * Returns true if dual readout is support on this
         * camera model
         */
         bool IsDualReadoutSupported();

         /*! 
         * Toggles dual readout (data digitzation via 2 ADC's)
         * mode for cameras that support this feature.
         * This function will throw an exception if the calling
         * program tries to activiate this feature on a camera that
         * does not support this mode
         *  \param [in] TurnOn true to activate, false to deactivate (single readout mode)
         * \exception std::runtime_error
         */
         void SetDualReadout( bool TurnOn );

         /*! 
         * \return true if dual readout is on, false if it is off (single readout mode)
         */
         bool GetDualReadout();
 
    protected:
        Aspen(const std::string & ioType,
             const std::string & DeviceAddr);

        void FixImgFromCamera( const std::vector<uint16_t> & data,
            std::vector<uint16_t> & out,  int32_t rows, int32_t cols );

        void CreateCamIo(const std::string & ioType,
            const std::string & DeviceAddr);

        bool AreColsCentered();

        void ExposureAndGetImgRC(uint16_t & r, uint16_t & c);

        void VerifyCamId();

        void CfgCamFromId( uint16_t CameraId );

        void WriteId2CamReg();

        void SetIsInterlineBit();

    private:
        void UpdateCfgWithRegisterInfo();

        void UpdateCfgWithStrDbInfo();
        
        const std::string m_fileName;

        //disabling the copy ctor and assignment operator
        //generated by the compiler - don't want them
        //Effective C++ Item 6
        Aspen(const Aspen&);
        Aspen& operator=(Aspen&);
}; 

#endif
