% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{EdgeTest-class}
\alias{EdgeTest-class}
\alias{EdgeTest}
\alias{print,EdgeTest-method}
\alias{EdgeTest-method}
\alias{plot,EdgeTest,missing-method}
\title{S4 class defining edge significance}
\usage{
\S4method{print}{EdgeTest}(x)

\S4method{plot}{EdgeTest,missing}(x, y, ...)
}
\arguments{
\item{x}{EdgeTest object.}

\item{y}{ignored.}

\item{...}{arguments to pass to \link{plotEdgeTest}.}
}
\description{
\code{EdgeTest} defines the significance of parent-child annotation enrichment.
}
\section{Slots}{

\describe{
\item{\code{tests}}{data.frame describing the significance test results with columns:
\itemize{
  \item  \code{parent}:    parent node annotation.
  \item  \code{child}:     child node annotation
  \item  \code{count}:     count of observed edges with the given 
                           parent-child annotation set.
  \item  \code{expected}:  mean count of expected edges for the 
                           given parent-child relationship.
  \item  \code{pvalue}:    one-sided p-value for the hypothesis that 
                            the observed edge abundance is greater 
                            than expected.
}}

\item{\code{permutations}}{data.frame containing the raw permutation test data with columns:
\itemize{
  \item  \code{parent}:  parent node annotation.
  \item  \code{child}:   child node annotation
  \item  \code{count}:   count of edges with the given parent-child 
                         annotation set.
  \item  \code{iter}:    numerical index define which permutation
                         realization each observation corresponds 
                         to.
}}

\item{\code{nperm}}{number of permutation realizations.}
}}

