% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coredata.xts.R
\name{xtsAttributes}
\alias{xtsAttributes}
\alias{xtsAttributes<-}
\title{Extract and Replace xts Attributes}
\usage{
xtsAttributes(x, user = NULL)

xtsAttributes(x) <- value
}
\arguments{
\item{x}{An xts object.}

\item{user}{Should user-defined attributes be returned? The default of
\code{NULL} returns all xts attributes.}

\item{value}{A list of new \code{name = value} attributes.}
}
\value{
A named list of user-defined attributes.
}
\description{
Extract and replace non-core xts attributes.
}
\details{
This function allows users to assign custom attributes to the xts objects,
without altering core xts attributes (i.e. tclass, tzone, and tformat).

\code{\link[=attributes]{attributes()}} returns all attributes, including core attributes of the
xts class.
}
\examples{

x <- xts(matrix(1:(9*6),nc=6),
         order.by=as.Date(13000,origin="1970-01-01")+1:9,
         a1='my attribute')

xtsAttributes(x)
xtsAttributes(x) <- list(a2=2020)

xtsAttributes(x)
xtsAttributes(x) <- list(a1=NULL)
xtsAttributes(x)

}
\seealso{
\code{\link[=attributes]{attributes()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
