% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-relogit.R
\docType{class}
\name{Zelig-relogit-class}
\alias{Zelig-relogit-class}
\alias{zrelogit}
\title{Rare Events Logistic Regression for Dichotomous Dependent Variables}
\arguments{
\item{formula}{a symbolic representation of the model to be
estimated, in the form \code{y ~ x1 + x2}, where \code{y} is the
dependent variable and \code{x1} and \code{x2} are the explanatory
variables, and \code{y}, \code{x1}, and \code{x2} are contained in the
same dataset. (You may include more than two explanatory variables,
of course.) The \code{+} symbol means ``inclusion'' not
``addition.'' You may also include interaction terms and main
effects in the form \code{x1*x2} without computing them in prior
steps; \code{I(x1*x2)} to include only the interaction term and
exclude the main effects; and quadratic terms in the form
\code{I(x1^2)}.}

\item{model}{the name of a statistical model to estimate.
For a list of other supported models and their documentation see:
\url{http://docs.zeligproject.org/articles/}.}

\item{data}{the name of a data frame containing the variables
referenced in the formula or a list of multiply imputed data frames
each having the same variable names and row numbers (created by
\code{Amelia} or \code{\link{to_zelig_mi}}).}

\item{...}{additional arguments passed to \code{zelig},
relevant for the model to be estimated.}

\item{by}{a factor variable contained in \code{data}. If supplied,
\code{zelig} will subset
the data frame based on the levels in the \code{by} variable, and
estimate a model for each subset. This can save a considerable amount of
effort. You may also use \code{by} to run models using MatchIt
subclasses.}

\item{cite}{If is set to 'TRUE' (default), the model citation will be printed
to the console.}
}
\value{
Depending on the class of model selected, \code{zelig} will return
  an object with elements including \code{coefficients}, \code{residuals},
  and \code{formula} which may be summarized using
  \code{summary(z.out)} or individually extracted using, for example,
  \code{coef(z.out)}. See
  \url{http://docs.zeligproject.org/articles/getters.html} for a list of
  functions to extract model components. You can also extract whole fitted
  model objects using \code{\link{from_zelig_model}}.
}
\description{
Rare Events Logistic Regression for Dichotomous Dependent Variables
}
\details{
The relogit procedure supports four optional arguments in addition to the
standard arguments for zelig(). You may additionally use:
\itemize{
    \item \code{tau}: a vector containing either one or two values for \code{tau},
    the true population fraction of ones. Use, for example, tau = c(0.05, 0.1) to specify
    that the lower bound on tau is 0.05 and the upper bound is 0.1. If left unspecified, only
    finite-sample bias correction is performed, not case-control correction.
    \item \code{case.control}: if tau is specified, choose a method to correct for case-control
    sampling design: "prior" (default) or "weighting".
    \item \code{bias.correct}: a logical value of \code{TRUE} (default) or \code{FALSE}
    indicating whether the intercept should be corrected for finite sample (rare events) bias.
}

Additional parameters avaialable to many models include:
\itemize{
  \item \code{weights}: vector of weight values or a name of a variable in the dataset
  by which to weight the model. For more information see:
  \url{http://docs.zeligproject.org/articles/weights.html}.
  \item \code{bootstrap}: logical or numeric. If \code{FALSE} don't use bootstraps to
  robustly estimate uncertainty around model parameters due to sampling error.
  If an integer is supplied, the number of boostraps to run.
  For more information see:
  \url{http://docs.zeligproject.org/articles/bootstraps.html}.
}
}
\section{Methods}{

\describe{
\item{\code{modcall_formula_transformer()}}{Transform model call formula.}

\item{\code{show(signif.stars = FALSE, subset = NULL, bagging = FALSE)}}{Display a Zelig object}

\item{\code{zelig(formula, data, model = NULL, ..., weights = NULL, by,
  bootstrap = FALSE)}}{The zelig function estimates a variety of statistical models}
}}

\examples{
library(Zelig)
data(mid)
z.out1 <- zelig(conflict ~ major + contig + power + maxdem + mindem + years,
              data = mid, model = "relogit", tau = 1042/303772)
summary(z.out1)

}
\seealso{
Vignette: \url{http://docs.zeligproject.org/articles/zelig_relogit.html}
}
