<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="xml" version='1.0' 
    doctype-public="-//TEI P4//DTD Main Document Type//EN" 
		doctype-system="http://www.tei-c.org/P4X/DTD/tei2.dtd"/>

  <!-- ToDo: internal subset
[<!ENTITY % TEI.general "INCLUDE"><!ENTITY % TEI.names.dates "INCLUDE"><!ENTITY % TEI.linking "INCLUDE"><!ENTITY % TEI.XML "INCLUDE">]
-->

  <xsl:template match="bibliography[@role='refdb']">
    <div type="refdb-bibliography">
      <xsl:apply-templates select="./title" mode="head"/>
      <listBibl rend="refdb">
        <xsl:apply-templates select="./bibliomixed"/>
      </listBibl>
    </div>
  </xsl:template>

  <xsl:template match="title" mode="head">
    <head><title>
    <xsl:apply-templates/>
  </title></head>
  </xsl:template>

  <xsl:template match="bibliomixed">
    <bibl>
      <xsl:attribute name="id">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:attribute name="rend">
        <xsl:value-of select="@role"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </bibl>
  </xsl:template>

  <xsl:template match="bibliomixed[@role='multixref']">
    <bibl rend="multixref">
      <xsl:apply-templates select="bibliomset[@relation='endtermtarget']" mode="endtermtarget"/>
    </bibl>
  </xsl:template>

  <xsl:template match="bibliomset" mode="endtermtarget">
    <seg type="endtermtarget">
      <xsl:attribute name="id">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </seg>
  </xsl:template>

  <xsl:template match="bibliomset[@id]">
    <seg>
      <xsl:attribute name="type">
        <xsl:value-of select="@role"/>
      </xsl:attribute>
      <xsl:attribute name="id">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </seg>
  </xsl:template>

  <!-- userdef, misc, link, notes -->
  <xsl:template match="bibliomset[@role]">
    <seg>
      <xsl:attribute name="type">
        <xsl:value-of select="@role"/>
      </xsl:attribute>
      <xsl:attribute name="id">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </seg>
  </xsl:template>

  <xsl:template match="bibliomset[@relation]">
    <xsl:choose>
      <xsl:when test="@relation='author'">
        <persName type="author">
          <xsl:apply-templates/>
        </persName>
      </xsl:when>
      <xsl:when test="@relation='editor'">
        <persName type="editor">
          <xsl:apply-templates/>
        </persName>
      </xsl:when>
      <xsl:when test="@relation='seditor'">
        <persName type="seditor">
          <xsl:apply-templates/>
        </persName>
      </xsl:when>
      <xsl:when test="@relation='etal'">
        <seg type="etal"><xsl:apply-templates/></seg>
      </xsl:when>
      <xsl:when test="@relation='article'">
        <seg type="article"><xsl:apply-templates/></seg>
      </xsl:when>
      <xsl:when test="@relation='book'">
        <seg type="book"><xsl:apply-templates/></seg>
      </xsl:when>
      <xsl:when test="@relation='intext'">
        <seg type="intext"><xsl:apply-templates/></seg>
      </xsl:when>
      <xsl:when test="@relation='journal'">
        <seg type="journal"><xsl:apply-templates/></seg>
      </xsl:when>
      <xsl:when test="@relation='endtermtarget'">
        <seg type="intext"><xsl:apply-templates/></seg>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="surname">
    <surname><xsl:apply-templates/></surname>
  </xsl:template>

  <xsl:template match="firstname">
    <foreName><xsl:apply-templates/></foreName>
  </xsl:template>

  <xsl:template match="othername">
    <name type="othername"><xsl:apply-templates/></name>
  </xsl:template>

  <xsl:template match="lineage">
    <name type="lineage"><xsl:apply-templates/></name>
  </xsl:template>

  <xsl:template match="pagenums">
    <seg type="pages"><xsl:apply-templates/></seg>
  </xsl:template>

  <xsl:template match="volumenum">
    <seg type="volume"><xsl:apply-templates/></seg>
  </xsl:template>

  <xsl:template match="issuenum">
    <seg type="issue"><xsl:apply-templates/></seg>
  </xsl:template>

  <xsl:template match="issn">
    <seg type="issn"><xsl:apply-templates/></seg>
  </xsl:template>

  <xsl:template match="isbn">
    <seg type="isbn"><xsl:apply-templates/></seg>
  </xsl:template>

  <xsl:template match="ulink">
    <seg type="ulink"><xsl:apply-templates/></seg>
  </xsl:template>

  <xsl:template match="abbrev">
    <abbr><xsl:apply-templates/></abbr>
  </xsl:template>

  <xsl:template match="abstract">
    <note type="abstract"><xsl:apply-templates/></note>
  </xsl:template>

  <xsl:template match="publishername">
    <publisher><xsl:apply-templates/></publisher>
  </xsl:template>

  <xsl:template match="address">
    <address><name><xsl:apply-templates/></name></address>
  </xsl:template>

  <xsl:template match="address/city">
    <pubPlace><xsl:apply-templates/></pubPlace>
  </xsl:template>

  <xsl:template match="title[@role]">
    <title>
      <xsl:attribute name="level">
        <xsl:choose>
          <xsl:when test="@role='JOUR'">
            <xsl:text>a</xsl:text>
          </xsl:when>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="@role='BOOK'">
            <xsl:text>m</xsl:text>
          </xsl:when>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="@role='CHAP'">
            <xsl:text>a</xsl:text>
          </xsl:when>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="@role='SERIES'">
            <xsl:text>s</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:attribute>
      <xsl:apply-templates/>
    </title>
  </xsl:template>

  <xsl:template match="bibliomset[@relation='journal']/title">
    <title level="j">
      <xsl:apply-templates/>
    </title>
  </xsl:template>

  <xsl:template match="pubdate">
    <date>
      <xsl:attribute name="rend">
        <xsl:value-of select="@role"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </date>
  </xsl:template>

</xsl:stylesheet>
