 /*
  *                            COPYRIGHT
  *
  *  pcb-rnd, interactive printed circuit board design
  *  Copyright (C) 2024 Tibor 'Igor2' Palinkas
  *
  *  This program is free software; you can redistribute it and/or modify
  *  it under the terms of the GNU General Public License as published by
  *  the Free Software Foundation; either version 2 of the License, or
  *  (at your option) any later version.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *  GNU General Public License for more details.
  *
  *  You should have received a copy of the GNU General Public License
  *  along with this program; if not, write to the Free Software
  *  Foundation, Inc., 31 Milk Street, # 960789 Boston, MA 02196 USA.
  *
  *  Contact:
  *    Project page: http://repo.hu/projects/pcb-rnd
  *    lead developer: http://repo.hu/projects/pcb-rnd/contact.html
  *    mailing list: pcb-rnd (at) list.repo.hu (send "subscribe")
  */

#include <libcschem/config.h>

#include <stdio.h>

#include <librnd/core/plugins.h>
#include <librnd/core/error.h>

#include <libcschem/extobj.h>
#include <libcschem/cnc_poly.h>
#include <libcschem/cnc_grp.h>

#include <sch-rnd/conf_core.h>
#include <sch-rnd/dad.h>
#include <sch-rnd/draw.h>
#include <librnd/hid/hid_dad.h>
#include <plugins/sch_dialogs/dlg_pen.h>

#define RND_TIMED_CHG_TIMEOUT conf_core.editor.edit_time
#include <librnd/plugins/lib_hid_common/timed_chg.h>

#include "chart_block.c"
#include "chart_arrow.c"


csch_extobj_impl_t extobj_chart_block, extobj_chart_arrow;

int pplg_check_ver_extobj_chart(int ver_needed) { return 0; }

void pplg_uninit_extobj_chart(void)
{
	csch_extobj_impl_unreg(&extobj_chart_block);
}

int pplg_init_extobj_chart(void)
{
	RND_API_CHK_VER;

	extobj_chart_block.name = "chart-block";
	extobj_chart_block.attr_edit_post = chart_block_attr_edit_post;
	extobj_chart_block.update = chart_block_update;
	extobj_chart_block.conv_from = chart_block_conv_from;
	extobj_chart_block.gui_edit_dlg = chart_block_gui_edit_dlg;
	csch_extobj_impl_reg(&extobj_chart_block);

	extobj_chart_arrow.name = "chart-arrow";
	extobj_chart_arrow.attr_edit_post = chart_arrow_attr_edit_post;
	extobj_chart_arrow.floater_edit_post = chart_arrow_floater_edit_post;
	extobj_chart_arrow.update = chart_arrow_update;
	extobj_chart_arrow.conv_from = chart_arrow_conv_from;
	extobj_chart_arrow.gui_edit_dlg = chart_arrow_gui_edit_dlg;
	csch_extobj_impl_reg(&extobj_chart_arrow);
	return 0;
}

