//<-- CLI SHELL MODE -->
// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ????-2008 - INRIA
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

function r=testresult(eps)
    if argn(2)<=0 then eps=1d-10;end
    if or(isnan(real(y))<>isnan(real(yref)))  then r=%t,return,end;
    if or(isnan(imag(y))<>isnan(imag(yref)))  then r=%t,return,end;
    if or(size(y)<>size(yref)) then r=%t,return,end;
    if yref==[] then r=%f,return,end;

    k=find(abs(yref)==0);
    if isempty(k)
        r = or([]);
    else
        r=or(abs(y(k)-yref(k))>eps);
    end

    k=find(abs(yref)<>0);
    if isempty(k)
        r=r|[];
    else
        r=r|or( max ( abs(y(k)-yref(k)) ./ abs(yref(k)) ) >eps );
    end
endfunction
ieee(1)

// ------------------------------ besselh(alpha[,K],x)------------------------------

alpha=[];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
8.40000000000000036];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[%nan+%nan*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan+%nan*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan+%nan*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[0.999999999999997446-10.3349026794206473*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.999999999999997446+10.3349026794206473*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.999998966509724529-10.3349027794205952*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[0.765197686557966383+0.0882569642156769973*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.765197686557966383-0.0882569642156769973*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.487703749086956295-0.596206209606004012*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[-0.260051954901933502+0.376850010012790504*%i -0.397149809863847292-0.0169407393250650198*%i -0.177596771314338348-0.308517625249033867*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933502-0.376850010012790504*%i -0.397149809863847292+0.0169407393250650198*%i -0.177596771314338348+0.308517625249033867*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.31063056052955762-0.336380148284720293*%i 0.272415233538270574-0.289490760923486856*%i 0.245467551730485706-0.257816638947182653*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.288216947635014376+0.0627738863740376352*%i 0.0691572616569851861+0.266221867363905018*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.864650842905043127-0.0627738863740379682*%i 0.0691572616569851861-0.266221867363905018*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.205009668070646411-0.212086316654584245*%i 0.191600335830164975-0.197347715498268128*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[-0.260051954901933502+0.376850010012790504*%i
-0.397149809863847292-0.0169407393250650198*%i
-0.177596771314338348-0.308517625249033867*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933502-0.376850010012790504*%i
-0.397149809863847292+0.0169407393250650198*%i
-0.177596771314338348+0.308517625249033867*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.31063056052955762-0.336380148284720293*%i
0.272415233538270574-0.289490760923486856*%i
0.245467551730485706-0.257816638947182653*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
8.40000000000000036];
yref=[-0.288216947635014376+0.0627738863740376352*%i
0.0691572616569851861+0.266221867363905018*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.864650842905043127-0.0627738863740379682*%i
0.0691572616569851861-0.266221867363905018*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.205009668070646411-0.212086316654584245*%i
0.191600335830164975-0.197347715498268128*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.282580089296005532+0.0611426719248229084*%i 0.0680949286455164587+0.260860299794333839*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.859124750279884219-0.0578395374887053712*%i 0.0702343630487119036-0.271692474123097438*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.204710539394216295-0.212355593630163458*%i 0.191359168939230689-0.197567749205550591*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[%nan+%nan*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan+%nan*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan+%nan*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[5.03898043091051198e-08-6366197.72367634624*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[5.03898043091051198e-08+6366197.72367634624*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.636619721977829234-6366197.72367631458*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[0.440050585744933553-0.781212821300288907*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.440050585744933553+0.781212821300288907*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.419607575907496144-0.792380888474382039*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[0.339058958525936538+0.324674424791800087*%i -0.0660433280235491887+0.397925710557099965*%i -0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.339058958525936538-0.324674424791800087*%i -0.0660433280235491887-0.397925710557099965*%i -0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.289847767402387269-0.369273247341898037*%i -0.257982370633597746-0.310083357729930509*%i -0.234711371607197739-0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0825704304932578653+0.284594371868072016*%i 0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.247711291479773887-0.284594371868071905*%i 0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.198591028778410006+0.219939618485522376*%i -0.186324039282828008-0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[ 0.339058958525936538+0.324674424791800087*%i
-0.0660433280235491887+0.397925710557099965*%i
-0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.339058958525936538-0.324674424791800087*%i
-0.0660433280235491887-0.397925710557099965*%i
-0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.289847767402387269-0.369273247341898037*%i
-0.257982370633597746-0.310083357729930509*%i
-0.234711371607197739-0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
8.40000000000000036];
yref=[0.0825704304932578653+0.284594371868072016*%i
0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.247711291479773887-0.284594371868071905*%i
0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.198591028778410006+0.219939618485522376*%i
-0.186324039282828008-0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0805588566675057155+0.279108983487138917*%i 0.265388401248268402-0.0527501414166842708*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.245747300872035002-0.268032077903665344*%i 0.276292676347178967+0.0542269854219353462*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.198923241476530482+0.219693383394633845*%i -0.186588090699604608-0.203436398574806665*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[5.03898043091051198e-08-6366197.72367634624*%i 1.27222187258540667e-15-127323954473516.594*%i 311843.447284119495-5.09295817894065707e+21*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[5.03898043091051198e-08+6366197.72367634624*%i 1.27222187258540667e-15+127323954473516.594*%i 311843.447284119495+5.09295817894065707e+21*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.636619721977829234-6366197.72367631458*%i -12732395.4473516364-127323954473515.953*%i -509295817582221.438-5.09295817894063191e+21*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[0.440050585744933553-0.781212821300288907*%i 0.114903484931900571-1.65068260681625478*%i 0.0195633539826691495-5.82151760596473089*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.440050585744933553+0.781212821300288907*%i 0.114903484931900571+1.65068260681625478*%i 0.0195633539826691495+5.82151760596473089*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.419607575907496144-0.792380888474382039*%i -1.32691890090194864-0.988555567342760066*%i -4.88806802770029858-3.16184138089665856*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[0.339058958525936538+0.324674424791800087*%i 0.36412814585207276+0.215903594603614996*%i 0.364831230613667068+0.146267162693192898*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.339058958525936538-0.324674424791800087*%i 0.36412814585207276-0.215903594603614996*%i 0.364831230613667068-0.146267162693192898*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.289847767402387269-0.369273247341898037*%i -0.401406418855069447+0.134449082058521574*%i -0.0367703086914941552+0.391335986221727217*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[ 0.339058958525936538+0.324674424791800087*%i 0.486091260585891194-0.16040039348492377*%i 0.309062722255251721-0.538541616105031817*%i
-0.0660433280235491887+0.397925710557099965*%i 0.36412814585207276+0.215903594603615023*%i 0.430171473875621879-0.182022115953484942*%i
-0.327579137591465286+0.147863143391226859*%i 0.0465651162777521929+0.367662882605524655*%i 0.364831230613667068+0.146267162693192898*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.339058958525936538-0.324674424791800087*%i 0.486091260585891194+0.16040039348492377*%i 0.309062722255251721+0.538541616105031817*%i
-0.0660433280235491887-0.397925710557099965*%i 0.36412814585207276-0.215903594603615023*%i 0.430171473875621879+0.182022115953484942*%i
-0.327579137591465286-0.147863143391226859*%i 0.0465651162777521929-0.367662882605524655*%i 0.364831230613667068-0.146267162693192898*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.289847767402387269-0.369273247341898037*%i -0.503862405464482466+0.0901979833901215833*%i -0.381968773216922741+0.489537225195393555*%i
-0.257982370633597746-0.310083357729930509*%i -0.401406418855069447+0.134449082058521546*%i -0.143424048221471756+0.444532439788452083*%i
-0.234711371607197739-0.272180404505854456*%i -0.339352100373364829+0.148944477144840853*%i -0.0367703086914941552+0.391335986221727217*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
8.40000000000000036];
yref=[0.0825704304932578653+0.284594371868072016*%i 0.265594911883436868-0.140744947159810785*%i -0.228101889059524665-0.207473852876394915*%i
0.270786268276835496-0.0534845083974161278*%i -0.00468434063869100758-0.278956274125194581*%i -0.273016906676212145-0.0793518126145812824*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.247711291479773887-0.284594371868071905*%i -0.796784735650310605+0.140744947159811146*%i 0.684305667178574106+0.207473852876394582*%i
0.270786268276835496+0.0534845083974161278*%i -0.00468434063869100758+0.278956274125194581*%i -0.273016906676212145+0.0793518126145812824*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.198591028778410006+0.219939618485522376*%i 0.259418169105827268+0.15182888693252336*%i 0.056444086802614292-0.303133529133480351*%i
-0.186324039282828008-0.203639750812897008*%i -0.235963202326076427+0.148862060542816449*%i 0.0739606096037440097+0.274526446309476313*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[-7.45058059692382812e-09-168658652.388109088*%i 0.25-4047807657314589*%i 33554432-1.78103536921841748e+23*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-7.45058059692382812e-09+168658652.388109088*%i 0.25+4047807657314589*%i 33554432+1.78103536921841748e+23*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-16.8658652380108833-168658652.388108224*%i -404780765.5-4047807657314569*%i -17810353664557056-1.78103536921840842e+23*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[0.351883806529722065-0.901214954842308846*%i 0.0829767227596750478-2.02168904229560242*%i 0.0132137736128492556-7.99421683125834193*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.351883806529722065+0.901214954842308846*%i 0.0829767227596750478+2.02168904229560242*%i 0.0132137736128492556+7.99421683125834193*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.56822260350909426-0.783028531402667483*%i -1.65636015475537968-1.16214575591738067*%i -6.71976207741457632-4.33041279463380935*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[0.412044162415464765+0.236105148830688782*%i 0.406986020132752646+0.137707238974328822*%i 0.391959608420343553+0.0774312728572489062*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.412044162415464765-0.236105148830688782*%i 0.406986020132752646-0.137707238974328822*%i 0.391959608420343553-0.0774312728572489062*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.374601468553362349-0.291890001272204935*%i -0.370240997918180659+0.217996577289598981*%i 0.0369333919769440355+0.397823907283612055*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[ 0.412044162415464765+0.236105148830688782*%i 0.463422297657139992-0.249464037123650451*%i 0.267641874148340619-0.601985736612042799*%i
0.0388438196375475442+0.404200660729673644*%i 0.406986020132752646+0.137707238974328822*%i 0.408840802508480261-0.25272269785791196*%i
-0.277293686932808758+0.231079618553641175*%i 0.130302183508562208+0.350580558421466015*%i 0.391959608420343553+0.0774312728572489062*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.412044162415464765-0.236105148830688782*%i 0.463422297657139992+0.249464037123650451*%i 0.267641874148340619+0.601985736612042799*%i
0.0388438196375475442-0.404200660729673644*%i 0.406986020132752646-0.137707238974328822*%i 0.408840802508480261+0.25272269785791196*%i
-0.277293686932808758-0.231079618553641175*%i 0.130302183508562208-0.350580558421466015*%i 0.391959608420343553-0.0774312728572489062*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.374601468553362349-0.291890001272204935*%i -0.493988964367443439+0.181569366543571309*%i -0.349915679185554551+0.558191738869442844*%i
-0.331290083561390059-0.234806083805821214*%i -0.370240997918180659+0.217996577289598981*%i -0.075975014148608605+0.474602318824380143*%i
-0.3002455888615011-0.200355097995776388*%i -0.299218405550633115+0.224396374190722392*%i 0.0369333919769440355+0.397823907283612055*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
8.40000000000000036];
yref=[0.174095089182458529+0.240546076055273117*%i 0.197117350906682559-0.228566945221770845*%i -0.29290554726319884-0.10277969811338393*%i
0.244808700524773382-0.12841584805211595*%i -0.0775662890440067115-0.268892924189574611*%i -0.285438661452586284-0.0124328265233755314*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.173215606457922-0.239907094453251313*%i -0.672527395792539839-0.116838670628740482*%i 0.578574584743836495+0.310330402777423575*%i
0.244808700524773382+0.12841584805211595*%i -0.0775662890440067115+0.268892924189574611*%i -0.285438661452586284+0.0124328265233755314*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.112981679720558184+0.274602721819283191*%i 0.29808070707952472+0.0473918826746817651*%i -0.0666834039986073102-0.303167692198543615*%i
-0.236870424138133084-0.142528355256746092*%i -0.189516305562587112+0.205921110625372272*%i 0.1375999783672541+0.250391794155750469*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[ 0.999999999999997446-10.3349026794206473*%i
5.03898043091051198e-08-6366197.72367634624*%i
1.27222187258540667e-15-127323954473516.594*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.999999999999997446+10.3349026794206473*%i
5.03898043091051198e-08+6366197.72367634624*%i
1.27222187258540667e-15+127323954473516.594*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.999998966509724529-10.3349027794205952*%i
-0.636619721977829234-6366197.72367631458*%i
-12732395.4473516364-127323954473515.953*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[0.765197686557966383+0.0882569642156769973*%i
0.440050585744933553-0.781212821300288907*%i
0.114903484931900571-1.65068260681625478*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.765197686557966383-0.0882569642156769973*%i
0.440050585744933553+0.781212821300288907*%i
0.114903484931900571+1.65068260681625478*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.487703749086956295-0.596206209606004012*%i
-0.419607575907496144-0.792380888474382039*%i
-1.32691890090194864-0.988555567342760066*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[-0.260051954901933502+0.376850010012790504*%i 0.339058958525936538+0.324674424791800087*%i 0.486091260585891194-0.160400393484923798*%i
-0.397149809863847292-0.0169407393250650198*%i -0.066043328023549161+0.397925710557099965*%i 0.36412814585207276+0.215903594603614996*%i
-0.177596771314338348-0.308517625249033867*%i -0.327579137591465286+0.147863143391226887*%i 0.0465651162777522137+0.367662882605524655*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933502-0.376850010012790504*%i 0.339058958525936538-0.324674424791800087*%i 0.486091260585891194+0.160400393484923798*%i
-0.397149809863847292+0.0169407393250650198*%i -0.066043328023549161-0.397925710557099965*%i 0.36412814585207276-0.215903594603614996*%i
-0.177596771314338348+0.308517625249033867*%i -0.327579137591465286-0.147863143391226887*%i 0.0465651162777522137-0.367662882605524655*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.31063056052955762-0.336380148284720293*%i -0.289847767402387269-0.369273247341898037*%i -0.503862405464482466+0.090197983390121611*%i
0.272415233538270574-0.289490760923486856*%i -0.257982370633597746-0.310083357729930509*%i -0.401406418855069447+0.134449082058521574*%i
0.245467551730485706-0.257816638947182653*%i -0.234711371607197766-0.272180404505854456*%i -0.339352100373364829+0.148944477144840881*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.288216947635014376+0.0627738863740376352*%i 0.0825704304932578792+0.284594371868072016*%i 0.265594911883436868-0.140744947159810813*%i
0.0691572616569851861+0.266221867363905018*%i 0.270786268276835496-0.0534845083974161417*%i -0.00468434063869102493-0.278956274125194581*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.864650842905043127-0.0627738863740379682*%i -0.24771129147977386-0.284594371868071905*%i -0.796784735650310605+0.14074494715981109*%i
0.0691572616569851861-0.266221867363905018*%i 0.270786268276835496+0.0534845083974161417*%i -0.00468434063869102493+0.278956274125194581*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.205009668070646411-0.212086316654584245*%i -0.198591028778410006+0.219939618485522376*%i 0.259418169105827268+0.151828886932523333*%i
0.191600335830164975-0.197347715498268128*%i -0.186324039282828008-0.203639750812897008*%i -0.235963202326076427+0.148862060542816477*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[ -0.260051954901933502+0.376850010012790504*%i
-0.0660433280235491887+0.397925710557099965*%i
0.0465651162777522137+0.367662882605524655*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.260051954901933502-0.376850010012790504*%i
-0.0660433280235491887-0.397925710557099965*%i
0.0465651162777522137-0.367662882605524655*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.31063056052955762-0.336380148284720293*%i
-0.257982370633597746-0.310083357729930509*%i
-0.339352100373364829+0.148944477144840881*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.282580089296005532+0.0611426719248229084*%i 0.0805588566675057294+0.279108983487138917*%i 0.260718835711755859-0.13767078042426989*%i
0.0680949286455164587+0.260860299794333839*%i 0.265388401248268402-0.0527501414166842847*%i -0.00493747580632844518-0.273570232162209104*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.859124750279884219-0.0578395374887053712*%i -0.245747300872034974-0.268032077903665344*%i -0.791998414023906472+0.131456891260273934*%i
0.0702343630487119036-0.271692474123097438*%i 0.276292676347178967+0.05422698542193536*%i -0.00442002466557511048+0.284446960322645992*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.204710539394216295-0.212355593630163458*%i -0.198923241476530482+0.219693383394633845*%i 0.259374551315559143+0.152315389993061961*%i
0.191359168939230689-0.197567749205550591*%i -0.186588090699604608-0.203436398574806665*%i -0.235899979077726946+0.149236560997593054*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
1.02000000000000002
2.02000000000000002];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
1.02000000000000002
2.02000000000000002];
x=[0];
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
1.02000000000000002
2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[ 0.722522753107867954-10.5435018262277929*%i
3.59141267836093903e-08-8811068.85048608482*%i
0.0009765625-179745804549905.625*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.722522753107867954+10.5435018262277929*%i
3.59141267836093903e-08+8811068.85048608482*%i
0.0009765625+179745804549905.625*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.722521698757681685-10.5435018984800166*%i
-0.881106849177740514-8811068.85048604198*%i
-17974580.4541015625-179745804549904.75*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
1.02000000000000002
2.02000000000000002];
x=[1];
yref=[0.767624213200681527+0.0643040307807657419*%i
0.430847058235354241-0.793245652497184595*%i
0.111303785599441013-1.68252516187502232*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.767624213200681527-0.0643040307807657419*%i
0.430847058235354241+0.793245652497184595*%i
0.111303785599441013+1.68252516187502232*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.468859108540752967-0.61118988653690054*%i
-0.434705541360321801-0.791137753558994627*%i
-1.3556584129158098-1.00273113072344833*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
1.02000000000000002
2.02000000000000002];
x=[3 4 5];
yref=[-0.248113342531625036+0.384820425921874987*%i 0.34741032197772298+0.316452158174697407*%i 0.484352361476476645-0.169632958363080733*%i
-0.397488017750936229-0.00447693217669133808*%i -0.0555197528009769292+0.399776541248366868*%i 0.369172943822437927+0.208362968213358424*%i
-0.187188738237360874-0.302795423995985136*%i -0.323527150348925874+0.15685459545204769*%i 0.055189660894999118+0.366792098940420641*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.248113342531625036-0.384820425921874987*%i 0.34741032197772298-0.316452158174697407*%i 0.484352361476476645+0.169632958363080733*%i
-0.397488017750936229+0.00447693217669133808*%i -0.0555197528009769292-0.399776541248366868*%i 0.369172943822437927-0.208362968213358424*%i
-0.187188738237360874+0.302795423995985136*%i -0.323527150348925874-0.15685459545204769*%i 0.055189660894999118-0.366792098940420641*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.299936209020461475-0.345955577303420303*%i -0.299275880887315104-0.36231180956354514*%i -0.503443808023835704+0.0995835468002096852*%i
0.263203660615266066-0.297893605530577366*%i -0.266261751732053742-0.303328873416572331*%i -0.398997153998613463+0.143195880088125477*%i
0.237259515744153937-0.265391436758334764*%i -0.242184097696100997-0.265744320636297771*%i -0.336070627604163175+0.156967753938725224*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
1.02000000000000002
2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ -0.2861015270808977+0.07180391829547704*%i 0.0922605432719850876+0.281660571010428407*%i 0.260319128687082679-0.150514543618939234*%i
0.0774792372615422525+0.26392041753001122*%i 0.269158266698861615-0.0613287659781691918*%i -0.0121122296346758626-0.278814546410423747*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.865048002509834491-0.0353796934361930923*%i -0.240752697743061989-0.291002905498753572*%i -0.797769166428211829+0.116701053328995441*%i
0.0774792372615422525-0.26392041753001122*%i 0.269158266698861615+0.0613287659781691918*%i -0.0121122296346758626+0.278814546410423747*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.211576262708756763-0.205536788772230028*%i -0.190998266617662588+0.226637038578893113*%i 0.26495112077725419+0.14220260264881332*%i
0.185312011803817039-0.203264549976300057*%i -0.192182330497776832-0.198175028480340659*%i -0.231984863496134286+0.155136328773931631*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
1.02000000000000002
2.02000000000000002];
x=[3
4
5];
yref=[ -0.248113342531625036+0.384820425921874987*%i
-0.0555197528009769431+0.399776541248366868*%i
0.0551896608949991249+0.366792098940420641*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.248113342531625036-0.384820425921874987*%i
-0.0555197528009769431-0.399776541248366868*%i
0.0551896608949991249-0.366792098940420641*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.299936209020461475-0.345955577303420303*%i
-0.266261751732053742-0.303328873416572331*%i
-0.336070627604163175+0.156967753938725224*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
1.02000000000000002
2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.280518747912432531+0.0699962983078473294*%i 0.0900627485375180697+0.276248225205322884*%i 0.255562216836810185-0.147262806532555718*%i
0.0762491476344531877+0.258594841647395546*%i 0.263784667726966349-0.0604384587417038308*%i -0.0122224672719179299-0.273425197533148701*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.859392120978805685-0.0306266274001191323*%i -0.239301736230959433-0.274428712544276476*%i -0.792729368128768042+0.107498932694273241*%i
0.0787275103035753876-0.269354514879212581*%i 0.274640078092432294+0.0622303207195611732*%i -0.0119936004153480373+0.284308702506610222*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.211285760234088904-0.205815354225449693*%i -0.191340413986076152+0.226403734315470978*%i 0.264929169130263764+0.142693333701389785*%i
0.185064066088280632-0.203476918530006629*%i -0.192441625422114404-0.197965053817515446*%i -0.231914093404297944+0.155511238858410061*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[-5.03898043091051198e-08+6366197.72367634624*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-5.03898043091051198e-08-6366197.72367634624*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.636619721977829234+6366197.72367631458*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[-0.440050585744933553+0.781212821300288907*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.440050585744933553-0.781212821300288907*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.419607575907496144+0.792380888474382039*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[-0.339058958525936538-0.324674424791800087*%i 0.0660433280235491887-0.397925710557099965*%i 0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538+0.324674424791800087*%i 0.0660433280235491887+0.397925710557099965*%i 0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.289847767402387269+0.369273247341898037*%i 0.257982370633597746+0.310083357729930509*%i 0.234711371607197739+0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.0825704304932578653-0.284594371868072016*%i -0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.247711291479773887+0.284594371868071905*%i -0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198591028778410006-0.219939618485522376*%i 0.186324039282828008+0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[-0.339058958525936538-0.324674424791800087*%i
0.0660433280235491887-0.397925710557099965*%i
0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538+0.324674424791800087*%i
0.0660433280235491887+0.397925710557099965*%i
0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.289847767402387269+0.369273247341898037*%i
0.257982370633597746+0.310083357729930509*%i
0.234711371607197739+0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
8.40000000000000036];
yref=[-0.0825704304932578653-0.284594371868072016*%i
-0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.247711291479773887+0.284594371868071905*%i
-0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198591028778410006-0.219939618485522376*%i
0.186324039282828008+0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.0805588566675057155-0.279108983487138917*%i -0.265388401248268402+0.0527501414166842708*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.245747300872035002+0.268032077903665344*%i -0.276292676347178967-0.0542269854219353462*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198923241476530482-0.219693383394633845*%i 0.186588090699604608+0.203436398574806665*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[-5.03898043091051198e-08+6366197.72367634624*%i
-25231325220.2017288-1.0872797214348254e-06*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-5.03898043091051198e-08-6366197.72367634624*%i
-25231325220.2017288+1.0872797214348254e-06*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.636619721977829234+6366197.72367631458*%i
-25231325220.2016029+2523.1325234030769*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[-0.440050585744933553+0.781212821300288907*%i
-1.10249557516017949-0.240297839123426921*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.440050585744933553-0.781212821300288907*%i
-1.10249557516017949+0.240297839123426921*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.419607575907496144+0.792380888474382039*%i
-0.797884560802865517+0.797884560802865628*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[-0.339058958525936538-0.324674424791800087*%i 0.0870080907208351517-0.477718215087091835*%i
0.0660433280235491887-0.397925710557099965*%i 0.367112032460934101-0.185285948354268981*%i
0.327579137591465286-0.147863143391226859*%i 0.3219244429611402+0.169651306144740777*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538+0.324674424791800087*%i 0.0870080907208351517+0.477718215087091835*%i
0.0660433280235491887+0.397925710557099965*%i 0.367112032460934101+0.185285948354268981*%i
0.327579137591465286+0.147863143391226859*%i 0.3219244429611402-0.169651306144740777*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.289847767402387269+0.369273247341898037*%i -0.153552955320593432+0.460658865961780795*%i
0.257982370633597746+0.310083357729930509*%i -0.099735570100358148+0.398942280401432703*%i
0.234711371607197739+0.272180404505854456*%i -0.0713649646461108761+0.356824823230554311*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.0825704304932578653-0.284594371868072016*%i 0.120953010973630551-0.272424375376841443*%i
-0.270786268276835496+0.0534845083974161278*%i -0.218249100772301557-0.170966347821113224*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.247711291479773887+0.284594371868071905*%i -0.12095301097362865-0.27242437537684111*%i
-0.270786268276835496-0.0534845083974161278*%i -0.218249100772301557+0.170966347821113224*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198591028778410006-0.219939618485522376*%i 0.295310324905105781-0.0404534691650830225*%i
0.186324039282828008+0.203639750812897008*%i -0.0327733723655391565+0.275296327870529045*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
8.40000000000000036];
yref=[-0.0825704304932578653-0.284594371868072016*%i
-0.218249100772301557-0.170966347821113224*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.247711291479773887+0.284594371868071905*%i
-0.218249100772301557+0.170966347821113224*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.198591028778410006-0.219939618485522376*%i
-0.0327733723655391565+0.275296327870529045*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.0805588566675057155-0.279108983487138917*%i 0.118980970251344659-0.266959004819083301*%i
-0.265388401248268402+0.0527501414166842708*%i -0.214192031331076199-0.167365441205606091*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.245747300872035002+0.268032077903665344*%i -0.122956267664942304-0.277999563638954672*%i
-0.276292676347178967-0.0542269854219353462*%i -0.222382024788788296+0.174643212333444514*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198923241476530482-0.219693383394633845*%i 0.295475738987752923-0.040048367037329724*%i
0.186588090699604608+0.203436398574806665*%i -0.032445291449234602+0.275412789424954285*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
0
1];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
0
1];
x=[0];
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
0
1];
x=[9.99999999999999955e-08];
yref=[ -311843.447284119495+5.09295817894065707e+21*%i
1.27222187258540667e-15-127323954473516.594*%i
-5.03898043091051198e-08+6366197.72367634624*%i
0.999999999999997446-10.3349026794206473*%i
5.03898043091051198e-08-6366197.72367634624*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -311843.447284119495-5.09295817894065707e+21*%i
1.27222187258540667e-15+127323954473516.594*%i
-5.03898043091051198e-08-6366197.72367634624*%i
0.999999999999997446+10.3349026794206473*%i
5.03898043091051198e-08+6366197.72367634624*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 509295817582221.438+5.09295817894063191e+21*%i
-12732395.4473516364-127323954473515.953*%i
0.636619721977829234+6366197.72367631458*%i
0.999998966509724529-10.3349027794205952*%i
-0.636619721977829234-6366197.72367631458*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
0
1];
x=[1];
yref=[-0.0195633539826691495+5.82151760596473089*%i
0.114903484931900571-1.65068260681625478*%i
-0.440050585744933553+0.781212821300288907*%i
0.765197686557966383+0.0882569642156769973*%i
0.440050585744933553-0.781212821300288907*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.0195633539826691495-5.82151760596473089*%i
0.114903484931900571+1.65068260681625478*%i
-0.440050585744933553-0.781212821300288907*%i
0.765197686557966383-0.0882569642156769973*%i
0.440050585744933553+0.781212821300288907*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 4.88806802770029858+3.16184138089665856*%i
-1.32691890090194864-0.988555567342760066*%i
0.419607575907496144+0.792380888474382039*%i
0.487703749086956295-0.596206209606004012*%i
-0.419607575907496144-0.792380888474382039*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
0
1];
x=[3 4 5];
yref=[-0.309062722255251721+0.538541616105031817*%i 0.486091260585891194-0.160400393484923798*%i -0.339058958525936538-0.324674424791800087*%i -0.260051954901933502+0.376850010012790504*%i 0.339058958525936538+0.324674424791800087*%i
-0.430171473875621879+0.182022115953484942*%i 0.36412814585207276+0.215903594603614996*%i 0.0660433280235491887-0.397925710557099965*%i -0.397149809863847292-0.0169407393250650198*%i -0.0660433280235491887+0.397925710557099965*%i
-0.364831230613667068-0.146267162693192898*%i 0.0465651162777522137+0.367662882605524655*%i 0.327579137591465286-0.147863143391226859*%i -0.177596771314338348-0.308517625249033867*%i -0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.309062722255251721-0.538541616105031817*%i 0.486091260585891194+0.160400393484923798*%i -0.339058958525936538+0.324674424791800087*%i -0.260051954901933502-0.376850010012790504*%i 0.339058958525936538-0.324674424791800087*%i
-0.430171473875621879-0.182022115953484942*%i 0.36412814585207276-0.215903594603614996*%i 0.0660433280235491887+0.397925710557099965*%i -0.397149809863847292+0.0169407393250650198*%i -0.0660433280235491887-0.397925710557099965*%i
-0.364831230613667068+0.146267162693192898*%i 0.0465651162777522137-0.367662882605524655*%i 0.327579137591465286+0.147863143391226859*%i -0.177596771314338348+0.308517625249033867*%i -0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.381968773216922741-0.489537225195393555*%i -0.503862405464482466+0.090197983390121611*%i 0.289847767402387269+0.369273247341898037*%i 0.31063056052955762-0.336380148284720293*%i -0.289847767402387269-0.369273247341898037*%i
0.143424048221471756-0.444532439788452083*%i -0.401406418855069447+0.134449082058521574*%i 0.257982370633597746+0.310083357729930509*%i 0.272415233538270574-0.289490760923486856*%i -0.257982370633597746-0.310083357729930509*%i
0.0367703086914941552-0.391335986221727217*%i -0.339352100373364829+0.148944477144840881*%i 0.234711371607197739+0.272180404505854456*%i 0.245467551730485706-0.257816638947182653*%i -0.234711371607197739-0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
0
1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.228101889059524665+0.207473852876394915*%i 0.265594911883436868-0.140744947159810813*%i -0.0825704304932578653-0.284594371868072016*%i -0.288216947635014376+0.0627738863740376352*%i 0.0825704304932578653+0.284594371868072016*%i
0.273016906676212145+0.0793518126145812824*%i -0.00468434063869102493-0.278956274125194581*%i -0.270786268276835496+0.0534845083974161278*%i 0.0691572616569851861+0.266221867363905018*%i 0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.684305667178574106-0.207473852876394582*%i -0.796784735650310605+0.14074494715981109*%i 0.247711291479773887+0.284594371868071905*%i 0.864650842905043127-0.0627738863740379682*%i -0.247711291479773887-0.284594371868071905*%i
0.273016906676212145-0.0793518126145812824*%i -0.00468434063869102493+0.278956274125194581*%i -0.270786268276835496-0.0534845083974161278*%i 0.0691572616569851861-0.266221867363905018*%i 0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ -0.056444086802614292+0.303133529133480351*%i 0.259418169105827268+0.151828886932523333*%i 0.198591028778410006-0.219939618485522376*%i -0.205009668070646411-0.212086316654584245*%i -0.198591028778410006+0.219939618485522376*%i
-0.0739606096037440097-0.274526446309476313*%i -0.235963202326076427+0.148862060542816477*%i 0.186324039282828008+0.203639750812897008*%i 0.191600335830164975-0.197347715498268128*%i -0.186324039282828008-0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
0
1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.223624092905500088+0.204064898970382769*%i 0.260718835711755859-0.13767078042426989*%i -0.0805588566675057155-0.279108983487138917*%i -0.282580089296005532+0.0611426719248229084*%i 0.0805588566675057155+0.279108983487138917*%i
0.268049735447983994+0.077515061198177887*%i -0.00493747580632844518-0.273570232162209104*%i -0.265388401248268402+0.0527501414166842708*%i 0.0680949286455164587+0.260860299794333839*%i 0.265388401248268402-0.0527501414166842708*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.679913121372516915-0.197190400008995986*%i -0.791998414023906472+0.131456891260273934*%i 0.245747300872035002+0.268032077903665344*%i 0.859124750279884219-0.0578395374887053712*%i -0.245747300872035002-0.268032077903665344*%i
0.278074937671342448-0.0812281915443821972*%i -0.00442002466557511048+0.284446960322645992*%i -0.276292676347178967-0.0542269854219353462*%i 0.0702343630487119036-0.271692474123097438*%i 0.276292676347178967+0.0542269854219353462*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.0570299235953570793+0.303542619878177933*%i 0.259374551315559143+0.152315389993061961*%i 0.198923241476530482-0.219693383394633845*%i -0.204710539394216295-0.212355593630163458*%i -0.198923241476530482+0.219693383394633845*%i
-0.0744246056267901385-0.274768483538119612*%i -0.235899979077726946+0.149236560997593054*%i 0.186588090699604608+0.203436398574806665*%i 0.191359168939230689-0.197567749205550591*%i -0.186588090699604608-0.203436398574806665*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
0
1];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
0
1];
x=[0];
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
0
1];
x=[9.99999999999999955e-08];
yref=[ 1.27222187258540667e-15-127323954473516.594*%i
-5.03898043091051198e-08+6366197.72367634624*%i
0.999999999999997446-10.3349026794206473*%i
5.03898043091051198e-08-6366197.72367634624*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 1.27222187258540667e-15+127323954473516.594*%i
-5.03898043091051198e-08-6366197.72367634624*%i
0.999999999999997446+10.3349026794206473*%i
5.03898043091051198e-08+6366197.72367634624*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ -12732395.4473516364-127323954473515.953*%i
0.636619721977829234+6366197.72367631458*%i
0.999998966509724529-10.3349027794205952*%i
-0.636619721977829234-6366197.72367631458*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
0
1];
x=[1];
yref=[ 0.114903484931900571-1.65068260681625478*%i
-0.440050585744933553+0.781212821300288907*%i
0.765197686557966383+0.0882569642156769973*%i
0.440050585744933553-0.781212821300288907*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.114903484931900571+1.65068260681625478*%i
-0.440050585744933553-0.781212821300288907*%i
0.765197686557966383-0.0882569642156769973*%i
0.440050585744933553+0.781212821300288907*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ -1.32691890090194864-0.988555567342760066*%i
0.419607575907496144+0.792380888474382039*%i
0.487703749086956295-0.596206209606004012*%i
-0.419607575907496144-0.792380888474382039*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
0
1];
x=[3 4 5];
yref=[ 0.486091260585891194-0.160400393484923798*%i -0.339058958525936538-0.324674424791800087*%i -0.260051954901933502+0.376850010012790504*%i 0.339058958525936538+0.324674424791800087*%i
0.36412814585207276+0.215903594603614996*%i 0.0660433280235491887-0.397925710557099965*%i -0.397149809863847292-0.0169407393250650198*%i -0.0660433280235491887+0.397925710557099965*%i
0.0465651162777522137+0.367662882605524655*%i 0.327579137591465286-0.147863143391226859*%i -0.177596771314338348-0.308517625249033867*%i -0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.486091260585891194+0.160400393484923798*%i -0.339058958525936538+0.324674424791800087*%i -0.260051954901933502-0.376850010012790504*%i 0.339058958525936538-0.324674424791800087*%i
0.36412814585207276-0.215903594603614996*%i 0.0660433280235491887+0.397925710557099965*%i -0.397149809863847292+0.0169407393250650198*%i -0.0660433280235491887-0.397925710557099965*%i
0.0465651162777522137-0.367662882605524655*%i 0.327579137591465286+0.147863143391226859*%i -0.177596771314338348+0.308517625249033867*%i -0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.503862405464482466+0.090197983390121611*%i 0.289847767402387269+0.369273247341898037*%i 0.31063056052955762-0.336380148284720293*%i -0.289847767402387269-0.369273247341898037*%i
-0.401406418855069447+0.134449082058521574*%i 0.257982370633597746+0.310083357729930509*%i 0.272415233538270574-0.289490760923486856*%i -0.257982370633597746-0.310083357729930509*%i
-0.339352100373364829+0.148944477144840881*%i 0.234711371607197739+0.272180404505854456*%i 0.245467551730485706-0.257816638947182653*%i -0.234711371607197739-0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
0
1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.265594911883436868-0.140744947159810813*%i -0.0825704304932578653-0.284594371868072016*%i -0.288216947635014376+0.0627738863740376352*%i 0.0825704304932578653+0.284594371868072016*%i
-0.00468434063869102493-0.278956274125194581*%i -0.270786268276835496+0.0534845083974161278*%i 0.0691572616569851861+0.266221867363905018*%i 0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.796784735650310605+0.14074494715981109*%i 0.247711291479773887+0.284594371868071905*%i 0.864650842905043127-0.0627738863740379682*%i -0.247711291479773887-0.284594371868071905*%i
-0.00468434063869102493+0.278956274125194581*%i -0.270786268276835496-0.0534845083974161278*%i 0.0691572616569851861-0.266221867363905018*%i 0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.259418169105827268+0.151828886932523333*%i 0.198591028778410006-0.219939618485522376*%i -0.205009668070646411-0.212086316654584245*%i -0.198591028778410006+0.219939618485522376*%i
-0.235963202326076427+0.148862060542816477*%i 0.186324039282828008+0.203639750812897008*%i 0.191600335830164975-0.197347715498268128*%i -0.186324039282828008-0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
0
1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.260718835711755859-0.13767078042426989*%i -0.0805588566675057155-0.279108983487138917*%i -0.282580089296005532+0.0611426719248229084*%i 0.0805588566675057155+0.279108983487138917*%i
-0.00493747580632844518-0.273570232162209104*%i -0.265388401248268402+0.0527501414166842708*%i 0.0680949286455164587+0.260860299794333839*%i 0.265388401248268402-0.0527501414166842708*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.791998414023906472+0.131456891260273934*%i 0.245747300872035002+0.268032077903665344*%i 0.859124750279884219-0.0578395374887053712*%i -0.245747300872035002-0.268032077903665344*%i
-0.00442002466557511048+0.284446960322645992*%i -0.276292676347178967-0.0542269854219353462*%i 0.0702343630487119036-0.271692474123097438*%i 0.276292676347178967+0.0542269854219353462*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.259374551315559143+0.152315389993061961*%i 0.198923241476530482-0.219693383394633845*%i -0.204710539394216295-0.212355593630163458*%i -0.198923241476530482+0.219693383394633845*%i
-0.235899979077726946+0.149236560997593054*%i 0.186588090699604608+0.203436398574806665*%i 0.191359168939230689-0.197567749205550591*%i -0.186588090699604608-0.203436398574806665*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[0];
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ -716418914.617646098+520508809.337161541*%i
119.403152436272933-86.7425820843251927*%i
8.52879747981205583e-06-53316.8312102425552*%i
0.0001220703125-746435636856.653198*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -716418914.617646098-520508809.337161541*%i
119.403152436272933+86.7425820843251927*%i
8.52879747981205583e-06+53316.8312102425552*%i
0.0001220703125+746435636856.653198*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ -716418862.566761613+520508880.979050338*%i
119.403143762014125-86.7425940246399847*%i
-0.00532315432428731583-53316.8312102422933*%i
-74643.5635986328125-746435636856.649536*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[1];
yref=[-0.96267128684022385+0.314183689901754326*%i
0.633870726369384796+0.454431262899762989*%i
0.582348851018592462-0.586842447641611864*%i
0.181417665056644584-1.27601068959802011*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.96267128684022385-0.314183689901754326*%i
0.633870726369384796-0.454431262899762989*%i
0.582348851018592462+0.586842447641611864*%i
0.181417665056644584+1.27601068959802011*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.255757057120614473+0.97981412790380662*%i
0.7248725373994509-0.287853565155630209*%i
-0.179166465319056278-0.807101988810427939*%i
-0.975705588846130234-0.842089219178969395*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[3 4 5];
yref=[-0.106536302179580572-0.46608061111318333*%i -0.406752056449066923+0.212390924829804678*%i 0.187886713469393868+0.423602426147222433*%i 0.494432522734784108-0.014709792627767504*%i
0.268869311811565981-0.306380088504755344*%i -0.344459534063007222-0.19942551345146825*%i -0.21720038170211492+0.336293915522475506*%i 0.268439400467266942+0.317128383884334675*%i
0.35944584577841987+0.0416545814756734967*%i -0.0150494093195696621-0.355966921924183777*%i -0.3576399166600715+0.00106144915522857208*%i -0.0850897673452503944+0.356264127687647869*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.106536302179580572+0.46608061111318333*%i -0.406752056449066923-0.212390924829804678*%i 0.187886713469393868-0.423602426147222433*%i 0.494432522734784108+0.014709792627767504*%i
0.268869311811565981+0.306380088504755344*%i -0.344459534063007222+0.19942551345146825*%i -0.21720038170211492-0.336293915522475506*%i 0.268439400467266942-0.317128383884334675*%i
0.35944584577841987-0.0416545814756734967*%i -0.0150494093195696621+0.355966921924183777*%i -0.3576399166600715-0.00106144915522857208*%i -0.0850897673452503944-0.356264127687647869*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.0396968401765022405+0.476450711635252655*%i 0.432654092885201846-0.152864568443076054*%i -0.126227658753542527-0.4458777979466374*%i -0.491560333636854974-0.0552117372653547489*%i
0.0561245049814432517+0.403744356501480606*%i 0.376079503294072581-0.130334620206487478*%i -0.112536430475554117-0.384194163470507555*%i -0.415467253960516536-0.0041333370081901577*%i
0.0620176048412275638+0.356497176559695039*%i 0.337076374072698137-0.115405598941508536*%i -0.102466769729951307-0.342648504686714039*%i -0.365767069597084549+0.0194640176292286138*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0420367120856716403-0.294296885430083921*%i -0.285871190821628263-0.0732023688316385257*%i -0.0655329743449836188+0.288280252375428703*%i 0.298439158504227919+0.0179157450884056269*%i
-0.262892922068786006-0.086280619148427995*%i -0.0606892109991265527+0.268366926287592067*%i 0.267227865711580748+0.0671115529850285913*%i 0.105227188617723372-0.257181667456753915*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.208809604864427539-0.0509634500368111726*%i 0.553022915362730627-0.294500434849446491*%i -0.163355666615431105+0.0267579348437040482*%i -0.521694431354299826+0.289368776112292503*%i
-0.262892922068786006+0.086280619148427995*%i -0.0606892109991265527-0.268366926287592067*%i 0.267227865711580748-0.0671115529850285913*%i 0.105227188617723372+0.257181667456753915*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.272395417839566834-0.119073415491575602*%i -0.0881364311870380251-0.281625449918773474*%i -0.279639508074117915+0.0959261182379777672*%i 0.141765925886183919+0.263228660119709246*%i
0.0627819887644752439+0.269472550738063421*%i 0.260861300871524204-0.0874949665087225992*%i -0.081414938826726943-0.263222910273154698*%i -0.274430457342645373+0.0436244814631968347*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0416209715612942399-0.288486935012754131*%i -0.28010358610171443-0.0721332902155140676*%i -0.0646267682459302079+0.282495141853438825*%i 0.292646097237778458+0.017990502767282146*%i
-0.257841240101032931-0.0842758673723411206*%i -0.0591735817167325096+0.26311716547420122*%i 0.262023152985124297+0.0654718271887456127*%i 0.102869840386841327-0.252309232987196319*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.203155336114940382-0.0612984986078191629*%i 0.553905555294752938-0.290836180966331459*%i -0.157563702980964282+0.0375190635506771827*%i -0.523668372270335358+0.283723585718319904*%i
-0.268042418096517854+0.0883312018516905356*%i -0.0622417085009255161-0.273720247940547168*%i 0.272534780013686639-0.0687904516700227342*%i 0.107636616697512302+0.262147089547452361*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.272634230972951086-0.118721332047866335*%i -0.087748953311749589-0.281736812085001009*%i -0.279782977722092485+0.095545296131978083*%i 0.141455761678950437+0.263560198603161933*%i
0.0631218629428649258+0.269449807661711782*%i 0.26075102821782209-0.0878026901637817547*%i -0.0817318984576275442-0.263133877327358878*%i -0.274477351685756932+0.0439797256650979601*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
-1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
-1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[0];
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
-1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 18626891780058596-13533229042766080*%i
-716418914.617646098+520508809.337161541*%i
119.403152436272933-86.7425820843251927*%i
8.52879747981205583e-06-53316.8312102425552*%i
0.0001220703125-746435636856.653198*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 18626891780058596+13533229042766080*%i
-716418914.617646098-520508809.337161541*%i
119.403152436272933+86.7425820843251927*%i
8.52879747981205583e-06+53316.8312102425552*%i
0.0001220703125+746435636856.653198*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 18626890426735600-13533230905455192*%i
-716418862.566761613+520508880.979050338*%i
119.403143762014125-86.7425940246399847*%i
-0.00532315432428731583-53316.8312102422933*%i
-74643.5635986328125-746435636856.649536*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
-1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[1];
yref=[ 1.86907461941519504-1.2713088566443258*%i
-0.96267128684022385+0.314183689901754326*%i
0.633870726369384796+0.454431262899762989*%i
0.582348851018592462-0.586842447641611864*%i
0.181417665056644584-1.27601068959802011*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 1.86907461941519504+1.2713088566443258*%i
-0.96267128684022385-0.314183689901754326*%i
0.633870726369384796-0.454431262899762989*%i
0.582348851018592462+0.586842447641611864*%i
0.181417665056644584+1.27601068959802011*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.0599041888858562466-2.2596631673942662*%i
-0.255757057120614473+0.97981412790380662*%i
0.7248725373994509-0.287853565155630209*%i
-0.179166465319056278-0.807101988810427939*%i
-0.975705588846130234-0.842089219178969395*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
-1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[3 4 5];
yref=[ 0.499083518338036936+0.191545604801620417*%i -0.106536302179580572-0.46608061111318333*%i -0.406752056449066923+0.212390924829804678*%i 0.187886713469393868+0.423602426147222433*%i 0.494432522734784108-0.014709792627767504*%i
0.169694481385489565+0.398572570979558949*%i 0.268869311811565981-0.306380088504755344*%i -0.344459534063007222-0.19942551345146825*%i -0.21720038170211492+0.336293915522475506*%i 0.268439400467266942+0.317128383884334675*%i
-0.171862430485208495+0.334306539556833759*%i 0.35944584577841987+0.0416545814756734967*%i -0.0150494093195696621-0.355966921924183777*%i -0.3576399166600715+0.00106144915522857208*%i -0.0850897673452503944+0.356264127687647869*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.499083518338036936-0.191545604801620417*%i -0.106536302179580572+0.46608061111318333*%i -0.406752056449066923-0.212390924829804678*%i 0.187886713469393868-0.423602426147222433*%i 0.494432522734784108+0.014709792627767504*%i
0.169694481385489565-0.398572570979558949*%i 0.268869311811565981+0.306380088504755344*%i -0.344459534063007222+0.19942551345146825*%i -0.21720038170211492-0.336293915522475506*%i 0.268439400467266942-0.317128383884334675*%i
-0.171862430485208495-0.334306539556833759*%i 0.35944584577841987-0.0416545814756734967*%i -0.0150494093195696621+0.355966921924183777*%i -0.3576399166600715-0.00106144915522857208*%i -0.0850897673452503944-0.356264127687647869*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.467058021038170568-0.260059381640809106*%i 0.0396968401765022405+0.476450711635252655*%i 0.432654092885201846-0.152864568443076054*%i -0.126227658753542527-0.4458777979466374*%i -0.491560333636854974-0.0552117372653547489*%i
-0.412560431532010941-0.132099211519474513*%i 0.0561245049814432517+0.403744356501480606*%i 0.376079503294072581-0.130334620206487478*%i -0.112536430475554117-0.384194163470507555*%i -0.415467253960516536-0.0041333370081901577*%i
-0.369325528590136676-0.069972932869532628*%i 0.0620176048412275638+0.356497176559695039*%i 0.337076374072698137-0.115405598941508536*%i -0.102466769729951307-0.342648504686714039*%i -0.365767069597084549+0.0194640176292286138*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
-1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.300843170468579835-0.0316156999516793158*%i 0.0420367120856716403-0.294296885430083921*%i -0.285871190821628263-0.0732023688316385257*%i -0.0655329743449836188+0.288280252375428703*%i 0.298439158504227919+0.0179157450884056269*%i
0.142060829734702965-0.241661020360697809*%i -0.262892922068786006-0.086280619148427995*%i -0.0606892109991265527+0.268366926287592067*%i 0.267227865711580748+0.0671115529850285913*%i 0.105227188617723372-0.257181667456753915*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.478652371164440149+0.276349069082910681*%i 0.208809604864427539-0.0509634500368111726*%i 0.553022915362730627-0.294500434849446491*%i -0.163355666615431105+0.0267579348437040482*%i -0.521694431354299826+0.289368776112292503*%i
0.142060829734702965+0.241661020360697809*%i -0.262892922068786006+0.086280619148427995*%i -0.0606892109991265527-0.268366926287592067*%i 0.267227865711580748-0.0671115529850285913*%i 0.105227188617723372+0.257181667456753915*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.185153977266883929+0.239215740291636808*%i 0.272395417839566834-0.119073415491575602*%i -0.0881364311870380251-0.281625449918773474*%i -0.279639508074117915+0.0959261182379777672*%i 0.141765925886183919+0.263228660119709246*%i
-0.280293821203385529+0.00408679604217940251*%i 0.0627819887644752439+0.269472550738063421*%i 0.260861300871524204-0.0874949665087225992*%i -0.081414938826726943-0.263222910273154698*%i -0.274430457342645373+0.0436244814631968347*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
-1.30000000000000004
-0.300000000000000044
0.699999999999999956
1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.295208883882440876-0.0305740967814102649*%i 0.0416209715612942399-0.288486935012754131*%i -0.28010358610171443-0.0721332902155140676*%i -0.0646267682459302079+0.282495141853438825*%i 0.292646097237778458+0.017990502767282146*%i
0.139043239894831056-0.237221943806996016*%i -0.257841240101032931-0.0842758673723411206*%i -0.0591735817167325096+0.26311716547420122*%i 0.262023152985124297+0.0654718271887456127*%i 0.102869840386841327-0.252309232987196319*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.481489589165971232+0.269202238903625657*%i 0.203155336114940382-0.0612984986078191629*%i 0.553905555294752938-0.290836180966331459*%i -0.157563702980964282+0.0375190635506771827*%i -0.523668372270335358+0.283723585718319904*%i
0.145141652219097028+0.246182257025218565*%i -0.268042418096517854+0.0883312018516905356*%i -0.0622417085009255161-0.273720247940547168*%i 0.272534780013686639-0.0687904516700227342*%i 0.107636616697512302+0.262147089547452361*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.184966673823006966+0.239718851959764251*%i 0.272634230972951086-0.118721332047866335*%i -0.087748953311749589-0.281736812085001009*%i -0.279782977722092485+0.095545296131978083*%i 0.141455761678950437+0.263560198603161933*%i
-0.280487209938313775+0.00444855012972955599*%i 0.0631218629428649258+0.269449807661711782*%i 0.26075102821782209-0.0878026901637817547*%i -0.0817318984576275442-0.263133877327358878*%i -0.274477351685756932+0.0439797256650979601*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
