/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* Detection tables for Adibou presente / Adiboo presents series. */

#ifndef GOB_DETECTION_TABLES_ADIBOUPRESENTE_H
#define GOB_DETECTION_TABLES_ADIBOUPRESENTE_H

// -- French: Adibou presente Dessin --

{
	{
		"adiboudessin",
		_s("Missing game code"), // Adibou presente Dessin 1.00 (Engine: DEV7 version 1.1.0.0)
		AD_ENTRY1s("adibou.stk", "14e3f8e9c237d4236d93e08c60b784bc", 217172),
		FR_FRA,
		kPlatformWindows,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kGameTypeNone,
	kFeatures640x480,
	0, 0, 0
},

#endif // GOB_DETECTION_TABLES_ADIBOUPRESENTE_H
