/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "OpenDRIM_SSHCapabilitiesAccess.h"

const string InstanceID = "OpenDRIM:SSHCapabilities";

int SSH_OpenDRIM_SSHCapabilities_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHCapabilities_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHCapabilities>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	if (!CF_isExist("/usr/sbin/sshd"))
		return OK;
	
	OpenDRIM_SSHCapabilities instance;
	instance.setInstanceID(InstanceID);
	
	if (discriminant == "ei")
		CF_assert(SSH_OpenDRIM_SSHCapabilities_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHCapabilities& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID != InstanceID ||
			!CF_isExist("/usr/sbin/sshd"))
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(SSH_OpenDRIM_SSHCapabilities_populate(instance, errorMessage));
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHCapabilities& newInstance, const OpenDRIM_SSHCapabilities& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHCapabilities_CreateGoalSettings(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHCapabilities& instance, unsigned short& returnValue, const OpenDRIM_SSHCapabilities_CreateGoalSettings_In& in, OpenDRIM_SSHCapabilities_CreateGoalSettings_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHCapabilities_populate(OpenDRIM_SSHCapabilities& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] InstanceID [KEY]
	 * [X] ElementName
	 * [X] RequestedStatesSupported
	 * [X] ElementNameEditSupported
	 * [X] MaxConnections
	 * [X] SupportedSSHVersions
	 * [X] SupportedEncryptionAlgorithms
	 * [X] ListeningPortManagementSupported
	 * [X] MaxListeningPorts
	 * + Conditional:
	 * [X] MaxElementNameLen
	 * [X] OtherSupportedSSHVersion
	 * [X] OtherSupportedEncryptionAlgorithm
	 */

	instance.setElementName("SSH Service Capabilities");
	instance.setElementNameEditSupported(false);

	string out_str;
	unsigned short maxSessions;
	CF_assert(CF_getConfigItem("MaxSession", out_str, errorMessage));
	
	if (out_str.size() != 0)
	{
		maxSessions = atoi(out_str.c_str());
		instance.setMaxConnections(maxSessions);
	}
	else
		instance.setMaxConnections(10);

	vector<unsigned short> supportedSSHVersions;
	supportedSSHVersions.push_back(SSHV_SSHv1);
	supportedSSHVersions.push_back(SSHV_SSHv2);
	instance.setSupportedSSHVersions(supportedSSHVersions);

	vector<unsigned short> supportedEncryptionAlgorithms;
	supportedEncryptionAlgorithms.push_back(OTHER);
	supportedEncryptionAlgorithms.push_back(DES3);
	supportedEncryptionAlgorithms.push_back(RC4);
	instance.setSupportedEncryptionAlgorithms(supportedEncryptionAlgorithms);
	
	instance.setOtherSupportedEncryptionAlgorithm("AES, BLOWFISH, CAST");
	instance.setListeningPortManagementSupported(false);
	instance.setMaxListeningPorts(1);
	_L_;
	return OK;
}

