/*
 *  Copyright 2011 Wolfgang Koller - http://www.gofg.at/
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

function Connection() {
    var self = this;
    self.type = Connection.UNKNOWN;

    var first = true;
    Cordova.deviceready.freeze();

    Cordova.exec(function (res) {
        self.type = res;
        if (first) {
            Cordova.deviceready.unfreeze();
            first = false;
        }
    }, null, "com.cordova.Connection", "getType", []);
}

Connection.UNKNOWN = "unknown";
Connection.ETHERNET = "ethernet";
Connection.WIFI = "wifi";
Connection.CELL_2G = "2g";
Connection.CELL_3G = "3g";
Connection.CELL_4G = "4g";
Connection.NONE = "none";
Connection.CELL = "cellular";

Cordova.addConstructor("com.cordova.Connection", function() {
    if (typeof(navigator.network) === "undefined") navigator.network = {};

    navigator.network.connection = new Connection();
    navigator.connection = navigator.network.connection;
    window.Connection = Connection;
});
