
function GlobalizationError(code, message) {
    this.code = code;
    this.message = message;
}

GlobalizationError.UNKNOWN_ERROR = 0;
GlobalizationError.FORMATTING_ERROR = 1;
GlobalizationError.PARSING_ERROR = 2;
GlobalizationError.PATTERN_ERROR = 3;

function convertStringToDateOptions(override) {
    var options = { formatLength: 'short', selector: 'date and time' };

    if (override) {
        for (var key in options) {
            if (!options.hasOwnProperty(key))
                continue;
            if (typeof(options[key]) !== typeof(override[key]))
                continue;
            options[key] = override[key];
        }
    }
    var formats = ["short", "medium", "long", "full"];
    var selectors = ["date", "time", "date and time"];

    options.formatLength = formats.indexOf(options.formatLength);
    options.selector = selectors.indexOf(options.selector);
    //TODO: throw error
    if (options.formatLength === -1)
        options.formatLength = 0;
    if (options.selector === -1)
        options.selector = 0;

    return options;
}

function convertStringToNumberOptions(override) {
    var options = { type: 'decimal' };
    //TODO: make function
    if (override) {
        for (var key in options) {
            if (!options.hasOwnProperty(key))
                continue;
            if (typeof(options[key]) !== typeof(override[key]))
                continue;
            options[key] = override[key];
        }
    }

    var types = [ 'decimal', 'percent', 'currency' ];
    options.type = types.indexOf(options.type);
    if (options.type === -1)
        options.type = 0;

    return options;
}

function isInt(n) {
   return n % 1 === 0;
}

var Globalization = {
    getPreferredLanguage: function (successCB, errorCB) {
        Cordova.exec(successCB, null, "com.cordova.Globalization", "getPreferredLanguage", [ { } ]);
    },

    getLocaleName: function (successCB, errorCB) {
        if (typeof(successCB) != "function") return;
        successCB({ value: navigator.language.replace('-', '_') });
    },

    dateToString: function (date, successCB, errorCB, override) {
        if (!(date instanceof Date)) return;
        if (typeof(successCB) != "function") return;
        if (typeof(errorCB) != "function") errorCB = new Function();

        var options = convertStringToDateOptions(override);
        Cordova.exec(successCB, errorCB, "com.cordova.Globalization", "dateToString",
                     [ { time_t: date.getTime(), formatLength: options.formatLength, selector: options.selector } ]);
    },

    stringToDate: function (dateString, successCB, errorCB, override) {
        if (typeof(dateString) !== 'string') return;
        if (typeof(successCB) != "function") return;
        if (typeof(errorCB) != "function") errorCB = new Function();

        var options = convertStringToDateOptions(override);
        Cordova.exec(successCB, errorCB, "com.cordova.Globalization", "stringToDate",
                     [ { dateString: dateString, formatLength: options.formatLength, selector: options.selector } ]);
    },

    getDateNames: function (successCB, errorCB, override) {
        if (typeof(successCB) != "function") return;
        if (typeof(errorCB) != "function") errorCB = new Function();
        var options = { type: 'wide', item: 'months' };

        if (override) {
            for (var key in options) {
                if (!options.hasOwnProperty(key))
                    continue;
                if (typeof(options[key]) !== typeof(override[key]))
                    continue;
                options[key] = override[key];
            }
        }

        var requests = ["days", "months"];
        var formats = ["narrow", "wide"];

        options.item = requests.indexOf(options.item);
        options.type = formats.indexOf(options.type);

        //TODO: throw error
        if (options.item === -1)
            options.item = 0;
        if (options.type === -1)
            options.type = 0;

        Cordova.exec(successCB, errorCB, "com.cordova.Globalization", "getDateNames",
                     [ options ]);
    },

    isDayLightSavingsTime: function (date, successCB, errorCB) {
        if (!(date instanceof Date)) return;

        Cordova.exec(successCB, errorCB, "com.cordova.Globalization", "isDayLightSavingsTime",
                     [ { time_t: date.getTime() } ]);
    },

    getFirstDayOfWeek: function (successCB, errorCB) {
        if (typeof(successCB) != "function") return;

        Cordova.exec(successCB, errorCB, "com.cordova.Globalization", "getFirstDayOfWeek",
                     [ { } ]);
    },

    numberToString: function (number, successCB, errorCB, override) {
        if (typeof(number) !== "number") return;
        if (typeof(successCB) !== "function") return;
        if (typeof(errorCB) !== "function") errorCB = new Function();

        var options = convertStringToNumberOptions(override);

        Cordova.exec(successCB, errorCB, "com.cordova.Globalization", "numberToString",
                     [ { type: options.type, isInt: isInt(number), number: number } ]);
    },

    stringToNumber: function (string, successCB, errorCB, override) {
        if (typeof(string) !== "string") return;
        if (typeof(successCB) !== "function") return;
        if (typeof(errorCB) !== "function") errorCB = new Function();

        var options = convertStringToNumberOptions(override);
        Cordova.exec(successCB, errorCB, "com.cordova.Globalization", "stringToNumber",
                     [ options.type, string ]);
    },

    getNumberPattern: function (successCB, errorCB, override) {
        if (typeof(successCB) !== "function") return;
        if (typeof(errorCB) !== "function") errorCB = new Function();

        var options = convertStringToNumberOptions(override);
        Cordova.exec(successCB, errorCB, "com.cordova.Globalization", "getNumberPattern",
                     [ options.type ]);
    },

    getCurrencyPattern: function (currencyCode, successCB, errorCB) {
        if (typeof(errorCB) !== "function") errorCB = new Function();

        //TODO: implement
        errorCB(new GlobalizationError(GlobalizationError.PATTERN_ERROR, "unimplemented"))
    },

    getDatePattern: function (successCB, errorCB, override) {
        if (typeof(successCB) !== "function") return;
        if (typeof(errorCB) !== "function") errorCB = new Function();

        var options = convertStringToDateOptions(override);
        Cordova.exec(successCB, errorCB, "com.cordova.Globalization", "getDatePattern",
                     [ options.formatLength, options.selector ]);
    }
};

Cordova.addConstructor("com.cordova.Globalization", function() {
    window.GlobalizationError = GlobalizationError;
    navigator.globalization = Globalization;
});
