#include "wakeupthread"

void Wakeupthread::execute() {
    Threadlist::desc("Wakeup thread");
    
    while (1) {
	if (config.wakeupsec()) {
	    for (unsigned i = 0; i < balancer.nbackends(); i++) {
		if (! balancer.backend(i).live()) {
		    Backend target(balancer.backend(i).backenddef());
		    debugmsg("Wakeup thread: checking " <<
			     target.description() << '\n');
		    target.live(balancer.backend(i).live());
		    try {
			target.check();
			if (target.live()) {
			    msg ("Wakeup call: backend " << 
				 target.description() <<
				 " has awoken\n");
			    balancer.backend(i).live(true);
			} else
			    balancer.backend(i).markconnecterror();
		    } catch (Error &e) {
			debugmsg("Exception in wakeup thread: " <<
				 e.what() << '\n');
		    } catch (...) {
			debugmsg("Exception in wakeup thread\n");
		    }
		}
	    }
	    sleep (config.wakeupsec());
	} else {
	    debugmsg("Wakeup thread: no activity right now\n");
	    sleep(30);
	}
    }
}

