/*
 * $Id: glue-shm.c,v 1.32 2012-02-13 10:28:46 vrsieh Exp $ 
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <sys/types.h>
#include <sys/mman.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue.h"

#ifndef MAP_ANONYMOUS
#define MAP_ANONYMOUS MAP_ANON
#endif

extern char _end;

/*
 * On CPU with 48 bits virtual addresses vm-test shows the following:
 *
 * Heap starts from &_end up to &_end + 0x2000000;
 * mmap/library region starts at 0x7eff0aecf000;
 */
#define HEAPRANDOM	(0x2000000)
#define HEAPSIZE	(64*1024*1024)

#define PAGE_SIZE	4096
#define PAGE_MASK	(~(PAGE_SIZE - 1))

static uintptr_t mem_brk = 0;

static void *
shm_reserve(size_t len, unsigned int align, int exec)
{
	uintptr_t old;
	uintptr_t new;
	void *retval;

	// fprintf(stderr, "reserve 0x%x 0x%x %d\n", len, align, exec);

	if (! mem_brk) {
		mem_brk = (uintptr_t) &_end + HEAPRANDOM + HEAPSIZE;

		mem_brk += PAGE_SIZE - 1;
		mem_brk &= PAGE_MASK;
	}

	if (exec) {
		align = 4096;
	}

	mem_brk += align - 1;
	mem_brk &= ~(align - 1);

	old = (mem_brk + PAGE_SIZE - 1) & PAGE_MASK;
	new = (mem_brk + len + PAGE_SIZE - 1) & PAGE_MASK;

	if (old != new) {
		int prot;
		int map;
		void *aret;

		prot = PROT_READ | PROT_WRITE;
		if (exec) {
			prot |= PROT_EXEC;
		}
		map = MAP_SHARED | MAP_ANONYMOUS;
#ifdef MAP_32BIT
		if (prot & PROT_EXEC) {
			map |= MAP_32BIT;
		}
#endif

		aret = mmap((void *) old, new - old,
				prot, map, -1, 0);
		assert(aret != MAP_FAILED);
	}

	if (1 <= len) {
		*(char *) (mem_brk) = 0x1;
		*(char *) (mem_brk + len - 1) = 0x2;
	}
	assert(! (mem_brk & (align - 1)));

	retval = (void *) mem_brk;

	mem_brk += len;
	mem_brk += align - 1;
	mem_brk &= ~(align - 1);

	// fprintf(stderr, "-> %p\n", retval);

	return retval;
}

void *
shm_alloc(size_t len)
{
	void *retval;

	retval = shm_reserve(len, sizeof(unsigned long), 0);

	return retval;
}

char *
shm_strdup(const char *str)
{
	char *ptr;

	ptr = shm_alloc(strlen(str) + 1);
	if (! ptr) {
		return ptr;
	}
	strcpy(ptr, str);
	return ptr;
}

void
shm_free(void *ptr)
{
	/* Do nothing... */
}

void *
shm_palloc(size_t len, int flags)
{
	void *retval;

	time_stop();

	retval = shm_reserve(len, PAGE_SIZE, flags & SHM_CODE);

	time_cont();

	return retval;
}

void
shm_pfree(void *ptr)
{
	/* Do nothing... */
}
