/*
 * $Id: sig_dio24.h,v 1.10 2012-03-06 14:46:49 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_DIO24_H_INCLUDED
#define __SIG_DIO24_H_INCLUDED

#include "sig_gen.h"
#include "sig_std_logic.h"

struct sig_dio24 {
	enum sig_gen_type type;
	struct sig_std_logic *sig[24];
};

extern struct sig_dio24 *
sig_dio24_create(const char *name);
extern void
sig_dio24_destroy(struct sig_dio24 *sig);

extern void
sig_dio24_suspend(struct sig_dio24 *b, FILE *fSig);
extern void
sig_dio24_resume(struct sig_dio24 *b, FILE *fSig);

#endif /* __SIG_DIO24_H_INCLUDED */
