{
     File:       HIToolbox/HITabbedView.h
 
     Contains:   Definition of the tab view provided by HIToolbox.
 
     Version:    HIToolbox-624~3
 
     Copyright:   2006-2008 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://bugs.freepascal.org
 
}
{       Initial Pascal Translation:  Jonas Maebe, <jonas@freepascal.org>, October 2009 }
{       Pascal Translation Updated:  Jonas Maebe, <jonas@freepascal.org>, October 2012 }
{
    Modified for use with Free Pascal
    Version 308
    Please report any bugs to <gpc@microbizz.nl>
}

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}
{$mode macpas}
{$modeswitch cblocks}
{$packenum 1}
{$macro on}
{$inline on}
{$calling mwpascal}

unit HITabbedView;
interface
{$setc UNIVERSAL_INTERFACES_VERSION := $0400}
{$setc GAP_INTERFACES_VERSION := $0308}

{$ifc not defined USE_CFSTR_CONSTANT_MACROS}
    {$setc USE_CFSTR_CONSTANT_MACROS := TRUE}
{$endc}

{$ifc defined CPUPOWERPC and defined CPUI386}
	{$error Conflicting initial definitions for CPUPOWERPC and CPUI386}
{$endc}
{$ifc defined FPC_BIG_ENDIAN and defined FPC_LITTLE_ENDIAN}
	{$error Conflicting initial definitions for FPC_BIG_ENDIAN and FPC_LITTLE_ENDIAN}
{$endc}

{$ifc not defined __ppc__ and defined CPUPOWERPC32}
	{$setc __ppc__ := 1}
{$elsec}
	{$setc __ppc__ := 0}
{$endc}
{$ifc not defined __ppc64__ and defined CPUPOWERPC64}
	{$setc __ppc64__ := 1}
{$elsec}
	{$setc __ppc64__ := 0}
{$endc}
{$ifc not defined __i386__ and defined CPUI386}
	{$setc __i386__ := 1}
{$elsec}
	{$setc __i386__ := 0}
{$endc}
{$ifc not defined __x86_64__ and defined CPUX86_64}
	{$setc __x86_64__ := 1}
{$elsec}
	{$setc __x86_64__ := 0}
{$endc}
{$ifc not defined __arm__ and defined CPUARM}
	{$setc __arm__ := 1}
{$elsec}
	{$setc __arm__ := 0}
{$endc}
{$ifc not defined __arm64__ and defined CPUAARCH64}
  {$setc __arm64__ := 1}
{$elsec}
  {$setc __arm64__ := 0}
{$endc}

{$ifc defined cpu64}
  {$setc __LP64__ := 1}
{$elsec}
  {$setc __LP64__ := 0}
{$endc}


{$ifc defined __ppc__ and __ppc__ and defined __i386__ and __i386__}
	{$error Conflicting definitions for __ppc__ and __i386__}
{$endc}

{$ifc defined __ppc__ and __ppc__}
	{$setc TARGET_CPU_PPC := TRUE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __ppc64__ and __ppc64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := TRUE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __i386__ and __i386__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := TRUE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
{$ifc defined iphonesim}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __x86_64__ and __x86_64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := TRUE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
{$ifc defined iphonesim}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __arm__ and __arm__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := TRUE}
	{$setc TARGET_CPU_ARM64 := FALSE}
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := TRUE}
{$elifc defined __arm64__ and __arm64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := TRUE}
{$ifc defined ios}
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_OS_EMBEDDED := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$endc}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$elsec}
	{$error __ppc__ nor __ppc64__ nor __i386__ nor __x86_64__ nor __arm__ nor __arm64__ is defined.}
{$endc}

{$ifc defined __LP64__ and __LP64__ }
  {$setc TARGET_CPU_64 := TRUE}
{$elsec}
  {$setc TARGET_CPU_64 := FALSE}
{$endc}

{$ifc defined FPC_BIG_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := TRUE}
	{$setc TARGET_RT_LITTLE_ENDIAN := FALSE}
{$elifc defined FPC_LITTLE_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := FALSE}
	{$setc TARGET_RT_LITTLE_ENDIAN := TRUE}
{$elsec}
	{$error Neither FPC_BIG_ENDIAN nor FPC_LITTLE_ENDIAN are defined.}
{$endc}
{$setc ACCESSOR_CALLS_ARE_FUNCTIONS := TRUE}
{$setc CALL_NOT_IN_CARBON := FALSE}
{$setc OLDROUTINENAMES := FALSE}
{$setc OPAQUE_TOOLBOX_STRUCTS := TRUE}
{$setc OPAQUE_UPP_TYPES := TRUE}
{$setc OTCARBONAPPLICATION := TRUE}
{$setc OTKERNEL := FALSE}
{$setc PM_USE_SESSION_APIS := TRUE}
{$setc TARGET_API_MAC_CARBON := TRUE}
{$setc TARGET_API_MAC_OS8 := FALSE}
{$setc TARGET_API_MAC_OSX := TRUE}
{$setc TARGET_CARBON := TRUE}
{$setc TARGET_CPU_68K := FALSE}
{$setc TARGET_CPU_MIPS := FALSE}
{$setc TARGET_CPU_SPARC := FALSE}
{$setc TARGET_OS_UNIX := FALSE}
{$setc TARGET_OS_WIN32 := FALSE}
{$setc TARGET_RT_MAC_68881 := FALSE}
{$setc TARGET_RT_MAC_CFM := FALSE}
{$setc TARGET_RT_MAC_MACHO := TRUE}
{$setc TYPED_FUNCTION_POINTERS := TRUE}
{$setc TYPE_BOOL := FALSE}
{$setc TYPE_EXTENDED := FALSE}
{$setc TYPE_LONGLONG := TRUE}
uses MacTypes,Appearance,CarbonEvents,Controls,QuickdrawTypes,CFBase,HIObject;
{$endc} {not MACOSALLINCLUDE}


{$ifc TARGET_OS_MAC}

{$ALIGN MAC68K}


{
 *  HITabbedView.h
 *  
 *  Discussion:
 *    API definitions for the tab view.
 }
{}
{   TABS (CDEF 8)                                                                     }
{}
{  Tabs use an auxiliary resource (tab#) to hold tab information such as the tab name  }
{  and an icon suite ID for each tab.                                                  }
{  The ID of the tab# resource that you wish to associate with a tab control should    }
{  be passed in as the Value parameter of the control. If you are using GetNewControl, }
{  then the Value slot in the CNTL resource should have the ID of the 'tab#' resource  }
{  on creation.                                                                        }
{  Passing zero in for the tab# resource tells the control not to read in a tab# res.  }
{  You can then use SetControlMaximum to add tabs, followed by a call to SetControlData}
{  with the kControlTabInfoTag, passing in a pointer to a ControlTabInfoRec. This sets }
{  the name and optionally an icon for a tab. Pass the 1-based tab index as the part   }
{  code parameter to SetControlData to indicate the tab that you want to modify.       }
{  Accessibility Notes: Those of you who wish to customize the accessibility           }
{  information provided for individual tabs of a tabs control -- by handling various   }
{  kEventClassAccessibility Carbon Events, by calling                                  }
{  HIObjectSetAuxiliaryAccessibilityAttribute, etc. -- need to know how to interpret   }
{  and/or build AXUIElementRefs that represent individual tabs. The AXUIElement        }
{  representing an individual tab will/must be constructed using the tab control's     }
{  ControlRef and the UInt64 identifier of the one-based index of the tab the element  }
{  refers to. As usual, a UInt64 identifier of zero represents the tabs control as a   }
{  whole. You must neither interpret nor create tab control elements whose identifiers }
{  are greater than the count of tabs in the tabs control.                             }
{ Tabs proc IDs }
const
	kControlTabLargeProc = 128;  { Large tab size, north facing   }
	kControlTabSmallProc = 129;  { Small tab size, north facing   }
	kControlTabLargeNorthProc = 128;  { Large tab size, north facing   }
	kControlTabSmallNorthProc = 129;  { Small tab size, north facing   }
	kControlTabLargeSouthProc = 130;  { Large tab size, south facing   }
	kControlTabSmallSouthProc = 131;  { Small tab size, south facing   }
	kControlTabLargeEastProc = 132;  { Large tab size, east facing    }
	kControlTabSmallEastProc = 133;  { Small tab size, east facing    }
	kControlTabLargeWestProc = 134;  { Large tab size, west facing    }
	kControlTabSmallWestProc = 135;   { Small tab size, west facing    }

{ Tab Directions }
type
	ControlTabDirection = UInt16;
const
	kControlTabDirectionNorth = 0;
	kControlTabDirectionSouth = 1;
	kControlTabDirectionEast = 2;
	kControlTabDirectionWest = 3;

{ Tab Sizes }
type
	ControlTabSize = UInt16;
const
	kControlTabSizeLarge = kControlSizeNormal;
	kControlTabSizeSmall = kControlSizeSmall;
	kControlTabSizeMini = kControlSizeMini;

{ Control Tab Entry - used during creation                             }
{ Note that the client is responsible for allocating/providing         }
{ the ControlButtonContentInfo and string storage for this             }
{ structure.                                                           }
type
	ControlTabEntry = record
		icon: ControlButtonContentInfoPtr;
		name: CFStringRef;
		enabled: Boolean;
	end;
{ Control Kind Tag }
const
	kControlKindTabs = FourCharCode('tabs');

{ The HIObject class ID for the HITabbedView class. }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kHITabbedViewClassID CFSTRP('com.apple.HITabbedView')}
{$endc}
{ Creation API: Carbon only }
{$ifc not TARGET_CPU_64}
{
 *  CreateTabsControl()
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework [32-bit only]
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function CreateTabsControl( window: WindowRef; const (*var*) boundsRect: Rect; size: ControlTabSize; direction: ControlTabDirection; numTabs: UInt16; const (*var*) tabArray: ControlTabEntry; var outControl: ControlRef ): OSStatus; external name '_CreateTabsControl';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{$endc} {not TARGET_CPU_64}


{
 *  Summary:
 *    Tagged data supported by the Tabs control.
 }
const
{
   * Used to get the bounds of the control area benath the tabs. Cannot
   * be used with SetControlData. Data is of type Rect.
   }
	kControlTabContentRectTag = FourCharCode('rect');

  {
   * Used to get or set the enable state of a specific tab. The part
   * code parameter to Get/SetControlData must be a 1-based tab index.
   * Data is of type Boolean.
   }
	kControlTabEnabledFlagTag = FourCharCode('enab');

  {
   * Used to get or set the font and style attributes of a specific
   * tab. The part code parameter to Get/SetControlData must be a
   * 1-based tab index. Data is of type ControlFontStyleRec.
   }
	kControlTabFontStyleTag = kControlFontStyleTag;

  {
   * Used to get or set the name and image of a specified tab. The part
   * code parameter to Get/SetControlData must be a 1-based tab index.
   * Data is of type ControlTabInfoRec. Available in Appearance Manager
   * 1.0.1 and later.
   }
	kControlTabInfoTag = FourCharCode('tabi');

  {
   * Used to get or set the image of a specified tab. The part code
   * parameter to Get/SetControlData must be a 1-based tab index. When
   * used with GetControlData, if the tab image is an IconRef or
   * CGImageRef, the Tabs control will automatically retain the icon or
   * image, and the caller of GetControlData must release it. Data is
   * of type ControlImageContentInfo, or HIViewContentInfo. Available
   * in Mac OS X 10.1 and later.
   }
	kControlTabImageContentTag = kControlContentTag;

const
	kControlTabInfoVersionZero = 0;    { ControlTabInfoRec}
	kControlTabInfoVersionOne = 1;     { ControlTabInfoRecV1}

type
	ControlTabInfoRec = record
		version: SInt16;                { version of this structure.}
		iconSuiteID: SInt16;            { icon suite to use. Zero indicates no icon}
		name: Str255;                   { name to be displayed on the tab}
	end;
type
	ControlTabInfoRecV1 = record
		version: SInt16;                { version of this structure. == kControlTabInfoVersionOne}
		iconSuiteID: SInt16;            { icon suite to use. Zero indicates no icon}
		name: CFStringRef;                   { name to be displayed on the tab. Will be retained so caller}
                                              { should always release it.}
	end;
{ Helper routines are available only thru the shared library/glue. }
{$ifc not TARGET_CPU_64}
{
 *  GetTabContentRect()
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework [32-bit only]
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 }
function GetTabContentRect( inTabControl: ControlRef; var outContentRect: Rect ): OSErr; external name '_GetTabContentRect';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  SetTabEnabled()
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework [32-bit only]
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Non-Carbon CFM:   in AppearanceLib 1.0 and later
 }
function SetTabEnabled( inTabControl: ControlRef; inTabToHilite: SInt16; inEnabled: Boolean ): OSErr; external name '_SetTabEnabled';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{}
{   Resource Types                                                                                    }
{}
{$endc} {not TARGET_CPU_64}

const
	kControlTabListResType = FourCharCode('tab#'); { used for tab control (Appearance 1.0 and later)}

{$endc} {TARGET_OS_MAC}
{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}

end.
{$endc} {not MACOSALLINCLUDE}
