/*****************************************************************************
 Copyright (c) 2023, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* SM4-CBC */
#include "cipher_test.h"
const struct cipher_test sm4_cbc_test_json[] = {
        /* Generated vectors by 3rd party library */
        { 128, 128, 1, "\xca\xa9\x35\x88\x36\x94\xf6\x7b\x8a\x58\x4d\xed\x0a\xa0\x42\xa3",
          "\x4f\xae\xca\xe5\x31\xaf\xc0\xed\x41\xf4\xaf\xe4\xb4\x3a\x68\xcd",
          "\xf1\x7b\xe7\x3b\x74\x08\x40\x66\xd1\x5f\x0f\x9e\xd6\xcf\x29\xd3\x25\xc1\xe9\xce\x6e\x61"
          "\xe7\xf4\x7c\xcf\x2c\xe7\x22\x04\xb5\x07\x83\x5a\xf3\x3e\xb1\x07\xa2\x71\x31\x4a\x65\x8c"
          "\x76\xbd\x53\xff\x7f\xbd\x03\x08\x25\x7f\x7e\x16\x0f\xd2\x41\x06\x07\x52\x06\xf3\xff\x36"
          "\x37\x68\x2e\x59\x33\xfd\xe3\x94\xea\x81\x82\x30\x16\x4b\xea\x28\xeb\x3d\x1f\x52\x3c\x62"
          "\x96\xcf\xee\x91\x4c\x54\x28\xda\xdd\x6a\xa9\xad\x88\x84\xce\xd3\x68\x2d\xd8\x4e\x3f\x89"
          "\x42\x20\xe2\x3d\x37\x4d\x51\x71\xc0\xf1\x11\xaa\xd7\xe3\xdd\x03\xfa\x65\x3e\xfa\x38\xe6"
          "\x6c\x2a\xf4\x2c\xb0\xca\x71\x5a\x54\xc5\xb5\xfc",
          "\xdd\x92\xae\xbb\x1b\x31\x0f\x8f\x6e\xd3\xd7\xe7\x79\xa3\xc0\x0a\x92\xf6\xe0\xa6\x8d\x84"
          "\x00\xac\xbc\xa8\x92\xa4\x49\xc4\x90\x68\x1b\x3c\x9a\x2c\xbf\x16\x54\x3b\x34\xbc\x6c\xec"
          "\xb6\x4a\xfd\x01\x48\x2c\xf3\x35\xfc\x62\x8d\x5d\x7c\xa3\x37\xa9\xfb\x3d\x0c\x10\x25\x8f"
          "\x07\xa3\x47\x10\x72\xdf\x4f\x16\x73\xaa\x29\xee\x03\x7e\x17\xee\xc4\x0e\x99\x4c\xec\x1a"
          "\x68\x0d\x8d\x66\x15\x5a\x0a\x23\x86\x57\xb5\x1a\x50\xb4\x56\xf4\xbc\xff\x9a\xe6\xa3\x61"
          "\x89\xbb\x36\x4d\x7d\x3b\xde\x14\x86\x53\x8c\xce\xb7\x57\x29\xd9\x19\x9f\xe2\x9b\xd2\xd1"
          "\x75\xb9\xa4\x8f\x2b\xe6\xa3\x86\x1b\xd8\x72\x97\xd0\x48\x9a\xe2\x64\x14\xd7\x52\xd8\x45"
          "\x10\x75\x06\x2b\x6d\xf7",
          1, 1152 },
        { 128, 128, 2, "\xad\xbf\x8a\x12\x67\x86\xa5\x61\xb9\x03\xef\xa4\xfe\x8d\x97\xe4",
          "\x1c\x6a\x0c\xa0\x5d\x5d\xdc\xf1\x37\xf0\xca\xbe\xc2\x91\xe7\x14",
          "\xcc\x03\x2f\xf4\xfb\x25\x0e\x5d\xe9\xec\x00\x14\x57\x99\xb0\xc6\x05\xa0\xfa\x01\x8f\xcf"
          "\x82\xd8\xf0\x1e\x3a\xcd\x3b\xfd\x25\x71\xb4\x02\xa9\x5b\x17\xc4\x8b\x7a\x40\x2d\xc0\x4b"
          "\x26\xe4\x45\x47\x72\x08\x5f\x20\x7e\x8d\x02\x7a\xd5\x66\x06\x8f\xa7\xbc\x11\xb8\x59\x57"
          "\x39\x9a\xd4\xbd\xe5\xbb\xf4\xf1\xcc\x58\x6e\x3d\xce\x73\x73\xe9\x30\xf1\x83\x26\x7e\xeb"
          "\x8a\x16\xa5\xb6\x40\xa7\x92\xa1\x9b\x29\x15\x3b\x1b\xfc\x29\x6e\xc4\xc5\xa7\x1c\xef\xba"
          "\x2f\x10\x59\x2e\xd7\x19\x0e\xdf\xe5\xe0\x17\xfc\x7c\x0d\x61\x7c\x34\xc3\x91\x76\xf2\x0f"
          "\x64\xdd\x83\x7e\xb7\x4a\x98\x0a\x5e\xe0\xba\x48\xd4\xc7\x91\x86\xad\x94\x73\x37\x14\x2e"
          "\x60\x24\x28\xcf\xfd\x5b\x96\x89\x6f\xae\x4b\x9f\x16\x8a\x61\xa2\xef\x71\x7f\xee\xde\x61"
          "\xe2\xe4\x9a\x24\x4f\xe6\x1b\xcd\x3e\xbc\xd8\xba\xe4\x00\xa5\x08\x87\xc8\x7b\xa1\xc2\xf9"
          "\x58\x44\x19\x87\xd3\x43\xd9\x1a\x2f\xba\x3f\x2b\x3a\x8b\x4d\x61\x84\xe1\x36\xfe\x9e\x35"
          "\x79\x86\x37\x4a\x61\xea\x12\x4b\xa8\x0c\xc4\xf8\xd7\x20\xd6\x71\xc0\x5f\x13\x30\x2c\x6c"
          "\xac\xc4\xf1\x0c\x69\x23\xc2\x32\xfa\x82\xe1\x49\xda\x2e\x2c\x9a\xc4\x87\x4c\xdc\x45\x42"
          "\x0f\xc7\x27\xb8\x5a\x32\x09\x70\xe5\x46\x62\xa0\x34\xce\x5b\x8d\x57\x57\xd0\x1b\x8b\x96"
          "\xd7\x38\x25\x44\x51\xd6\x88\x10\x28\x5f\x76\xb3\xad\x45\x27\xce\x35\x78\x51\x8a\x38\x94"
          "\x21\xa4\xb3\x67\x3e\x4a\xac\x5b\x89\xec\x2a\x83\x2e\x7e\x93\x2b\x56\xb4\x0b\xce\xc6\x4d"
          "\x6a\xde\x76\xc6\xca\xe0\x57\x5e\x2c\xd0\xc3\xa6\x1f\xff\xe6\x36\x44\x6a\xc5\xc0\x87\xeb"
          "\x1a\xe5\x0d\xc4\x54\x60\x36\x14\xfa\x6b\xb3\x29\xaf\x6a\xe9\x8a\x50\x2d\x8f\x9b\x6b\xdd"
          "\x26\xa5\xa1\x7c\xab\xa6\x27\xf1\xcd\xf2\x83\xad\xa1\xf5\x55\x56\xdc\x72\x2b\x85\x74\x6a"
          "\xd0\x2b\x6c\x79\x4a\x93\x97\x39\xfc\xa1\x65\x96\x3f\xa7\x24\x18\x2e\xc1\xaf\xae\xe1\xb9"
          "\x70\x48\xa8\xbe\xf3\x0b\x73\x1e\xfb\x64\x9a\x28\x58\x55\x2c\xe2\x99\x4c\x33\x3d\x3e\x06"
          "\x69\x9f\x76\x42\x1f\x48\x99\x9f",
          "\x7d\xf7\x9a\x19\x6d\xe7\x73\x88\x03\x23\x2f\x99\xbb\x89\xf7\x99\x56\x24\x4d\x74\x1c\xa9"
          "\xf1\x8a\xc4\x7f\x2e\x2a\x67\x00\x4e\x03\x0e\xff\x92\xb7\xae\x78\x4f\x5e\x95\x3d\x17\x58"
          "\xef\xe4\x43\xa5\xe2\xd1\xb8\x09\x75\x21\x89\x08\x8c\x3c\xfa\xbd\x60\x95\x0c\x10\xae\xc4"
          "\x92\x1a\x41\x77\x05\x2d\x98\xeb\x88\xb7\x07\xa8\xc2\x82\x2c\x8e\x59\x2f\x4f\xb8\x42\xa0"
          "\x0f\x63\x78\x66\xa5\xee\x57\x4c\xb6\xbc\xf2\x82\xce\xdb\x4f\x26\x72\x32\xc4\xa6\xb3\x0a"
          "\x57\xed\xd8\xf3\x09\x6d\x02\x55\xdf\x05\xaf\xf4\xd6\x09\x9d\xc2\xa4\xa4\x46\x16\xea\xf9"
          "\x2b\x25\x5b\x5f\x5e\x70\x46\x86\x3f\x20\x6f\x7c\xa6\x8b\xf5\x7d\xcd\xb3\x14\x6f\x01\x94"
          "\x05\x4b\xce\x03\x8f\xcb\x1c\xa7\xb3\x20\xbe\x10\x9e\xf7\x85\xc8\xad\x9b\xca\xbc\x3e\xdb"
          "\x65\x7f\x4b\xb1\x20\x81\x58\x63\x64\x93\xbe\x68\x3c\xbe\x50\x47\xbc\x22\xbd\xa3\x1c\x11"
          "\x8c\x59\x19\x53\x11\x3c\x58\x8e\xd7\xc1\x75\xa1\xca\xcc\x95\xec\x51\x2a\xeb\x85\x87\x59"
          "\xf5\xbd\x5a\x11\xb1\xff\x18\x84\x91\x90\x0c\x07\x4e\xac\x9a\x8b\xd0\xf4\xa6\x84\xff\x09"
          "\x9f\x11\x94\x63\xba\xcb\x30\xf9\x9b\x66\xbd\xa3\x03\x17\x29\x88\x96\x35\x54\xe3\xe5\x64"
          "\x23\x73\xa5\x5a\xcb\x2d\x1e\xb0\x4b\x17\xf8\xe1\x4f\xe2\x50\xc9\x1f\x4a\x6f\x5a\xde\xf5"
          "\x21\x1e\x8f\xd3\x5a\x63\xb0\x0b\x4c\x8d\x21\xe5\x8c\x93\xce\xe4\x8d\x62\x1a\x64\xa3\x70"
          "\x02\x80\x26\x7d\x0b\xa0\xc0\x48\x1d\x5e\x98\x0b\x11\x64\x98\x99\xb9\xed\xc0\x7b\xf5\xc3"
          "\x35\x79\x36\xb8\x04\x3a\x37\xb4\x33\xa7\x62\xbf\x72\xf7\x69\x9e\x31\x2c\x40\xb3\x5d\x9d"
          "\xf9\x2d\x98\xa3\x70\xb7\xc7\x83\x04\x61\x9d\x6a\xd4\xdd\x25\xa2\xe9\x06\xa5\xa7\x4a\x16"
          "\x30\x0c\x3b\x0e\x87\xda\xd0\x68\x1f\x3d\x08\x58\x3b\x2d\x58\x7c\x11\x53\xcf\x69\xcb\xce"
          "\xb9\x10\x2a\xed\xad\x99\x46\x11\xb0\x7a\x8e\x3f\x88\x3e\xc0\xf4\x96\x5c\x17\x26\x0c\xdf"
          "\x5a\x71\xd1\x07\x07\x06\x3b\x9b\xc2\xd4\x1a\xe3\x04\x1b\x38\xef\x91\xe5\x2d\x3c\xeb\xc5"
          "\x0b\xea\xfb\x39\x7d\xae\x6a\x26\x10\x99\x00\xfd\xa4\x15\x38\x32\xb5\x22\x0c\x4d\x33\x15"
          "\xc5\x0e",
          1, 3584 },
        { 128, 128, 3, "\x3f\xb0\x1d\x37\x23\x35\x05\xc7\xdb\xd5\xff\x66\xac\xd4\x0f\x8b",
          "\x5c\x18\x23\x68\xab\x42\xfd\x27\xee\x08\x42\xae\x63\x92\x42\x27",
          "\x97\xbb\x5b\x7d\x64\x31\x91\xfc\xaa\xb1\x12\x21\xc7\x43\x80\x95\xfb\x73\x21\xab\xfc\x1c"
          "\x16\x6a\x88\x32\xbb\xef\x16\x30\x81\xf7\x4b\x06\x74\xa8\xba\x9c\xac\x2e\x13\x62\x49\x33"
          "\x2f\xa4\xae\x63\x8f\xf8\x0e\xd5\x9a\xc9\x87\xbb\x30\x63\xad\x07\x4a\x1f\x44\x2a\x4f\x69"
          "\x29\x9b\x98\x84\x17\x2a\x9a\x6f\x4d\x7c\x6b\x5e\x35\x76\x32\xdd\x97\x86\x65\xf6\xf4\x70"
          "\x5c\xc4\xb4\xc9\xf2\xb3\x78\xe2\x1c\x46\xd6\xda\x0f\x33\x1a\x6a\xec\xdf\xda\xc3\xa6\x34"
          "\xce\xad\x93\xe5\x7b\x81\xcc\x57\xcb\xab\xd6\x59\xa1\xbe\x95\x0c\xf1\x94\xb1\xdf\x03\x24"
          "\x26\x42\xe3\xfc\x4f\xec\x4f\x6f\x8d\xf6\xbe\xe8\xc1\x8a\xb9\x0e\xfb\xa4\xae\xa9\x12\x40"
          "\x25\x5e\xab\x5c\x5b\x1a\xe5\x09\x40\x9e\x39\x67\x9b\xb7\xc1\x79\x21\x88\x6a\x55\x29\xf4"
          "\x68\x3d\x78\x61\x40\x52\xb7\x38\xf0\x66\x0b\xcf\x85\xf7\x3e\x48\xee\x7d\x7f\x47\xbf\x53"
          "\xc8\xd4\x49\xfe\xd7\x19\x15\x07\x31\x2c\x2b\xa7\xda\x0d\xc2\x2a\x5f\x1b\xbd\x06\xdd\xd9"
          "\xf3\x6e\x6e\xc3\x53\xbb\xa3\x04\x99\x22\x49\x92\x15\x37\x42\x3e\x20\xc2\xf7\xd3\x7f\x09"
          "\x45\xc4\xce\xab\x69\xc1\x6e\xbe\xc9\x2d\xa7\xaa\x1f\xc5\xbf\xa4\xa9\xc1\x17\xd5\xf0\xe6"
          "\x88\x41\xd0\x12\xa3\xe6\xe1\x8c\x10\xd3\x5d\xaa\x43\x86\xac\xea\xc8\x92\x0d\xf7\x8a\x42"
          "\xaa\xdb\x88\xa8\x4b\xe7\x5d\x27\x46\x5d\xc0\x18\xe3\xc9\x85\x55\xea\xa6\x52\xd1\xab\xda"
          "\xf2\xf4\x98\x44\x41\xcb\xaf\x68\xa7\xa6\x10\x5f\xa4\xd8\x8c\xf6\xd3\x2d\x58\x2a\xa9\xce"
          "\x34\x42\xde\x8e\x77\x3f",
          "\xd0\xc4\x47\x15\x70\x82\x3e\x5c\xa9\x42\x2b\x7e\x86\x8e\x84\xd5\x4c\xc0\x3d\xd0\x34\xd3"
          "\x27\x6d\x21\xee\xe5\xbe\xb6\x55\x84\x8d\xb4\x8e\x21\xe4\xec\xf9\xdd\xad\xbb\xa8\x3a\x0d"
          "\x7c\x45\x22\xfd\xd6\x16\x60\x38\x4e\x61\x31\x1c\xa7\xa4\xe4\xf8\x64\x24\xf5\x43\xcc\x0f"
          "\x72\xb8\xe4\x7a\xa5\x2a\x26\xc0\x14\xa3\xe7\x8b\xb6\x90\x44\xbf\xab\xd8\x8c\x82\xf4\x14"
          "\xd8\xc6\xde\xba\xd8\x7d\x39\xd6\x97\xf1\x66\x06\x1b\xfd\x9c\x6b\x3a\xaa\x79\x3b\x07\xed"
          "\xe5\x4c\x14\x91\xf7\xe6\xff\x35\xc6\x97\x93\x9a\x35\xd0\xb8\x76\x67\x76\xd0\xda\x88\xe8"
          "\xc3\x39\x7e\xe9\x6b\x9d\x34\xcb\x11\x70\x6d\x8f\x2a\xfe\xbd\xdd\xa1\xf6\x76\x7b\x65\x42"
          "\xd5\xc9\x7a\x66\xe8\x76\x99\xdd\x9d\xaa\x68\xb2\x48\x38\x88\x22\xa4\xaa\x16\x55\x7e\xb0"
          "\xe2\xbf\x7a\x01\xc9\x39\xfb\x8c\xb5\x55\x6f\x4a\x54\x7c\x82\xbd\x4e\xef\xb4\x04\x96\xf2"
          "\xc7\x28\x0d\x75\xff\xba\xcb\xb8\xd0\x23\x31\x39\xbe\x77\x02\x1e\x46\xcd\xe6\xaf\x36\x8b"
          "\x16\xee\xc2\x89\x9b\xe8\xfc\x8b\x5f\x04\x01\x6f\xc8\x4f\x72\xf9\x6a\xf9\xf8\xb8\xe2\x03"
          "\xa1\x0b\x3a\xe5\x00\x34\x2c\x0d\x85\x0e\x89\xb5\xb1\xa2\xa1\xe9\x5b\x26\xe2\xcc\xb7\x24"
          "\x0c\xa6\xcd\x2f\xd8\xb2\x0e\xfc\xb2\xeb\xf0\x18\x13\x2b\x74\x6a\x5d\x8c\x71\x69\x09\x22"
          "\xdc\x73\x95\x3e\xf8\xb0\xa4\xef\xeb\x7a\x37\xc0\x25\x98\xcf\xa7\x92\x2d\xc1\xf8\xb9\x6b"
          "\x4f\xb2\x44\xa4\xf3\x1a\x24\xfa\xad\x28\x50\x79\x6f\x54\xbe\x14\x00\x3a\x77\x82\x90\x7e"
          "\xd6\xcc\x5b\xcd\xac\xde\x42\xea\x45\x1f\x49\xe2\xf7\x2f\xaa\x69\x32\x8b\x08\x51\x43"
          "\x11",
          1, 2688 },
        { 128, 128, 4, "\x47\xf7\x0d\x29\xea\x26\x0b\xb2\x26\x87\x7e\xf8\xbc\x9c\x75\x2a",
          "\x7a\x84\xaa\xb9\x18\xb0\xb9\x47\xa4\x46\x43\x56\x9b\xfd\xe1\x52",
          "\x0f\x19\x17\x79\xda\xcd\x7a\xeb\xd0\x44\xef\xc0\x45\xc6\x07\xe7\x01\x31\x0a\xde\x61\x6f"
          "\x7b\x56\x06\x6d\x08\x95\xed\xc9\xcc\xb9\x0c\xa9\x11\x97\x46\x04\x0d\xee\xe7\xc0\x74\x07"
          "\xa2\x8c\x45\x06\x40\xec\x58\xd7\xd1\x19\xc4\x11\xa6\xb9\xe1\xe1\xdc\x0a\xbf\xfe\x08\x89"
          "\xb5\x7c\x5c\xca\x75\x85\x57\x77\x33\x81\x09\x32\x78\xca\xdd\x46\x95\x63\xe8\x85\x83\x35"
          "\x68\xb8\x8c\xd5\x17\x56\xe7\xfc\xe1\x3e\x2a\x4a\x44\x9a\x2c\x4b\xe2\xe8\x97\x46\xee\x6a"
          "\xa3\x4d\x3d\x08\xb4\x71\x44\xb7\x0a\x22\x2f\x6f\x6e\x87\x2a\x37\x52\xbf",
          "\x79\x4e\x3f\xcc\x49\x2c\x3a\xd0\xae\x9c\xab\x4d\x15\x7d\x00\x33\xf9\xdd\x3a\xff\x67\x37"
          "\xab\x78\x90\xf1\x30\xfc\x87\x14\xd2\x21\x33\x8d\x43\xba\xb8\x33\xd0\x2f\x50\x37\xd4\x53"
          "\x6a\xf4\x52\x79\x58\xba\x13\x61\xbc\xcc\x40\x40\x41\x38\xe3\xfc\x1e\xc1\xa8\xca\x74\x4c"
          "\x40\x7c\x8a\x76\x80\x22\x7d\x6d\xb0\xa1\x17\x35\xbf\x58\x40\xed\x0f\x50\x23\x5c\x68\x69"
          "\xd6\x86\xae\x82\xc7\x23\xfc\xf4\xcc\x4b\xa0\x76\x55\x46\x5c\xba\xd0\x21\xcb\x24\x96\xe8"
          "\x98\x18\x16\x22\x3e\xcd\x67\xa8\x9b\x5b\xe3\x7c\xca\x6d\x2f\x8d\xb3\x24\x2f\x10\x10\x96"
          "\x19\x6c\x83\x02\x37\x43\xae\x77\x93\xbd\x56\x87",
          1, 1024 },
        { 128, 128, 5, "\x91\x86\xe6\x0e\x44\x18\x41\x86\x7d\x0a\xba\x03\xe7\x28\xc3\x9b",
          "\x05\x28\x94\x0d\x83\xd9\xe2\x78\xf1\x79\x1f\x20\x53\x29\x06\xa0",
          "\xbe\x44\xe8\xb9\x6a\xf2\x97\x5d\xb4\xe8\x20\x4c\x1a\x49\x0f\xb6\xb4\xcf\x31\x7b\x56\xbb"
          "\x53\xb6\xf4\x01\x2d\x02\xa2\x75\x7f\x1c\x51\x25\x27\xbb\xe5\x86\xe4\x0f\x3c\x63\x62\x21"
          "\x31\x68\x25\xca\xca\xa7\xc7\xaa\x7c\x34\xf9\xce\xb8\x95\xd5\x73\x04\x18\x40\x21\xdc\x79"
          "\x66\x64\x27\x9c\xc0\x34\x84\x3b\x74\xc0\xc8\x4c\x25\xaf\x0f\xa5\x57\x73\x48\xc6\x02\xb8"
          "\x33\x4f\xd9\x0d\x23\x4e\x7b\x91\x03\x3a\x5c\x34\x56\x51\xa2\xf1\x2c\x6e\x9b\x9f\x23\xf4"
          "\x1d\x55\x26\xee\x9d\xc6\xd0\xf4\x2b\xd5\x75\x45\x28\x17\x43\x17\x00\xf4\xa6\x05\xd4\x91"
          "\x76\xe9\xc7\x1b\x50\xea\x2c\xd6\x1d\xfd\x14\xa9\x70\x0b\xe9\xff\x7c\xad\x73\xb6\x62\x4a"
          "\xd2\x87\xcd\xb3\x6d\x98\xa2\x48\x85\x67\x98\xa9\xdd\x2e\xd9\x9d\x88\x3d\xee\xe9\x42\xcb"
          "\x17\x9d\xf1\x5e\x5e\x78\xaa\x33\x42\x2c\xdf\xe2\xa4\xba\xb9\x13\x44\x8d\xa9\x69\x03\x7f"
          "\x97\x67\x43\x30\x2c\x2f\x75\x46\x40\x3e\xfc\x5f\xab\xb1\x3c\x7d\x51\xdb\xd6\x3c\x29\x84"
          "\x99\xe3\xf1\x64\xdb\x3c\x80\x08\x50\xa7\x2c\x1e\xb5\x6c\x17\x20\x59\xf1\x46\xb7\xfe\xb7"
          "\x61\x65\x85\xd2\xc9\x68\x50\x7a\x91\xe6\x13\x77\x5c\x0d\x63\xd1\x07\x9d\x6e\x1e\xa7\x86"
          "\x2d\x34\x04\xa7\xe8\x08\x76\xd1\x3e\x99\x67\xa9\x21\xd0\xea\xa2\xdb\xf1\x58\xd9\x12\x06"
          "\xb1\x77\x66\x9c\xf5\xa1\x24\xea\xae\xed\x6d\x80\x79\x0c\xaf\xbe\x9a\xe5\x11\xb9\x8f\xec"
          "\x5d\x0e\x0b\x83\xb3\x32\x41\x99\x24\xa8\x7a\x26\x24\x5c\x0d\x23\xa5\xc5\x83\x1d\xc3\xda"
          "\x2b\x8e\x79\x6c\xd9\xfc",
          "\xb7\xa8\x93\xcd\x94\xa3\xa7\xbf\x57\xad\xa8\x20\xfd\x41\x9b\x1a\x08\x3c\x09\xce\xc9\x55"
          "\x03\x4f\x9f\xa8\xce\xf0\xb9\x49\x38\x84\x29\x4e\xda\xb7\x9a\x89\x12\x2d\xfe\x72\x60\x4b"
          "\xc0\xb8\xd0\x37\x38\x3b\x77\xe6\xb3\xad\xe8\x6b\x15\x68\xa4\x03\xfe\x5e\x95\xea\xe2\x5a"
          "\xd0\xe9\x38\x22\x77\x1c\xa7\x47\xed\x3e\xfd\x6f\xe6\x81\xf3\xd9\xef\x1e\x04\x64\x8e\x1e"
          "\xfe\xe6\x15\xb2\xe4\x3d\x7b\x57\x0a\x0c\x22\xac\x11\x0f\x31\x35\x93\x9e\xbc\x91\x8e\x72"
          "\x13\x29\x58\xc2\x05\x0e\x2c\x0d\x83\x53\xf9\x53\x2a\x65\x9a\x0a\x03\xf0\xae\x44\xab\x21"
          "\x09\xaf\xac\xeb\x38\xeb\x48\x94\x24\x62\x89\xb2\x04\xd0\xc8\x40\xb6\x83\x93\x31\x49\x12"
          "\xed\x17\x38\xd6\x6f\x6f\xe6\xec\x14\x76\xfb\x97\x48\xc2\x8d\x98\x0b\xd2\x73\x1b\xa3\xc1"
          "\x07\x1b\x87\xba\x96\x0b\xd5\x54\x66\x59\xda\xeb\xae\x9d\xba\xfe\x15\xfa\x70\x21\x4a\x11"
          "\xac\x93\x21\x67\x5e\xda\x3a\xe3\x8a\x86\xc5\xc7\x87\xe0\x2a\xb9\x19\xab\xd1\x76\x2c\xee"
          "\x2e\x4e\x13\x16\x5f\x76\x7b\x74\x6a\xdb\xc6\x8c\x3e\x68\xe9\x71\x60\x05\x19\x98\xc9\xfa"
          "\x34\xb8\xf5\xfe\x10\x02\x6c\xc1\x9a\xf4\xd7\x2b\xf0\x55\x27\xa1\x6a\x17\x2f\xcc\x75\xda"
          "\xb1\xd8\xae\x20\x21\x2b\x4a\xe8\xe7\xd3\x68\x4d\x45\x3c\xe7\xa0\xa0\x08\x69\x56\x20\x54"
          "\x8a\x68\x33\xb9\x95\xbb\x48\x58\xe6\xe6\x39\x2c\x49\xf0\xee\x70\xef\x03\xb4\x66\x87\xe0"
          "\x07\x80\xa1\x70\xd5\xee\xf0\x6c\xd9\x55\x2f\xce\xef\x11\x92\x7a\xd9\xe2\xe6\x3c\x91\x93"
          "\xfe\x7b\x55\xc5\x56\xf7\x00\x12\xc6\xb5\xab\x8e\xf5\x80\xc7\x79\xad\x65\xe0\x1f\xfd"
          "\xa1",
          1, 2688 },
        { 128, 128, 6, "\xb5\x0f\x19\x37\x04\xd9\x31\x23\x00\xc2\x4d\x18\xcf\x11\x34\xb0",
          "\x1d\x1e\xd8\x7c\x66\xb0\x27\x47\x30\x5c\x54\xc2\xc9\x41\x69\x75",
          "\xe7\x13\x76\x61\x90\xe4\x7f\xdf\x42\x72\xe1\x7d\xe3\x0a\xfd\xb4\x87\x6c\x2f\x13\x80\x62"
          "\x32\xfb\xd0\x61\xfe\x3e\x1c\x7f\x5b\x2a\x43\x9a\x63\xbc\x33\xca\x7d\xc0\xfa\x2b\x17\x79"
          "\x13\xf3\x1f\x10\xec\x42\x52\x8f\xe2\x17\x5d\xd1\x99\xdb\x9c\xbf\x85\x58\x59\x01\x2d\xf1"
          "\x10\x22\xbf\xd0\xa4\x05\x92\xb9\x0d\x08\x3b\xbd\x5e\xe1\xf0\x67\xd8\xef\xa5\xab\x1c\x9b"
          "\x9a\xfc\x6b\x2f\xee\x89\x2e\x42\x27\x17\x9c\x2a\xd0\x19\xba\x45\x82\x6b\x16\xa9\x29\xcf"
          "\xcb\xf9\x51\x21\xab\x47\x00\xa7\xa4\xe1\xe7\xe4\xc6\xde\x3a\x48\xe9\x64\x0f\xb9\x40\xbd"
          "\xb9\x30\x9c\x27\x5f\x59\x18\x1b\x72\xf3\x6e\xac\x5a\x57\x24\xab\x97\x4d\x72\x59\x24\x79"
          "\x8a\x33\xb3\xbe\xb3\x46\x6a\x0c\x11\x04\x9e\x56\x05\x7e\x1f\xe3\xc8\xc3\x70\x80\xd5\xf9"
          "\xdc\x32\x70\xa0\x4e\x43\xa5\x65\xd8\xb8\xb2\xd0\x45\x35\xd8\xfe\xfa\x6a\x4e\x90\xb3\x5e"
          "\x25\xe4\x26\xcc\xad\x7f\xd1\xa3\x7e\xa8\xa7\x07\x7a\x48\x06\xfd\x44\x16\xf4\x64\x8f\xbb"
          "\xc3\x7e\xbd\x8a\xb7\x00\x63\x5b\xcb\xd5\x23\x31\x76\x92\x77\x17\x7a\xdc\x5a\x32\xf5\xb2"
          "\x96\x5b\x9e\x50\xa2\x04\x3c\x13\x17\xde\xa4\xc3\x68\x4f\xfd\x9a\x59\x92\x26\x27\xc8\x57"
          "\x44\x80\xa0\x05\x42\xca\x79\x17\xde\x8c\x2f\x06\x43\x4b\x70\xb9\x62\x3c\x17\xae\x77\x1a"
          "\x67\x6a\x78\xb6\xc3\xd2\x78\x0d\x6a\x0a\x64\xfc\xb6\xc7\xc7\x0c\xb8\x4d\xae\x07\xd7\xe5"
          "\x77\xcd\xb9\x5a\x32\x57\x27\x21\x1c\x2c\x0e\x54\xb3\x09\x4e\xc2\x7a\x15\x15\xf0\xf6\xfe"
          "\x69\xed\x71\x26\xad\xbd",
          "\xca\xf9\x7a\xf4\xa9\xb1\xa8\x3e\xff\x89\x06\x2d\x26\x90\x53\x65\xb4\x6f\x96\x17\xae\xfb"
          "\x25\xc6\x33\x0b\xce\x78\x23\x81\xfd\x27\x7d\x2b\xa2\xa2\x9a\x7c\x11\xef\xa8\xf8\x49\x81"
          "\xf4\x6c\xc6\xaf\x34\xa2\xaf\x80\xa3\x36\x63\x15\x27\x12\xf9\x84\x5d\xe2\x55\xcf\xf0\x6b"
          "\x8b\xec\xaa\x2e\xfd\x51\x65\x9c\x8b\xc6\xcf\xa5\xa4\x7d\xf0\x04\xcf\xc1\x43\x38\xf9\x5b"
          "\xc9\xbc\xd6\x5b\xe9\x1c\x24\xbe\xac\x0c\x9f\xe7\x76\x8e\xc0\x1a\x21\x60\xf4\xd7\x00\xa9"
          "\x40\x58\x5d\x41\xcd\x58\xc1\x76\xdc\x4c\x0f\x20\x1a\xfa\xcb\x1a\xfc\x7a\x16\x44\xc2\x37"
          "\x29\xce\x0a\x2c\x26\xfc\x9f\x11\x62\x8d\xed\x54\x7b\x88\xf6\xdd\xe5\xb1\x90\x95\x43\x96"
          "\x2f\xba\xeb\xb8\x25\x3e\xe5\xb7\x3d\x84\x33\x13\xd7\xab\x73\x36\xae\x25\xbd\x20\xe0\x21"
          "\x05\x91\x52\xa9\xcc\xc9\xa0\x33\xfe\xdb\xa9\x6d\xe7\xcb\x2a\x44\x71\x4e\x67\xb0\x17\x62"
          "\x2d\x4c\x7e\x10\x69\xcf\xe4\x51\x14\x54\x68\x9a\x97\xdd\x75\x55\xf0\x5c\x94\xfc\xe7\x76"
          "\x28\xdc\x89\x06\x79\x2d\xc5\x92\xb2\xb8\x47\x96\x1a\xbd\xff\xd9\xe2\x2f\x71\x45\xbf\x3f"
          "\x53\x2a\xa8\xb6\x9e\x70\xd5\x6a\x88\xe7\x44\x97\xc0\xdd\xa8\xc6\x8c\x9c\x44\xfb\xbd\xfc"
          "\xe5\xa8\xbc\xa9\x2e\xb1\x43\x86\x91\xcf\xd3\x1c\x17\x32\xa8\x8b\x0d\x14\x78\xbc\x49\xa1"
          "\xdc\xf5\xb2\xf6\xae\x96\xba\x43\x5a\x8a\x35\xeb\x62\x0c\xc7\x08\x40\xd9\xe9\xc2\xfc\x6c"
          "\x7a\x68\x04\xe9\xd3\xce\x67\x84\x05\xb1\xf6\x0b\xfb\x95\x64\xcd\xf4\x3d\x44\x06\xdf\x4b"
          "\xf0\x3f\xf6\x75\x23\xbd\x0c\x65\x30\x43\x4a\x42\xc2\x91\xa2\xc9\x1e\x66\x63\xa4\xeb"
          "\xf0",
          1, 2688 },
        { 128, 128, 7, "\xb9\x23\xa6\xc3\x88\xd4\xc4\xa2\x9d\x17\x8a\x66\x3d\x06\xf4\xea",
          "\x7e\xc6\x12\x36\x38\xb2\x95\xaa\x77\x2c\xf3\xe4\x4b\xb8\x0c\x3a",
          "\xbb\x43\xda\x16\xbb\xac\x08\xcf\xf2\xa0\xdb\x50\x31\xdf\xd0\x5e\xc7\x24\xa2\x86\x6e\xd8"
          "\xac\x2a\x74\xe5\x74\x38\x3e\x50\xad\x44\x7a\x06\xac\xad\x8f\xc7\xbd\x45\xee\x0c\x50\xa8"
          "\x1f\x11\xd9\xec\x7c\x5b\x00\xd3\x3d\xa7\x64\x0e\xc9\x76\x6f\x12\xa1\x74\x75\x44\xa6\x9d"
          "\xd2\x64\x50\x51\x1d\x1d\xde\xe8\x88\x41\x36\x0b\xf8\x56\x9e\x29\x81\x71\x40\xf1\x61\x06"
          "\x72\xcf\xdc\xe4\x91\xdc\xb9\xf2\xf1\xe9\xe2\xf0\xa2\xd1\xc6\x89\xb5\xf6\xe4\xe3\xba\x4c"
          "\x50\xbf\x06\x97\x24\xa9\xdd\xdf\x5a\x60\x0b\x31\x51\x5d\x4f\x33\x8c\x0e",
          "\x2e\xf9\x5a\x46\xcd\xe5\xc4\x8e\xa4\xd6\x4a\x49\x1a\x1e\xee\xc1\x02\xad\xcb\xc6\x59\x8a"
          "\x5c\xae\x5f\xe7\xbe\xbe\x63\x84\x37\xd1\x0f\x4e\xdd\x63\xf9\x5f\x26\xdb\x07\x3e\x25\xe0"
          "\xed\xab\xfc\x6f\xbf\x0a\x08\x8b\xeb\x41\x53\xb8\xb8\x7c\xa3\x42\x84\x43\x95\xcc\x5b\x70"
          "\x26\x14\x71\x82\x31\x35\x1d\x16\x43\x86\x75\x34\x13\x77\x25\x0f\xfa\x91\x51\x02\x9f\x9f"
          "\xf1\x3c\xde\xc7\x92\x51\x3b\x2a\xd7\xe4\xa2\x38\xc2\x70\x68\x33\x71\x58\x68\x40\x98\x30"
          "\xb4\xe4\x5e\x3f\x65\xd3\x52\x75\xc0\x24\xa6\x94\x77\xd5\x8c\x05\xda\x35\xed\x01\xee\xd3"
          "\x18\xea\x60\xb4\x3a\x7b\x3b\x35\x06\x40\x68\x5d",
          1, 1024 },
        { 128, 128, 8, "\x37\xa4\xcb\xdc\xca\xc4\x12\x8e\x67\x37\x39\x38\x10\x1f\xe9\xa8",
          "\xb9\x6e\xf0\xb4\x4e\x8a\x46\x52\x62\x76\xcf\x57\xba\x07\xff\xff",
          "\xe6\x73\x12\x8a\xac\xdb\x6f\x5c\x8d\x37\xbd\x84\x7e\x08\xd7\x88\x91\xeb\x34\x58\x76\x1e"
          "\x39\x16\xa9\x8e\xe4\x26\x27\x01\xf8\x43\x7a\x82\x64\xac\x78\x16\x7c\x09\xd5\xb2\x18\x8b"
          "\x18\x7b\x15\x1e\xce\x5c\x04\xce\x0a\xd6\xa9\x23\xf5\xef\xc7\x99\x8e\x95\xcd\xb7\xc5\xc6"
          "\xbf\x11\x9a\x63\x18\x6a\xe6\x62\x64\xc6\x6b\x83\xd8\x9b\xf0\x6b\x7e\xa5\xe8\xcc\x0f\x45"
          "\x62\x09\x27\x57\xbd\xdb\x95\x9c\xdd\x19\x21\x3a\xc2\x6c\xfd\x11\x47\x18\x95\x84\xa1\xb8"
          "\xf6\x26\x30\x1c\x67\x4e\x5a\xeb\xdf\x7a\x1c\xce\x62\xe8\x64\xb9\xe4\x5f\x50\x5a\x9f\x69"
          "\x9a\x63\xcd\x2e\xcb\x8a\x04\x55\xf9\xb8\x62\xb6\xc8\x38\x8a\x66\x2c\xe4\xd3\x04\xb6\xae"
          "\x05\x90\x05\x32\xdf\x57\xec\xc0\x67\xd6\x43\xf7\x6b\x74\xc2\x8f\xb3\xc0\x28\x44\xa1\x17"
          "\x71\x80\xb4\xbc\xb6\x75\xa8\xe4\x9c\x99\x82\x7a\x93\xb0\x10\x53\xa3\x90\xea\xe5\x98\xf7"
          "\x4d\x38\x1e\x99\xd6\x1e\xd1\x7b\x50\x23\xc1\x69\xae\xb1\x24\xf3\x2b\xb9\x73\x0b\x97\x25"
          "\xc6\x7d\x94\x56\x4f\xb5\x58\x56\xd1\x51\xc3\x87\xb3\x1c\x20\x47\xcc\x1f\x82\x11\xa0\x2e"
          "\xfd\xdb\x6e\x7e\x66\x1c\x4b\xd1\x9e\xf5\x2d\x8b\x11\x47",
          "\x43\xce\x0a\x61\xc9\xe1\x05\x6e\x1e\x28\xfc\x6a\xf0\x11\xe9\xb2\xbe\x82\x61\x68\x85\x1c"
          "\x30\x5b\x0c\xa6\x31\xd8\x24\x23\xf7\xd2\xbe\x3e\xc7\xea\xe9\x80\xb0\xaf\x5a\x61\x39\x31"
          "\xe9\xde\xbc\x8b\xc6\xa0\x9d\xed\xf2\x43\xd5\x86\xb0\x7d\x20\xef\x9d\xd0\xaa\x79\x16\x1e"
          "\x55\x81\xb7\xd1\xc7\xc1\x24\x70\x16\x92\x35\x61\xd8\x22\xb1\xc0\x53\x74\x90\xcf\xe3\xab"
          "\xc1\x82\x80\x89\x28\x80\x41\x46\x6c\x0e\x3c\x33\x5c\x5a\xb5\xbb\xdf\x3a\xc9\x28\x36\x1b"
          "\x56\x47\x2e\x16\x8d\x7d\x1d\x1a\x37\x1e\x5a\x15\xda\x0a\x7d\x4f\xa3\x1b\xdd\xe9\x33\x83"
          "\xad\xc7\xdc\x4c\x52\x4d\xa6\xb8\x71\x75\xd4\xc6\xc3\x5a\x97\x41\x3b\x59\x15\xff\xa4\x1f"
          "\xa6\x24\x02\x39\xad\x43\xee\x04\xe5\xb9\x5f\x01\x8c\xe9\x88\xb1\xc7\xe3\xbf\x73\x19\xfe"
          "\x2d\xc6\xf7\x82\x7d\x34\x9d\xbe\xde\xaa\x64\xdc\x39\x91\x37\x1b\x4e\x3a\xb3\x8e\xd5\x2a"
          "\xdd\xae\xf3\x57\xd0\xe4\xeb\x7c\x0c\xc3\xcf\x83\xe4\x01\xc8\xfd\x55\x27\xc9\x23\xaf\x2e"
          "\xd9\xbc\xfa\x03\x57\xc9\xe9\x78\xf9\x59\xfc\xb5\xde\x71\xf8\x54\xbd\xdf\x93\xe4\x61\xdf"
          "\x49\x19\xf9\x08\xc7\xd6\x31\x1a\xcb\xc0\x5f\x22\x12\xff\xd4\x87\x7c\x1a\x55\x5d\xa4\x6c"
          "\x57\xf6\xa1\xb8\x60\x4e\x06\xe3",
          1, 2048 },
        { 128, 128, 9, "\xa4\x5e\x0c\x69\x32\xad\x62\x55\x62\x14\x74\x87\x16\xdd\x34\x93",
          "\x92\x72\x45\xb7\xe1\x4a\x40\xd3\xf3\xf5\x17\x5d\xd3\xc3\x9a\x63",
          "\x6f\x10\x2c\x7c\x75\x35\x16\x87\xdb\x0b\x41\xb1\xbc\xb2\x71\xd2\xef\x8a\x56\x70\x38\x93"
          "\xe5\x79\xb9\x63\x2a\x09\xc3\x35\xe9\xf4\x8d\xb2\x32\xda\x37\x36\x50\x82\x1b\xef\x29\xc5"
          "\xf4\x71\xac\xfb\x7f\x8b\x65\x6d\xf0\xae\x1c\x83\xd0\x88\x72\x90\xc4\xb5\x60\x94\xf7\xcc"
          "\xd3\x8f\x23\x08\xe5\x25\x60\x5b\xd6\xab\xcc\x1a\x7d\x17\xa8\x46\x82\x26\x1c\x30\x13\x60"
          "\xfc\xa6\xca\x8b\x53\x26\x09\xb9\xb1\x0a\x3e\x4c\xb3\x27\x7c\x18\x58\x37\xc2\xd3\x77\x67"
          "\xed\xec\xe9\xd7\x40\xb0\x1a\x93\xb6\x7e\x31\xc7\xa4\x86\x63\x3a\xa3\x28\xb1\xc1\xb2\xb1"
          "\x3e\xe0\x7d\xfc\x14\x2d\xed\xc2\x47\xd3\xaf\xa7\xa8\x0f\x56\xca\xc3\x8b\x4e\x8d\x2b\xa1"
          "\x65\x71\xf9\x1e\xb3\xc5\x53\xd7\x91\x83\x9b\x0d\xf2\x2e\x83\x0e\xa6\x31\xb4\x63\x67\x34"
          "\x23\x3b\xac\x9f\x3d\x2a\xd6\x38\x52\x9a\xfc\x38\x18\x0f\x62\x4d\xe8\x4b\xb8\x7e\x45\x5f"
          "\x28\xfe\x44\xc4\x16\xf9\x1f\x03\x06\x67\xc9\x2b\x3d\x98\xd5\xff\xe6\xdb\x8b\x70\x0f\xaa"
          "\x02\x20\xe9\x83\xeb\x3a\x42\x8e\xc3\x90\x79\xb0\x07\xa3\xf6\x5e\xb9\xa9\xe3\x81\x3c\x4c"
          "\xc9\xec\xac\x10\x3f\xcb\x35\x46\x98\xf7\xab\xd0\x13\xbf\x75\x6b\x41\x90\xaa\x4c\xa0\x99"
          "\x06\x25\x5a\x31\x2a\x5a\xc3\x09\x08\x35\x2d\x80\x8d\xbd\x89\xe8\x7a\x10\x28\xe9\x47\x2d"
          "\xf7\xe5\x98\x5f\x73\x9b\xd9\x23\x41\xec\xb1\x28\xe5\x67\x81\xc1\x53\xc7\xbe\xa7\xfa\xb9"
          "\x0b\xf0\x6e\x73\xf5\x09\x3e\xe3\x90\xa5\x3a\x1c\xe8\x08\x28\x56\xb8\xbe\xe1\x38\xb1\x68"
          "\x09\xae\x25\x11\x28\x03\x0e\x7c\x38\xbd\x80\x8d\x0b\x7e\x46\x5e\x00\xa0\x70\x50\xac"
          "\x7c",
          "\x35\xa9\xb1\x0a\x7f\xd1\x4e\x29\xba\x2d\xf2\x58\x16\xf5\x53\xc8\xc1\x83\x99\x10\xbf\x00"
          "\x81\xd0\x95\x86\xa1\x58\xe5\x81\x33\x9a\xa3\x1f\xf7\x36\xc5\x41\xe7\xd2\xd7\x58\x15\xdd"
          "\x0d\xe5\x75\xa3\x51\x1c\xfe\xdf\x63\xf3\x10\x96\xad\x95\x79\x04\xf2\x88\xce\xf9\x0a\x34"
          "\x1b\x5a\x2f\x85\xed\x5c\x16\x9c\x19\xa1\x8b\xfc\xd9\x7e\x5c\x4c\xf3\x74\xed\x4a\x6b\x5d"
          "\xe8\x5c\x98\x8f\xd1\xf6\xef\xae\xd3\x21\x9b\x77\xd6\xb8\x52\x5f\x54\x56\xb2\xf8\x3a\xbc"
          "\x64\xc0\x13\x4c\x5a\xbb\x73\x01\x20\xad\xaf\x5f\x4b\x27\x0a\x38\x07\xc2\x2c\x2f\xf4\xcd"
          "\x41\xb4\x5e\x9f\x05\xa8\xf6\xaf\x2f\xf3\xd9\x0e\x24\xc7\x66\x11\xfa\xea\x54\xe4\xec\xec"
          "\xd6\x8f\x08\x3f\xa6\xc7\x9c\xa6\xc4\xeb\x14\x10\x12\x56\x9b\x5d\x73\xef\xf9\xc2\x1b\x1d"
          "\x74\x3a\x48\xe3\xc8\x5f\x59\x12\x63\x28\x56\xde\xc0\xf8\xdb\xe0\x87\x13\x10\xea\x4d\x31"
          "\xc8\x08\x4b\x3a\x58\x5c\x0a\x1a\xab\x7c\x36\x10\x12\x66\xea\x53\x87\xfc\xb8\x8e\x51\x0d"
          "\xc7\x85\x0a\x11\x4e\x0c\xee\x4b\x1d\xac\xca\xbc\xe7\xb0\x00\x20\xad\x14\xdf\xb9\xe7\x5c"
          "\x77\x9e\xad\x35\x09\xea\x7e\xa1\x19\x8b\xb0\x98\xa8\xaf\x7d\x8e\xed\x34\xae\xa9\x40\x68"
          "\x1a\x37\x66\x1e\xfc\x87\x60\xf4\xe0\xca\x5e\x49\x50\x1e\x6d\xeb\x10\x70\xae\x80\x63\x12"
          "\x12\xc4\x6b\x38\x6b\x37\x2c\x47\x12\x45\xe7\x7f\x6d\xbf\xb7\xa2\xfa\xa6\x03\x5d\x87\xc0"
          "\xea\xf4\x84\xcd\xe3\xbb\xf6\x0a\x65\x5f\x1d\x07\x80\xbc\xf8\xd7\x56\x9e\xc5\x4f\x44\x4f"
          "\xee\x69\xdc\xc3\x9c\x00\x30\x7f\x78\xa8\x12\xac\xad\x1d\x77\xf9\xde\xd9\x05\xd7\x6d\x19"
          "\x82\xc3\xff\x83\x81\x48\x82\xbe\x09\xda\xd4\xeb\x1f\xe8\x96\x69",
          1, 2816 },
        { 128, 128, 10, "\xeb\xcb\x01\xb1\x19\x2a\x67\xd5\x19\xf7\xea\x54\x16\x54\x0c\x42",
          "\x3e\x8e\xd8\x30\xd6\x68\x57\x2f\x4f\xd8\x81\x60\x09\x84\xb4\xd0",
          "\x6b\x44\xa6\x07\x77\x51\xa3\x86\xe6\x0b\xbf\xf6\xd9\x52\x3e\xa0\x06\x03\x4a\xbd\xac\xdb"
          "\x23\x79\x71\x6f\x4c\x0d\xfa\xe5\xa4\x2f\x71\xe3\xbf\x9d\x96\xff\xf2\x53\x0a\xec\xc8\x26"
          "\x90\xdc\x97\xba\xd7\xeb\xe1\x55\x49\x10\x5c\x3f\x30\x8f\xfc\x72\xd1\xcc\xc5\xcc\x58\x36"
          "\x60\xbf\xe0\xe2\x74\x53\xca\x06\xa0\x88\xbb\xf0\x6e\x25\x8b\xa2\x1e\xcf\x2e\xa3\x53\xd8"
          "\x6b\x4c\xaf\xa6\xe4\xfc\x01\xc0\x74\xb8\xea\x96\xd3\x1a\x49\x52\xdb\x1f\x49\x6c\xe5\xb4"
          "\x5c\xfa\x8d\xb0\xd1\x5d\x04\x76\xe2\xc4\x6d\x58\x50\x9e\x67\x3f\x60\x56\x4a\x26\x36\x20"
          "\xbc\x88\x72\x7f\xdd\xda\x28\xda\x21\x1a\x1d\x30\x3d\xe4\xb4\x8b\x95\xb7\x1e\x9c\xb0\x98"
          "\x41\xe2\x8c\xd7\x37\x76\x15\x5f\xb5\x93\x3b\x74\xc1\xca\x69\xfb\xcf\x06\x89\x76\xdb\xd0"
          "\x52\xc5\xf0\xac\xc5\xfb\x26\x74\x86\xca\x33\x31\xb8\x0b\xef\x64\x62\xa2\xdf\xcd\x06\x4a"
          "\xe3\xf3\x09\x5d\x8c\x7a\xca\xfd\xba\x52\x5b\x78\xa1\x22\xce\xc6\x66\x4b\xc8\x55\x54\xd7"
          "\xbf\xe3\x62\xa9\xb3\x3e\xb1\x19\xae\x8a\xf8\x95\x0e\xee\x88\x0f\x25\x2f\x08\x8a\x59\xab"
          "\xdf\x4a\xb9\xda\x9f\x9c\xce\x65\xd5\xa8\x94\xa3\x52\xe3\x6c\x60\x93\x0c\x76\x8a\x66\xf0"
          "\x06\x5d\x8a\x7e\x84\x6b\x88\xac\x46\xb5\x8e\x05\xa0\xa1\xf6\xe7\xd6\x42\xe8\x4d\xee\x67"
          "\xf7\x24\xfe\x5a\xc6\x67\x81\xe3\xc0\xf0\x07\x5a\x43\x09\x57\x5b\x5b\x02\x54\x5d\x8e\xcf"
          "\x6d\xab\x92\x6c\x47\x4b\x0f\xb1\xa8\xa7\x1b\x0c\x49\xfe\x3d\xc6\xa2\xcb\x12\xcd\xec\x66"
          "\x90\xc2\x76\xd7\x49\xfe\x77\x3e\xdf\x88\x0f\x39\x91\x60\x26\xc6\xff\xc0\x36\xdb\xd4\x4d"
          "\xe1\x90\xca\x96\x5e\x33\x85\x4f\x94\xb4\x42\x48\x42\xea\x06\x88",
          "\xd1\x81\x7f\x0d\x2e\xe9\x4a\x83\x54\x17\xe0\x9f\x23\x73\xf4\x2d\x23\xb0\xdf\x9c\x32\x44"
          "\x3f\xfd\xca\xaf\x3c\xc0\x96\x48\x6c\xfd\xd9\xe4\x70\xe7\xe6\xfe\x91\xd9\x90\x18\x78\x12"
          "\x81\x17\xda\x53\xc6\xc1\x41\x5a\xe2\xca\xa0\xbf\xfe\x1e\xb9\xfb\x42\x53\xf9\x75\x3b\x0b"
          "\xd6\xcd\x1d\x15\xda\xc0\x9a\x21\x84\xae\x3e\x22\xa6\x1f\x91\x7f\xcb\x45\x42\xf9\x0a\xc0"
          "\x0d\xd8\x27\xeb\x9a\x06\xea\x61\xa3\x0e\xc6\xa7\x30\xe2\x3d\xc7\x5d\x2c\xe0\x34\x65\x70"
          "\xa8\x4f\x35\xcd\xdf\xef\xdd\xdc\x37\x36\x82\x3f\x15\xcf\x29\x1d\x15\xbc\x92\x46\xc1\xf7"
          "\xcc\x45\x73\x2f\xc0\x17\xd9\xed\x78\xbc\x32\xa0\x11\xad\xf6\x63\xd8\x71\x6b\xb7\xf1\xd9"
          "\x86\xd4\xf2\x05\xbb\xff\xb7\x84\xea\xbc\x1b\x3d\x90\x44\xb8\xe9\xff\x36\x9f\x94\xa3\x2f"
          "\x31\xec\xbb\x36\xed\xad\x56\x65\x64\x4e\x86\x83\xb0\x91\xcd\xbc\x56\xb9\xa8\xa1\xa3\x74"
          "\xae\xc5\xc9\x58\xd0\x0a\x57\xc0\x2a\x84\x92\x30\x42\x8a\x9a\xbc\xeb\x97\x71\xbe\xe7\xa6"
          "\x57\xb6\x4c\x86\x5a\x9e\xb3\xdf\x86\x42\xcb\xe9\x2d\xc3\x3d\xc0\xb0\xcf\x17\x67\xa1\xb5"
          "\x20\x1a\xbd\x83\x35\xa5\x12\xdd\xca\xdb\x9c\xff\x2e\x76\x15\x54\x9b\x57\xe5\x99\x78\x1b"
          "\xb5\x20\x6e\x92\xbd\x1d\x23\xc1\x1c\x95\xb0\x34\x8f\xeb\x7d\xb9\x17\x1b\x37\x90\xc8\x93"
          "\xa1\x4b\x94\x86\x6e\xe1\x52\x7b\x24\x23\xa3\x05\x0f\xf7\xaf\xd2\x45\xff\x67\xb4\x56\x39"
          "\x3b\xce\xb5\x10\x0a\xb9\xb4\x73\xee\xf5\x33\xb1\xd4\x45\x6d\x55\x09\x7e\xaf\x6b\x75\x91"
          "\x37\x38\x8a\x13\x80\xf2\xbf\x45\x5c\xbd\x30\x98\xcf\x6b\x87\xab\x07\xf5\x38\xb8\x57\xe1"
          "\x72\x88\x03\x46\xeb\x87\x87\xf9\x60\x27\x37\x5c\x5d\x75\x37\x2a\x3a\x26\xc0\x3e\x3c\xb3"
          "\xd1\xaf\xca\x71\x8e\x97\x9c\x25\x3b\x1f",
          1, 2944 },
        { 128, 128, 11, "\x23\x92\xc5\x2e\x25\x7e\x7d\xd1\xf3\xa5\xd6\x4d\xac\xfc\xaa\x02",
          "\xb0\xdb\x14\x69\x98\xd2\xa2\x82\x42\x13\x3f\x0a\x42\xd8\xce\x9a",
          "\x4f\x49\x49\x72\x31\xd0\x36\xee\xad\xee\xce\x1b\x36\x96\x1c\x96\x7b\xce\x5a\xf6\xdf\x72"
          "\xe7\xbb\x8c\x33\x0f\x99\x14\x4d\x68\x37\x22\x8f\x1a\xa3\x49\xb9\xaa\x25\xf2\x3c\x7b\xcf"
          "\x46\x6f\x9f\xa7",
          "\x12\x1d\xcb\xc3\x47\x9c\x41\x6e\xf5\xc4\x97\xbd\xac\x9b\x94\x6c\x2d\x78\xf2\x23\x04\xd1"
          "\xb9\xa7\x3b\x58\xa5\xe2\x2b\xbe\x1c\xb3\xd4\xe1\xbc\xc9\x9a\x85\x09\x82\xc5\x3e\x07\x26"
          "\x02\x53\x88\x6c\x49\x9d\x9f\x08\xc0\x68\xda\x65\x54\x02\xe3\x33\x89\x4d\xb7\xa3",
          1, 384 },
        { 128, 128, 12, "\x00\x82\x6a\x92\x09\x2f\x24\x77\x4d\x2b\x34\xc9\x23\x2b\x0b\x20",
          "\xf2\x6f\xf3\xed\xaa\xa2\xf1\xc4\x66\x68\x99\xf8\xb7\xaf\xbf\xaf",
          "\xf0\x0f\x43\xde\xe2\xb3\x9d\x33\x85\xf4\x62\xaf\x91\x7b\x6d\x4e\x4c\x48\x30\xc7\x93\x64"
          "\xac\x4c\xac\xb8\xc6\xc3\xbc\x2a\xfc\xae\xbb\xec\x4a\x33\xad\x6d\x2b\xb0\xc0\xec\xe1\xd1"
          "\x33\xcd\xd4\xbb\x2d\x87\xeb\xe4\x25\xdf\x74\xac\xf2\xd5\x4c\xf9\xc1\x93\x39\x31\x42\x71"
          "\x6b\x4d\x29\xcc\x18\x76\xe3\xb4\x8f\x96\x49\xb5\x66\x74\xb6\x7b\x39\x6a\xbd\x38\x1a\x53"
          "\x6a\xda\x22\x47\x2c\xe8\xcf\x7b\x35\x7e\x4d\xe7\xbc\x17\xc8\xc7\xb4\x8a\x71\x6b\x94\xbf"
          "\x09\x0d\x8a\x6f\x00\xf6\x87\x2a\xe2\xe7\x93\x1f\xab\x78\x9d\x44\x3d\xc4\xa1\x74\x60\x9f"
          "\x44\xb5\x61\x84\xc4\xe7\x1b\xed\xa8\x13\xc7\xc5\x84\x69\xaa\xa2\xb0\xf3\x0d\x31\x6d\x60"
          "\xd9\xef\x84\x44\xef\x4a\xc9\x73\x46\xa5\xdf\xed\x38\x43\xc7\x58\x33\x30\xa5\x2c\x1a\x69"
          "\x0b\x76\x8e\x9c\x1e\x65\x63\x2c\x8f\xe7\x23\x01\x6d\xf2\x6d\x3d\xcd\x44\x3e\x0d\xf8\xe4"
          "\x9d\x5f\x25\xc6\x16\x0b\x9b\x28\x52\x93\x97\x9a\x12\xd4\xec\x90\x95\x52\xdf\x00\x60\x02"
          "\x48\xe1\x8b\x36\x80\xc5\xc3\x22\x47\x52\x47\xce\x1e\x6c\x8e\xd3\x3c\x4d\x6b\xe1\x08\xdb"
          "\xf1\xa7\x17\xd2\x17\x32\x8c\x7b\x18\x26\x37\xf7\xaa\x93\xc6\xec\xd9\x69\x39\xd5\x61\x78"
          "\x85\x3a\xf6\x43\x43\x84\x0e\x38\x71\xc2\x03\x57\x05\xea\x37\xa0\x52\x48\x3b\x97\x2b\x33"
          "\x81\xe8",
          "\x36\xc6\x7c\xed\x77\x5b\xb5\xf8\x24\x69\xf2\xe7\x1e\x5d\xa1\x06\x68\x91\x06\x12\xd6\x4f"
          "\x78\x09\xcd\x35\x3c\x42\x28\x88\x15\xea\xc1\x09\xf0\x64\x60\xdf\x8f\x89\xdf\x34\xf8\x65"
          "\xfe\xff\xe8\x5a\x4d\xfe\x8c\x82\xf5\xbe\x43\x02\xba\xe9\xe7\x04\x35\xdd\x54\x18\x87\x7b"
          "\xf7\x4a\xe1\x30\xd5\x22\xe8\x62\x87\xff\x82\x59\x33\xc3\xa9\xcb\xbe\x42\x53\x03\xd5\xdc"
          "\x66\xd1\xcb\xac\x40\x16\xd8\xdd\x24\xfc\x12\xcc\xd2\x80\x2c\x43\xf5\x41\x5e\xb3\x7a\xb0"
          "\x01\x9d\x6b\xca\x44\x5a\xaa\xe9\xcc\xcb\xbc\x32\x6c\xd4\x22\x74\xa6\xda\x4a\x12\x18\x72"
          "\x7d\xe2\x47\x69\xbb\x75\x50\x30\xd6\x7d\x80\xb7\x55\x17\x9f\xb4\xe1\x1d\xae\x7a\x2a\xe1"
          "\x73\x1c\x9b\xa3\xec\xd3\x69\x59\x5e\xf0\x4b\x90\x8f\x5f\x41\x6d\xc1\x2d\x70\x7b\xee\x43"
          "\x2c\x45\xfd\xd2\x47\x44\x10\x5a\x53\x9b\x18\xfc\x10\x2f\x33\xf5\x56\x36\xcc\xda\xeb\x52"
          "\x1e\x92\xf4\xcb\x4c\xd5\xa1\x21\xef\x5c\x3c\x1f\xfd\xde\x4c\xa4\x17\x57\x00\x39\x80\xab"
          "\xee\xe8\xec\x25\x63\x26\x8c\x2d\x1d\xc5\xe0\xd8\x99\x20\x60\xd5\x0b\x31\x66\xb8\x8b\xed"
          "\xe6\xf3\x05\xea\xf8\x76\xd9\x28\x41\xe6\x77\x98\x26\x42\x5e\x51\xf5\xd9\x76\x78\xb8\x51"
          "\x11\x91\x23\xf9\x46\xbd\x93\xc4\xb2\x18\xad\x7b\xde\x4c\xb4\x42\x77\x1a\x53\xeb\x9e\x67"
          "\xdf\xeb\xcb\xb8\xbb\xd3\x48\x4d\xf0\x01\xe2\x00\xe5\xfb\x41\x6e\xea\x45",
          1, 2304 },
        { 128, 128, 13, "\x6f\x1e\x3a\xf9\xd9\xcc\x23\x6f\x77\x2c\x02\x52\xca\x40\xb5\x1f",
          "\x94\x30\x7d\x11\xa9\xb2\x60\x14\x40\x24\xad\x18\x25\xa5\x84\x87",
          "\x2d\x1b\x83\x67\x82\xdf\x23\xf8\xc4\x90\x10\x5b\x6e\x61\xa9\x33\x21\xe5\xd2\xbe\x88\xe0"
          "\x96\xb2\x14\xa2\xfd\xb9\x34\xbb\x62\xda\xb1\x06\x49\xed\xbe\xb7\x3b\xa7\x78\x22\xfe\xb6"
          "\x5a\x4a\xe6\xdd\x52\x6a\x8c\xdd\x00\xb0\xc1\x8b\xca\xce\x40\x17\x67\x21\x5b\x18\xf8\x66"
          "\x6b\xa4\xca\xb3\x92\x61\x92\x9d\xb0\xb1\x1f\x2d\x14\x86\x62\x57\x74\x2a\x30\xe7\x7e\xc7"
          "\xcf\xb6\x5b\xb3\x1b\x52\xf7\x83\x48\x08\x13\x2f\xae\x63\xbc\x0e\x06\x88\x0c\x21\xcc\xc7"
          "\x9a\x26\x99\xcc\xb3\x6c\xef\xd7\xf7\xe8\x23\x25\x59\xa1\xbd\x1e\x89\x45\x64\x32\xf7\x92"
          "\xee\x9e\xd8\x64\xd9\x54\xf4\xc0\x24\xa6\x95\xec\xf5\x1b\xed\x58\x75\x4f\x12\xc1\xdd\x4b"
          "\xc6\x40\xfd\x0f\xd8\x11",
          "\xb1\x9c\x54\x82\xff\xc8\x4a\x8a\xac\x28\x49\xcc\xdb\x73\x4f\x94\xde\xa8\x0e\x74\x22\x30"
          "\x0d\x4e\x3e\x95\x31\x6f\x68\x9c\xa4\xcb\xc1\x2d\x78\x81\xe2\x90\xcc\x62\x3d\x6e\x66\xb9"
          "\xf4\x64\xd9\x1c\x2e\x31\x11\x2b\xa8\x19\xed\xbe\x0f\x75\xe0\xdb\xc1\x3b\x74\x43\x23\xac"
          "\xf4\xba\x7d\x95\x42\x3f\x5b\x65\x32\x86\xa4\xea\xbb\x77\xa7\x16\x10\x72\x88\xdb\x4f\x1d"
          "\x7b\x76\x4d\xa1\xe9\x90\x3c\x28\x25\xfc\xb9\x74\x5a\xfe\xd0\x33\x0d\x6c\xb9\x50\x09\xd2"
          "\xcd\xb1\xf7\x3a\x1a\x8d\x02\x8f\xbe\x51\xd0\x7b\xef\x6c\x33\xeb\x70\xa5\xdd\x01\xba\x4e"
          "\x8a\x08\xec\x0e\xc9\x14\x09\x0e\xba\xcf\xd5\x0d\xef\x79\x85\x41\x83\x38\xb7\x13\xe4\x8f"
          "\xe4\xf4\xf5\xc2\xea\x5e\x15\xfb\xf7\xbe\xfb\x03\xe2\x6e\xd1\x74\x09\x94\xaa\xf4\xa2"
          "\xf0",
          1, 1280 },
        { 128, 128, 14, "\xa9\xd7\xdd\x48\xaf\x2c\xe4\xa3\x5a\x5a\x4e\x61\x02\x60\xcc\xde",
          "\x78\x85\xb2\x28\xbc\xdc\x45\x6e\xf7\x7d\x1a\xe7\x5b\x34\x11\x5b",
          "\xfd\xd7\x66\x37\x86\x80\xf6\xb7\x5e\xf1\x97\x07\xfa\xfd\x1f\x2c\xa3\x58\x03\xc8\x5a\x73"
          "\x0a\xa5\x43\x9b\x71\x83\x05\x8c\x06\x51\x6f\x48\xad\xc5\x5c\xcf\x9e\x72\x47\xad\x91\x06"
          "\x27\x19\x1d\x9e\x33\x33\x8f\x9a\x03\x2e\x22\xc5\x23\xc6\x2a\x04\x05\xb4\xaa\xdc\x44\x22"
          "\x49\x85\xa1\xfa\x91\x81\x50\x90\xe9\x7d\xb8\x3c\x17\x43\x23\x88\x73\xb2\xa0\xfc\x1a\x82"
          "\x40\x8c\x52\x73\x77\xde\x62\x43\x6b\x0d\x47\x19\xbd\x29\x97\x5e\xe1\xc6\x1d\x9a\xa1\x7b"
          "\xbc\x0f\x2a\x22\x4d\x37\x02\x8a\x37\x78\x65\x3e\xdb\x85\xca\x4c\xe3\xc2\x73\xe9\xc8\x36"
          "\xac\x69\x36\x7d\x62\x35\x7c\x4d\x0e\x7a\xec\xa9\x74\xfb\x65\x3d\xed\xa5\xf5\x51\xd9\x45"
          "\x21\xb4\xcd\x48\xbc\xc3\x2c\xc6\xd7\x1e\x9b\x76\x96\x9c\xa5\xd3\xc2\xcd\x21\xcf\x25\x0e"
          "\x25\x6e\xdc\x06\xc2\xa3\x47\x08\x00\xaa\x79\xe8\xfa\xbb\x6f\xd3\xea\x40\x88\x88\xf0\x4b"
          "\x0e\x00\xa6\xaa\xf8\xf3\x6d\x33\x73\x68\x02\xe2\xcd\x56\x22\x68\xee\xcd\xa6\x33\xec\x92"
          "\xff\x0f\x6d\xc0\xa9\x4a\xad\xfa\x42\x9a\xb5\x51\x1a\x78\x1e\x20\xef\xf9\xed\x7f\xe2\x0a"
          "\xec\xef\xfc\xad\x30\x3f\x38\x16\x98\x06\x60\x9b\x42\x4a\x35\xcc\x29\xe1\x3c\xfa\xeb\xac"
          "\x46\x0e\x2c\xe3\xde\x29\x0a\x5f\x64\xd0\x01\xac\xf9\x16\x2f\xb2\x77\x7c\xf7\xaa\xa2\xb2"
          "\x9a\x95\x11\xf6\xfa\x0c\xad\x14\xc1\xb4\x60\xa4\xc1\xea\x82\xf2\x11\x7a\x9a\x97\x44\xd9"
          "\xb7\x37\x50\x2c\xcb\x6c\x7c\xe8\xc9\x0b\xb6\x46\xed\xd9\x4e\x8f\x8c\x27\x54\x70\xd1\x8c"
          "\xdd\x86\x28\xbc\xed\x74\x40\x52\x1a\xf6\xaf\xd5\x35\xa5\xab\xee\xe2\xbd\x68\x6c\x28\x15"
          "\x14\x36\x67\xf2\x17\xae\x38\x8b\x59\x05\x9b\x85\xdd\xbf\xb2\xbf\xf4\xb7\xe7\x1e\x5a\x11"
          "\x0f\xa8\x5c\x1e\xdf\x92\xbd\x76\x9b\x78\x64\x93\x2a\x50\x90\xe9\x4a\xe2\x15\xa4\x66\x9b"
          "\x9d\x9a\xbf\xec\x72\xd4\x7b\x80\xc2\xc2\x1d\x16\x6e\xfc\xae\x2b\x32\x27\xbd\x00\x09\x73"
          "\xbf\x3c\x7f\x53\xf1\xb4\x89\xdc\x85\xbd\x09\xc2\x3d\x43\x6d\x1f\x91\xf7\xca\x5a\x89\x04"
          "\x3d\xd3\x3a\x30\xbe\x15\xd9\x58\xb6\x2e\xa8\xd7\x49\x26\xad\xfc\x90\xe8\x1a\x82\xb0\x8f"
          "\x12\x87\x67\xa7\x8f\x14\xe3\xc7\xf6\x79\xcf\xe9\x69\x96\x7c\x66\x2c\xf8",
          "\x7f\x05\x54\xdb\xee\xcd\xa0\xfc\xda\x76\x64\x15\xf4\xdd\x23\x10\x65\x95\x72\xbf\x57\x15"
          "\xfd\x5a\xad\xbb\x30\xc1\x2e\xb2\x30\x0a\x3a\x5f\xf0\xe0\xb6\xa9\x56\x20\x0d\x81\x63\xa1"
          "\x16\x4c\xc0\x0c\x58\x17\x85\x42\x79\xda\x82\xa4\xa6\xc0\xa7\x1e\x26\xba\xb5\x4a\xf6\x12"
          "\x76\x58\xb3\xab\x46\x48\x84\x45\xc6\xf5\x52\x69\x22\x25\xb9\x9b\xfa\x3f\xf3\x89\x25\x06"
          "\x75\x13\x9f\x2b\x09\x1b\x45\xca\x80\x25\xca\xbb\x85\x40\x76\x5a\x50\xb0\x4d\x62\xcb\xff"
          "\x76\xd8\x77\xda\x3d\x9e\xf6\x67\xdf\xe6\xae\x25\xdc\x28\x9d\x15\x9c\x04\x3a\x32\xae\xf8"
          "\xe9\x31\x37\x81\x02\xec\x1b\x6b\xce\xbe\x56\x87\x00\x01\x83\xc5\x80\x1f\x7b\x0c\x3f\x61"
          "\x5b\xc8\xb5\x2a\x91\x95\x8c\x1a\xb2\x87\x58\x73\x93\x43\xd8\xe4\x30\x9c\xdb\x53\xc7\x14"
          "\x1f\x8d\xea\x77\xc7\x4f\x41\x7c\xa4\xfb\xbd\x35\x05\x8e\xca\x70\x15\x58\x0d\x6f\xb0\xb2"
          "\xda\x2f\xbc\x83\x6c\xf0\x27\x9e\xe9\xba\x6a\xb4\x04\x2a\x4a\xdc\x46\x61\x74\xa1\x10\x2d"
          "\x1a\x57\x96\xc0\x8c\x7b\xb1\xfa\xf9\xd9\xdc\x48\x2d\xda\xe0\xf3\x5c\xfc\xd5\x0d\xf5\xee"
          "\xfc\x92\x00\x02\x9a\x2b\x6b\x9c\x90\xfa\xd2\x26\x87\x76\x0d\x40\x26\xe1\x76\x2a\x15\x37"
          "\x23\x16\xfa\x75\x77\x01\x41\xbd\x74\x66\x28\x5c\x5c\xb6\xb6\xfa\x13\x0a\xb2\x7c\x98\x40"
          "\x1a\xa0\xd5\xb7\x77\xd5\x30\x8f\xde\xca\x9f\x71\x97\xd2\xe8\x93\x6b\x57\x5b\x25\xd7\xac"
          "\x24\x15\x62\x75\x83\x07\x4c\xa5\xa8\x6b\x40\x70\xc8\xe4\xb3\xf5\x73\xfe\x8b\x91\x14\x81"
          "\xa4\x2d\xfc\x7f\xa1\x76\xb4\x3c\x19\xeb\x0c\xb5\x70\x41\xba\x58\xce\x93\x16\xb4\x09\xad"
          "\xfd\x84\x03\x0c\xf9\x15\x73\x07\x27\xc2\xa8\x76\x71\x9f\x13\x05\x3a\x01\xfb\x0c\xa3\x13"
          "\xb2\xb8\x8c\xea\x71\xc5\xbf\x55\x9b\xe1\x1a\xe7\x95\xf4\x20\x67\x7e\xb5\x06\x3f\xbe\x7e"
          "\xde\xf1\x4f\x05\x60\xb5\xf1\x8c\x6e\x04\xf5\x59\x14\x43\xda\x0c\xd2\xb1\xe8\x67\xaa\x8d"
          "\x0a\x67\xc5\x9c\xef\xee\xdf\x8f\xe5\x65\x55\x52\xa8\xb0\xd2\xd6\x7f\xc0\x19\x63\xcd\x9b"
          "\xd4\x13\x86\xc1\xbf\x79\xa9\xfd\xbe\x05\x80\xc8\x75\x4b\xd3\xf4\x05\xc4\x0e\x94\xf8\x00"
          "\x48\x6f\xf2\xc9\x25\xeb\xa9\x75\xae\x46\x51\x21\x03\xaa\x15\x0b\x7b\x4f\xe5\x21\xf9\xce"
          "\xfb\x3f\xde\xb1\xcc\xdb\x45\xc0\x47\xfb\x35\x01",
          1, 3840 },
        { 128, 128, 15, "\xae\x10\xaf\xd3\xeb\xa4\x9a\xd7\x47\x7b\x54\x4d\x09\x4f\xd1\xeb",
          "\x65\x8c\x6b\x62\xc1\x9d\x45\x5e\x5e\x95\xbb\x14\xb3\xf7\x0f\x4a",
          "\x56\xd7\xcf\x68\xa5\x31\x3f\x14\x0a\xfc\xd2\x48\xb4\x25\x1e\xac\x6c\x58\x53\x43\x7c\xa5"
          "\x21\x34\x6d\xc8\x71\x80\x36\x0e\x1a\x3d\x40\xab\xac\x8f\xd8\x7a\xfa\xf8\x9d\xa0\xca\x14"
          "\x09\x93\x4a\x3f\xf3\x9b\x58\xe4\x5b\xfd\x02\x06\xe1\x71\x2e\x76\xfd\x81\xb8\x40",
          "\x69\x5b\xab\x96\xd9\xeb\xcc\x29\x8f\x8f\xc7\x8a\x12\x47\xdd\xcc\x6a\x82\xe6\x50\x89\x4b"
          "\x1f\xb9\xf0\xd3\xd4\x04\xb7\x42\x93\x67\x02\x65\x01\x38\x9d\x4f\x1f\xf9\xd7\xaa\x16\x43"
          "\xd1\xbb\xf4\xce\x01\x6e\x74\x56\x41\x81\x76\xc2\x4a\x28\xc3\xdd\xa1\x73\xb5\xc9\x56\x1d"
          "\x64\xf0\xd6\xba\x73\x17\x48\xb8\x36\x01\x9b\xb7\x59\x94",
          1, 512 },
        { 128, 128, 16, "\x30\x4e\x57\x4d\x55\x26\x5d\xb8\x7e\xf2\x31\x09\xfe\x52\xb4\x48",
          "\x24\xcd\xf5\x71\x5c\x50\x75\x18\x4c\xd4\x1f\xd5\xd3\xe1\x14\x14",
          "\xbe\xc2\x85\x27\x7f\x0f\xc9\xfc\x90\x10\x6c\xa1\x93\x2f\xbb\x6e\xee\x86\x77\xd8\xbe\x4c"
          "\xf0\x5d\x4a\xe7\x46\xdb\xd6\xcd\x6b\x22\x66\x14\x95\xd0\x19\x40\x8d\x3d\xf8\x0e\x19\xaa"
          "\x40\xac\x4c\x0f\xdb\x02\xb8\x61\xa2\x42\xf7\xfe\x51\x6e\x49\x56\x1b\x6c\xb2\xfa\x00\xb8"
          "\xad\x11\x41\x24\x70\x68\x00\xc5\x18\x6e\x5a\xda\x49\x1e\xf6\x6a\x58\x83\x14\xf2\x2b\xd3"
          "\xc7\x40\xbe\x14\x45\x49\x28\xac\x41\x61\x48\xcb\xfb\x11\xf2\x29\xb8\x9e\x3a\xaa\x8d\x89"
          "\x95\xa1\x92\xb3\x95\xcd\x37\xde\x30\x6a\xa6\x63\x83\x00\xbe\x51\xca\x91\xa7\x5e\x88\x55"
          "\x59\x3b\x5d\x61\xe7\x01\x1f\x85\x6e\x80\x84\x6c\xc0\xd3\x79\xa0\xc7\x7e\x21\x60\x46\xcb"
          "\x87\x64\x94\x12\x89\xa6\xf7\x9e\xc2\xad\x05\x21\x1b\xd2\x2d\xd3\xef\xfd\x3e\x93\xc7\x62"
          "\xd9\x60\xe6\x5f\x4c\x2c\xa9\x46\xe1\x9b\xcb\xd3\x5c\x2c\x2e\xba\xe9\xdc\xfb\xd3\xd8\x0f"
          "\x05\x65\x61\xe3\x22\x4e\x45\xdc\x87\x27\xad\x11\x91\xdf\x9c\x33\x3e\x32\xd5\xa1\x16\x95"
          "\x32\xc0\x56\xdb\x4e\x04\x10\xc5\x35\x39\xb7\x1d\xb6\x34\x56\xf8\xd3\xc4\xd4\x7e\x30\xcb"
          "\x3b\x46\x43\x2f\xe5\x03\xfb\x42\x80\xb4\xc3\x1f\x50\x23\x30\xa1\xf1\xe4\x8b\xf5\x17\x59"
          "\x1a\xe0\xdb\x02\xcd\x76\x5d\x3f\xc3\x53\xf8\x02\x3c\x8f\xc5\x2f\xe8\xd6\x4e\xd1\x8f\x68"
          "\x2f\x10\x6a\x94\xb2\x7b\xa2\xf1\xf9\xeb\x11\x5d\xb7\xe2\xec\x0f\x0e\xc3\x5d\xb6\x7e\xd9"
          "\xef\xf6\x1c\xc8\x6b\x18\xf7\x41\xb4\xf5\xe4\x5a",
          "\xd5\x6e\x44\x2f\x76\xa3\x5e\xb8\x41\x6a\x3a\xd0\xb9\x4c\x22\x22\x6a\xf3\xa9\x15\x0d\x04"
          "\xba\xf0\xda\x0c\x5d\xcd\x6d\x97\x53\xd3\x65\x27\xcb\xeb\x18\x4f\x8e\xf5\x28\x97\x84\x1d"
          "\xcc\x42\x44\x2b\xe2\x80\x61\x5a\xeb\x09\xe4\x7f\x92\xf1\x3a\x3f\xd5\x66\x67\x22\x8b\xae"
          "\x52\x4b\x98\x04\xd0\x99\x56\x1f\xda\x84\x56\xb9\x81\x47\xa9\xe7\x51\x8e\xc4\x77\x2e\x5e"
          "\x70\xea\x2d\x9d\x59\xf8\xa8\x6e\xa7\x55\x6a\x50\x16\x31\x40\xa5\xd1\xf5\x3f\xc0\xdf\x3d"
          "\xeb\xb7\xc0\xb5\x79\xfb\x32\xa3\x48\x59\xf0\x3f\x09\xf3\xdc\x55\xff\x77\xd8\xa8\x85\x33"
          "\x7a\x9d\xe7\x7e\x34\x08\x91\xec\x23\x71\x63\x0e\xa5\x61\x70\xcb\x64\x6c\x6e\x24\xd2\x78"
          "\xd5\xe5\xd8\x6c\x42\x19\xf7\xb0\xab\x78\x65\x57\x18\xb0\xb2\x00\x31\xb7\xf0\x5b\x02\xc5"
          "\x45\x86\x78\x60\xd5\x36\xe2\xda\xe8\x84\x26\xf6\xce\x98\x9a\x49\x2e\xbe\xb4\x4c\xb1\x4b"
          "\x23\x09\x02\x46\xca\x72\x41\x2b\xce\x76\x48\xd6\xb8\x98\xea\x24\x51\x3b\xe3\x05\xc4\x44"
          "\x99\xaa\xd1\x36\x53\x94\x4a\x20\xfe\xae\x61\xca\xe5\x35\xc7\xe5\xbb\x17\xf2\x93\x56\xc1"
          "\x0a\xd7\x5c\x54\x76\xab\x2f\x30\xf3\x8b\x5a\x1f\xd4\xc4\x1a\x20\xd2\xf0\x56\x17\xdd\x11"
          "\x3d\x6a\x93\xfd\xdb\x1b\xe6\x68\x35\x26\x55\x79\x5b\x91\x75\x53\xe8\xf4\xf0\x07\x44\xd2"
          "\xa8\xba\xdd\xa6\x67\xea\xb6\x79\x90\x93\xea\xb6\x6a\x29\x16\x73\xa3\x19\xd9\x75\x1d\x58"
          "\x57\xae\x69\x9e\x42\x4d\x84\x83\x6e\x66\x5b\x0e\x5b\x2b\x64\x05\x59\x69\xa4\xee\xed\xc2"
          "\xbe\x85\x42\xff\xae\x6f",
          1, 2560 },
        { 128, 128, 17, "\xcc\xe3\xfb\x93\x59\x62\x0a\x01\xd5\xc7\x31\xf3\x9a\xf0\x0e\x4b",
          "\xdf\x0e\x7e\x4c\xb3\xd8\x18\x37\x2d\x7e\xc2\x6e\x0b\x8d\x56\x6a",
          "\x13\xa1\xcb\x11\x53\xe9\xfe\xd8\x4d\x76\x03\xba\x68\x22\x6c\x35\x86\x81\x9f\xae\x58\x4a"
          "\x70\x93\x70\xa9\x21\xe5\x2d\x6b\x1e\x66\x56\x79\xe6\xd7\x95\x7e\x3e\x61\x55\x79\xbd\x18"
          "\xe3\x0e\x4d\x53\xe2\xa2\x43\x26\xb1\xb8\x3f\x81\x2d\xba\x6c\xd1\x40\xcf\x8a\x8d\xfd\x91"
          "\x06\x3d\x64\x13\x4c\x05\xcb\x7b\x42\xc5\xa6\xdb\x87\x7f\x53\x47\x86\x64\xd5\xa4\xe0\x54"
          "\x25\xf5\xff\xa0\x5b\x0a\x58\xa3\xdc\xdc\x13\xf6\xce\x0b\x6d\x89\xd2\x7c\x16\xd3\xb8\xf1"
          "\xdd\x7c\x52\x95\xd2\x78\xf6\xb0\xe4\x59\xce\xf1\xf0\xd5\x23\x1a\xe5\x7b\x53\xa8\x28\xe6"
          "\x69\x5f\x59\x4b\x9e\x95\x7f\x76\x2d\x58\x84\x1a\x3e\x8f\x9a\x6c\x81\x2c\x87\x6f\x8e\xb6"
          "\xbe\xe6\x39\xac\x53\x93\x86\xa2\x72\x01\x46\x7f\x07\xa8\x71\x19\x8f\xac\x66\xeb\xa1\x66"
          "\xc5\x50\x1d\x2c\x5c\x03\x0d\x4d\x9d\x5a\xb5\xc1\x4f\xdc\xde\x5e\xdb\xf9\x00\x33\x4f\x46"
          "\x2a\xfe\x9b\x10\x5b\x60\x40\x9d\x46\x46\x25\x94\x11\xa8\x13\xba\xbc\x5a\x59\xca\x6d\xf3"
          "\x05\xc6\x7a\xc2\xc4\xa6\xf5\xa8\xef\x6f\x98\xfe\x9d\x05\xac\x91\xb3\xc9\x27\x10\x0a\x3c"
          "\x4f\x0c\x40\x88\x99\xdb\x20\x1b\x62\xc1\x1a\xec\x67\x02\xd4\x83\xcd\xad\x1e\xc1\x41\xf6"
          "\x92\x7e\x89\x1e\xb5\x22\xc6\x94\x6a\xfb\xb4\xc6\x23\x75\xe1\x2f\x90\xe0\x03\x9a\x94\xe0"
          "\xb5\xfe\xad\x0c\xcf\xb3\x86\x4c\x8c\xb3\x2f\x9b\x1b\x04\x00\x84\x56\xa9\x26\x4f\x9b\xe0"
          "\xbf\x72\x40\xea\x32\x1e\xe4\xeb\xdf\x65\x9e\xdb\xda\xac\x4f\x28\x58\x9d\x6b\x44\x67\xb6"
          "\x12\x31\x67\x71\xda\x9e\x76\xca\x33\x4e\x0f\x94\x1f\xac\xa0\x72\x66\xe1\xdc\xa2\xd5\x83"
          "\xa9\xaf\x84\x62\xcb\x1d\x56\x55\x77\x63\xfe\x10\x2d\xc5\x97\xe2\x63\x45\x49\x6d\x23\xef"
          "\xac\x22\x90\x5e\x50\x1f\x68\x38\x6d\xc1\x3b\x29\x1a\xde\xab\x5d\x86\x11\x32\x62\x25\x4a"
          "\x4e\xa6\xcb\xdc\x31\x3d\x8a\x55\xf3\x3b\xf3\xb8\xb3\x8d\xc9\x48\x54\xb1\x06\x12\x5e\x17"
          "\xb8\x10\x8a\xce\x28\x51\x5e\x89\x16\x00\x8c\xd7\xe9\x52\x61\x44\x7b\x5b\xe4\x7e\xbf\xba"
          "\x89\xd1\x19\xc8\xc8\xcc\x05\x60",
          "\x12\x28\x51\x19\xc5\x98\xb1\xb8\xf3\x97\xac\x26\x66\x88\xac\xee\xb9\xf5\xdb\xf6\x8c\x4d"
          "\xcf\x59\x7a\x0c\xa2\xd5\x83\xc0\x9e\xe4\x8c\x0f\x6f\xdd\x58\x67\x0e\x0b\xc8\x8f\x3a\x62"
          "\x5e\xd6\x7f\xe5\xa4\x84\xf5\x5b\x78\x60\xa4\x3c\x23\x05\x63\x90\x4d\xd6\x92\x66\x82\xac"
          "\x80\x60\x46\x5d\x43\x6c\xca\x23\x43\x45\xfd\xb0\x94\xbd\x3c\x00\x3b\x37\x09\x29\xd3\x22"
          "\x1e\x36\x0a\x08\x52\x08\xbf\xe7\x29\xe1\xf6\x84\x64\xdd\xa3\x45\x0a\x9d\x72\xa4\x71\xd3"
          "\x8c\x17\x77\x1f\xb5\xff\xfc\x72\xb2\x10\x98\xc8\xd1\x4c\x9b\x30\xdb\x13\x48\xad\x69\x5d"
          "\x15\x6b\x92\x83\x1a\x9e\xa2\x28\x88\xa0\x50\xcc\xaf\xf7\x85\xed\xad\x2c\x55\x11\xcf\x65"
          "\x77\x3c\x9e\x15\xe8\x38\x6e\x1a\xfe\xcd\x42\x6c\xcd\x42\xc7\x29\x81\xca\xe7\xf4\xb7\x8e"
          "\x15\x3e\xa8\xea\xff\xa8\x21\xb5\x85\xfd\xe8\xa7\x93\xb3\xca\x6c\xf7\x6b\x4e\x95\xa5\x06"
          "\x98\xbd\xa1\x37\x2e\xca\xc6\x00\xc4\x99\xdd\x4a\xd4\x10\x6e\x6d\xc0\xdc\x6d\x4c\x33\x00"
          "\x94\x58\xb3\x14\xd4\x28\x20\xc1\x43\x79\x25\xfc\x6b\x5c\xcd\x0d\xc7\x48\xdd\xc6\xd2\x8b"
          "\xde\x32\x11\x60\xef\xe7\x68\x92\x64\x2b\x1d\x7c\x3d\xba\x35\x65\xa6\xc8\xfe\x7e\x42\x7c"
          "\x1d\x2d\xbd\x8d\x17\x03\x96\xf6\x00\x60\xa6\x7b\xbf\x9a\x2c\x7d\xb8\x35\xf6\x25\x47\x64"
          "\x28\xa8\xe8\x14\x41\x27\xb7\x88\x3c\x46\x15\x3b\xf3\xcc\xe9\xa2\x17\x64\xb6\xc6\x93\x12"
          "\xbc\xf5\x9a\x55\xac\x34\xd8\xae\x23\xd1\x7c\x81\xe2\xe9\x0f\x3d\x28\x98\xba\x79\x44\x7e"
          "\x63\x57\x0d\xb8\xf0\xc1\xfb\x73\x1c\xd6\x93\xe1\x5e\x01\x75\xec\xac\xa4\x3a\xf2\x53\x7e"
          "\x42\x7b\x4b\x5e\xf7\x97\x60\x36\x5f\x2a\xdb\x25\x31\x71\xa0\xc8\x81\xb6\x1d\x2f\x80\x73"
          "\xfc\xe9\x06\x3b\xf2\x83\xcd\xbe\x84\xe8\xc7\x6d\x6f\x94\x42\x6b\x0c\x41\x52\x1c\x19\x09"
          "\xd2\x95\x0a\xa9\xee\x5f\xf5\x0b\x33\x69\x1c\xa8\x83\xae\x80\x28\xdb\x7a\xdf\x09\x93\x50"
          "\xc8\x62\x37\x8e\x7d\x3a\x65\x6b\x18\x49\xb3\x8e\xc0\x4b\x5f\xc8\x4e\xca\xcc\xe2\xce\x1c"
          "\xde\x82\xd7\xf7\x08\xf0\x6a\x4a\x97\x8e\xb9\x21\x71\xd1\x85\xd3\xf5\xa8\x48\x3f\x09\x3e"
          "\x75\xd2",
          1, 3584 },
        { 128, 128, 18, "\xf2\xb0\xfb\x0c\xa1\xbc\x6f\x96\x34\x67\xb8\x80\x22\x46\xb5\xdc",
          "\x0c\xb1\x36\xc7\xd7\xa2\xff\x75\xbb\x78\x7d\x75\x3c\x27\x48\x53",
          "\xa6\x95\x7d\x52\x1a\x4a\x98\x38\x53\x95\x3d\x2d\x2a\xf8\x11\x81\x77\x0c\x10\xb3\xa9\x04"
          "\x59\x14\xb1\xca\xf4\x99\xde\x10\x14\x58\x61\x11\xc7\xa0\xb8\xe2\x15\x5b\x09\x99\x4b\x06"
          "\x53\xd7\x25\xc5\x34\x55\x28\xff\xc7\xb9\x6e\x59\xe3\x3a\xe0\x04\x0e\x9e\xf3\x31\xa3\xeb"
          "\xd1\xd2\x7a\xc6\xe5\x4f\x72\x00\xb0\xc4\xaf\xea\xcf\x93\x04\x81\xfd\x28\x48\x73\xd7\x7b"
          "\x3a\x14\x07\x75\x44\x5f\x5b\xdd\x6f\xb3\xf4\x81\xf1\xe0\x2a\xfc\x08\x96\x2f\x23\x95\x34"
          "\x37\x25\x40\xd7\x1e\xae\xe8\x06\xd0\x2f\x10\x96\xf4\xd1\x33\xa3\x78\xcb\x18\x3c\x1b\x32"
          "\x8b\xfe\x36\x16\x28\x44\x30\x8f\xab\x93\x63\x5f\xd3\x6e\x32\x23\x0f\x07\x4e\xba\x7c\xf1"
          "\x74\xfc\x16\x43\x76\x80\xdf\x80\xa6\x91\xb6\x1c\x3b\x33\xb9\x85\xb5\x72\x8b\x30\x73\x1a"
          "\xdc\x39\xd1\x86\xac\xba\x0a\xdc\x9b\x00\x81\x05\xe5\x88\x7f\xaa\xd1\x04\x45\x1f\x8c\x79"
          "\xb6\xbb\xcc\x72\x52\xa0\x50\x7b\x1c\xd5\x42\x16\x89\x68\x9d\xef\xbf\x4b\x4d\x20\x29\x69"
          "\xda\x63\xdd\x71\xee\x9e\x9d\x8c\x05\x1a\x7b\xce\x60\xd0\x62\xf4\x5d\x43\xcb\x2e\xe0\xc5"
          "\x91\x06\xfe\x6d\x41\x3e\xa5\x0a\xc3\x29\x8d\xce\xe3\xf5\xa0\xdf\x5b\xaf\xee\xea\x3c\x34"
          "\x3e\x86\xf5\x2b\x55\x9d\x09\x76\x68\x6f\x0f\x86\xd5\xd1\x85\x32\xbc\x3d\x3d\x7c\x87\x7c"
          "\xcf\x66\xf5\x98\x94\x33\x0b\xc9\x6b\x84\x81\xef\x0d\x35\x55\x8f\xb7\x8f\xc0\x6c\x07\x6e"
          "\x93\xae\xee\xd7\xc9\x9d\x68\x47\x76\x37\xaa\x63\x86\x1f\x26\xac\x6e\xc1\x00\x57\x0e\x17"
          "\x80\x25\x23\x2a\x74\x95\x39\xc9\x3b\x34\x84\x88\xee\xa5\xf0\xa9\x8e\x0e\xde\x63\x1b\x5c"
          "\xac\x25\x6d\x33\xd8\xa1\xea\x41\xb5\xcd\x49\x7b\x0a\xc4\x5a\xfe\x91\x1a\x89\x22\xa7\x62"
          "\xa5\xf7\x42\x42\x0b\x1c\x66\x09\x66\xbc\xc2\x77\x43\x25\x48\x84\x4d\x9d\x87\x32\x9c\xc0"
          "\x75\x7c\xcc\x24\x08\x3e\x7f\x2e\xe3\x46\xe1\x5c\x1b\x5e\x2e\x1d\x9d\x74\xe9\xfe\x50\x98"
          "\x8d\x1c\x55\xc1\x3b\x3e\x17\xaf\xf0\xb5\x0e\xe0\x5c\x9a\x8b\x53\x85\x86\x13\x1c\xf8\xaf"
          "\x2d\xc2\x8f\x26\x42\x63\x7a\x61\x07\x40\x02\x97\xf4\xdb\x36\x3b\x68\x8f\x80\x63\x45\x7e"
          "\xe3\x25",
          "\x88\x31\x75\x8a\x23\xc3\xfd\x15\x99\xab\xcc\x8f\xc4\x94\x3b\x91\x9f\x31\xab\x8b\x19\x48"
          "\xcb\xa2\xf3\x34\x5f\x70\x00\xe9\x7f\xe4\x0d\x1f\xae\xf8\xe3\xf2\x0f\x20\xc8\x0c\x2c\x30"
          "\x59\x8c\xa8\xa9\xbf\x5d\x12\xa3\x31\xad\x34\x8f\x0e\xbb\x4c\xe7\x2a\xf9\xa9\xbb\x2c\x96"
          "\x39\x6d\x49\xfb\x10\x5a\xb8\x65\xfc\xe5\x67\x56\x05\x00\x1b\x33\x26\xff\xee\xaa\x63\x2c"
          "\xc5\x57\x3f\x55\x7b\x09\x86\xe3\x72\x17\xaa\x2f\x53\x74\x50\x64\xd6\xe3\xf1\x4f\x3a\xce"
          "\xef\x07\xed\xf6\x81\x60\xdd\xf3\x7f\x7b\x5d\xeb\x66\x52\x5d\x9f\x67\x34\xbf\xc8\x4d\xa7"
          "\xe8\xdc\xf7\x5d\x9d\x65\xd2\x7d\x78\x5a\xd8\x06\x9c\xa6\x2b\x6e\xb0\x27\x57\x89\xb5\x1c"
          "\x57\x03\x96\x68\x33\x1c\xb4\x8d\x00\x03\xc4\x2d\xd3\x89\x89\x3c\xf5\x3c\x89\xb3\x4d\x60"
          "\x08\xd7\xa5\xf7\xee\xe1\xb1\x66\xd9\xbf\x2a\x0c\xbb\x1e\x2a\x30\x98\xeb\x6d\x94\xca\xfd"
          "\x5c\x04\xd3\x91\x22\x84\x5e\xf8\x65\x52\x9f\xa5\xbf\x4c\x40\xcb\xda\x74\xd9\xf1\x84\x7f"
          "\xa2\xbc\x68\xe5\x63\xc7\xc7\xfa\x07\x3d\xa5\x76\xa8\x37\x6b\x48\xf5\x48\xc1\x4a\xe7\x85"
          "\x0a\x6c\x3f\x52\x72\x9f\x3c\x42\x9f\x7d\xad\x96\x93\x03\x02\x3d\x24\xcc\x83\x03\x0a\x61"
          "\x57\xd4\xcb\x02\x56\x2b\x6c\x3d\xc3\xd0\x56\xb9\xf1\xff\x44\xf1\x09\xc2\x2b\x4f\x24\xee"
          "\x5f\x28\x9c\x77\xd7\x50\x24\xdf\xd2\xb1\x56\xf9\x99\xc1\xf3\x5f\xf2\x14\x5a\xae\xea\xaa"
          "\xe5\xc0\xe4\x07\xf7\xf2\xa1\x0e\x69\xed\x1c\x23\x1f\x3c\xf7\x1b\x58\xef\xdd\x70\xca\x71"
          "\xb4\x26\x3e\x48\x79\x1e\x5f\x99\x8c\x0d\x8c\x89\x6f\x48\x08\x85\x35\x10\xec\x2d\x28\x51"
          "\xb2\xf3\xdf\x2d\x13\xdf\x76\xa4\x0e\x44\xb7\x60\x2b\x1d\xc9\x36\x60\x1b\xb5\xa2\x06\x99"
          "\x85\x57\x20\x19\xed\xea\xc5\x98\x5e\x03\x1e\x1a\xaf\x8e\xb7\xb7\x8e\x88\x87\xcd\xf7\x34"
          "\x68\x7f\x3e\xf6\x28\x97\x8a\xfd\x80\x75\x01\x0b\xea\xb3\x80\x82\x39\x52\x54\x72\x8a\x6f"
          "\x26\x73\x11\xb5\xd2\x04\x82\xa8\x2c\x11\x33\x6b\x89\xb8\x01\xb0\xbf\xf5\x74\x07\x39\x05"
          "\xfa\xc6\x2e\x95\x11\x18\x18\x0c\xfc\x05\x21\xec\xa1\x60\x46\xf8\x6d\xf1\x31\x49\x75\x26"
          "\xb0\x37\xef\x39\x5e\xa8\x3f\xaf\xf0\xa6\x49\x0f\xa0\xc1\xfa\xa2\x53\xbc",
          1, 3712 },
        { 128, 128, 19, "\xeb\x8b\x7d\x20\xf9\xa4\x3f\x58\x9e\xde\xd2\xf1\xc2\x92\x56\xd1",
          "\xf0\x51\x82\x2f\x4d\x94\xe2\xad\x23\x25\x96\x45\xd3\xbe\x4a\x0f",
          "\xe3\x6a\x67\x5c\xdc\x16\xb4\xc9\x91\x37\xd9\xb2\xa4\xab\xce\x29\xc1\x80\xf3\x99\x61\x4f"
          "\xee\x43\x0b\xf5\xe4\x4c\x4c\xe3\x7a\x7f\x56\x9e\x67\xb0\xfe\x0b\x37\x08\xe3\x14\x2f\x59"
          "\x86\xb9\xd6\x75\x56\x44\xe0\x23\x79\x5e\xcc\x9a\x66\x6b\x30\xcf\xd7\x8f\xd4\x1e\x6a\x73"
          "\x91\x09\xcf\x25\x0b\x4a\x3e\x01\x3b\x2f\x50\xd9\xfe\x34\x13\xc8\xed\x82\x84\x85\x27\x19"
          "\x5f\xef\xe0\x8a\x7e\x63\x12\x44\x7a\x35\xa1\xec\xee\x40\x46\xc7\x1b\x0e\x56\x4d\x10\x55"
          "\x18\x10\x8d\x25\x19\xd0\xb9\x2c\x32\x39\xb1\x46\x25\xe8\x04\xef\x88\x31\xd3\x8f\x1e\xaa"
          "\x51\xc2\x3d\x20\x71\x55\x45\xd5\xa0\xcc\x88\xc4\xd6\xba\xc6\x66\xc3\x95\x77\x4d\xff\xad"
          "\xdf\xcd\x4c\x53\x7c\x8b\x85\x99\xa3\xf4\xe9\x5a\x00\x4e\x29\x41\x0b\x5a\x93\x85\xd0\xa0"
          "\x7b\x2f\xf5\x7f\xb2\x9e\x77\xb3\x43\x7e\xa0\xe1\xb8\x74\xe4\x38\x16\x7d\x19\x68\x13\x7a"
          "\x5e\x19\x10\xee\xa1\xcb\x39\x5f\xca\xa8\x66\x50\x5d\x65\x64\x7e\xf3\x5c\x98\xde\x10\xc7"
          "\x7a\x42\xf6\xeb\x96\x78\x0e\x42\xf0\x5f\x76\x3f\x04\x55\x21\xb3\x26\xf6\x63\x70\x72\xf2"
          "\x49\x2f\x82\x5c\x81\xfc\x96\x6f\x8c\x1e\x21\x8b\xe1\x1d\x60\xb4\x2f\x9b\xcc\x27\xfe\xd7"
          "\x1f\x9f\x4b\x66\x9e\x76\x26\x03\xbc\x5f\x35\x2b\x53\xcf\x09\x83\xe8\x18\x2b\x65\x10\xe8"
          "\xc4\x3c",
          "\x56\xc5\xd5\x2e\x6a\xbe\x53\x6f\xe7\xa4\x8b\x07\xaa\xf3\x50\x83\xd6\x7a\xaa\x11\xec\x4f"
          "\x92\xda\x0c\x9f\xb9\x08\xb7\xcf\xf4\x27\x17\xf8\x4b\x14\x31\x6c\x71\x0b\x56\x4c\xbf\x60"
          "\x12\x3e\x76\x95\xc0\x2f\x63\xf4\xd2\x2e\x1e\x9e\xfb\x75\x8b\xb2\x14\x68\xfb\xa6\xbf\x0e"
          "\xf5\xad\xae\x5f\xff\xe5\x7b\x18\x0e\x0c\x17\xa1\xd8\xf7\xf6\xd1\xcf\x6d\xa3\xac\x03\x5e"
          "\x5c\xd3\x33\xa1\xf9\x09\x2f\xf5\x8b\xe2\xb6\x66\x37\x76\x2e\x13\xc2\x2a\xb0\xc2\xf2\x81"
          "\xed\x0c\x8b\x2d\x1a\x32\x52\x61\x94\xf3\xcb\xaa\x74\x03\xda\x45\xe2\x49\xae\x97\xb6\xf1"
          "\x8c\x5c\x8a\xf6\x1c\x66\xdb\xa9\xb7\xf0\x3b\xeb\x46\x33\x2f\x9d\x30\xf5\x49\xd6\xa1\x28"
          "\xae\xc5\x4a\xc3\xf4\x19\xbf\x1c\xac\x68\x4b\xb5\x34\x70\x70\x44\x63\x98\x7f\x31\x9b\xf9"
          "\x70\xc9\x88\x90\x05\xf2\x5a\x98\x96\xbe\xeb\x87\xd1\x8b\x1d\x2b\x19\x0e\xc9\x29\x89\xb7"
          "\xd2\x65\x3e\x81\xe2\x6e\xb1\x61\xc8\x3f\x5d\xdd\x65\x13\x83\xdf\x09\x54\x7e\xd4\xd6\xd6"
          "\xb7\xda\x79\xb0\x68\x29\x5a\x7c\x60\x7d\x93\x52\x1a\xe1\x9d\x9e\x95\xb7\xa4\x42\x24\x31"
          "\x52\x3b\xee\x09\x02\x51\x4b\xa0\xab\x70\x9a\x79\x7e\x14\xbc\xbf\x9d\x6c\xb5\xcf\x67\x1e"
          "\x85\x28\xc8\x3f\x6a\xac\xb0\x51\x35\xf9\x66\x4f\x4a\xc7\x8e\xcb\x53\x62\x10\x46\x87\xe4"
          "\xe3\x3c\xa2\x8c\xad\x30\xb6\x90\xe8\x3b\x19\x19\x1a\xcd\x6a\x8c\x1b\x7e",
          1, 2304 },
        { 128, 128, 20, "\x1e\x69\xfd\x14\xca\x7f\x1b\xad\x99\x14\xac\x42\xf0\xb3\x27\x82",
          "\x28\xda\xa5\x2b\xab\x92\xb4\xd3\x04\xc2\xa9\x6f\x89\x88\xf8\xd7",
          "\x95\xc5\xbf\x47\x39\x9c\xfc\x40\xaa\xa0\xcb\x4e\xd5\xec\x9b\x52\xe2\xbc\xd0\xfe\x55\x91"
          "\x66\x3a\x36\xd0\xb6\x69\xf3\x3d\x1e\xa4\x56\x16\x8d\x93\x0a\x33\x5f\xb0\xf3\xe5\x02\xb7"
          "\x1a\x1b\x30\xd5\x9d\xec\xb0\xdd\xe9\xc6\xb4\x57\x6b\x35\x56\x1b\x3a\x30\xf0\x92\xa6\x96"
          "\x33\x4d\xdc\xa5\xfe\xca\xad\xcc\xe7\x5a\xcc\x00\xb7\x35\x41\xc0\x63\x34\x75\xaa\x6f\x5c"
          "\x6a\xaf\x82\x6d\x81\xa3\x41\x7d\x86\xb1\x5c\x6b\x77\x8b\xe9\x30\xcf\x05\xd5\xe1\x44\x6e"
          "\xee\x09\x78\x22\xb3\x44\xda\xdd\x0e\x86\xdb\x5f\x35\x3e\xbf\x2f\x63\x77\xfa\x45\xe9\x15"
          "\x1e\x2d\x02\x43\x3d\xa2\x4a\x8c\x88\x14\xd4\xa0\xb9\xdb\xbb\x0e\x93\xfb\xa1\x4d\xde\xd1"
          "\xbe\x3c\xac\x9b\xc8\x10\xe5\xe6\x5d\x2a\x1d\xd5\xfa\x37\x20\xcb\x88\x9c\x9e\x4a\x81\x1b"
          "\x38\x0d\x1a\xeb\x16\x66\x57\xdf\xe9\xa0\xbb\x0e\x30\x28\x63\x43",
          "\x10\xad\x71\xf5\x54\x9f\xcd\x67\x3d\x23\x0f\xc5\xc2\x60\x69\x52\x04\x3a\x3e\x59\x8b\x6b"
          "\x40\x8b\x64\x79\x0f\xec\x4a\x3d\x62\xe7\x48\x59\x02\x8a\x28\xd1\xad\xe2\x1d\x5f\x03\xcd"
          "\x4f\x4d\x57\x86\x4f\x2c\x4e\x2a\x0e\x35\x7c\xab\x02\x27\x4b\x38\x89\x1d\xf0\xe5\xfd\x92"
          "\xc8\xd4\x0f\x09\xef\x1e\x29\xd8\x50\x0b\x3f\x5e\xde\xaf\x07\x45\x25\x3a\x3a\x6c\x5b\x4a"
          "\xc7\x69\x9d\x66\x33\xe5\xd2\x07\xb0\x04\xdd\xc4\xcd\x54\x4a\xaf\xd8\x0f\x55\x59\x38\x6f"
          "\xaf\xba\x16\x27\xe7\xbb\xa2\x2d\xc1\x31\xbf\x16\xa3\x66\x8d\x39\x3f\xf1\xb5\xf3\x00\xfb"
          "\x65\xc8\x71\xb1\x20\x2f\x21\x27\x87\xdf\xde\x77\x52\x02\x45\x9a\xf6\x9a\x5b\xc3\xe0\xcc"
          "\x66\x72\xeb\xaf\xfc\xd3\xa0\x42\x8c\xf0\x35\xf8\xa6\x74\xf5\x9c\x5d\x03\x84\xeb\x1d\xc1"
          "\x9d\xa2\x7d\x15\x4b\x13\x93\xf9\xff\x1f\xc7\xb1\x6a\x36\x97\x8f\x90\xb8\x81\x2c\xf0\x53"
          "\x5f\xf4\x08\xe6\xe3\xbd\x17\x22\x49\x6e",
          1, 1536 },
        { 128, 128, 21, "\x66\x6b\xba\xcb\xcb\xe2\x6e\x2c\xdf\x2b\x42\x73\x00\x5e\x51\x32",
          "\x6b\x26\x34\xfc\x87\xbd\xf7\x65\xe8\x2d\xf0\x67\x2d\xf3\x67\x60",
          "\x50\x03\x5e\x36\xeb\xe4\xca\xc4\x0c\x72\x8b\x91\x50\xec\xc1\x1c\x00\xb0\xf4\xf1\xed\x2c"
          "\xa0\x26\xe6\xb5\x28\xdc\x96\x83\x47\x0b\x44\x12\xb5\xc6\xdb\xd6\x41\x90\x4e\xec\xa3\xcc"
          "\xb7\x48\x4c\x5f\x8c\x17\x3b\x17\xb4\x4d\xfa\xce\x7c\xdf\xc4\x2a\x29\xd8\x00\xf5\x0c\x36"
          "\xea\xc2\x5f\x66\xde\xa7\x48\x73\x15\x90\x97\x11\xb7\x02\xaa\x69\xf8\x75\x56\x53\x21\xd2"
          "\xce\x3f\x15\xec\xb5\x90\xd1\x82\x7c\x10\x11\x7e\x6f\x43\x3c\x7e\x4e\x07\x6f\xe6\x9f\x45"
          "\x4c\x53\x31\x44\xb8\x1c\x14\xc6\x17\x0b\x48\xa6\x56\x53\x53\xbe\xfa\xaf\x98\xb8\x94\x94"
          "\x66\x6c\x6b\x37\x33\x61\x84\xdb\x1b\x8d\xdc\x27\xea\xc9\xfc\xb0\x91\x6d\x5a\x56\x5a\x7c"
          "\xee\xbb\x07\x50\xaf\xcb\xa5\xcb\x90\xeb\xaf\xe8\x9e\x8a\x7e\x82\xae\x5a\x0b\x55\x38\x00"
          "\xd7\xe4\xd5\x11\x07\x79\x66\x07\x7a\xab\xc7\xfd\x5c\x09\x4c\xee\xd3\x81\xd6\x9c\xd8\x18"
          "\x08\xd6\xe4\xe8\xe5\xb1\x41\x6f\x89\xa0\x2e\x86\x63\x57\xe5\x54\x43\x2e\xb7\x38\x5c\x8f"
          "\x5e\xe5\x06\xf6\x27\x45\x63\xaf\x52\x1b\x11\x64\xef\xea\xa5\x52\x5d\xd8\x4e\x4e\xad\x52"
          "\x25\xfa\x06\xda\x5e\x15\xee\x02\x23\x69\xd5\x85\x51\xff\x98\x48\xd3\x33\xc0\x3a\xaf\xff"
          "\x18\xf6\xb5\xd2\x06\x89\x2a\xb6\x60\xb0\x11\xf1\x4a\x25\x7c\xc8\x8e\xb1\x11\x77\x7f\xd5"
          "\xb0\xc4\x78\xba\xf8\x74\x52\x2c\xba\x34\x83\xd6\x9c\x0d\x6a\xa6\x35\x70\x0e\x02\x5a\x5d"
          "\x39\x96\x32\x6a\x9a\x2d\x85\xd4\xce\xca\xe9\x26\x54\xe0\xd8\x9b\x90\x50\x27\xa7\x77\x9f"
          "\xcf\x6f\x32\xac\x11\xda\xd0\x1a\x6b\xb4\x05\x12\x6a\x31\x41\x00\x37\xb7\xcd\xde\x4f\x7b"
          "\xb7\xda\x2b\x11\xeb\xaf\xf6\xef\xc8\x80\x31\x87\xdc\x50\xfd\xb8\xec\x91\x32\xa8\x5b\x57"
          "\xb9\x32\x4d\x1f\xc4\xc2\xde\x81\xf0\x3b\x75\xca\x61\x02\x51\xdb\xd7\xba\xed\x67\x71\x50"
          "\xd3\x13\xf3\xcb\xd8\xc4\xc5\x0b\x17\x07\x45\x44\xd1\x3a\x99\x5a\x5e\x43\x78\x59",
          "\x3d\xc8\xcf\xf6\x56\x7b\x3d\x8a\x5f\x9a\x8b\x7a\x36\xeb\xcb\x93\x1e\x6c\xd9\xd0\xb3\x6a"
          "\x35\x45\xe4\x05\x98\x3b\x30\x6a\xd6\x1d\xe9\xca\x11\x57\x17\x50\x48\x45\x3c\x09\x71\x58"
          "\x44\x0e\xfb\x24\x4b\xae\xb2\x05\xa0\x2f\x73\xae\x40\x1a\x7a\x6d\x61\x73\x5a\xe6\xc8\xa3"
          "\x5a\xd6\x53\x4d\x2c\x23\xd6\x23\x9b\x36\x0a\xe4\x56\x5b\xf7\x1e\x7a\xd4\x34\xa5\x2b\xc6"
          "\x3c\x35\x39\xe9\x72\xa1\x95\xd4\x92\xff\x7f\x50\x8a\x33\x74\x8f\xef\xbf\xb2\x59\x9d\x65"
          "\x89\xf1\x46\x1c\xf9\xc6\x00\xc3\x1b\xf0\x92\xf9\xd6\x5b\x36\x02\x08\x68\x9a\xc8\x43\x4c"
          "\xa6\xee\xd1\x13\x9b\x57\x9c\xbe\x1c\x19\x01\xac\x83\x58\x90\x0f\x4e\x72\xca\x9e\x7f\xfc"
          "\x19\x3c\xcb\x53\x13\x2f\xd9\x06\x3c\x8f\x02\xb3\x16\x56\x30\xe1\x1a\x83\x91\x9f\xb2\x23"
          "\xbd\x65\xbc\x46\xa6\x14\xaa\xae\x7f\xf5\x9f\x3d\xba\x09\x54\x88\xae\x00\x7f\xf7\x36\x5b"
          "\x4d\x86\x77\x32\x11\xb8\x29\x3f\xed\x60\xcb\xa8\xf6\x74\x03\x6c\x66\xd3\x2a\x13\x91\x98"
          "\x26\x04\x32\x61\xb6\xbe\x46\x01\x2a\x85\x77\x76\xc5\x0d\xca\x95\x6d\x27\x55\x8c\xa0\xe7"
          "\x6c\x31\x03\xcb\x8e\x06\xe9\x3f\xf1\xdf\x0f\xcc\x23\x79\xd0\x96\xdd\xa5\x98\x0a\xb4\x5a"
          "\xd2\x9d\xc7\x79\x51\x03\x74\x28\x27\x22\xdd\x9b\x25\xdc\xbe\x20\x3c\x74\x47\x0b\xb7\x79"
          "\x4c\x2d\xbc\x37\x47\x9c\xa6\xbd\xeb\x87\x6d\x65\xf2\xe9\x4a\xf8\xdf\x18\xf3\x0d\xfe\x23"
          "\x82\x21\x32\x8f\x29\x7f\x22\x43\x99\x2e\x88\x85\x5e\x83\x49\x05\x00\x6e\xd8\xf5\x94\x75"
          "\x59\x34\x30\x58\xae\x21\x35\x55\xab\x02\x2e\x98\xa4\x8a\xe6\x92\xe4\x7d\x8b\xba\xeb\x94"
          "\xab\x0d\x55\x8a\xf5\x05\xae\xd6\x70\x12\x54\xe5\xa6\xeb\x38\xa0\xe2\xbf\x10\x2c\xcb\x61"
          "\x6c\x9b\x58\xe0\x3e\x53\xe2\x76\xd4\x4c\xc7\x0d\x12\x4c\xf0\x2f\xf9\x07\x97\x82\xe7\x20"
          "\x0a\x09\xd5\xe1\x0b\xdb\xc8\xf7\xbe\x78\x06\x28\xd3\xe4\x27\x3c\x17\x94\x45\x19\xdb\x7d"
          "\x5a\x73\x4f\xea\x10\x8e\x29\xe4\xf2\x20\x99\x8e\x0d\x51",
          1, 3328 },
        { 128, 128, 22, "\x57\x08\x26\xef\x18\x8e\x84\x50\x5f\x30\x24\x7e\x3f\x43\x85\xae",
          "\x60\xf6\x70\x1b\x64\x23\x9e\x82\xf6\x3c\x4e\xc9\x20\xb6\xce\xe4",
          "\x94\xd4\x02\x1b\xec\x59\xc2\xbb\xf6\x26\x0f\xa9\xab\x83\x79\x55\x1b\x8b\x1a\x41\x4f\xf1"
          "\xac\x22\x85\xde\xc8\xda\x41\x7d\xa3\x65\x3b\x51\x36\xda\x9c\xff\x1a\xd2\x93\xcf\x88\x75"
          "\xaf\x1c\x90\x9a\xf9\xe9\x95\x00\xc1\xc9\x0f\xa3\x47\xfc\x41\x61\x03\xa2\x02\x35\x76\xf6"
          "\x3b\x3f\xf2\x5f\xa0\x2b\xf8\x72\x8a\xe1\x29\xf5\xd9\x10\xa7\xad\xf6\x13\x64\xac\xe3\x17"
          "\x51\xb7\x93\xfc\x4d\x0b\x87\xad\x43\xf3\xa3\x24\xa5\xca\x16\x24\xfa\x11\xfb\xdb\x94\x54"
          "\xda\xf6\x0b\x73\x32\xe3\x0f\x83\xff\xed\x1e\x3b\xe9\x01\x4c\xca\x4d\x31\x89\x2a\xdf\xd2"
          "\x47\xaf\x95\x0f\xb2\x6f\xdd\x9b\xc3\xda\x29\x08\x8b\x49\xcf\x53\xc4\xd6\x24\x94\x2d\xfc"
          "\xf9\xf5\xf1\x92\x35\x48",
          "\x64\xf1\xda\x6b\x99\x7a\x1f\xba\x0d\x84\x64\xf2\x26\x26\x00\x7b\xd0\x93\xe8\x03\xd5\xad"
          "\xc3\xa8\xff\x0a\x28\x47\xbd\xbd\x0f\x21\x2f\xda\xb7\x2a\x50\x75\x69\x13\x17\xc1\xbc\xda"
          "\xc1\x4d\x40\x3b\x30\x25\x67\x48\xe3\xab\x4f\x46\x44\x37\x2f\x14\xaf\x08\xe9\x66\xce\x3b"
          "\xdc\x7b\xf3\xf9\xac\x2a\xaa\x1c\xf0\x31\x70\x89\x7b\x25\x9b\xdd\xd2\x5d\x24\x83\x82\x0d"
          "\x48\x66\xef\x82\xc9\x23\x75\x8e\xaf\x76\xec\x7d\x7b\xcd\xab\xfe\xf3\x64\x89\xf3\x23\xcf"
          "\xa5\x89\x05\x3c\x87\x9e\x01\x4e\x48\xb5\x74\xcc\xa6\xf9\x41\x24\x36\x50\x8c\x57\x69\x71"
          "\xbb\xdb\x6f\x9c\x8f\xb9\xd5\xa7\xdf\xac\x01\x51\x66\xda\x3b\x25\x62\x03\xd3\xc2\xec\x8c"
          "\x15\x2e\x2f\x0b\x20\xbc\xb2\x44\xfc\x1c\x69\x23\xfb\x2f\xbe\x55\xf1\x08\x0f\xfe\xa7"
          "\xef",
          1, 1280 },
        { 128, 128, 23, "\xc6\x17\xae\x85\xa7\x7a\xc3\xf0\xdc\x29\xca\x6f\xcb\x82\x31\x26",
          "\x59\x20\x3e\x5e\x7f\x7a\xa8\x24\x4d\x27\xbc\x5c\x13\x4a\xbe\xbb",
          "\xc7\x56\x86\xf2\x2f\x10\xbd\xa9\x65\x65\x14\xd5\x9b\x81\xd1\x9b\xe7\x71\x93\x97\x15\x17"
          "\x62\x2b\x92\xf1\x19\x67\x78\x98\x93\xd5\xaa\xd9\x01\x83\x2c\xa9\x33\x9a\x0f\x18\xab\x92"
          "\x89\x37\x51\x69\xf3\x0e\x97\xd7\x92\xc1\x74\x49\xd3\x80\x4e\x74\x5f\x76\x5b\x7c\x0c\xe4"
          "\x0a\x2c\x84\x51\x13\x80\x76\xc5\x3d\x21\xaf\x7e\x7c\x6c\xac\x53\xd8\xa6\xb9\xdf\xcc\x27"
          "\x1a\x50\xf6\x3a\x11\x2b\xc1\x0f\xb9\xcc\xd7\x51\x23\x1a\x9f\xbf\x58\xfc\xda\x8f\xb9\x25"
          "\x2b\xb5\xa4\x1e\xdc\x76\x0d\x57\x8a\x81\x43\x63\x8a\xd3\xac\x02\xe9\xe9\x62\x09\xa8\x13"
          "\x0d\x48\xce\xa0\x6e\x69\x51\xcb\xd1\x4a\x14\xc9",
          "\x65\x80\xda\x16\xb2\x84\x42\x2e\xdf\x75\x10\xe8\x14\x16\xf5\x36\x23\xf8\x90\x97\x04\xd5"
          "\x4b\xee\x26\x5a\x38\xfa\x59\xe4\xed\xbb\xf2\x6c\xb2\xbb\x0d\x10\x8e\x88\x1e\xd1\xfa\xcc"
          "\xc8\xe2\x3c\xb4\x9c\xf7\x71\x35\x26\x37\xc1\x55\xf6\x24\x46\x1a\x7e\x0d\x82\xc9\x39\x7c"
          "\x1b\xf7\x15\x3a\x9f\x9e\xe8\x2d\x54\xe2\xf0\xd4\xaf\x01\xce\xb0\xef\x40\x98\x0c\x5c\x3b"
          "\x19\xef\x9c\x8c\x26\x49\x63\x7c\x87\x9f\x48\xc8\xf4\xdc\x9f\xf9\x25\x61\xd5\x7a\xf8\x11"
          "\xdd\xde\xc1\x99\x10\xe6\x8b\xdf\xaf\xc6\x6c\xce\x09\xd9\x9d\xec\x97\x06\x1e\x7d\x5e\x13"
          "\x2b\xff\x88\x20\xed\xa2\x87\xe1\x58\x4b\xfa\xba\xeb\x9a\x89\x13\x5c\xba\x3e\xef\x52\x1b"
          "\xe0\xfb\xa9\x74\xf7\x09",
          1, 1152 },
        { 128, 128, 24, "\xd9\x57\xd6\xc3\xa8\xe2\x32\x83\x3a\xc4\x88\x33\xce\x67\xcc\x43",
          "\xdb\x75\x4e\x4a\xde\xfa\xa9\xa0\x90\x5e\x72\xf4\xf3\x3c\x65\x96",
          "\x86\x89\x63\xfc\xff\xf3\x7f\x82\x5b\xba\xd9\x47\xcc\x1f\x87\xcd\x8d\xde\xe9\xa1\xec\x7d"
          "\x29\x9e\xa8\x0d\x74\xbe\x28\xe8\x41\x4b\x8d\x0f\x82\x2d\x86\x5e\x5f\x92\x03\xfc\x9b\xf3"
          "\xc8\x85\xdc\x07\x9b\x9d\xc8\xf6\xe9\x69\x4d\x63\x66\x2e\x4c\x11\xdd\x37\xff\xfc\x14\xd9"
          "\xd8\xf4\xd4\x27\xc5\xa5\x32\xc7\x73\x88\x89\xc5\x31\xc8\xcb\x89\xc7\x20\xed\x68\xfe\xf2"
          "\x9c\x63\xd0\x94\x8b\x64\x1f\x4c\xae\x1a\xce\x36\x5d\x62\x50\x08\xb2\x1b\xf0\x2f\x00\x9d"
          "\xf0\x7b\x7e\x97\xd9\x80\xfb\x34\xa5\xca\x2c\xd3\x8d\xe3\x1d\x41\xf3\x55\x6b\xb2\x66\x2b"
          "\xf3\x4a\x3e\x09\x5a\xbd\xe1\x03\xa6\x60\x7f\xaf\xa1\xdd\x1f\x99\xd5\xbe\xda\xc9\x3b\xab"
          "\xa9\xe1\xd5\xf4\xcf\x85\x3d\x49\xf8\x49\x49\xb3\xcd\x18\x5d\x19\x8a\xaf\xc7\x2f\x79\x7b"
          "\xf6\x90\xde\x58\xc2\xb5\x74\x63\x43\x41\xb6\x94\x2f\xd6\xec\xb2\x28\x15\xa4\xd1\x31\xc6"
          "\xec\x98\xd2\xba\x09\xa7\xd4\x9e\x4f\x37\xe8\x6a\x96\x46\xe0\xa5\x8d\x42\xdc\xc7\x0d\xe8"
          "\x52\x60\xc6\x87\x69\x7e\x41\xfc\x3f\x96\xcb\xfe\x42\x53\xa2\x00\xcf\xbe\x92\xaa\x74\xc7"
          "\x1a\xa8\xea\x49\xb2\x10\x0a\xf2\x1a\xa0\x07\xfe\xbe\x77\x7d\xdb\xcd\x9d\xee\xb6\xbd\x94"
          "\xb7\xae\xd5\x2e\x82\x24\x2d\x60\xa7\xc3\x37\xad\xf8\xfe\x4b\x40\xcd\xe3\x00\x22\xbd\x93"
          "\xa3\x27\x1a\xd3\x06\x94\x98\x4f\x1e\x7b\x7c\x80\xd7\x5a\x51\xda\x80\x7c\xdf\x96\x07\x95"
          "\x47\x64\x5d\x7a\xa8\x6b\x59\x72\x77\x2f\x30\xa0\x35\xaf\x56\x20\xe3\x6a\x67\x35\x4b\x8b"
          "\xad\x5b\x94\xed\xf4\x16\x84\x99\xe1\xaa\x0e\x7d\xee\x0d\xe4\x24\x43\xf6\xdd\x33\x54\xf6"
          "\x01\x4d\x65\x6c\x53\xff\xaf\x94\xf3\x09\x2d\x76\x55\x55\x6d\xed\x34\xb5\xde\xf3\x24\xf6"
          "\x2d\x86\x32\xab\xab\xdd\x91\x66\xdc\xa9\x36\xe9\xf7\x87\x4a\x9a\xc6\x71\x78\x1b\x48\x98"
          "\xfa\x93\x33\xc9",
          "\xfe\x1e\x71\x13\x30\x61\x89\x90\xb7\xd2\xec\x2b\x2c\x5f\xfd\xba\x0b\x6c\x92\x00\xd8\xff"
          "\xde\xf0\x5d\xf0\xd8\x02\xa4\x5b\x2c\x3d\x99\x35\xbf\x59\xa6\xfb\x39\x5a\x9a\x99\xa9\x9a"
          "\xf2\x2f\x5a\xe4\x2d\xa5\x42\x1c\x7d\x7b\xfa\xa1\x49\x89\xbc\x2f\x5f\x4b\x69\xc1\xee\x02"
          "\xb9\xfb\x62\x0e\x8a\x4e\xd7\xb3\x97\xe8\x0d\xf3\x50\x4b\x9e\xfe\x60\xe5\x06\x43\x0e\xae"
          "\xcb\x1a\x4a\x42\xea\x73\x96\x66\xe6\xbe\x23\x7e\x9a\x64\xa3\x01\x0a\xb9\x96\x19\x4b\x7b"
          "\x42\x6e\xb1\xa4\x4c\x12\x03\x1a\x89\x2c\x0a\xe3\x8d\x6a\x0b\xc9\x84\xeb\x89\x31\xb1\xb8"
          "\xfb\x56\x28\xec\x57\xf3\x68\x04\x15\x8a\x4f\xc9\x4a\x08\xa9\x1e\x6c\xc7\x20\xd1\x12\x35"
          "\x53\x07\xbf\xe1\x40\x10\x1f\xea\x88\xc5\xb3\x2e\xd8\xf7\xda\x52\xc4\xf4\x82\x65\x60\xdd"
          "\xc6\x7f\x62\x99\x88\x50\x10\xc1\x8f\x43\xb1\x64\xdb\x70\x7c\xc2\xcf\xa5\x41\x55\x32\x34"
          "\x25\x8c\xcc\xce\xd5\xc4\xd9\x17\x84\x39\xd7\x04\xc7\xf2\xc6\x4c\x50\x9f\x1c\x40\xd5\x7e"
          "\xe7\x6f\x6b\xd4\x57\xe8\xdd\x2d\x7c\x57\x86\xc7\xd6\x4d\x6e\x89\x1a\xa4\xd2\x4a\x1a\x39"
          "\xfc\x9b\xc9\x5f\x8d\xa8\x56\x46\x92\xb9\x3f\xd1\x79\xfb\x51\x8f\xe2\x51\x03\x3d\x60\x85"
          "\x30\xe3\x3e\x5d\x52\x51\xf0\xfa\xe7\x8d\x1c\xcf\xb8\xfb\xdb\xba\x17\x45\xa3\x55\x9e\x39"
          "\xaa\xf3\x2f\xbf\xee\x8c\x08\xa6\x9b\xce\x54\xb5\x54\x00\x8f\xcd\x95\x37\x4b\xae\xbb\xe8"
          "\xf2\x6f\x1a\x08\x74\xe6\xf4\x7c\x71\x73\x9a\x64\xb5\x5f\x1f\x28\x40\x10\x17\x39\x78\xe8"
          "\xc0\x4b\xe7\x2a\x71\xa7\x4e\xa3\x8c\x9e\x30\x2c\xdb\x8f\x0f\xba\x98\x77\xb9\x96\xb8\x8b"
          "\x5e\x32\xda\x92\xd1\xe8\xa8\x31\x57\x9f\xe1\x77\x96\x2e\x54\x11\x34\x43\x56\xfd\x29\x48"
          "\xaf\x3a\xdb\xcf\xf3\x58\xdb\x02\x4b\xa1\x13\x94\x8c\x2f\xc6\x4c\x1b\xd9\x1c\x11\xbd\xcd"
          "\x21\xdf\xaa\x32\xfb\xee\x9c\x72\xfc\xa0\x56\x2a\x89\xa4\xdb\x46\x52\x4d\x34\xc4",
          1, 3200 },
        { 128, 128, 25, "\x66\x96\x4f\x8f\x9b\xa4\x24\x9c\xa0\x24\x0e\xdb\x0a\xaa\xef\xe2",
          "\x78\x5a\x3e\xe0\x66\x48\x43\x07\xa2\xad\x18\xec\x7c\x9c\x8f\x4a",
          "\x08\x44\x02\x22\xe7\x65\x3c\x4c\x16\x33\xa6\xa1\x8d\xac\x02\x04\x8d\x8e\x66\x0f\xc2\x4e"
          "\xbf\x53\x6c\x61\xbe\x10\x7d\x59\xb6\x0f\xd0\xb1\xe5\x3b\x90\x75\x74\xfd\x71\xcf\x29\x1c"
          "\x84\xd8\xa7\x14\x63\xd6\x8e\xd3\x22\xa8\xe1\xca\x28\xea\xb1\x87\x37\x63\x01\xb1",
          "\x48\x73\xae\x1d\xab\x98\x42\x05\x7f\x53\xb2\x2b\x15\x11\x93\x01\x40\xce\xb2\xa6\xf4\x71"
          "\x7b\x64\xd6\xb8\xf7\x87\xc2\x18\xaa\x5a\xfc\x3c\x75\x89\x09\x08\xca\x1a\x39\xa3\x57\x51"
          "\xea\xdf\x5d\xf3\xcd\x89\x89\x61\x92\x73\xc4\x41\x55\xe3\x21\xd9\xc4\xd1\x02\x05\xca\xaa"
          "\x5f\x89\x19\x61\xb4\xde\xef\xa6\x16\xe4\xf5\x69\xa3\x38",
          1, 512 },
        { 128, 128, 26, "\x51\xe7\x1e\xae\x30\xd1\x3e\x2e\x38\x87\x7b\xe2\xb9\x26\xfc\x8c",
          "\x94\x57\x44\x51\x75\xd6\xb7\x70\x34\xcc\x9c\x64\x05\x3f\xe5\x18",
          "\x35\xe7\xa4\x7e\x7f\x27\x81\x91\x07\xde\x29\x75\x1c\xcf\x84\x24\xdf\xea\x59\x8d\xb2\x9b"
          "\x5e\x2b\x20\x1d\x7c\x23\x55\x22\x3e\x21\x4c\x6d\x47\x59\x31\x0a\x92\x8b\x00\x9b\x8a\x2a"
          "\x07\x2c\xa3\x1d",
          "\x8c\x9f\xfd\x00\xf0\x97\xb2\xc3\x0b\xdf\x1f\x49\xcc\x64\x00\x22\xed\x1a\xfb\x2f\xab\x45"
          "\xf4\x46\x3e\xf7\xfd\x39\xbe\x0c\x5b\x30\x40\x75\x3f\x57\x8f\x64\x43\xc3\x2c\xcd\xcf\x8f"
          "\x2d\xe2\x57\x2c\xd8\x24\x95\xcd\x88\x67\xee\x3e\x46\xd1\x7c\xe6\x21\x13\x40\x11",
          1, 384 },
        { 128, 128, 27, "\x91\x88\x58\x06\x3b\x1b\x0f\xc8\x20\x7c\xf8\xbc\x5f\xdc\x07\x3d",
          "\x18\x0f\xdc\x55\x61\x4d\x37\x44\x9e\x60\x18\x0c\x24\xa0\x61\x3e",
          "\xdf\x93\xb5\x13\x28\x23\xeb\x8f\xa3\xce\x47\xa1\x04\xd6\xc8\x37\x0e\xba\x95\x3c\xa2\x7e"
          "\xb4\x00\x98\x93\xdf\x43\x74\x80\xcf\xa8\xe9\xf2\x02\x04\xfa\x03\xa3\xc9\x08\x2c\x24\xeb"
          "\x2f\x56\x2a\x74\x1a\x2f\xcb\xbd\x13\xc5\xab\x74\x2f\x1b\x57\x65\x01\x83\x11\x3e\xc7\x91"
          "\xec\x76\xcb\x70\x65\x08\x13\xad\xef\x86\xef\xc8\xca\xc2\x5c\xf0\x13\x1a\x77\x2e\xb5\x47"
          "\xd7\xe2\x27\x24\x79\x43\xd0\xfc\x45\x26\xee\x0d\x18\xb0\xa8\xc9\xbb\xc8\x21\xed\x30\x2d"
          "\x61\x13\xe9\x57\x7e\x17\x92\x9d\x36\x25\x04\xf6\xb6\xe7\x70\x9b\xe4\x98\x65\x8e\x4c\x30"
          "\xb8\x32\x54\x90\xcc\x77\x58\x65\xac\x6e\x06\xcd\xb4\x21\xb4\x90\x74\x62\x50\x3e\xff\x96"
          "\xc0\x46\xcb\x8e\x86\x87\xa9\xa5\x96\xaa\x61\x2b\xaa\x21\xb1\xd5\x31\xa3\xec\xec\xd4\xb2"
          "\x52\x83\xbf\xbb\xd3\xf2\x79\x9c\x69\x6b\x41\x68\xa4\xd3\x1c\xbc",
          "\x21\x93\x30\xe9\x81\x5a\x69\x38\x32\x67\x42\x65\x41\x0e\xe3\x89\xdb\xfb\xc4\x99\xa8\x19"
          "\x0c\x78\x1a\xa0\x4d\x52\xd2\x0a\xf8\x38\xcf\x8d\xff\x09\xdf\x27\x59\x25\x6c\xbf\x4d\x29"
          "\xc3\xf7\x17\x97\xf9\x52\xf5\x96\x84\x92\xe4\x1b\x4f\xa2\xbe\x7a\x47\x9a\xa1\xc3\xba\x5a"
          "\xbd\xb9\x01\xfa\x9b\x57\x35\xe6\xf0\x19\xc0\xa7\xad\x22\x39\x58\x78\x73\xc7\xc0\x01\xa6"
          "\x49\x0b\x2b\xcc\xff\x77\xac\x93\xfa\x8f\x1f\xc7\xc1\x2f\xf3\xbf\xd9\xe9\x30\x9d\x95\x42"
          "\xa3\x09\x04\x2f\xe6\xc4\x9c\x13\xad\x06\x17\xe8\x4e\x4c\x60\x7c\x82\xe6\x91\x05\xbd\x85"
          "\x37\xc6\xb5\xf0\x7a\x5c\x87\xe8\x61\xe0\xa1\xa6\xe1\x04\x50\x56\x0a\x4e\x50\xbc\x7d\x29"
          "\x9c\x53\xef\xeb\x0b\x46\xd0\x2d\x39\x89\x99\x60\x8a\xb8\xbb\xb5\x1e\xa8\xe6\x0d\xb6\x6f"
          "\x84\x49\x62\x2e\x2b\xeb\x53\x60\x02\xb5\x41\x6e\xb3\x19\xf2\x9a\xf5\x50\x92\x78\xc6\x94"
          "\x1e\xec\xbb\x89\x01\x19\xf3\x5c\xd3\x21",
          1, 1536 },
        { 128, 128, 28, "\x57\x22\x7f\x8b\xbc\x1a\xd7\x8d\xed\x0b\x5a\x3c\x4c\x84\x31\x0f",
          "\x95\x53\xc9\x2c\xea\x37\x00\xde\x74\x46\x2b\x41\xf6\x78\x72\xc2",
          "\x13\xed\x14\x1c\x52\xd6\x98\x76\x25\x5c\x4e\xb1\x58\x31\x15\x44\x23\x34\xaa\x79\x50\x52"
          "\xdb\x60\x28\x34\x38\xa1\xb2\xaa\x18\x3d\x36\xea\xfd\x3f\xf7\x2c\xdc\x8b\x4d\x77\x4c\x9c"
          "\x62\xff\xb1\x91\x96\x2a\xaf\xc9\xf8\xda\xdf\x7e\x8c\xaa\x7f\xb6\xf8\xa4\x3a\x1b\x30\x2e"
          "\x32\x1c\x77\xab\xcd\x79\x6f\x1e\xda\x9d\x1a\x5b\xb4\x69\x7a\x1c\x4b\xd3\x13\x34\x86\x36"
          "\xa1\x7b\x1f\x5f\x74\xf5\x9e\xc9\x44\x18\xaa\xe1\x08\xeb\xfc\xc5\x17\x7e\x79\x89\x9c\xfd"
          "\x71\xf1\x01\x16\x7b\xf0\x09\x37\x3a\x84\x05\x35\xda\x36\x96\x5d\x1d\xa7\x9e\xf4\xf0\xde"
          "\x43\xbd\xf4\xa3\x60\xe0\x2f\xf2\x4c\x77\x5a\x10\xa9\x64\x10\x78\x6a\x00\x08\x21\x70\xcc"
          "\xc5\x3a\x4d\xd4\x27\xfd\x5f\xee\xf0\xc1\x61\x21\xb5\xed\x00\x8e\x63\x92\x38\x39\x47\x8e"
          "\xc9\x04\x05\x6e\xd9\x58\xbd\x01\xac\x6c\xa7\x78\xfc\xda\xee\x6e\x5f\xd1\x9b\xae\x0b\x3a"
          "\xf3\xd8\xcb\xf5\x35\xa5\xc7\x65\x9b\x69\xd3\xc0\xf8\xd3\xc6\xc2\xd1\xca\x2a\x32\x67\xd0"
          "\xa1\x88\xbf\xb5\xca\x5b\xb9\xe1\xfb\x57\x91\xd5\xa4\x76\x83\x94\xe3\x49\x41\x13\x02\xc6"
          "\xa9\x2d\x5e\xe1\x5a\xb7\x84\x48\x35\xc8\x65\x4f\xa4\x24\x9c\xc1\x60\xb6\xf4\xa4\x82\xf6"
          "\x30\xb1\x0d\xd4\x8d\x5a\x60\xff\xd0\xb0\x25\xd2\x53\x24\xb8\x27\xff\x75\x2d\xfc\x4e\xfa"
          "\xcf\x94\x89\x39\x52\xeb\x79\xdb\x4e\x1e\x98\x45\x50\xe4\x9c\xda\x78\xea\x5b\x34\x02\x16"
          "\x96\x59\xaa\x61\xd8\x3a\xba\x0e\x75\x1b\x5e\xfb\xc7\x8b\x4f\x73\x44\xd6\xdd\xbf\x63\xe3"
          "\xb4\x9b\x88\xc3\x34\x53\x8a\x55\x60\x08\x1d\x95\x9e\xb6\x1a\x92\x48\x05\xba\x5f\x1c\xe4"
          "\x21\x4f\x35\x85\xb4\x88\x02\xef\x53\x9d\x09\x7b\xd9\xf1\x61\x5c\x38\x1d\x3d\xe3\x35\x38"
          "\x00\x88\x2b\xe0\x54\xbd\x02\xa1\x62\x28\x70\xc6\x5b\xce\x55\x89\x18\xf3\x16\xf7\x56\x62"
          "\x9d\xa1\x1f\xdd\x9c\x26\xc3\xd6\x66\x08\x4d\x3d\x88\x2a\xce\x32\xd5\x82\x0b\xc8\x24\xf3"
          "\x45\x4d\xa4\xa1\x70\x72\x35\xb7\xb5\x08\x80\xcf\xdc\x6a\x8e\x26\xd0\x48\xeb\xaa\x80\xa6"
          "\x70\xc3\x57\xd9\x93\x2b\xbd\x0e",
          "\x22\xcd\x43\x71\x2e\x6c\xd7\xa4\xb7\xf0\x66\xf7\x20\x29\x9c\xc8\x96\x04\x58\xcd\x8b\xdb"
          "\x36\x73\x14\xf4\x0b\xf4\x7d\xcc\x87\xc3\x45\x51\x9b\x40\x5d\x9f\x2a\xe9\x50\x6e\x38\x4c"
          "\x02\x44\xf3\xf6\xa4\x02\xc0\x3f\xaa\xed\x67\x38\x34\x16\x9e\x71\x90\x73\xe3\x8c\x0a\x70"
          "\x9e\x94\xcf\x5d\xe9\x7e\xde\xa4\xf9\x79\x79\xe3\x02\x24\x6e\x59\x7d\x0f\xf3\x78\xd8\xcd"
          "\x29\x26\x06\x10\xe8\xd2\x55\xf2\xc9\xd7\x21\x19\x0e\xc5\x40\xe4\xfa\x5c\xcc\x2c\x46\xec"
          "\x35\x8c\xd4\x21\x7b\x3e\x31\x40\x18\xd8\xcc\x16\xa2\x14\xea\x1d\x0e\x2a\x2b\x71\xf8\xab"
          "\x4a\x23\x67\x66\xe1\xfb\xaa\x1b\x6c\xb1\xfc\x1f\x76\xb2\xb1\x2d\x57\xc5\x6a\x89\x88\xde"
          "\xf7\xc8\x6e\x60\x11\xb2\x45\x59\xc7\xd5\x1d\x6a\x0e\x47\xe3\xa7\x42\xdc\x15\x45\x64\xcb"
          "\xc9\x20\x66\xba\x52\x9f\xb1\x66\x4a\xe5\x16\x6e\x92\xe7\x1f\x9e\xcd\x3a\x8a\xf7\xbd\x51"
          "\xdc\xe7\xc7\x3b\x10\x4d\x1e\x1e\xde\x47\x2b\x36\x57\xb6\xb3\x2b\xd4\x78\x4a\xec\xa9\xb5"
          "\x32\x6a\x80\xbb\x96\x58\x07\x35\xa9\x76\x74\xf8\x5b\x2a\xbd\x69\x3e\x4c\x9a\x26\x23\x35"
          "\x0a\xe1\xa6\x43\xcb\xe1\x68\x07\x37\x9b\x5a\xa7\x28\x0a\xbb\xdd\x2f\x34\x20\xee\x64\xc4"
          "\x5c\x5e\x3b\x69\x70\x58\x7d\x7b\x26\xda\x3d\x9b\x77\x0a\xcb\xad\xfe\xd6\xcb\xe6\x7f\x2b"
          "\x95\x89\xdb\x17\xda\xe5\xa5\xd6\x4b\xd4\x0a\xf7\xa4\x4a\x17\xa1\x3f\x06\xa8\xe3\x2e\x5d"
          "\x2e\xa9\x0c\x29\x4e\xbe\x7a\x52\x9a\x38\x9c\xc7\x5e\x44\x7b\xe8\xf1\x26\x0d\x74\x3d\x1a"
          "\x88\x09\x10\x0a\xb7\x4c\x59\xb0\x55\x3d\x12\x65\xb6\x18\x07\xae\xd2\x5d\x49\x31\x1b\x2f"
          "\xa7\xad\x49\x02\xfb\xc4\xa7\xc5\xab\x43\x75\x08\x41\xcd\xa7\xf2\xf6\xf0\xe6\xe1\x9a\xde"
          "\xfd\x58\xb4\x15\x94\x13\x8a\xb0\x36\xb8\xe6\x4e\x18\x3c\x22\x1d\x40\xec\x79\x90\xfb\x25"
          "\xb6\xb5\x0c\xac\xa5\x96\x78\xf0\x0a\xeb\xc1\x8b\xfb\x7b\xb3\x9e\x96\xd4\x47\x15\x94\xc4"
          "\x94\xac\x54\x0b\x5f\xff\x31\xfc\xf7\x3e\xbb\x99\xe3\x3c\x15\xed\x51\xe1\xc2\x42\x20\x83"
          "\x36\x45\xc2\xad\xf0\xdb\x63\x23\xc1\x78\xf2\x38\x33\xeb\x7b\x6b\x82\xaa\x6d\x0c\xf9\xb5"
          "\x2b\x59",
          1, 3584 },
        { 128, 128, 29, "\x3a\x95\xb8\x71\x86\x18\x6e\x1b\x51\xb0\xc9\x19\x28\xe8\x2c\x25",
          "\x1a\x75\x0e\xea\x95\x6d\xea\xef\xf5\x74\xdb\x03\x83\x68\xba\x00",
          "\x79\xd2\x88\x9c\xe6\x58\x44\xfa\x9a\x04\xc4\x82\x02\x86\xb1\x1d\x4b\x80\xf2\x38\x01\x77"
          "\x9f\xb7\x38\x8a\xb5\xae\x85\x83\x2f\x5e\x71\x72\xe6\x3d\x2e\xb7\xe1\x4f\x2c\x62\x95\x75"
          "\x13\x85\xd6\xb5\x80\x95\xbd\x13\xc2\xe9\x20\x88\xc6\x9b\xaa\x82\x45\xe4\x74\xef\xa0\x8f"
          "\xab\x3b\x59\x38\x71\x3f\x52\x81\xd8\xa6\x9b\x69\x3c\x01\xcf\xa2\xc3\x03\x90\x2f\x3b\x17"
          "\x19\x9d\xd2\x89\x5b\xf4\x6e\x20\x27\x31\xdd\xc5\x18\x42\x8f\xbd\x7f\x62\xcc\x19\xbd\x83"
          "\x10\x60\x67\x97\xfa\x9c\xac\xe9\x2a\xa9\x81\x20\xbb\x8a\xbe\x06\xb3\xac\xfd\x80\x64\x62"
          "\xca\x75\x73\x1a\x00\x8c\x97\x37\x99\x08\x11\x74\x0c\x36\x20\x17\x01\xf9\xda\x18\x25\x41"
          "\xdb\xd1\xbf\x12\x48\x45\x1c\x1a\x1a\xb6\x74\xdf\xbe\xfb\xfd\x8b\x4a\xc7\xd7\x3a\x6a\xc2"
          "\x28\x25\xd2\x07\x50\xef\xd8\xb8\x1f\xf2\x73\x28\xfb\x96\x28\x51\x61\xd5\x9b\x25\x1c\x66"
          "\x1b\xec\x48\xc9\xec\xf4\x96\x65\x0a\xc6\x50\xe9\xcb\x56\xf3\x79\x3a\x09\xbf\xb3\x68\x06"
          "\xde\xfd\x76\xd3\x4c\x2c\x80\xee\xc2\x68\x62\xef\x8d\x84\x7f\xd5\x3a\x42\x52\xfe\x8d\x63"
          "\xfe\x07\xd7\x2a\x86\xe6\xf4\x38\x19\xa4\xdf\x10\x46\xbd\x67\x1e\x4f\xd2\xe8\x5b\x48\xa2"
          "\xa4\x8f\x3d\x5f\xab\xc9\xc8\xc6\xcf\x70\x6b\xad\x6a\x85\x13\x75\xf8\xb2\x52\xf9\x0e\xf4"
          "\xe3\xca\x9f\x30\xe3\xe7\x9d\x70\x7a\x92\x8a\x6e\x62\x53\x34\xa0\x92\x45\x20\xaf\xfe\x4e"
          "\xde\xa9\x6a\x37\xb3\xc8\xd5\x5d\x65\xb2\x0d\x8e\x6f\x8d\xfe\xfa\x9c\xca\x7c\xa1\x21\x8a"
          "\xa9\x73\x1c\x75\x94\x34\x92\xad\x68\x6e\xc6\xa6\xa0\x47\x92\xd5\x0a\x57\x1c\x0f\x92\x99"
          "\x17\x3b\x58\x8a\xf2\x0b\x04\xa7\x14\xb4\xf0\x99\x5b\x28\x4b\x72\x7b\xe9\x3b\x57\x65\xf9"
          "\x8a\xde\x0c\xb4\xcc\x5d\x1d\xf3\x14\x6f\xca\xc6\xb3\x17\x8e\xe5\x38\x44\x11\x9f\x00\x73"
          "\xa5\x47\x98\x2b\x8f\x2c\xbb\x66\x19\xa4\xc4\x8a\xc1\xc6\x90\xaf\x7e\x79\x29\x94\x43\xc2"
          "\xed\x09\x2f\xc2\x67\x35\x87\x23\x44\xc7\x61\x3d\xa6\x35\x1a\x46\x72\x80\x16\xa6\x85\x31"
          "\x06\xb6\x82\xc2\x35\xd3\x55\x21\x85\xf0\x2f\x6b\x1b\x25\xa1\x26\x53\x0f\x16\xf1\xd6\xca"
          "\x06\x48\x95\x93\x54\x78\xcc\x4a\x88\x6f\x1d\x67\x58\x12\xe6\x1d\x2b\xa9",
          "\xff\xfd\x99\x8b\xaf\x2b\x52\x4e\x55\x29\x73\x86\x22\x15\x3c\x69\x14\x18\x1c\x37\x56\x95"
          "\xc8\x5d\xf9\x15\xfd\xd8\xe6\xb1\x3a\xc1\x7a\x1d\xb5\x20\x1b\x2b\xab\x86\x6a\x6b\x8f\x2f"
          "\x5d\x16\x96\x72\x29\x72\x7b\xd5\xf4\xc5\x4d\x51\xf2\x9e\xa3\x67\xe0\x5e\xa5\xf6\xee\x66"
          "\x9a\xb7\xe0\x76\xb2\x39\xc9\x5c\x11\x80\x3b\x39\xde\x6c\xc4\x23\x2f\xae\x97\x42\x6d\xbe"
          "\x8d\xa3\x24\x04\x72\xdf\xca\x01\xb6\x82\xc1\x3a\xa0\xd8\x3f\x44\x8b\x1c\x40\xa5\x5a\x2d"
          "\x57\x56\x4d\x62\x21\xab\x67\x14\xfd\x97\x02\xdb\xe5\x63\x93\x8e\xc3\xbf\x57\xb1\x88\x3d"
          "\x5d\xd1\xd0\x18\x04\xba\x6b\x43\x8d\xf2\x3a\x75\xe4\x00\x4f\x03\xef\x61\x87\x9d\xd9\x02"
          "\xb1\xe8\xe8\x9e\x56\xb5\xdf\xa8\x1a\xf4\xfc\x00\x39\x3c\x07\x00\x3e\xcb\x42\x22\xd6\x20"
          "\x00\xcc\x79\x5b\xdf\x41\x5e\x2e\x43\x24\xe1\x14\x51\x2c\x3b\x43\xbd\x06\xa9\x44\x78\xef"
          "\xcb\xd0\x62\x3f\x84\xad\x30\xdf\x7b\xda\xaa\x86\xef\x63\x26\x2e\x31\xe7\xff\xf3\x6e\xf5"
          "\x7e\x59\xa5\x80\x4b\xee\x56\xb1\xa6\x94\x72\xc2\x95\x12\x5b\xf9\x3f\xdc\x47\xfb\x75\x50"
          "\xf8\x6f\x51\xd0\xc6\x9e\xeb\x08\x48\xea\x29\x3a\x98\xbe\xcb\x5d\xc2\xde\x78\x89\x11\x2b"
          "\x2a\x52\xd9\xdb\xb1\x82\xe2\xff\xb1\xa2\x4e\x55\xc7\x93\xf1\x77\x6a\x52\x37\xc1\xf0\x5d"
          "\xc4\x17\x58\x5f\x2d\x69\xcd\x81\xe4\xce\xf7\x8b\x8d\xb7\x21\xb2\x0c\x8a\x89\x5c\x17\xfb"
          "\xb9\x24\x67\x05\x60\x0e\x7b\xa7\x82\x28\x2a\x3a\x21\xbd\xad\xdf\x5e\x7c\x18\xd0\x1b\x02"
          "\xd8\x02\x0f\x55\xb2\x6d\x17\x85\xa9\xc1\x27\xd4\xf4\x2d\x59\xcd\xd6\x45\x68\xaf\x71\x89"
          "\x94\x59\x59\x3c\x22\x38\x79\xc0\x32\x74\x04\x5f\xdb\xea\xb3\x5b\xc1\xc2\xbb\x68\x4d\x0f"
          "\x0d\xdf\x18\x29\x10\x68\xc0\x66\x54\x4d\xdd\x53\xb5\x8a\x94\x9e\x6a\x85\xf9\x12\xff\x4e"
          "\x91\x3f\x58\xe4\x8c\x1c\x27\xa0\x69\xbc\x5a\xa3\xbb\xf9\xbb\x89\xaa\xdd\x3b\x37\x85\xe1"
          "\x2e\x59\x70\x71\x51\x5d\x4f\xe6\xd2\x24\x60\x81\x34\xc7\xfd\xbc\xa9\xbe\x78\x91\x03\x1c"
          "\x1d\x62\x70\xe5\x01\x69\xfa\x02\xc8\x77\xa9\xaf\x59\x9a\x3a\x6d\x83\xb1\x22\xe0\x44\xf9"
          "\x7c\x76\xe1\x4a\x70\x5c\xf4\x53\xa1\x77\x12\x36\x1b\x89\xc8\xc5\xdf\xda\x52\x6c\x25\x68"
          "\xce\xef\xc9\x70\xa1\x7c\x84\x92\xb5\xf8\xa5\x20",
          1, 3840 },
        { 128, 128, 30, "\x99\xfd\x0c\x36\xce\x13\x67\x66\x41\x0a\x3d\x8c\xcd\xb7\x96\xb2",
          "\xaa\x96\xc3\xbe\x3a\x1a\x91\x2b\xce\x62\x67\x65\xfb\x9b\x6e\x0e",
          "\xb7\x15\x85\xe1\xde\xf6\x7a\x2c\x95\xb2\x46\x08\x06\xd5\xac\x78\xc5\xf3\x09\x01\x9f\x1d"
          "\xe0\xe6\x2b\xa2\x5e\x01\x38\x02\xe3\xf4\x4f\x27\xb9\x1a\x68\x5b\xb3\xd2\x2d\x16\xb2\xa4"
          "\xda\x4b\x6a\x0e\xc9\x5d\xe4\x55\x1b\xad\x63\x5a\x56\x7d\x96\x7c\x76\x25\x5b\xa4\xc4\x78"
          "\x4d\xd8\xd7\xc0\xf5\xdb\x25\x65\x5a\x45\x78\xb8\xf3\xb7\x31\xce\x08\xe2\x42\x9c\x16\x94"
          "\xcf\x73\x89\xc4\x8e\x14\x84\x63\x4f\xf9\x93\xaf\x55\x50\x30\xe4\xc3\xc1\x79\x6a\x01\xb7"
          "\xe5\x98",
          "\x5a\xb5\x8a\x3c\xc6\x74\x5c\x94\x02\x05\x36\xdb\xb3\xfc\x19\xb2\x4b\x27\x6f\xaf\x86\x8d"
          "\x8d\xdf\xf5\x0a\x64\xf1\x20\x8c\x59\x1b\x24\xa4\xf4\xcf\x5d\xaa\x1e\x06\x17\x94\x03\x7b"
          "\x53\x7b\x50\xa6\xae\xa0\x26\x2c\xa9\x8e\xf3\x55\xc9\x06\x47\xd4\x32\xe2\x35\x2e\xad\xf5"
          "\x0b\xb2\xfa\x24\x91\x06\x35\xa2\x33\x60\xcb\xda\x45\xd9\x0e\x25\x6d\xac\x8e\xc6\xa0\x24"
          "\x08\xe4\x4f\x7d\x7b\xb4\xce\x17\x91\x87\x41\xee\x30\x00\xcb\x1c\x18\xc3\x6e\x05\xc3\x1a"
          "\x39\x7f\x72\xde\x2a\x07\x2e\x79\xe4\xe4\xc6\x0c\xad\x01\x44\x4c\x8e\xe5",
          1, 896 },
        { 128, 128, 31, "\xe4\x0f\x9c\x22\x00\x63\x60\x9b\x3a\xb2\xaf\x5e\xe2\x6d\x68\xa9",
          "\x10\xb6\x37\x5f\xec\xb9\x42\x82\x2f\xa2\x90\xc7\xaa\xa7\x66\xcd",
          "\x4e\x38\xf6\x57\xc8\x14\x97\xcc\x1f\xb8\xc0\xb4\x29\xa1\x8c\x42\xa9\xe0\xad\xf1\x24\x8c"
          "\x1f\xc8\xd2\x0c\x8c\x48\xe3\xd1\xd1\x94\xe2\x24\x29\x1c\xc3\x39\x3b\xc6\xb3\x62\xd1\x36"
          "\x4b\x4b\x05\xae\x3c\x2d\xc0\x85\x85\x31\x65\x45\x50\xcd\xba\xc8\x49\xc2\xeb\x4a\x86\xfa"
          "\x2a\xc8\x32\x92\x68\x62\xef\x56\x4e\xc1\x08\x9b\x45\x55\x82\x29\x7c\x05\x0f\x5c\x1b\x97"
          "\x15\x11\x9b\xe9\x91\x0d\x5e\x42\x33\xfa\xec\x54\x84\xd9\xe9\xb7\xb0\x41\x66\x1d\x61\x34"
          "\x6c\xa2\x2a\xd0\x30\xc8\x43\x33\x4b\x61\x34\xc4\x3d\xee\xa6\x69\x82\x92\x46\x5c\x8a\x9f"
          "\x4f\x0c\x26\x54\x4b\xda\x6e\xb7\x25\xa8\x37\x1b\xc7\x6c\xcf\x56\xb9\xe3\xde\x64\x9e\x52"
          "\x3f\xd8\x00\x6d\x7b\x3e\x12\x4f\x1b\xa4\x67\x14\x5f\xba\xb7\x93\x8b\xd1\x4b\x28\x74\xa2"
          "\x5e\x3b\x80\x33\x1b\x98\x0b\x09\x2d\x2b\xa6\x3b\xac\xb8\x58\x0e\x49\x1a\xfb\xbc\x64\x0f"
          "\x81\x45\xd8\xcd\x42\xe3\xea\x48\x44\x11",
          "\x33\x68\xd1\x72\x10\xa5\x1c\xa0\x0e\x9a\x8d\x26\xc8\x6b\x41\x60\xbf\x14\xd0\x44\x4f\x54"
          "\xb3\xad\xc6\xf2\x27\x2e\x19\x99\x23\x73\x01\xc3\x24\x6d\xbf\x83\x9f\x3d\x53\xc7\x55\x44"
          "\x6c\xb7\x6b\xb6\x03\xcd\xa9\x3d\x33\x05\xd6\xdf\xae\x18\xf7\x3e\xb2\x3a\xfc\x90\x13\x70"
          "\x2b\x4a\x2e\xd3\xad\x8e\x2a\xd4\x00\x19\x77\x92\x8b\x81\xf6\xd7\x24\x96\x84\xc5\x7c\x38"
          "\xfb\x6a\x4e\x23\x14\xa9\x26\x1e\xfc\x50\xf1\x5a\x21\xa1\xdd\xac\x8f\x8e\x1a\xef\x87\x92"
          "\xf7\x42\xa8\x27\xea\x50\x6a\x0e\xa2\xfa\x2a\x38\x67\xc3\x83\xa3\x96\x55\xd8\x00\x1a\x82"
          "\x58\x62\x7e\xf5\x2a\xb9\x60\x3e\x7b\xc5\xc9\x08\xee\x93\xba\x71\x87\xf8\x65\xe9\xc5\x50"
          "\xe7\x59\xf7\x15\x0a\xfe\x61\x1c\x66\x0c\x6d\xbd\xc9\x79\xc1\xff\xc6\x3b\xbd\x9e\xe9\x9b"
          "\x01\xaf\x7b\x8f\x09\xc5\xca\x0c\x81\xd2\x78\x25\x3f\x79\x7c\xca\x72\x2c\x89\x6c\xa9\xea"
          "\xe7\x86\x71\x25\xd7\x27\xd1\x7c\x05\xbf\x8a\x57\x15\x8e\xb8\xe7\x4d\xe9\x53\xb1\xb3\x4e"
          "\xd0\x38\x9b\x45",
          1, 1664 },
        /* Vectors from https://datatracker.ietf.org/doc/html/draft-ribose-cfrg-sm4-04 and
           https://datatracker.ietf.org/doc/html/draft-ribose-cfrg-sm4-10 */
        { 128, 128, 32, "\x01\x23\x45\x67\x89\xAB\xCD\xEF\xFE\xDC\xBA\x98\x76\x54\x32\x10",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F",
          "\xAA\xAA\xAA\xAA\xBB\xBB\xBB\xBB\xCC\xCC\xCC\xCC\xDD\xDD\xDD\xDD"
          "\xEE\xEE\xEE\xEE\xFF\xFF\xFF\xFF\xAA\xAA\xAA\xAA\xBB\xBB\xBB\xBB",
          "\x78\xEB\xB1\x1C\xC4\x0B\x0A\x48\x31\x2A\xAE\xB2\x04\x02\x44\xCB"
          "\x4C\xB7\x01\x69\x51\x90\x92\x26\x97\x9B\x0D\x15\xDC\x6A\x8F\x6D",
          1, 256 },
        { 128, 128, 33, "\xFE\xDC\xBA\x98\x76\x54\x32\x10\x01\x23\x45\x67\x89\xAB\xCD\xEF",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F",
          "\xAA\xAA\xAA\xAA\xBB\xBB\xBB\xBB\xCC\xCC\xCC\xCC\xDD\xDD\xDD\xDD"
          "\xEE\xEE\xEE\xEE\xFF\xFF\xFF\xFF\xAA\xAA\xAA\xAA\xBB\xBB\xBB\xBB",
          "\x0D\x3A\x6D\xDC\x2D\x21\xC6\x98\x85\x72\x15\x58\x7B\x7B\xB5\x9A"
          "\x91\xF2\xC1\x47\x91\x1A\x41\x44\x66\x5E\x1F\xA1\xD4\x0B\xAE\x38",
          1, 256 },
        { 0, 0, 0, NULL, NULL, NULL, NULL, 0, 0 }
};
