#!/bin/sh

cd libjte

# Extract the root directory of the current path
debian_mapping=`pwd | cut -d'/' -f 2`

# The following sequence was copied from test/demo.c (slightly adapted because
# md5 script does not exist anymore):

# Produce an .md5 file
find . -name '*.c' -exec bin/jigdo-gen-checksum-list '{}' ';' >test/file.md5

# Produce payload image "test/file.outfile", the template file and
# the jigdo file. Input is test/file.md5 and the data files *.c
test/demo -outfile test/file.outfile \
          -template test/file.template \
          -jigdo test/file.jigdo \
          -md5 test/file.md5 \
          -mapping Debian="/$debian_mapping/" \
          *.c

jigit-mkimage -t test/file.template \
              -j test/file.jigdo \
              -m Debian="/$debian_mapping/" \
              -o test/file.rebuilt

diff -q test/file.outfile test/file.rebuilt

exit $?
