/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "distributionlist_description.h"

using namespace Form;

Description::Entry::List DistributionListDescription::entries() const
{
  Entry::List entries;

  {
    Entry entry;
    entry.setName( "cn" );
    entry.setType( "non-empty-string" );
    entry.setLabel( QObject::tr( "List Name" ) );
    entry.setComment( QObject::tr( "Required" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "members" );
    entry.setType( "memberselection" );
    entry.setLabel( QObject::tr( "Members" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "hidden" );
    entry.setType( "boolean" );
    entry.setLabel( QObject::tr( "Hidden" ) );
    entry.setComment( QObject::tr( "Check here to make this distribution list available only to authenticated users" ) );
    entries.append( entry );
  }

  return entries;
}
