/*************************************************************
 *   mpgtx an mpeg toolbox                                   *
 *   by Laurent Alacoque <laureck@users.sourceforge.net>     *   
 *   (c) 2001                                                *
 *   You may copy, modify and redistribute this              *
 *   source file under the terms of the GNU Public License   *
 ************************************************************/
#ifndef __chunkTab_hh_
#define __chunkTab_hh_

#include "mpeg.hh"


class chunkTab {
public:
	chunkTab(int _max = 20);
	~chunkTab();
	bool AddFile(char* filename);
	bool ParseRange(char* range);
	bool ParseBoundaries(char* boundaries);
	void PrintTab();
	void PrintInfos();
	bool Nchunks(int n);
	chunk** GetChunks(int* n);
protected:
        /**
         * adds some room to the internal tabs
         */
	void MoreRoom(int n);
	bool ParseValue(
		char* value,
		int value_length,
		off_t* translation,
		float* stranlslation,
		bool* time);
	/// ordered tab of chunks
	chunk** TheTab;
	int max;
	int current_chunk;
	int current_mpeg;
	mpeg* current_mpeg_ptr;
	mpeg** MpegTab;
	//	char* current_file;
};


#endif // __chunkTab_hh_
