/*
 * Decompiled with CFR 0.152.
 */
package org.nltk.mallet;

import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class CRFInfo {
    private static Logger logger = MalletLogger.getLogger((String)CRFInfo.class.getName());
    public String uri = "?";
    public double gaussianVariance = 1.0;
    public String defaultLabel = "O";
    public int maxIterations = 500;
    public int stateStructure = FULLY_CONNECTED_STRUCTURE;
    public static int FULLY_CONNECTED_STRUCTURE = 0;
    public static int HALF_CONNECTED_STRUCTURE = 1;
    public static int THREE_QUARTERS_CONNECTED_STRUCTURE = 2;
    public static int BILABELS_STRUCTURE = 3;
    public static int ORDER_N_STRUCTURE = 4;
    public int[] orders = null;
    public boolean[] defaults = null;
    public String start = null;
    public Pattern forbidden = null;
    public Pattern allowed = null;
    public boolean fullyConnected = false;
    public List<StateInfo> stateInfoList;
    public List<WeightGroupInfo> weightGroupInfoList;
    public int transductionType = 0;
    public String modelFile = null;
    public String featureDetectorName = null;
    public boolean addStartState = false;
    public boolean addEndState = false;

    CRFInfo(String string) throws ParserConfigurationException, SAXException, IOException {
        this.uri = string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.parse(documentBuilder.parse(string).getDocumentElement());
    }

    CRFInfo(File file) throws ParserConfigurationException, SAXException, IOException {
        this.uri = file.getName();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.parse(documentBuilder.parse(file).getDocumentElement());
    }

    CRFInfo(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.parse(documentBuilder.parse(inputStream).getDocumentElement());
    }

    void parse(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                String string = node.getNodeName();
                if (string.equals("gaussianVariance")) {
                    this.gaussianVariance = this.getTextDouble((Element)node);
                    continue;
                }
                if (string.equals("defaultLabel")) {
                    this.defaultLabel = this.getText((Element)node);
                    continue;
                }
                if (string.equals("maxIterations")) {
                    this.maxIterations = this.getTextInt((Element)node);
                    continue;
                }
                if (string.equals("transductionType")) {
                    String string2 = this.getText((Element)node);
                    if (string2.equalsIgnoreCase("VITERBI")) {
                        this.transductionType = 0;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("VITERBI_FBEAM")) {
                        this.transductionType = 1;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("VITERBI_BBEAM")) {
                        this.transductionType = 2;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("VITERBI_FBBEAM")) {
                        this.transductionType = 3;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("VITERBI_FBEAMKL")) {
                        this.transductionType = 4;
                        continue;
                    }
                    throw new RuntimeException("Bad transdutionType val");
                }
                if (string.equals("states")) {
                    this.readStates((Element)node);
                    continue;
                }
                if (string.equals("weightGroups")) {
                    this.readWeightGroups((Element)node);
                    continue;
                }
                if (string.equals("modelFile")) {
                    this.modelFile = this.getText((Element)node);
                    continue;
                }
                if (string.equals("featureDetector")) {
                    this.featureDetectorName = this.getAttrib((Element)node, "name");
                    continue;
                }
                if (string.equals("addStartState")) {
                    this.addStartState = this.getTextBoolean((Element)node);
                    continue;
                }
                if (string.equals("addEndState")) {
                    this.addEndState = this.getTextBoolean((Element)node);
                    continue;
                }
                throw new RuntimeException("Unexpected tag " + string);
            }
            if (!(node instanceof Text)) continue;
            this.assertEmptyText(node);
        }
    }

    void readStates(Element element) {
        this.stateInfoList = new ArrayList<StateInfo>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                String string = node.getNodeName();
                if (string.equals("state")) {
                    this.stateInfoList.add(this.readState((Element)node));
                    continue;
                }
                throw new RuntimeException("Unexpected tag " + string);
            }
            if (!(node instanceof Text)) continue;
            this.assertEmptyText(node);
        }
        if (this.stateInfoList.size() == 0) {
            this.stateInfoList = null;
            String string = this.getAttrib(element, "structure");
            if (string.equalsIgnoreCase("FullyConnected")) {
                this.stateStructure = FULLY_CONNECTED_STRUCTURE;
            } else if (string.equalsIgnoreCase("HalfConnected")) {
                this.stateStructure = HALF_CONNECTED_STRUCTURE;
            } else if (string.equalsIgnoreCase("ThreeQuarterLabels")) {
                this.stateStructure = THREE_QUARTERS_CONNECTED_STRUCTURE;
            } else if (string.equalsIgnoreCase("BiLabels")) {
                this.stateStructure = BILABELS_STRUCTURE;
            }
        } else if (element.hasAttribute("structure")) {
            throw new RuntimeException("use structure or <state>s, not both");
        }
    }

    StateInfo readState(Element element) {
        StateInfo stateInfo = new StateInfo();
        stateInfo.name = this.getName(element);
        if (element.hasAttribute("initialCost")) {
            stateInfo.initialCost = this.getAttribDouble(element, "initialCost");
        }
        if (element.hasAttribute("finalCost")) {
            stateInfo.finalCost = this.getAttribDouble(element, "finalCost");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                String string = node.getNodeName();
                if (string.equals("initialCost")) {
                    stateInfo.initialCost = this.getTextDouble((Element)node);
                    continue;
                }
                if (string.equals("finalCost")) {
                    stateInfo.finalCost = this.getTextDouble((Element)node);
                    continue;
                }
                if (string.equals("transitions")) {
                    this.readTransitions((Element)node, stateInfo);
                    continue;
                }
                throw new RuntimeException("Unexpected tag " + string);
            }
            if (!(node instanceof Text)) continue;
            this.assertEmptyText(node);
        }
        return stateInfo;
    }

    void readTransitions(Element element, StateInfo stateInfo) {
        NodeList nodeList = element.getElementsByTagName("transition");
        stateInfo.destinationNames = new String[nodeList.getLength()];
        stateInfo.labelNames = new String[nodeList.getLength()];
        stateInfo.weightNames = new String[nodeList.getLength()][];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            stateInfo.destinationNames[i] = this.getAttrib(element2, "destination");
            stateInfo.labelNames[i] = this.getAttrib(element2, "label");
            String string = this.getAttrib(element2, "weightGroups");
            String[] stringArray = string.split("\\s+");
            stateInfo.weightNames[i] = new String[stringArray.length];
            for (int j = 0; j < stringArray.length; ++j) {
                stateInfo.weightNames[i][j] = stringArray[j];
            }
        }
    }

    void readWeightGroups(Element element) {
        this.weightGroupInfoList = new ArrayList<WeightGroupInfo>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                String string = node.getNodeName();
                if (string.equals("weightGroup")) {
                    this.weightGroupInfoList.add(this.readWeightGroup((Element)node));
                    continue;
                }
                throw new RuntimeException("Unexpected tag " + string);
            }
            if (!(node instanceof Text)) continue;
            this.assertEmptyText(node);
        }
    }

    WeightGroupInfo readWeightGroup(Element element) {
        WeightGroupInfo weightGroupInfo = new WeightGroupInfo();
        weightGroupInfo.name = this.getName(element);
        weightGroupInfo.featureSelectionRegex = this.getAttrib(element, "features");
        return weightGroupInfo;
    }

    private String getName(Element element) {
        return this.getAttrib(element, "name");
    }

    private String getAttrib(Element element, String string) {
        if (!element.hasAttribute(string)) {
            throw new RuntimeException("Expected " + string + " for " + element);
        }
        return element.getAttribute(string);
    }

    private int getAttribInt(Element element, String string) {
        try {
            return Integer.parseInt(this.getAttrib(element, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Bad value for " + string);
        }
    }

    private double getAttribDouble(Element element, String string) {
        if (this.getAttrib(element, string).equals("+inf")) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            return Double.parseDouble(this.getAttrib(element, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Bad value for " + string);
        }
    }

    private void assertEmptyText(Node node) {
        if (!node.getNodeValue().trim().equals("")) {
            throw new RuntimeException("Unexpected text " + node);
        }
    }

    private double getTextDouble(Node node) {
        try {
            return Double.parseDouble(this.getText(node));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Bad value for " + node);
        }
    }

    private int getTextInt(Node node) {
        try {
            return Integer.parseInt(this.getText(node));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Bad value for " + node);
        }
    }

    private boolean getTextBoolean(Node node) {
        try {
            return Boolean.parseBoolean(this.getText(node));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Bad value for " + node);
        }
    }

    private String getText(Node node) {
        if (node.getChildNodes().getLength() != 1 || node.getFirstChild() == null || !(node.getFirstChild() instanceof Text)) {
            throw new RuntimeException("Expected value for " + node);
        }
        return ((Text)node.getFirstChild()).getNodeValue();
    }

    private Element getElementByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            throw new RuntimeException("Expected to find " + string);
        }
        if (nodeList.getLength() == 1) {
            return (Element)nodeList.item(0);
        }
        throw new RuntimeException("Multiple " + string + " elements");
    }

    private String ljust(String string, int n) {
        while (string.length() < n) {
            string = string + " ";
        }
        return string;
    }

    void display(PrintStream printStream) {
        Object object;
        printStream.println("CRF [" + this.uri + "]");
        printStream.println("  gaussian variance  = " + this.gaussianVariance);
        printStream.println("  default label      = '" + this.defaultLabel + "'");
        Iterator<Object> iterator = this.stateInfoList.iterator();
        printStream.println("\n  States & Transitions\n  ~~~~~~~~~~~~~~~~~~~~");
        while (iterator.hasNext()) {
            object = iterator.next();
            printStream.print("    " + this.ljust("[" + ((StateInfo)object).name + "]", 22));
            printStream.print(" (initial cost = " + ((StateInfo)object).initialCost);
            printStream.println(", final cost = " + ((StateInfo)object).finalCost + ")");
            for (int i = 0; i < ((StateInfo)object).destinationNames.length; ++i) {
                printStream.print("      -> ");
                printStream.print(this.ljust("[" + ((StateInfo)object).destinationNames[i] + "]", 20));
                printStream.print(" (label='" + ((StateInfo)object).labelNames[i] + "'");
                printStream.print(", weightGroups=[");
                for (int j = 0; j < ((StateInfo)object).weightNames[i].length; ++j) {
                    printStream.print(((StateInfo)object).weightNames[i][j]);
                    if (j >= ((StateInfo)object).weightNames[i].length - 1) continue;
                    printStream.print(", ");
                }
                printStream.println("])");
            }
        }
        iterator = this.weightGroupInfoList.iterator();
        printStream.println("\n  Weight Groups\n  ~~~~~~~~~~~~~~~~~");
        while (iterator.hasNext()) {
            object = (WeightGroupInfo)iterator.next();
            printStream.print("    " + this.ljust(((WeightGroupInfo)object).name, 22));
            printStream.println(" (features=/" + ((WeightGroupInfo)object).featureSelectionRegex + "/)");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        CRFInfo cRFInfo = new CRFInfo(stringArray[0]);
        cRFInfo.display(System.out);
    }

    public class WeightGroupInfo {
        public String name;
        public String featureSelectionRegex;
    }

    public class StateInfo {
        public String name;
        public double initialCost = 0.0;
        public double finalCost = 0.0;
        public String[] destinationNames;
        public String[] labelNames;
        public String[][] weightNames;
    }
}

