/***********************************************************************************
* Smooth Tasks
* Copyright (C) 2012 Toni Dietze <smooth-tasks@derflupp.e4ward.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#include "AnimationThrowPoint.h"

#include <QPointF>

namespace SmoothTasks {

AnimationThrowPoint::AnimationThrowPoint(QObject* parent)
	: AnimationThrow<2, QPointF>(parent)
{}

AnimationThrowPoint::AnimationThrowPoint(QObject* target, const QByteArray& propertyName, QObject* parent)
	: AnimationThrow<2, QPointF>(target, propertyName, parent)
{}

AnimationThrowPoint::~AnimationThrowPoint() {
}

QPointF AnimationThrowPoint::convert(const qreal src[]) const {
	return QPointF(src[0], src[1]);
}

void AnimationThrowPoint::convert(const QPointF& src, qreal dst[]) const {
	dst[0] = src.x();
	dst[1] = src.y();
}

} // namespace SmoothTasks
