/***********************************************************************************
* Smooth Tasks
* Copyright (C) 2012 Toni Dietze <smooth-tasks@derflupp.e4ward.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef ANIMATIONVARIANT_H
#define ANIMATIONVARIANT_H

#include <QVariantAnimation>

namespace SmoothTasks {

/** Actually, this class does not implement anything. Its only purpose is to
 * make QVariantAnimation intantiable, if a QPropertyAnimation is not needed.
 * To get informed about the ongoing animation, connect to the valueChanged
 * slot.
 */
class AnimationVariant : public QVariantAnimation
{
	Q_OBJECT

public:
	AnimationVariant(QObject* parent = 0);

protected:
	/* implement */ virtual void updateCurrentValue(const QVariant& value);
};

} // namespace SmoothTasks

#endif // ANIMATIONVARIANT_H
