/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.util.EventObject;
import weka.core.Instances;

public class TrainingSetEvent
extends EventObject {
    private static final long serialVersionUID = 5872343811810872662L;
    protected Instances m_trainingSet;
    private boolean m_structureOnly;
    protected int m_runNumber = 1;
    protected int m_maxRunNumber = 1;
    protected int m_setNumber;
    protected int m_maxSetNumber;

    public TrainingSetEvent(Object source, Instances trainSet) {
        super(source);
        this.m_trainingSet = trainSet;
        if (this.m_trainingSet != null && this.m_trainingSet.numInstances() == 0) {
            this.m_structureOnly = true;
        }
    }

    public TrainingSetEvent(Object source, Instances trainSet, int setNum, int maxSetNum) {
        this(source, trainSet);
        this.m_setNumber = setNum;
        this.m_maxSetNumber = maxSetNum;
    }

    public TrainingSetEvent(Object source, Instances trainSet, int runNum, int maxRunNum, int setNum, int maxSetNum) {
        this(source, trainSet, setNum, maxSetNum);
        this.m_runNumber = runNum;
        this.m_maxRunNumber = maxRunNum;
    }

    public Instances getTrainingSet() {
        return this.m_trainingSet;
    }

    public int getRunNumber() {
        return this.m_runNumber;
    }

    public int getMaxRunNumber() {
        return this.m_maxRunNumber;
    }

    public int getSetNumber() {
        return this.m_setNumber;
    }

    public int getMaxSetNumber() {
        return this.m_maxSetNumber;
    }

    public boolean isStructureOnly() {
        return this.m_structureOnly;
    }
}

