#include "drmdatainput.h"
#include "qsstvglobal.h"
#include "dsp/filter.h"
#include "dsp/downsamplefilter.h"
#include "drm.h"
#include "drmproto.h"
#include "sound/soundio.h"
#include "utils/supportfunctions.h"
#include "dsp/filterparam.h"


#define FILTERLENGTH 8
//#define HILBERT83
#define HILBERT151
//#define HILBERT360
#ifdef HILBERT83
#define HILBERTTAPS 83
#endif

#ifdef HILBERT151
#define HILBERTTAPS 151
#endif

#ifdef HILBERT360
#define HILBERTTAPS 360
#endif

//static float subfilt1[FILTERLENGTH] =

//{
//  -6.304691e-004,
//  2.369513e-003,
//  -9.174512e-003,
//  3.102797e-002,
//  2.437302e-001,
//  -2.230165e-002,
//  6.759297e-003,
//  -1.587494e-003
//};


//static float subfilt2[FILTERLENGTH] =
//{
//  -1.818568e-003,
//  8.332497e-003,
//  -2.973091e-002,
//  1.111435e-001,
//  1.924554e-001,
//  -3.981645e-002,
//  1.180361e-002,
//  -2.561942e-003
//};

//static float subfilt3[FILTERLENGTH] =
//{
//  -2.561942e-003,
//  1.180361e-002,
//  -3.981645e-002,
//  1.924554e-001,
//  1.111435e-001,
//  -2.973091e-002,
//  8.332497e-003,
//  -1.818568e-003
//};

//static float subfilt4[FILTERLENGTH] =
//{
//  -1.587494e-003,
//  6.759297e-003,
//  -2.230165e-002,
//  2.437302e-001,
//  3.102797e-002,
//  -9.174512e-003,
//  2.369513e-003,
//  -6.304691e-004
//};

//static float B_Inphase[HILBERTTAPS] =
//{
//  -0.000013096429498,
//  0.000000663887755,
//  -0.000069635287780,
//  -0.000011931707517,
//  -0.000144533153108,
//  -0.000025373980217,
//  -0.000391789228659,
//  -0.000232426477943,
//  -0.000478143393960,
//  -0.000487558968789,
//  -0.000685650336825,
//  -0.001354704880460,
//  -0.000546201344479,
//  -0.002342397998132,
//  -0.000346673289958,
//  -0.004288405547670,
//  0.000076514567549,
//  -0.006214057213030,
//  0.000471140764452,
//  -0.008869259301553,
//  0.000310928936475,
//  -0.010853542810835,
//  -0.000618723760850,
//  -0.012558669622822,
//  -0.003528318293013,
//  -0.012565638823234,
//  -0.008458796942648,
//  -0.010998473138919,
//  -0.016909533624041,
//  -0.007029340421051,
//  -0.028648813220546,
//  -0.000916074544044,
//  -0.045239295406484,
//  0.007126861010101,
//  -0.067146558987974,
//  0.016470713456071,
//  -0.099200587662524,
//  0.025927955112860,
//  -0.157545675961710,
//  0.034759206835915,
//  -0.403756659009051,
//  0.872044314623357,
//  0.298152956415124,
//  0.045762401414113,
//  0.057682372386628,
//  0.046612304642337,
//  0.009812557897304,
//  0.044738697480695,
//  -0.007877026958678,
//  0.039793922738241,
//  -0.014019542011307,
//  0.033363547774391,
//  -0.014228247558443,
//  0.025586601071249,
//  -0.011722710151015,
//  0.018169441690637,
//  -0.007774072820479,
//  0.011227152592688,
//  -0.004254206945683,
//  0.005868718139545,
//  -0.001002308783387,
//  0.001901375136305,
//  0.000729336127630,
//  -0.000472570900136,
//  0.001969539594901,
//  -0.001560255803054,
//  0.001905716822635,
//  -0.001878235948282,
//  0.001813958429404,
//  -0.001475079548897,
//  0.001117144708583,
//  -0.001143142395249,
//  0.000739068897549,
//  -0.000539580485663,
//  0.000277728151810,
//  -0.000341625345467,
//  0.000100860733753,
//  -0.000052333537017,
//  0.000001973643242,
//  -0.000040013168559,
//  -0.000013316614262,
//  0.000006340573991,
//  -0.000004973750149
//};

//static float B_Quad[HILBERTTAPS] =
//  { 0.000000000000000, -0.000006581551523, -0.000014192774668,
//0.000038355453153, -0.000061469802717, 0.000046155098672,
//  -0.000269873790862, 0.000273874035623, -0.000496517495085,
//    0.000383120218360, -0.001080412050939, 0.000679569009380,
//    -0.001431859472243,
//  0.000632904747289, -0.002103194937170, 0.000269803608080,
//    -0.002028650339142, -0.000864482682011, -0.001935633229621,
//    -0.003130320749406,
//  -0.000660757624173, -0.006511157948451, 0.000829477180331,
//    -0.011499838339182, 0.003150251021340, -0.017295118095470,
//    0.004931046332886,
//  -0.024156288476640, 0.005730140929231, -0.030544691199518,
//    0.003619186767370, -0.036441773169957, -0.003417440897749,
//    -0.040091021199004,
//  -0.019051201727783, -0.041600273509535, -0.051332869304505,
//    -0.039743071204460, -0.127032560999817, -0.035198771562362,
//    -0.488057960837085,
//  -0.584664836150859, 0.558860293285832, -0.018787192344116,
//    0.193986224985834, -0.008891772659445, 0.111263353226189,
//    0.000562232648398,
//  0.069350999397921, 0.008632835092782, 0.043147713646936,
//    0.014687263334153, 0.025127872636149, 0.018102917799341,
//    0.013466436394485,
//  0.019348490199617, 0.005952331932605, 0.018192510371929,
//    0.002067567347773, 0.015985137219339, 0.000257349155187,
//    0.012513166744168,
//  -0.000036691339210, 0.009393580004274, 0.000299271454802,
//    0.006076795140808, 0.000699657108499, 0.003864640455567,
//    0.001119449029703,
//  0.001926535004930, 0.001049068709402, 0.000995120503174,
//    0.001044597409952, 0.000305528639009, 0.000630886520545,
//    0.000111000803475,
//  0.000464927709514, 0.000005944149118, 0.000157049271650,
//    -0.000003528848644, 0.000069808136642, 0.000001885388254,
//    0.000012115208419,
//};

#ifdef HILBERT83

// blFIR  Hilbert
// localSamplingrate = 12000.000000
// number of taps = 83
// corner frequency = 1000.000000
// beta = 0.500000
// window applied
//Coefficients:
const FILTERPARAMTYPE hilbert[HILBERTTAPS]=
{

     0.00195121951219512,
     0,
     0.00218951295028307,
     0,
     0.00274155836904681,
     0,
     0.00365039553708327,
     0,
     0.00496219678931242,
     0,
     0.00672774409495607,
     0,
     0.00900470037777058,
     0,
     0.01186106975868,
     0,
     0.0153804894372836,
     0,
     0.0196704386862718,
     0,
     0.024875273452504,
     0,
     0.0311975987201718,
     0,
     0.0389347935888508,
     0,
     0.0485447715399211,
     0,
     0.0607723902308125,
     0,
     0.0769136201887418,
     0,
     0.0994316691908993,
     0,
     0.13362885988773,
     0,
     0.193330225501393,
     0,
     0.329299964994593,
     0,
     0.998650268544521,
     0,
     -0.998650268544521,
     0,
     -0.329299964994593,
     0,
     -0.193330225501393,
     0,
     -0.13362885988773,
     0,
     -0.0994316691908993,
     0,
     -0.0769136201887418,
     0,
     -0.0607723902308125,
     0,
     -0.0485447715399211,
     0,
     -0.0389347935888508,
     0,
     -0.0311975987201718,
     0,
     -0.024875273452504,
     0,
     -0.0196704386862718,
     0,
     -0.0153804894372836,
     0,
     -0.01186106975868,
     0,
     -0.00900470037777058,
     0,
     -0.00672774409495607,
     0,
     -0.00496219678931242,
     0,
     -0.00365039553708327,
     0,
     -0.00274155836904681,
     0,
     -0.00218951295028307,
     0,
     -0.00195121951219512
  };
#endif

#ifdef HILBERT151

// blFIR  Hilbert
// localSamplingrate = 12000.000000
// number of taps = 151
// corner frequency = 1000.000000
// beta = 0.500000
// window applied
//Coefficients:

const FILTERPARAMTYPE hilbert[HILBERTTAPS]=
{
     0.00106666666666667,
     0,
     0.00111799020198943,
     0,
     0.00121749046405025,
     0,
     0.00136886588233087,
     0,
     0.00157592342822028,
     0,
     0.00184260137668314,
     0,
     0.00217299884412417,
     0,
     0.00257141359464515,
     0,
     0.00304238999373074,
     0,
     0.00359077949800265,
     0,
     0.00422181674681683,
     0,
     0.00494121522949637,
     0,
     0.00575528773156199,
     0,
     0.00667109844581354,
     0,
     0.00769665596238367,
     0,
     0.0088411596130561,
     0,
     0.0101153162732349,
     0,
     0.0115317513868608,
     0,
     0.0131055477183722,
     0,
     0.0148549598147661,
     0,
     0.0168023740886606,
     0,
     0.0189756183245283,
     0,
     0.0214097779833233,
     0,
     0.0241497635092426,
     0,
     0.0272540175599975,
     0,
     0.0308,
     0,
     0.0348925322232539,
     0,
     0.0396769064421141,
     0,
     0.045360270349271,
     0,
     0.0522481015058711,
     0,
     0.0608098544941651,
     0,
     0.0718051968979872,
     0,
     0.0865479463372845,
     0,
     0.107521909278733,
     0,
     0.140052424123536,
     0,
     0.19798957926751,
     0,
     0.332124254201553,
     0,
     0.999596501845475,
     0,
     -0.999596501845475,
     0,
     -0.332124254201553,
     0,
     -0.19798957926751,
     0,
     -0.140052424123536,
     0,
     -0.107521909278733,
     0,
     -0.0865479463372845,
     0,
     -0.0718051968979872,
     0,
     -0.0608098544941651,
     0,
     -0.0522481015058711,
     0,
     -0.045360270349271,
     0,
     -0.0396769064421141,
     0,
     -0.0348925322232539,
     0,
     -0.0308,
     0,
     -0.0272540175599975,
     0,
     -0.0241497635092426,
     0,
     -0.0214097779833233,
     0,
     -0.0189756183245283,
     0,
     -0.0168023740886606,
     0,
     -0.0148549598147661,
     0,
     -0.0131055477183722,
     0,
     -0.0115317513868608,
     0,
     -0.0101153162732349,
     0,
     -0.0088411596130561,
     0,
     -0.00769665596238367,
     0,
     -0.00667109844581354,
     0,
     -0.00575528773156199,
     0,
     -0.00494121522949637,
     0,
     -0.00422181674681683,
     0,
     -0.00359077949800265,
     0,
     -0.00304238999373074,
     0,
     -0.00257141359464515,
     0,
     -0.00217299884412417,
     0,
     -0.00184260137668314,
     0,
     -0.00157592342822028,
     0,
     -0.00136886588233087,
     0,
     -0.00121749046405025,
     0,
     -0.00111799020198943,
     0,
     -0.00106666666666667
  };
#endif

#ifdef HILBERT360

// blFIR  Hilbert
// localSamplingrate = 12000.000000
// number of taps = 360
// corner frequency = 8000.000000
// beta = 1.000000
// window applied
//Coefficients:

const FILTERPARAMTYPE hilbert[HILBERTTAPS]=
{
   0.000447320955694772,
   0,
   0.000455558927413046,
   0,
   0.000467201131289238,
   0,
   0.000482357657235191,
   0,
   0.000501139723312327,
   0,
   0.000523659757475149,
   0,
   0.000550031490215828,
   0,
   0.000580370059009746,
   0,
   0.000614792125543957,
   0,
   0.000653416006801779,
   0,
   0.000696361821178391,
   0,
   0.000743751650915635,
   0,
   0.000795709722270862,
   0,
   0.000852362604976147,
   0,
   0.000913839432702755,
   0,
   0.000980272146423472,
   0,
   0.00105179576276502,
   0,
   0.0011285486696673,
   0,
   0.001210672951919,
   0,
   0.0012983147494246,
   0,
   0.00139162465137996,
   0,
   0.00149075812989859,
   0,
   0.00159587601704457,
   0,
   0.00170714502969781,
   0,
   0.00182473834721175,
   0,
   0.00194883624743331,
   0,
   0.0020796268073506,
   0,
   0.0022173066754303,
   0,
   0.00236208192361964,
   0,
   0.00251416898803742,
   0,
   0.00267379570858608,
   0,
   0.00284120247911163,
   0,
   0.00301664352135053,
   0,
   0.00320038829777273,
   0,
   0.00339272308060342,
   0,
   0.00359395269683864,
   0,
   0.00380440247202873,
   0,
   0.00402442039907038,
   0,
   0.00425437956232035,
   0,
   0.00449468085214296,
   0,
   0.00474575601067502,
   0,
   0.0050080710563162,
   0,
   0.00528213014245216,
   0,
   0.00556847991546485,
   0,
   0.00586771444852104,
   0,
   0.00618048084138014,
   0,
   0.00650748559305694,
   0,
   0.00684950187428514,
   0,
   0.00720737785119832,
   0,
   0.00758204624155527,
   0,
   0.00797453532156124,
   0,
   0.00838598164664784,
   0,
   0.00881764480575967,
   0,
   0.00927092459873636,
   0,
   0.00974738111417594,
   0,
   0.0102487582958671,
   0,
   0.0107770117263209,
   0,
   0.0113343415352682,
   0,
   0.0119232315715625,
   0,
   0.0125464962755426,
   0,
   0.0132073370786259,
   0,
   0.0139094106696869,
   0,
   0.0146569121483854,
   0,
   0.015454676997362,
   0,
   0.0163083070387749,
   0,
   0.0172243272273486,
   0,
   0.0182103824647697,
   0,
   0.019275486886001,
   0,
   0.0204303427008687,
   0,
   0.0216877523409707,
   0,
   0.0230631574055806,
   0,
   0.0245753523839949,
   0,
   0.0262474430643373,
   0,
   0.028108153434625,
   0,
   0.0301936384591154,
   0,
   0.0325500469449935,
   0,
   0.0352372234345217,
   0,
   0.0383341869762954,
   0,
   0.0419474683535509,
   0,
   0.0462242114069099,
   0,
   0.0513735488362621,
   0,
   0.0577030667580263,
   0,
   0.0656844408554181,
   0,
   0.0760796596826624,
   0,
   0.0902049460455389,
   0,
   0.110546573465011,
   0,
   0.142432367889117,
   0,
   0.199714813347055,
   0,
   0.333186579940791,
   0,
   0.999982386895462,
   0,
   -0.999982386895462,
   0,
   -0.333186579940791,
   0,
   -0.199714813347055,
   0,
   -0.142432367889117,
   0,
   -0.110546573465011,
   0,
   -0.0902049460455389,
   0,
   -0.0760796596826624,
   0,
   -0.0656844408554181,
   0,
   -0.0577030667580263,
   0,
   -0.0513735488362621,
   0,
   -0.0462242114069099,
   0,
   -0.0419474683535509,
   0,
   -0.0383341869762954,
   0,
   -0.0352372234345217,
   0,
   -0.0325500469449935,
   0,
   -0.0301936384591154,
   0,
   -0.028108153434625,
   0,
   -0.0262474430643373,
   0,
   -0.0245753523839949,
   0,
   -0.0230631574055806,
   0,
   -0.0216877523409707,
   0,
   -0.0204303427008687,
   0,
   -0.019275486886001,
   0,
   -0.0182103824647697,
   0,
   -0.0172243272273486,
   0,
   -0.0163083070387749,
   0,
   -0.015454676997362,
   0,
   -0.0146569121483854,
   0,
   -0.0139094106696869,
   0,
   -0.0132073370786259,
   0,
   -0.0125464962755426,
   0,
   -0.0119232315715625,
   0,
   -0.0113343415352682,
   0,
   -0.0107770117263209,
   0,
   -0.0102487582958671,
   0,
   -0.00974738111417594,
   0,
   -0.00927092459873636,
   0,
   -0.00881764480575967,
   0,
   -0.00838598164664784,
   0,
   -0.00797453532156124,
   0,
   -0.00758204624155527,
   0,
   -0.00720737785119832,
   0,
   -0.00684950187428514,
   0,
   -0.00650748559305694,
   0,
   -0.00618048084138014,
   0,
   -0.00586771444852104,
   0,
   -0.00556847991546485,
   0,
   -0.00528213014245216,
   0,
   -0.0050080710563162,
   0,
   -0.00474575601067502,
   0,
   -0.00449468085214296,
   0,
   -0.00425437956232035,
   0,
   -0.00402442039907038,
   0,
   -0.00380440247202873,
   0,
   -0.00359395269683864,
   0,
   -0.00339272308060342,
   0,
   -0.00320038829777273,
   0,
   -0.00301664352135053,
   0,
   -0.00284120247911163,
   0,
   -0.00267379570858608,
   0,
   -0.00251416898803742,
   0,
   -0.00236208192361964,
   0,
   -0.0022173066754303,
   0,
   -0.0020796268073506,
   0,
   -0.00194883624743331,
   0,
   -0.00182473834721175,
   0,
   -0.00170714502969781,
   0,
   -0.00159587601704457,
   0,
   -0.00149075812989859,
   0,
   -0.00139162465137996,
   0,
   -0.0012983147494246,
   0,
   -0.001210672951919,
   0,
   -0.0011285486696673,
   0,
   -0.00105179576276502,
   0,
   -0.000980272146423472,
   0,
   -0.000913839432702755,
   0,
   -0.000852362604976147,
   0,
   -0.000795709722270862,
   0,
   -0.000743751650915635,
   0,
   -0.000696361821178391,
   0,
   -0.000653416006801779,
   0,
   -0.000614792125543957,
   0,
   -0.000580370059009746,
   0,
   -0.000550031490215828,
   0,
   -0.000523659757475149,
   0,
   -0.000501139723312327,
   0,
   -0.000482357657235191,
   0,
   -0.000467201131289238,
   0,
   -0.000455558927413046,
   0,
   -0.000447320955694772,
   0
};
#endif


//double lowpass[4*FILTERLENGTH];

drmDataInput::drmDataInput(int blockSize)
{
  iqFilter=NULL;
  init(blockSize);
}

drmDataInput::~drmDataInput()
{
//  delete downFilter;
  delete iqFilter;
}

void drmDataInput::init(int blockSize)
{

  if(iqFilter) delete iqFilter;
  iqFilter=new filter(0,hilbert,HILBERTTAPS,0,48000,false,1);
  inputResampler.init(blockSize);
  iterationCounter=0;
}


unsigned int drmDataInput::getData(DSPFLOAT *inputBuf,DSPFLOAT *outputBuf,DSPFLOAT rRation)
{
  int processedSamples;
  inputResampler.resample(rRation,inputBuf);
  processedSamples=inputResampler.rxBuffer.count();
  inputResampler.rxBuffer.copy(outputBuf,processedSamples);
  inputResampler.rxBuffer.skip(processedSamples);
  iqFilter->processIQ(inputBuf,outputBuf,processedSamples);
  return (processedSamples);
}



