% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWeights.R
\name{getWeights}
\alias{getWeights}
\title{Optimize weights for model averaging.}
\usage{
getWeights(models)
}
\arguments{
\item{models}{An list object containing all considered candidate models fitted by
\code{\link[lme4]{lmer}} of the lme4-package or of class
\code{\link[nlme]{lme}}.}
}
\value{
An updated object containing a vector of weights for the underlying candidate models, value
of the object given said weights as well as the time needed.
}
\description{
Function to constructed an optimal vector of weights for model averaging of
Linear Mixed Models based on the proposal of Zhang et al. (2014) of using Stein's Formular
to derive a suitable criterion based on the conditional Akaike Information Criterion as
proposed by Greven and Kneib. The underlying optimization used is a customized version
of the Augmented Lagrangian Method.
}
\section{WARNINGS }{
 For models called via \code{gamm4} or \code{gamm}
no weight determination via this function is currently possible.
}

\examples{
data(Orthodont, package = "nlme")
models <- list(
    model1 <- lmer(formula = distance ~ age + Sex + (1 | Subject) + age:Sex,
               data = Orthodont),
    model2 <- lmer(formula = distance ~ age + Sex + (1 | Subject),
               data = Orthodont),
    model3 <- lmer(formula = distance ~ age + (1 | Subject),
                 data = Orthodont),
    model4 <- lmer(formula = distance ~ Sex + (1 | Subject),
                data = Orthodont))

foo <- getWeights(models = models)
foo


}
\references{
Greven, S. and Kneib T. (2010) On the behaviour of marginal and
conditional AIC in linear mixed models. Biometrika 97(4), 773-789.

Zhang, X., Zou, G., & Liang, H. (2014). Model averaging and
weight choice in linear mixed-effects models. Biometrika, 101(1), 205-218.

Nocedal, J., & Wright, S. (2006). Numerical optimization.
Springer Science & Business Media.
}
\seealso{
\code{\link[lme4]{lme4-package}}, \code{\link[lme4]{lmer}},
\code{\link[lme4]{getME}}
}
\author{
Benjamin Saefken & Rene-Marcel Kruse
}
