// Copyright (C) 2025 EDF
// All Rights Reserved
// This code is published under the GNU Lesser General Public License (GNU LGPL)
#pragma once
#include "geners/GenericIO.hh"
#include "geners/listIO.hh"
#include "geners/vectorIO.hh"
#include "geners/arrayIO.hh"
#include "StOpt/core/grids/GridAdaptBaseGeners.h"
#include "StOpt/core/grids/GridAdapt1D.h"
#include "StOpt/core/grids/Mesh1DGeners.h"

/** \file GridAdapt1DGeners.h
 *  \brief Define non intrusive serialization with random access
*  \author Pierre Gruet
 */

// Concrete reader/writer for classGridAdapt1D
// Note publication of  as "wrapped_type".
struct GridAdapt1DGeners: public gs::AbsReaderWriter<StOpt::GridAdaptBase>
{
    typedef StOpt::GridAdaptBase wrapped_base;
    typedef StOpt::GridAdapt1D wrapped_type;

    // Methods that have to be overridden from the base
    bool write(std::ostream &, const wrapped_base &, bool p_dumpId) const override;
    wrapped_type *read(const gs::ClassId &p_id, std::istream &p_in) const override;

    // The class id forGridAdapt1D  will be needed both in the "read" and "write"
    // methods. Because of this, we will just return it from one static
    // function.
    static const gs::ClassId &wrappedClassId();
};

gs_specialize_class_id(StOpt::GridAdapt1D, 1)
gs_declare_type_external(StOpt::GridAdapt1D)
gs_associate_serialization_factory(StOpt::GridAdapt1D, StaticSerializationFactoryForGridAdaptBase)



