/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* help.c by Gopal Narayanan
 * This file contains help menu widgets
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <config.h>
#include "help.h"

/* 
 * pops up the help window
 */

void 
helpCB (gpointer DATA)
{
  char *help_txt;
  GtkWidget *vbox;
  GtkWidget *scrolled_win;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *helpwin;

  
  /* allocate memory for the Help text */
  
  if ((help_txt = (char *) malloc(2000*sizeof(char)))  == NULL){
    perror("help text error: malloc");
    return;
  } else {
    sprintf(help_txt, "\n TRANSCALC %s\n",VERSION);
    strcat(help_txt, HELPTEXT);
  }

  helpwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (helpwin), "Help");
  gtk_signal_connect (GTK_OBJECT (helpwin), "destroy",
                        GTK_SIGNAL_FUNC(gtk_widget_destroyed),
                        &helpwin);
  gtk_container_border_width (GTK_CONTAINER (helpwin), 5);
  
  gtk_widget_set_usize (helpwin, 650, 400);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (helpwin), vbox);
  gtk_widget_show(vbox);

  /* scrolled window will contain help text */
  scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_border_width(GTK_CONTAINER(scrolled_win), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                                     GTK_POLICY_AUTOMATIC,
                                     GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (vbox), scrolled_win, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_win);
  
  /* put help text into label */
  label = gtk_label_new(help_txt);
  gtk_signal_connect (GTK_OBJECT (label), "destroy",
                          GTK_SIGNAL_FUNC (gtk_widget_destroyed), &label);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);

  /* gtk_container_add(GTK_CONTAINER(scrolled_win), label);*/
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_win), 
					 label);
  gtk_widget_show (label);
  

  /* Finally the dismiss button */
  button = gtk_button_new_with_label ("Dismiss");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT (helpwin));
  gtk_box_pack_end(GTK_BOX(vbox), button, FALSE, FALSE, 0);
  gtk_widget_show(button);
  gtk_widget_show (helpwin);
  free(help_txt);

}

/* 
 * pops up the about window
 */

void 
aboutCB (gpointer DATA)
{
  char *about_txt;
  GtkWidget *vbox;
  GtkWidget *scrolled_win;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *aboutwin;

  
  /* allocate memory for the Help text */
  
  if ((about_txt = (char *) malloc(2000*sizeof(char)))  == NULL){
    perror("about text error: malloc");
    return;
  } else {
    sprintf(about_txt, "\n TRANSCALC %s\n",VERSION);
    strcat(about_txt, ABOUTTEXT);
  }

  aboutwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (aboutwin), "About");
  gtk_signal_connect (GTK_OBJECT (aboutwin), "destroy",
                        GTK_SIGNAL_FUNC(gtk_widget_destroyed),
                        &aboutwin);
  gtk_container_border_width (GTK_CONTAINER (aboutwin), 5);
  
  gtk_widget_set_usize (aboutwin, 500, 350);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (aboutwin), vbox);
  gtk_widget_show(vbox);

  /* scrolled window will contain about text */
  scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_border_width(GTK_CONTAINER(scrolled_win), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                                     GTK_POLICY_AUTOMATIC,
                                     GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (vbox), scrolled_win, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_win);
  
  /* put about text into label */
  label = gtk_label_new(about_txt);
  gtk_signal_connect (GTK_OBJECT (label), "destroy",
                          GTK_SIGNAL_FUNC (gtk_widget_destroyed), &label);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  /* gtk_container_add (GTK_CONTAINER (scrolled_win), label);*/
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_win), 
					 label);
  gtk_widget_show (label);
  

  /* Finally the dismiss button */
  button = gtk_button_new_with_label ("Dismiss");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT (aboutwin));
  gtk_box_pack_end(GTK_BOX(vbox), button, FALSE, FALSE, 0);
  gtk_widget_show(button);
  gtk_widget_show (aboutwin);
  free(about_txt);

}


