/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_combo.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb2/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBCombo
// put vdk class name to corresponding widget
#define VDK_ANCESTOR  VDKCombo
// put here vdk class name string
#define VDK_CLASS "VDKCombo"
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "combo"

extern char *wi_widget_prompts[];
static char buff[128];
// used to autogenerate default
int CLASS::Counter = 0;

//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
///////////////////////////////////////////////////
/* 
 properties names
 */
char* vdkcombo_props[] =
{ EDITABLE,SORTED,HIDDEN,CASESENSITIVE,0 };
/*
entry widget signal names && nicknames
Default response method name will be made by:
On<object name><nickname>.
For instance if object name = <Abutton> and nickname = <Click>
default response method name will be: <OnAbuttonClick>
*/
char* vdkcombo_signals[] =
{
SIGNAL_ACTIVATE,SIGNAL_CHANGED,
SIGNAL_SELECTION_CHANGED ,SIGNAL_FOCUS_IN, 
SIGNAL_FOCUS_OUT,0
};
char* vdkcombo_nicknames[] =
{
NICK_ACTIVATE,NICK_CHANGED,
NICK_SELECTION_CHANGED,NICK_FOCUS_IN,
NICK_FOCUS_OUT,0
};

/*
 */
int
EntryButtonPressed(GtkWidget * wid,
		   GdkEvent * ev,
		   gpointer p)
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(wid),
			       "button_press_event");
  // proceed to upper level
  return false;
}
//////////////////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDK_ANCESTOR(owner),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties 
  for(t=0; vdkcombo_props[t]; t++)
    proplist.add(VDKBProperty(vdkcombo_props[t]));
  // add to VDKBObject signal list
  for(t=0; vdkcombo_signals[t]; t++)
    siglist.add(VDKBSignal(vdkcombo_signals[t],
			   this,
			   vdkcombo_nicknames[t]));
  //
  CONNECT_COMMON_EVENTS;
  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(widget)->entry),
		       "button_press_event",
		       GTK_SIGNAL_FUNC(::EntryButtonPressed),
		       (gpointer) this);
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s\"%s\";",
	  PROP_EDITABLE,
	  (char*) GetProp(EDITABLE));
  fprintf(fp,"\n\t%s%s;",
	  PROP_HIDDEN,
	  (char*) GetProp(HIDDEN));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SORTED,
	  (char*) GetProp(SORTED));
  fprintf(fp,"\n\t%s%s;",
	  PROP_CASESENSITIVE,
	  (char*) GetProp(CASESENSITIVE));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* combo;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    // actually makes widget
    combo = new CLASS(buff,owner);
 // add widget to form
  return owner->AddToSelf(combo,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return NULL;
  source = new char[4096];
  sprintf(tmp,"\n%s = new %s(this);",obj_name,VDK_CLASS);
  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);

  if(props)
    {
      strcat(source,props);
      delete props;
    }
  // set widget specific properties
  if(parser.GetParam(arg,buffer,PROP_EDITABLE) && 
     strcmp(arg,NIHIL_PROP))
    {
      sprintf(tmp,"\n%s->%s = %s;", obj_name, EDITABLE, arg);
      strcat(source,tmp);
    }    
  if(parser.GetParam(arg,buffer, PROP_HIDDEN) && 
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = %s;",obj_name,HIDDEN,arg);
     strcat(source,tmp);
   }
  if(parser.GetParam(arg,buffer,PROP_SORTED) && 
     strcmp(arg,NIHIL_PROP))
    {
      sprintf(tmp,"\n%s->%s = %s;",obj_name,SORTED,arg);
      strcat(source,tmp);
    }    
  // 
  if(parser.GetParam(arg,buffer, PROP_CASESENSITIVE) && 
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = %s;",obj_name,CASESENSITIVE,arg);
     strcat(source,tmp);
   }        
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  CLASS* combo;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return false;
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      combo = new CLASS(obj_name,owner);
      if(parser.GetParam(arg,buffer,PROP_EDITABLE) && strcmp(arg,NIHIL_PROP))
	combo->SetPropValue(EDITABLE,arg);
      if(parser.GetParam(arg,buffer,PROP_HIDDEN) && strcmp(arg,NIHIL_PROP))
	combo->SetPropValue(HIDDEN,arg);
      if(parser.GetParam(arg,buffer,PROP_SORTED) && strcmp(arg,NIHIL_PROP))
	combo->SetPropValue(SORTED,arg);
      if(parser.GetParam(arg,buffer,PROP_CASESENSITIVE) 
	 && strcmp(arg,NIHIL_PROP))
	combo->SetPropValue(CASESENSITIVE,arg);
      // pack widget to container
      return owner->PackToSelf(combo, container, buffer, parser);
    }
  else
    return false;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  VDKString True = CHECK_TRUE;
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  VDKTable *table = new VDKTable(inspector,2,2);
  table->SetSize(219,-1);
  
  editable = new VDKCheckButton(inspector,_(wi_widget_prompts[2]));
  table->AddToCell(editable,0,0);
  editable->Checked = GetProp(EDITABLE) == True;
  // this after (so no signal hang)
  editable->Parent(this);
  SignalConnect(editable,"toggled",&CLASS::OnSetEditable);

  sorted = new VDKCheckButton(inspector,_(wi_widget_prompts[3]));
  table->AddToCell(sorted,0,1);
  sorted->Checked = GetProp(SORTED) == True;
  // this after (so no signal hang)
  sorted->Parent(this);
  SignalConnect(editable,"toggled",&CLASS::OnSetSorted);

  hidden = new VDKCheckButton(inspector,_(wi_widget_prompts[4]));
  table->AddToCell(hidden,1,0);
  hidden->Checked = GetProp(HIDDEN) == True;
  // this after (so no signal hang)
  hidden->Parent(this);
  SignalConnect(hidden,"toggled",&CLASS::OnSetHidden);

  casesensitive = new VDKCheckButton(inspector,_(wi_widget_prompts[5]));
  table->AddToCell(casesensitive,1,1);
  casesensitive->Checked = GetProp(CASESENSITIVE) == True;
  // this after (so no signal hang)
  casesensitive->Parent(this);
  SignalConnect(casesensitive,"toggled",&CLASS::OnSetCaseSensitive);

  bframe->Add(table,l_justify,false,false,false);
  return bframe; 
}

/*
 */
bool
CLASS::OnSetEditable(VDKObject*)
{
  SetPropValue(EDITABLE, editable->Checked ? CHECK_TRUE : CHECK_FALSE);
  Editable = editable->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetHidden(VDKObject*)
{
  SetPropValue(HIDDEN, hidden->Checked ? CHECK_TRUE : CHECK_FALSE);
  Hidden = hidden->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetSorted(VDKObject*)
{
  SetPropValue(SORTED, sorted->Checked ? CHECK_TRUE : CHECK_FALSE);
  Sorted = sorted->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetCaseSensitive(VDKObject*)
{
  SetPropValue(CASESENSITIVE, casesensitive->Checked ? CHECK_TRUE : CHECK_FALSE);
  CaseSensitive = casesensitive->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
