/* configtokens.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2003-2020 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "wdefines.h"
#include "simplelist.hh"
#include "configtokens.h"
#include "configparser.hh"

struct mytoken tokenlist[]={
  {GLOBAL_WCP,"global"},
  {COLORS_WCP,"colors"},
  {LANG_WCP,"lang"},
  {PALETTE_WCP,"palette"},
  {OWNOP_WCP,"ownop"},
  {LISTERSETS_WCP,"listersets"},
  {LEFT_WCP,"left"},
  {RIGHT_WCP,"right"},
  {HBARTOP_WCP,"hbartop"},
  {HBARHEIGHT_WCP,"hbarheight"},
  {VBARLEFT_WCP,"vbarleft"},
  {VBARWIDTH_WCP,"vbarwidth"},
  {DISPLAYSETS_WCP,"displaysets"},
  {NAME_WCP,"name"},
  {SIZE_WCP,"size"},
  {TYPE_WCP,"type"},
  {PERMISSION_WCP,"permission"},
  {OWNER_WCP,"owner"},
  {DESTINATION_WCP,"destination"},
  {MODTIME_WCP,"modtime"},
  {ACCTIME_WCP,"acctime"},
  {CHGTIME_WCP,"chgtime"},
  {ROWS_WCP,"rows"},
  {COLUMNS_WCP,"columns"},
  {CACHESIZE_WCP,"cachesize"},
  {OWNERSTYLE_WCP,"ownerstyle"},
  {TERMINAL_WCP,"terminal"},
  {USESTRINGFORDIRSIZE_WCP,"usestringfordirsize"},
  {TIMESETS_WCP,"timesets"},
  {STYLE1_WCP,"style1"},
  {STYLE2_WCP,"style2"},
  {STYLE3_WCP,"style3"},
  {DATE_WCP,"date"},
  {TIME_WCP,"time"},
  {DATESUBSTITUTION_WCP,"datesubstitution"},
  {DATEBEFORETIME_WCP,"datebeforetime"},
  {STATEBAR_WCP,"statebar"},
  {SELLVBAR_WCP,"sellvbar"},
  {UNSELLVBAR_WCP,"unsellvbar"},
  {CLOCKBAR_WCP,"clockbar"},
  {REQUESTER_WCP,"requester"},
  {UNSELDIR_WCP,"unseldir"},
  {SELDIR_WCP,"seldir"},
  {UNSELFILE_WCP,"unselfile"},
  {SELFILE_WCP,"selfile"},
  {UNSELACTDIR_WCP,"unselactdir"},
  {SELACTDIR_WCP,"selactdir"},
  {UNSELACTFILE_WCP,"unselactfile"},
  {SELACTFILE_WCP,"selactfile"},
  {LVBG_WCP,"lvbg"},
  {STARTUP_WCP,"startup"},
  {BUTTON_WCP,"button"},
  {BUTTONS_WCP,"buttons"},
  {POSITION_WCP,"position"},
  {TITLE_WCP,"title"},
  {COMMANDS_WCP,"commands"},
  {SHORTKEYS_WCP,"shortkeys"},
  {PATHS_WCP,"paths"},
  {PATH_WCP,"path"},
  {FILETYPES_WCP,"filetypes"},
  {FILETYPE_WCP,"filetype"},
  {NORMAL_WCP,"normal"},
  {NOTYETCHECKED_WCP,"notyetchecked"},
  {UNKNOWN_WCP,"unknown"},
  {NOSELECT_WCP,"noselect"},
  {DIR_WCP,"dir"},
  {USEPATTERN_WCP,"usepattern"},
  {USECONTENT_WCP,"usecontent"},
  {PATTERN_WCP,"pattern"},
  {CONTENT_WCP,"content"},
  {FTCOMMANDS_WCP,"ftcommands"},
  {DND_WCP,"dnd"},
  {DC_WCP,"doubleclick"},
  {SHOW_WCP,"show"},
  {RAWSHOW_WCP,"rawshow"},
  {USER_WCP,"user"},
  {FLAGS_WCP,"flags"},
  {IGNOREDIRS_WCP,"ignoredirs"},
  {HOTKEYS_WCP,"hotkeys"},
  {HOTKEY_WCP,"hotkey"},
  {FONTS_WCP,"fonts"},
  {GLOBALFONT_WCP,"globalfont"},
  {BUTTONFONT_WCP,"buttonfont"},
  {LEFTFONT_WCP,"leftfont"},
  {RIGHTFONT_WCP,"rightfont"},
  {TEXTVIEWFONT_WCP,"textviewfont"},
  {STATEBARFONT_WCP,"statebarfont"},
  {CLOCKBARSETS_WCP,"clockbarsets"},
  {MODUS_WCP,"modus"},
  {TIMESPACE_WCP,"timespace"},
  {TIME_WCP,"time"},
  {VERSION_WCP,"version"},
  {EXTERN_WCP,"extern"},
  {UPDATETIME_WCP,"updatetime"},
  {SHOWHINTS_WCP,"showhints"},
  {PROGRAM_WCP,"program"},
  {KEY_WCP,"key"},
  {DOUBLE_WCP,"double"},
  {MOD_WCP,"mod"},
  {CONTROL_WCP,"control"},
  {SHIFT_WCP,"shift"},
  {LOCK_WCP,"lock"},
  {MOD1_WCP,"mod1"},
  {MOD2_WCP,"mod2"},
  {MOD3_WCP,"mod3"},
  {MOD4_WCP,"mod4"},
  {MOD5_WCP,"mod5"},
  {DNDACTION_WCP,"dndaction"},
  {DCACTION_WCP,"doubleclickaction"},
  {SHOWACTION_WCP,"showaction"},
  {RSHOWACTION_WCP,"rawshowaction"},
  {USERACTION_WCP,"useraction"},
  {ROWUP_WCP,"rowup"},
  {ROWDOWN_WCP,"rowdown"},
  {CHANGEHIDDENFLAG_WCP,"changehiddenflag"},
  {COPYOP_WCP,"copyop"},
  {FIRSTROW_WCP,"firstrow"},
  {LASTROW_WCP,"lastrow"},
  {PAGEUP_WCP,"pageup"},
  {PAGEDOWN_WCP,"pagedown"},
  {SELECTOP_WCP,"selectop"},
  {SELECTALLOP_WCP,"selectallop"},
  {SELECTNONEOP_WCP,"selectnoneop"},
  {INVERTALLOP_WCP,"invertallop"},
  {PARENTDIROP_WCP,"parentdirop"},
  {ENTERDIROP_WCP,"enterdirop"},
  {CHANGELISTERSETOP_WCP,"changelistersetop"},
  {SWITCHLISTEROP_WCP,"switchlisterop"},
  {FILTERSELECTOP_WCP,"filterselectop"},
  {FILTERUNSELECTOP_WCP,"filterunselectop"},
  {PATHTOOTHERSIDEOP_WCP,"path2osideop"},
  {QUITOP_WCP,"quitop"},
  {DELETEOP_WCP,"deleteop"},
  {RELOADOP_WCP,"reloadop"},
  {MAKEDIROP_WCP,"makedirop"},
  {RENAMEOP_WCP,"renameop"},
  {DIRSIZEOP_WCP,"dirsizeop"},
  {SIMDDOP_WCP,"simddop"},
  {STARTPROGOP_WCP,"startprogop"},
  {SEARCHENTRYOP_WCP,"searchentryop"},
  {ENTERPATHOP_WCP,"enterpathop"},
  {SCROLLLISTEROP_WCP,"scrolllisterop"},
  {CREATESYMLINKOP_WCP,"createsymlinkop"},
  {CHANGESYMLINKOP_WCP,"changesymlinkop"},
  {CHMODOP_WCP,"chmodop"},
  {TOGGLELISTERMODEOP_WCP,"togglelistermodeop"},
  {SETSORTMODEOP_WCP,"setsortmodeop"},
  {SETFILTEROP_WCP,"setfilterop"},
  {SHORTKEYFROMLISTOP_WCP,"shortkeyfromlistop"},
  {CHOWNOP_WCP,"chownop"},
  {WORKERCONFIG_WCP,"workerconfig"},
  {USERSTYLE_WCP,"userstyle"},
  {DATESTRING_WCP,"datestring"},
  {TIMESTRING_WCP,"timestring"},
  {COLOR_WCP,"color"},
  {PATTERNIGNORECASE_WCP,"patternignorecase"},
  {PATTERNUSEREGEXP_WCP,"patternuseregexp"},
  {PATTERNUSEFULLNAME_WCP,"patternusefullname"},
  {COM_WCP,"com"},
  {SEPARATEEACHENTRY_WCP,"separateeachentry"},
  {RECURSIVE_WCP,"recursive"},
  {START_WCP,"start"},
  {TERMINALWAIT_WCP,"terminalwait"},
  {SHOWOUTPUT_WCP,"showoutput"},
  {SHOWOUTPUTINT_WCP,"showoutputint"},
  {VIEWSTR_WCP,"viewstr"},
  {INBACKGROUND_WCP,"inbackground"},
  {TAKEDIRS_WCP,"takedirs"},
  {ACTIONNUMBER_WCP,"actionnumber"},
  {ROWUP_WCP,"rowup"},
  {HIDDENFILES_WCP,"hiddenfiles"},
  {HIDE_WCP,"hide"},
  {TOGGLE_WCP,"toggle"},
  {FOLLOWSYMLINKS_WCP,"followsymlinks"},
  {MOVE_WCP,"move"},
  {RENAME_WCP,"rename"},
  {SAMEDIR_WCP,"samedir"},
  {REQUESTDEST_WCP,"requestdest"},
  {REQUESTFLAGS_WCP,"requestflags"},
  {OVERWRITE_WCP,"overwrite"},
  {ALWAYS_WCP,"always"},
  {NEVER_WCP,"never"},
  {COPYMODE_WCP,"copymode"},
  {FAST_WCP,"fast"},
  {PRESERVEATTR_WCP,"preserveattr"},
  {MODE_WCP,"mode"},
  {ACTIVE_WCP,"active"},
  {ACTIVE2OTHER_WCP,"active2other"},
  {SPECIAL_WCP,"special"},
  {REQUEST_WCP,"request"},
  {CURRENT_WCP,"current"},
  {OTHER_WCP,"other"},
  {FILTER_WCP,"filter"},
  {QUICK_WCP,"quick"},
  {ALSOACTIVE_WCP,"alsoactive"},
  {RESETDIRSIZES_WCP,"resetdirsizes"},
  {KEEPFILETYPES_WCP,"keepfiletypes"},
  {RELATIVE_WCP,"relative"},
  {ONFILES_WCP,"onfiles"},
  {ONDIRS_WCP,"ondirs"},
  {SORTBY_WCP,"sortby"},
  {SORTFLAG_WCP,"sortflag"},
  {REVERSE_WCP,"reverse"},
  {DIRLAST_WCP,"dirlast"},
  {DIRMIXED_WCP,"dirmixed"},
  {EXCLUDE_WCP,"exclude"},
  {INCLUDE_WCP,"include"},
  {UNSET_WCP,"unset"},
  {UNSETALL_WCP,"unsetall"},
  {SCRIPTOP_WCP,"scriptop"},
  {NOP_WCP,"nop"},
  {PUSH_WCP,"push"},
  {LABEL_WCP,"label"},
  {IF_WCP,"if"},
  {END_WCP,"end"},
  {POP_WCP,"pop"},
  {SETTINGS_WCP,"settings"},
  {WINDOW_WCP,"window"},
  {GOTO_WCP,"goto"},
  {PUSHUSEOUTPUT_WCP,"pushuseoutput"},
  {DODEBUG_WCP,"dodebug"},
  {WPURECURSIVE_WCP,"wpurecursive"},
  {WPUTAKEDIRS_WCP,"wputakedirs"},
  {STACKNR_WCP,"stacknr"},
  {PUSHSTRING_WCP,"pushstring"},
  {IFTEST_WCP,"iftest"},
  {IFLABEL_WCP,"iflabel"},
  {WINTYPE_WCP,"wintype"},
  {OPEN_WCP,"open"},
  {CLOSE_WCP,"close"},
  {LEAVE_WCP,"leave"},
  {CHANGEPROGRESS_WCP,"changeprogress"},
  {CHANGETEXT_WCP,"changetext"},
  {PROGRESSUSEOUTPUT_WCP,"progressuseoutput"},
  {WINTEXTUSEOUTPUT_WCP,"wintextuseoutput"},
  {PROGRESS_WCP,"progress"},
  {WINTEXT_WCP,"wintext"},
  {SHOWDIRCACHEOP_WCP,"showdircacheop"},
  {ACTIVESIDE_WCP,"activeside"},
  {SHOWFREESPACE_WCP,"showfreespace"},
  {ACTIVEMODE_WCP,"activemode"},
  { INODE_WCP, "inode" },
  { NLINK_WCP, "nlink" },
  { BLOCKS_WCP, "blocks" },
  { SHOWHEADER_WCP, "showheader" },
  { LVHEADER_WCP, "lvheader" },
  { IGNORECASE_WCP, "ignorecase" },
  { LISTVIEWS_WCP, "listviews" },
  { BLL_WCP, "bll" },
  { LBL_WCP, "lbl" },
  { LLB_WCP, "llb" },
  { BL_WCP, "bl" },
  { LB_WCP, "lb" },
  { LAYOUT_WCP, "layout" },
  { BUTTONSVERT_WCP, "buttonsvertical" },
  { LISTVIEWSVERT_WCP, "listviewsvertical" },
  { EXTCOND_WCP, "extcond" },
  { USEEXTCOND_WCP, "useextcond" },
  { SUBTYPE_WCP, "subtype" },
  { PARENTACTIONOP_WCP, "parentactionop" },
  { NOOPERATIONOP_WCP, "nooperationop" },
  { COLORMODE_WCP, "colormode" },
  { CUSTOM_WCP, "custom" },
  { DEFAULT_WCP, "default" },
  { COLOREXTERNPROG_WCP, "colorexternprog" },
  { UNSELECTCOLOR_WCP, "unselectcolor" },
  { SELECTCOLOR_WCP, "selectcolor" },
  { UNSELECTACTIVECOLOR_WCP, "unselectactivecolor" },
  { SELECTACTIVECOLOR_WCP, "selectactivecolor" },
  { PARENT_WCP, "parent" },
  { DONTCD_WCP, "dontcd" },
  { DONTCHECKVIRTUAL_WCP, "dontcheckvirtual" },
  { GOFTPOP_WCP, "goftpop" },
  { HOSTNAME_WCP, "hostname" },
  { USERNAME_WCP, "username" },
  { PASSWORD_WCP, "password" },
  { DONTENTERFTP_WCP, "dontenterftp" },
  { ALWAYSSTOREPW_WCP, "alwaysstorepw" },
  { ASK_WCP, "ask" },
  { SSHALLOW_WCP, "sshallow" },
  { INTERNALVIEWOP_WCP, "internalviewop" },
  { CUSTOMFILES_WCP, "customfiles" },
  { SHOWMODE_WCP, "showmode" },
  { SELECTED_WCP, "selected" },
  { FIELD_WIDTH_WCP, "field_width" },
  { REVERSESEARCH_WCP, "reversesearch" },
  { QUICKSEARCHENABLED_WCP, "quicksearchenabled"},
  { MOUSECONF_WCP, "mouseconf" },
  { SELECTBUTTON_WCP, "selectbutton" },
  { ACTIVATEBUTTON_WCP, "activatebutton" },
  { SCROLLBUTTON_WCP, "scrollbutton" },
  { SELECTMETHOD_WCP, "selectmethod" },
  { ALTERNATIVE_WCP, "alternative" },
  { SEARCHOP_WCP, "searchop" },
  { EDITCOMMAND_WCP, "editcommand" },
  { SHOWPREVRESULTS_WCP, "showprevresults" },
  { TEXTVIEW_WCP, "textview" },
  { TEXTVIEWHIGHLIGHTED_WCP, "textviewhighlighted" },
  { TEXTVIEWSELECTION_WCP, "textviewselection" },
  { FILTEREDSEARCHENABLED_WCP, "filteredsearchenabled"},
  { DIRBOOKMARKOP_WCP, "dirbookmarkop" },
  { OPENCONTEXTMENUOP_WCP, "opencontextmenuop" },
  { CONTEXTBUTTON_WCP, "contextbutton" },
  { ACTIVATEMOD_WCP, "activatemod" },
  { SCROLLMOD_WCP, "scrollmod" },
  { CONTEXTMOD_WCP, "contextmod" },
  { NONE_WCP, "none" },
  { RUNCUSTOMACTION_WCP, "runcustomaction" },
  { CUSTOMNAME_WCP, "customname" },
  { CUSTOMACTION_WCP, "customaction" },
  { SAVE_WORKER_STATE_ON_EXIT_WCP, "saveworkerstateonexit" },
  { OPENWORKERMENUOP_WCP, "openworkermenuop" },
  { XFTFONTS_WCP, "xftfonts" },
  { USEMAGIC_WCP, "usemagic" },
  { MAGICCOMPRESSED_WCP, "magiccompressed" },
  { MAGICMIME_WCP, "magicmime" },
  { MAGICPATTERN_WCP, "magicpattern" },
  { CHANGELABELOP_WCP, "changelabelop" },
  { ASKFORLABEL_WCP, "askforlabel" },
  { LABELCOLORS_WCP, "labelcolors" },
  { BOOKMARKLABEL_WCP, "bookmarklabel" },
  { BOOKMARKFILTER_WCP, "bookmarkfilter" },
  { SHOWONLYBOOKMARKS_WCP, "showonlybookmarks" },
  { SHOWONLYLABEL_WCP, "showonlylabel" },
  { SHOWALL_WCP, "showall" },
  { OPTIONMODE_WCP, "optionmode" },
  { INVERT_WCP, "invert" },
  { SET_WCP, "set" },
  { CHANGEFILTERS_WCP, "changefilters" },
  { CHANGEBOOKMARKS_WCP, "changebookmarks" },
  { QUERYLABEL_WCP, "querylabel" },
  { MODIFYTABSOP_WCP, "modifytabsop" },
  { TABACTION_WCP, "tabaction" },
  { NEWTAB_WCP, "newtab" },
  { CLOSECURRENTTAB_WCP, "closecurrenttab" },
  { NEXTTAB_WCP, "nexttab" },
  { PREVTAB_WCP, "prevtab" },
  { TOGGLELOCKSTATE_WCP, "togglelockstate" },
  { MOVETABLEFT_WCP, "movetableft" },
  { MOVETABRIGHT_WCP, "movetabright" },
  { CHANGELAYOUTOP_WCP, "changelayoutop" },
  { LISTVIEWWEIGHT_WCP, "listviewweight" },
  { INFIXSEARCH_WCP, "infixsearch" },
  { VOLUMEMANAGEROP_WCP, "volumemanagerop" },
  { VOLUMEMANAGER_WCP, "volumemanager" },
  { MOUNTCOMMAND_WCP, "mountcommand" },
  { UNMOUNTCOMMAND_WCP, "unmountcommand" },
  { FSTABFILE_WCP, "fstabfile" },
  { MTABFILE_WCP, "mtabfile" },
  { PARTFILE_WCP, "partfile" },
  { REQUESTACTION_WCP, "requestaction" },
  { WEIGHTTOACTIVE_WCP, "weighttoactive" },
  { SIZEH_WCP, "sizeh" },
  { NEXTAGING_WCP, "nextaging" },
  { ENTRY_WCP, "entry" },
  { PREFIX_WCP, "prefix" },
  { VALUE_WCP, "value" },
  { EJECTCOMMAND_WCP, "ejectcommand" },
  { CLOSETRAYCOMMAND_WCP, "closetraycommand" },
  { AVFSMODULE_WCP, "avfsmodule" },
  { FLEXIBLEMATCH_WCP, "flexiblematch" },
  { USE_VERSION_STRING_COMPARE_WCP, "useversionstringcompare" },
  { SWITCHBUTTONBANKOP_WCP, "switchbuttonbankop" },
  { SWITCHTONEXTBANK_WCP, "switchtonextbank" },
  { SWITCHTOPREVBANK_WCP, "switchtoprevbank" },
  { SWITCHTOBANKNR_WCP, "switchtobanknr" },
  { BANKNR_WCP, "banknr" },
  { USE_VIRTUAL_TEMP_COPIES_WCP, "usevirtualtempcopies" },
  { PATHJUMPOP_WCP, "pathjumpop" },
  { PATHJUMPALLOWDIRS_WCP, "pathjumpallowdirs" },
  { CLIPBOARDOP_WCP, "clipboardop" },
  { CLIPBOARDSTRING_WCP, "clipboardstring" },
  { COMMANDSTRING_WCP, "commandstring" },
  { EVALCOMMAND_WCP, "evalcommand" },
  { WATCHMODE_WCP, "watchmode" },
  { APPLY_WINDOW_DIALOG_TYPE_WCP, "applywindowdialogtype" },
  { FLAGS_ARE_RELATIVE_TO_BASEDIR_WCP, "flagsarerelativetobasedir" },
  { COMMANDMENUOP_WCP, "commandmenuop" },
  { SEARCHMODEONKEYPRESS_WCP, "searchmodeonkeypress" },
  { PATHENTRYONTOP_WCP, "pathentryontop" },
  { PATHJUMPSETS_WCP, "pathjumpsets" },
  { STORE_FILES_ALWAYS_WCP, "storefilesalways" },
  { SHOWDOTDOT_WCP, "showdotdot" },
  { SHOWBREADCRUMB_WCP, "showbreadcrumb" },
  { FACES_WCP, "faces" },
  { FACE_WCP, "face" },
  { ENABLE_INFO_LINE_WCP, "enableinfoline" },
  { INFO_LINE_LUA_MODE_WCP, "infolineluamode" },
  { INFO_LINE_CONTENT_WCP, "infolinecontent" },
  { RESTORE_TABS_MODE_WCP, "restore_tabs_mode" },
  { STORE_TABS_MODE_WCP, "store_tabs_mode" },
  { AS_EXIT_STATE_WCP, "as_exit_state" },
  { USE_EXTENDED_REGEX_WCP, "useextendedregex" },
  { HIGHLIGHT_USER_ACTION_WCP, "highlightuseraction" },
  { CHTIMEOP_WCP, "chtimeop" },
  { ADJUSTRELATIVESYMLINKS_WCP, "adjustrelativesymlinks" },
  { OUTSIDE_WCP, "outside" },
  { MAKEABSOLUTE_WCP, "makeabsolute" },
  { MAKERELATIVE_WCP, "makerelative" },
  { EDIT_WCP, "edit" },
  { MAGICIGNORECASE_WCP, "magicignorecase" },
  { ENSURE_FILE_PERMISSIONS_WCP, "ensure_file_permissions" },
  { USER_RW_WCP, "user_rw" },
  { USER_RW_GROUP_R_WCP, "user_rw_group_r" },
  { USER_RW_ALL_R_WCP, "user_rw_all_r" },
  { LEAVE_UNMODIFIED_WCP, "leave_unmodified" },
  { PREFERUDISKSVERSION_WCP, "prefer_udisks_version" },
  { CHANGECOLUMNSOP_WCP, "changecolumnsop" },
  { PATTERNISCOMMASEPARATED_WCP, "pattern_is_comma_separated" },
  { USE_STRING_COMPARE_MODE_WCP, "usestringcomparemode" },
  { STRCASECMP_WCP, "strcasecmp" },
  { VIEWNEWESTFILESOP_WCP, "viewnewestfilesop" },
  { SHOWRECENT_WCP, "showrecent" },
  { DIRCOMPAREOP_WCP, "dircompareop" },
  { TABPROFILESOP_WCP, "tabprofilesop" },
  { EXTERNALVDIROP_WCP, "externalvdirop" },
  { VDIR_PRESERVE_DIR_STRUCTURE_WCP, "vdirpreservedirstructure" },
  { OPENTABMENUOP_WCP, "opentabmenuop" },
  { INITIALTAB_WCP, "initialtab" },
  { SHOWBYTIME_WCP, "showbytime" },
  { SHOWBYFILTER_WCP, "showbyfilter" },
  { SHOWBYPROGRAM_WCP, "showbyprogram" },
  { EXTENSION_WCP, "extension" },
  { TERMINAL_RETURNS_EARLY_WCP, "terminalreturnsearly" },
  { DIRECTORYPRESETS_WCP, "directorypresets" },
  { DIRECTORYPRESET_WCP, "directorypreset" },
  { HELPOP_WCP, "helpop" }
};

ArrayList *tokenlist_sorted = NULL;

int tokenlist_sortfunction( void *p1, void *p2 )
{
  if ( ( p1 == NULL ) || ( p2 == NULL ) ) return 0;
  return strcasecmp( ((struct mytoken*)p1)->str,
                     ((struct mytoken*)p2)->str );
}

void cleanUpTokens()
{
  // the list contains just pointers to the static array so
  // delete of list is enough
  delete tokenlist_sorted;
  tokenlist_sorted = NULL;
}

int findToken( const char *str)
{
  int s, i, left, right, middle, erg;
  struct mytoken *t1;
  
  if ( tokenlist_sorted == NULL ) {
    // init sorted token list for binary search
    tokenlist_sorted = new ArrayList();
    s = sizeof( tokenlist ) / sizeof( tokenlist[0] );
    for ( i = 0; i < s; i++ ) {
      tokenlist_sorted->addElement( &( tokenlist[i] ) );
    }
    tokenlist_sorted->sort( tokenlist_sortfunction );
  }
  
  s = tokenlist_sorted->size();
  left = 0;
  right = s - 1;
  do {
    middle = ( left + right ) / 2;
    t1 = (struct mytoken*)tokenlist_sorted->getElementAt( middle );
    if ( t1 == NULL ) return ERROR;
    erg = strcasecmp( str, t1->str );
    if ( erg == 0 ) return t1->token;
    else if ( erg < 0 ) {
      right = middle - 1;
    } else {
      left = middle + 1;
    }
  } while ( left <= right );
  return ERROR;
}

