/*
 *  Copyright (c) 2000-2022 Inria
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *  * Neither the name of the ALICE Project-Team nor the names of its
 *  contributors may be used to endorse or promote products derived from this
 *  software without specific prior written permission.
 * 
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 *  Contact: Bruno Levy
 *
 *     https://www.inria.fr/fr/bruno-levy
 *
 *     Inria,
 *     Domaine de Voluceau,
 *     78150 Le Chesnay - Rocquencourt
 *     FRANCE
 *
 */

#ifndef GEOGRAM_GFX_LUA_LUA_GLUP
#define GEOGRAM_GFX_LUA_LUA_GLUP

#include <geogram_gfx/api/defs.h>
#ifdef __cplusplus
extern "C" {
#endif

#include <geogram/third_party/lua/lua.h>

/**
 * \file geogram_gfx/glup_viewer/glup_viewer_lua.h
 * \brief LUA bindings for GLUP.
 */

/**
 * \brief Registers GLUP functions to LUA.
 * \param[in] L a pointer to the LUA state.
 */
void GEOGRAM_GFX_API init_lua_glup(lua_State* L);


/**
 * \brief Makes sure GLUP is in a valid state.
 * \details Restores the previous depth of matrix stacks
 *  and terminates pending GLUP primitives. This makes sure
 *  GLUP is in a valid state even if there was an error in
 *  LUA code.
 * \param[in] L a pointer to the LUA state.
 */
void GEOGRAM_GFX_API adjust_lua_glup_state(lua_State* L);

#ifdef __cplusplus
}
#endif
    
#endif

