/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableAssert
extends GenericAssert<Throwable> {
    private final ObjectAssert objectAssert;

    protected ThrowableAssert(Throwable actual) {
        super(actual);
        this.objectAssert = new ObjectAssert(actual);
    }

    public ThrowableAssert as(String description) {
        this.objectAssert.as(description);
        this.description(description);
        return this;
    }

    public ThrowableAssert describedAs(String description) {
        return this.as(description);
    }

    public ThrowableAssert as(Description description) {
        this.objectAssert.as(description);
        this.description(description);
        return this;
    }

    public ThrowableAssert describedAs(Description description) {
        return this.as(description);
    }

    public ThrowableAssert isInstanceOf(Class<? extends Throwable> type) {
        this.objectAssert.isInstanceOf(type);
        return this;
    }

    public ThrowableAssert isExactlyInstanceOf(Class<?> type) {
        this.isNotNull();
        this.objectAssert.validateNotNull(type);
        Class<?> current = ((Throwable)this.actual).getClass();
        if (type.equals(current)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"expected exactly the same type:", Formatting.inBrackets(type), " but was:", Formatting.inBrackets(current)}));
    }

    public ThrowableAssert hasMessage(String message) {
        this.isNotNull();
        Fail.failIfNotEqual(this.customErrorMessage(), this.rawDescription(), ((Throwable)this.actual).getMessage(), message);
        return this;
    }

    public ThrowableAssert hasNoCause() {
        this.isNotNull();
        Throwable actualCause = ((Throwable)this.actual).getCause();
        if (actualCause == null) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"expected exception without cause, but cause was:", Formatting.inBrackets(actualCause.getClass())}));
    }

    public ThrowableAssert isEqualTo(Throwable expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public ThrowableAssert isNotEqualTo(Throwable other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public ThrowableAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public ThrowableAssert isNotSameAs(Throwable other) {
        this.assertNotSameAs(other);
        return this;
    }

    public ThrowableAssert isSameAs(Throwable expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ThrowableAssert satisfies(Condition<Throwable> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ThrowableAssert doesNotSatisfy(Condition<Throwable> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ThrowableAssert is(Condition<Throwable> condition) {
        this.assertIs(condition);
        return this;
    }

    public ThrowableAssert isNot(Condition<Throwable> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public ThrowableAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        this.objectAssert.overridingErrorMessage(message);
        return this;
    }
}

