!{\src2tex{textfont=tt}}
!!****f* ABINIT/gauleg
!! NAME
!! gauleg
!!
!! FUNCTION
!! Compute supports and weights for Gauss-Legendre integration
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  x1=lower bound of integration
!!  x2=upper bound of integration
!!  n=order of integration
!!
!! OUTPUT
!!  x(n)=array of support points
!!  w(n)=array of integration weights
!!
!! PARENTS
!!      opt_proj
!!
!! NOTES
!!   Code follows [W.H. Press et al., Numerical
!!   Recipes (Cambridge University Press, New York, 1986].
!!
!! SOURCE

 subroutine gauleg(x1,x2,x,w,n)

 use defs_basis

 implicit none


!Arguments ---------------------------------------------
 integer :: n
 real(dp) :: x1,x2
 real(dp) :: x(n),w(n)

!Local variables ---------------------------------------
 real(dp), parameter :: eps=1.d-13
 
 integer :: i,j,loop_root,m
 real(dp) :: p1,p2,p3,pp,xm,xl,z,z1

! *********************************************************************

 m=(n+1)/2
 xm=0.5d0*(x2+x1)
 xl=0.5d0*(x2-x1)

 do i=1,m
  z=cos(pi*(i-0.25d0)/(n+0.5d0))

  do loop_root=1,100

   p1=1.d0
   p2=0.d0

   do j=1,n
    p3=p2
    p2=p1
    p1=((2.d0*j - 1.d0)*z*p2 - (j-1.d0)*p3)/j
   enddo

   pp=n*(z*p1-p2)/(z*z-1.d0)
   z1=z
   z=z1-p1/pp

   if (abs(z-z1) < eps) exit

  enddo
  x(i)=xm-xl*z
  x(n+1-i)=xm+xl*z
  w(i)=2.d0*xl/((1.d0-z*z)*pp*pp)
  w(n+1-i)=w(i)

 enddo

 end subroutine gauleg

!!***
