;          ROUND.ASM                                          Agner Fog 2003

;  2003 GNU General Public License www.gnu.org/copyleft/gpl.html

.686
.model flat

PublicAlias MACRO MangledName ; macro for giving a function alias public names
        MangledName label near
        public MangledName
ENDM

.code

; ********** round function **********
; C++ prototype:
; extern "C" int Round (double x);

; This function converts a double precision floating point number to
; an integer, rounding to nearest or even. Does not check for overflow.
; This function is much faster than the default conversion method in C++
; which uses truncation.

Round PROC NEAR
PUBLIC Round
PublicAlias _Round                    ; Underscore needed when called from Windows
        fld     qword ptr [esp+4]
        sub     esp, 4
        fistp   dword ptr [esp]
        pop     eax
        ret
Round ENDP

END
