"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmptyStateIcon = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_styles_1 = require("@patternfly/react-styles");
const empty_state_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/EmptyState/empty-state"));
const Spinner_1 = require("../Spinner");
const isSpinner = (icon) => icon.type === Spinner_1.Spinner;
const EmptyStateIcon = (_a) => {
    var { className, icon: IconComponent } = _a, props = tslib_1.__rest(_a, ["className", "icon"]);
    const iconIsSpinner = isSpinner((0, jsx_runtime_1.jsx)(IconComponent, {}));
    return ((0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(empty_state_1.default.emptyStateIcon), children: (0, jsx_runtime_1.jsx)(IconComponent, Object.assign({ className: className, "aria-hidden": !iconIsSpinner }, props)) }));
};
exports.EmptyStateIcon = EmptyStateIcon;
exports.EmptyStateIcon.displayName = 'EmptyStateIcon';
//# sourceMappingURL=EmptyStateIcon.js.map