// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System;
using Xunit;

namespace NuGet.VisualStudio.Internal.Contracts.Test
{
    public sealed class PackageVulnerabilityMetadataContextInfoFormatterTests : FormatterTests
    {
        [Theory]
        [MemberData(nameof(TestData))]
        public void SerializeThenDeserialize_WithValidArguments_RoundTrips(PackageVulnerabilityMetadataContextInfo expectedResult)
        {
            PackageVulnerabilityMetadataContextInfo? actualResult = SerializeThenDeserialize(PackageVulnerabilityMetadataContextInfoFormatter.Instance, expectedResult);

            Assert.NotNull(actualResult);
            Assert.Equal(expectedResult, actualResult);
        }

        public static TheoryData<PackageVulnerabilityMetadataContextInfo> TestData => new()
            {
                { new PackageVulnerabilityMetadataContextInfo(new Uri("htpp://www.nuget.org"), 2) }
            };
    }
}
