﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Threading;
using Microsoft.CodeAnalysis.CSharp.Extensions;

namespace Microsoft.CodeAnalysis.CSharp.Completion.Providers;

internal static class DirectiveCompletionProviderUtilities
{
    internal static bool TryGetStringLiteralToken(SyntaxTree tree, int position, SyntaxKind directiveKind, out SyntaxToken stringLiteral, CancellationToken cancellationToken)
    {
        if (tree.IsEntirelyWithinStringLiteral(position, cancellationToken))
        {
            var token = tree.GetRoot(cancellationToken).FindToken(position, findInsideTrivia: true);
            if (token.Kind() is SyntaxKind.EndOfDirectiveToken or SyntaxKind.EndOfFileToken)
            {
                token = token.GetPreviousToken(includeSkipped: true, includeDirectives: true);
            }

            if (token.Kind() == SyntaxKind.StringLiteralToken && token.Parent!.Kind() == directiveKind)
            {
                stringLiteral = token;
                return true;
            }
        }

        stringLiteral = default;
        return false;
    }
}
