// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2022 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package timestamp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	stderrors "errors"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/sigstore/timestamp-authority/v2/pkg/generated/models"
)

// GetTimestampCertChainReader is a Reader for the GetTimestampCertChain structure.
type GetTimestampCertChainReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetTimestampCertChainReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (any, error) {
	switch response.Code() {
	case 200:
		result := NewGetTimestampCertChainOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewGetTimestampCertChainNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewGetTimestampCertChainDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetTimestampCertChainOK creates a GetTimestampCertChainOK with default headers values
func NewGetTimestampCertChainOK() *GetTimestampCertChainOK {
	return &GetTimestampCertChainOK{}
}

/*
GetTimestampCertChainOK describes a response with status code 200, with default header values.

The PEM encoded cert chain
*/
type GetTimestampCertChainOK struct {
	Payload string
}

// IsSuccess returns true when this get timestamp cert chain o k response has a 2xx status code
func (o *GetTimestampCertChainOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get timestamp cert chain o k response has a 3xx status code
func (o *GetTimestampCertChainOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get timestamp cert chain o k response has a 4xx status code
func (o *GetTimestampCertChainOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get timestamp cert chain o k response has a 5xx status code
func (o *GetTimestampCertChainOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get timestamp cert chain o k response a status code equal to that given
func (o *GetTimestampCertChainOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get timestamp cert chain o k response
func (o *GetTimestampCertChainOK) Code() int {
	return 200
}

func (o *GetTimestampCertChainOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/v1/timestamp/certchain][%d] getTimestampCertChainOK %s", 200, payload)
}

func (o *GetTimestampCertChainOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/v1/timestamp/certchain][%d] getTimestampCertChainOK %s", 200, payload)
}

func (o *GetTimestampCertChainOK) GetPayload() string {
	return o.Payload
}

func (o *GetTimestampCertChainOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewGetTimestampCertChainNotFound creates a GetTimestampCertChainNotFound with default headers values
func NewGetTimestampCertChainNotFound() *GetTimestampCertChainNotFound {
	return &GetTimestampCertChainNotFound{}
}

/*
GetTimestampCertChainNotFound describes a response with status code 404, with default header values.

The content requested could not be found
*/
type GetTimestampCertChainNotFound struct {
}

// IsSuccess returns true when this get timestamp cert chain not found response has a 2xx status code
func (o *GetTimestampCertChainNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get timestamp cert chain not found response has a 3xx status code
func (o *GetTimestampCertChainNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get timestamp cert chain not found response has a 4xx status code
func (o *GetTimestampCertChainNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get timestamp cert chain not found response has a 5xx status code
func (o *GetTimestampCertChainNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get timestamp cert chain not found response a status code equal to that given
func (o *GetTimestampCertChainNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get timestamp cert chain not found response
func (o *GetTimestampCertChainNotFound) Code() int {
	return 404
}

func (o *GetTimestampCertChainNotFound) Error() string {
	return fmt.Sprintf("[GET /api/v1/timestamp/certchain][%d] getTimestampCertChainNotFound", 404)
}

func (o *GetTimestampCertChainNotFound) String() string {
	return fmt.Sprintf("[GET /api/v1/timestamp/certchain][%d] getTimestampCertChainNotFound", 404)
}

func (o *GetTimestampCertChainNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetTimestampCertChainDefault creates a GetTimestampCertChainDefault with default headers values
func NewGetTimestampCertChainDefault(code int) *GetTimestampCertChainDefault {
	return &GetTimestampCertChainDefault{
		_statusCode: code,
	}
}

/*
GetTimestampCertChainDefault describes a response with status code -1, with default header values.

There was an internal error in the server while processing the request
*/
type GetTimestampCertChainDefault struct {
	_statusCode int

	Payload *models.Error
}

// IsSuccess returns true when this get timestamp cert chain default response has a 2xx status code
func (o *GetTimestampCertChainDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get timestamp cert chain default response has a 3xx status code
func (o *GetTimestampCertChainDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get timestamp cert chain default response has a 4xx status code
func (o *GetTimestampCertChainDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get timestamp cert chain default response has a 5xx status code
func (o *GetTimestampCertChainDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get timestamp cert chain default response a status code equal to that given
func (o *GetTimestampCertChainDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get timestamp cert chain default response
func (o *GetTimestampCertChainDefault) Code() int {
	return o._statusCode
}

func (o *GetTimestampCertChainDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/v1/timestamp/certchain][%d] getTimestampCertChain default %s", o._statusCode, payload)
}

func (o *GetTimestampCertChainDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/v1/timestamp/certchain][%d] getTimestampCertChain default %s", o._statusCode, payload)
}

func (o *GetTimestampCertChainDefault) GetPayload() *models.Error {
	return o.Payload
}

func (o *GetTimestampCertChainDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}
