/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <CUnit/CUnit.h>
#include <guacamole/unicode.h>

/**
 * Test which verifies that guac_utf8_write() properly encodes Unicode
 * codepoints as UTF-8.
 */
void test_unicode__utf8_write() {

    char buffer[16];

    /* Test writes */
    CU_ASSERT_EQUAL(1, guac_utf8_write(0x00065, &(buffer[0]),  10));
    CU_ASSERT_EQUAL(2, guac_utf8_write(0x00654, &(buffer[1]),   9));
    CU_ASSERT_EQUAL(3, guac_utf8_write(0x00876, &(buffer[3]),   7));
    CU_ASSERT_EQUAL(4, guac_utf8_write(0x12345, &(buffer[6]),   4));
    CU_ASSERT_EQUAL(0, guac_utf8_write(0x00066, &(buffer[10]),  0));

    /* Test result of write */
    CU_ASSERT(memcmp("\x65",             &(buffer[0]), 1) == 0); /* U+0065  */
    CU_ASSERT(memcmp("\xD9\x94",         &(buffer[1]), 2) == 0); /* U+0654  */
    CU_ASSERT(memcmp("\xE0\xA1\xB6",     &(buffer[3]), 3) == 0); /* U+0876  */
    CU_ASSERT(memcmp("\xF0\x92\x8D\x85", &(buffer[6]), 4) == 0); /* U+12345 */

}

