#ifndef INCLUDED_OPTBASE_
#define INCLUDED_OPTBASE_

#include <getopt.h>

#include <cstddef>

#include "../base/base.h"

struct OptBase: public Base
{
    using LongOpt = struct option;              // cf. getopt_long

    private:
        bool d_usage;           // if true -h was specified
        bool d_version;         // if true -v was specified
    
        StrVect d_plainArgs;
        std::string d_src;      // real source filename with option -t

    protected:
        PtrVect &d_argv;            // freely modifiable by (and provided by)
                                    //  the derived class
    public:
        OptBase(PtrVect &argv);                                         // 1.
        virtual ~OptBase();

        std::string const &src() const;                                 // .f
        size_t tailIdx() const;                                         // .f 
                                                                        
        void setUsage();                                                // .f
        void setVersion();                                              // .f
        bool usage() const;                                             // .f
        bool version() const;                                           // .f
                                                                        
        StrVect const &plainArgs() const;                               // .f

                                                // may redefine d_plainArgs
        std::string setPlain(size_t idx, std::string const &str);

        void remaining(char const *caller) const;   // remaining opts/args

    protected:
        void setPlainArgs();
};

#include "optbase.f"        

#endif


