/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IGGWIDGETKEYBUTTON_H
#define IGGWIDGETKEYBUTTON_H

//
//  Non-abstract classes defined in this file
//
// iggWidgetKeyCheckBox;
// iggWidgetKeyExecButton;
// iggWidgetKeyToggleButton;
// iggWidgetKeyFileNameButton;
// iggWidgetKeyIntExecButton;
//
#include "iggwidgetkeyhandler.h"


#include "istring.h"

class iImage;

class ibgWidgetButtonSubject;


class iggWidgetKeyButton : public iggWidgetKeyHandler<bool>
{

public:

	iggWidgetKeyButton(int type, const iString &text, const iObjectKey &key, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

	void SetReverse(bool s);

	virtual void QueryValue(bool &val) const;

protected:

	virtual void UpdateValue(bool val);

	virtual void OnVoid1Body();

	bool mReverse;
	ibgWidgetButtonSubject *mSubject;
};


class iggWidgetKeyCheckBox : public iggWidgetKeyButton
{

public:

	iggWidgetKeyCheckBox(const iString &text, const iObjectKey &key, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);
};


class iggWidgetKeyExecButton : public iggWidgetKeyButton
{

public:

	iggWidgetKeyExecButton(const iString &text, const iObjectKey &key, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

	virtual void QueryValue(bool &val) const;

protected:

	virtual void UpdateWidgetBody();
};


class iggWidgetKeyToolButton : public iggWidgetKeyButton
{

public:

	iggWidgetKeyToolButton(const iString &text, const iObjectKey &key, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

	virtual void QueryValue(bool &val) const;

protected:

	virtual void UpdateWidgetBody();
};


class iggWidgetKeyToggleButton : public iggWidgetKeyButton
{

public:

	iggWidgetKeyToggleButton(const iImage *icon, const iString &text, const iObjectKey &key, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

protected:

	const iImage *mIcon;
};


class iggWidgetKeyFileNameButton : public iggWidgetKeyHandler<iString>
{

public:

	iggWidgetKeyFileNameButton(const iString &text, const iString &header, const iString &selection, const iObjectKey &key, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

	void SetDefaut(const iString &s);

	virtual void QueryValue(iString &val) const;

protected:

	virtual void UpdateWidgetBody();
	virtual void UpdateValue(iString val);

	virtual void OnVoid1Body();

	ibgWidgetButtonSubject *mSubject;
	iString mHeader, mSelection, mDefault;
};


class iggWidgetKeyExecIntButton : public iggWidgetKeyHandler<int>
{

public:

	iggWidgetKeyExecIntButton(int value, const iString &text, const iObjectKey &key, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

	virtual void QueryValue(int &val) const;

protected:

	virtual void UpdateWidgetBody();
	virtual void UpdateValue(int val);

	virtual void OnVoid1Body();

	int mValue;
	ibgWidgetButtonSubject *mSubject;
};

#endif  // IQTWIDGETKEYBUTTON_H

