; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

define dso_local i32 @visible(ptr noalias %A, ptr noalias %B) #0 {
; TUNIT: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: read) uwtable
; TUNIT-LABEL: define {{[^@]+}}@visible
; TUNIT-SAME: (ptr noalias nocapture nofree readonly [[A:%.*]], ptr noalias nocapture nofree readonly [[B:%.*]]) #[[ATTR0:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL1:%.*]] = call i32 @noalias_args(ptr noalias nocapture nofree noundef readonly align 4 [[A]], ptr noalias nocapture nofree noundef readonly align 4 [[B]]) #[[ATTR4:[0-9]+]]
; TUNIT-NEXT:    [[CALL2:%.*]] = call i32 @noalias_args_argmem(ptr noalias nocapture nofree noundef readonly align 4 [[A]], ptr noalias nocapture nofree noundef readonly align 4 [[B]]) #[[ATTR4]]
; TUNIT-NEXT:    [[ADD:%.*]] = add nsw i32 [[CALL1]], [[CALL2]]
; TUNIT-NEXT:    ret i32 [[ADD]]
;
; CGSCC: Function Attrs: mustprogress nofree noinline nosync nounwind willreturn memory(argmem: read) uwtable
; CGSCC-LABEL: define {{[^@]+}}@visible
; CGSCC-SAME: (ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A:%.*]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL1:%.*]] = call i32 @noalias_args(ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B]]) #[[ATTR6:[0-9]+]]
; CGSCC-NEXT:    [[CALL2:%.*]] = call i32 @noalias_args_argmem(ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B]]) #[[ATTR6]]
; CGSCC-NEXT:    [[ADD:%.*]] = add nsw i32 [[CALL1]], [[CALL2]]
; CGSCC-NEXT:    ret i32 [[ADD]]
;
entry:
  %call1 = call i32 @noalias_args(ptr %A, ptr %B)
  %call2 = call i32 @noalias_args_argmem(ptr %A, ptr %B)
  %add = add nsw i32 %call1, %call2
  ret i32 %add
}

define private i32 @noalias_args(ptr %A, ptr %B) #0 {
; TUNIT: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: read) uwtable
; TUNIT-LABEL: define {{[^@]+}}@noalias_args
; TUNIT-SAME: (ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A:%.*]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 4
; TUNIT-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B]], align 4
; TUNIT-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], [[TMP1]]
; TUNIT-NEXT:    [[CALL:%.*]] = call i32 @noalias_args_argmem(ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B]]) #[[ATTR4]]
; TUNIT-NEXT:    [[ADD2:%.*]] = add nsw i32 [[ADD]], [[CALL]]
; TUNIT-NEXT:    ret i32 [[ADD2]]
;
; CGSCC: Function Attrs: mustprogress nofree noinline nosync nounwind willreturn memory(argmem: read) uwtable
; CGSCC-LABEL: define {{[^@]+}}@noalias_args
; CGSCC-SAME: (ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A:%.*]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 4
; CGSCC-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B]], align 4
; CGSCC-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], [[TMP1]]
; CGSCC-NEXT:    [[CALL:%.*]] = call i32 @noalias_args_argmem(ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B]]) #[[ATTR7:[0-9]+]]
; CGSCC-NEXT:    [[ADD2:%.*]] = add nsw i32 [[ADD]], [[CALL]]
; CGSCC-NEXT:    ret i32 [[ADD2]]
;
entry:
  %0 = load i32, ptr %A, align 4
  %1 = load i32, ptr %B, align 4
  %add = add nsw i32 %0, %1
  %call = call i32 @noalias_args_argmem(ptr %A, ptr %B)
  %add2 = add nsw i32 %add, %call
  ret i32 %add2
}


define internal i32 @noalias_args_argmem(ptr %A, ptr %B) #1 {
; TUNIT: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: read) uwtable
; TUNIT-LABEL: define {{[^@]+}}@noalias_args_argmem
; TUNIT-SAME: (ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A:%.*]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 4
; TUNIT-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B]], align 4
; TUNIT-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], [[TMP1]]
; TUNIT-NEXT:    ret i32 [[ADD]]
;
; CGSCC: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: read) uwtable
; CGSCC-LABEL: define {{[^@]+}}@noalias_args_argmem
; CGSCC-SAME: (ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A:%.*]], ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 4
; CGSCC-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B]], align 4
; CGSCC-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], [[TMP1]]
; CGSCC-NEXT:    ret i32 [[ADD]]
;
entry:
  %0 = load i32, ptr %A, align 4
  %1 = load i32, ptr %B, align 4
  %add = add nsw i32 %0, %1
  ret i32 %add
}

define dso_local i32 @visible_local(ptr %A) #0 {
; TUNIT: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: readwrite) uwtable
; TUNIT-LABEL: define {{[^@]+}}@visible_local
; TUNIT-SAME: (ptr nocapture nofree readonly [[A:%.*]]) #[[ATTR1:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[B:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    store i32 5, ptr [[B]], align 4
; TUNIT-NEXT:    [[CALL1:%.*]] = call i32 @noalias_args(ptr nocapture nofree noundef readonly align 4 [[A]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B]]) #[[ATTR4]]
; TUNIT-NEXT:    [[CALL2:%.*]] = call i32 @noalias_args_argmem(ptr nocapture nofree noundef readonly align 4 [[A]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B]]) #[[ATTR4]]
; TUNIT-NEXT:    [[ADD:%.*]] = add nsw i32 [[CALL1]], [[CALL2]]
; TUNIT-NEXT:    ret i32 [[ADD]]
;
; CGSCC: Function Attrs: mustprogress nofree noinline nosync nounwind willreturn memory(argmem: readwrite) uwtable
; CGSCC-LABEL: define {{[^@]+}}@visible_local
; CGSCC-SAME: (ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[B:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    store i32 5, ptr [[B]], align 4
; CGSCC-NEXT:    [[CALL1:%.*]] = call i32 @noalias_args(ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B]]) #[[ATTR6]]
; CGSCC-NEXT:    [[CALL2:%.*]] = call i32 @noalias_args_argmem(ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[A]], ptr noalias nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[B]]) #[[ATTR8:[0-9]+]]
; CGSCC-NEXT:    [[ADD:%.*]] = add nsw i32 [[CALL1]], [[CALL2]]
; CGSCC-NEXT:    ret i32 [[ADD]]
;
entry:
  %B = alloca i32, align 4
  store i32 5, ptr %B, align 4
  %call1 = call i32 @noalias_args(ptr %A, ptr nonnull %B)
  %call2 = call i32 @noalias_args_argmem(ptr %A, ptr nonnull %B)
  %add = add nsw i32 %call1, %call2
  ret i32 %add
}

define internal i32 @noalias_args_argmem_ro(ptr %A, ptr %B) #1 {
; CGSCC: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@noalias_args_argmem_ro
; CGSCC-SAME: (i32 [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR3:[0-9]+]] {
; CGSCC-NEXT:    [[B_PRIV:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    store i32 [[TMP1]], ptr [[B_PRIV]], align 4
; CGSCC-NEXT:    [[A_PRIV:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    store i32 [[TMP0]], ptr [[A_PRIV]], align 4
; CGSCC-NEXT:    [[T0:%.*]] = load i32, ptr [[A_PRIV]], align 4
; CGSCC-NEXT:    [[T1:%.*]] = load i32, ptr [[B_PRIV]], align 4
; CGSCC-NEXT:    [[ADD:%.*]] = add nsw i32 [[T0]], [[T1]]
; CGSCC-NEXT:    ret i32 [[ADD]]
;
  %t0 = load i32, ptr %A, align 4
  %t1 = load i32, ptr %B, align 4
  %add = add nsw i32 %t0, %t1
  ret i32 %add
}

define i32 @visible_local_2() {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@visible_local_2
; TUNIT-SAME: () #[[ATTR2:[0-9]+]] {
; TUNIT-NEXT:    [[B:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    ret i32 10
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@visible_local_2
; CGSCC-SAME: () #[[ATTR4:[0-9]+]] {
; CGSCC-NEXT:    [[CALL:%.*]] = call i32 @noalias_args_argmem_ro(i32 noundef 5, i32 noundef 5) #[[ATTR9:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[CALL]]
;
  %B = alloca i32, align 4
  store i32 5, ptr %B, align 4
  %call = call i32 @noalias_args_argmem_ro(ptr %B, ptr %B)
  ret i32 %call
}

define internal i32 @noalias_args_argmem_rn(ptr %A, ptr %B) #1 {
; TUNIT: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: write) uwtable
; TUNIT-LABEL: define {{[^@]+}}@noalias_args_argmem_rn
; TUNIT-SAME: (ptr noalias nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR3:[0-9]+]] {
; TUNIT-NEXT:    ret i32 undef
;
; CGSCC: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: readwrite) uwtable
; CGSCC-LABEL: define {{[^@]+}}@noalias_args_argmem_rn
; CGSCC-SAME: (ptr noalias nocapture nofree noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR5:[0-9]+]] {
; CGSCC-NEXT:    [[T0:%.*]] = load i32, ptr [[B]], align 4
; CGSCC-NEXT:    store i32 0, ptr [[B]], align 4
; CGSCC-NEXT:    ret i32 [[T0]]
;
  %t0 = load i32, ptr %B, align 4
  store i32 0, ptr %B
  ret i32 %t0
}

define i32 @visible_local_3() {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@visible_local_3
; TUNIT-SAME: () #[[ATTR2]] {
; TUNIT-NEXT:    [[B:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    [[CALL:%.*]] = call i32 @noalias_args_argmem_rn(ptr noalias nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[B]]) #[[ATTR5:[0-9]+]]
; TUNIT-NEXT:    ret i32 5
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@visible_local_3
; CGSCC-SAME: () #[[ATTR4]] {
; CGSCC-NEXT:    [[B:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    store i32 5, ptr [[B]], align 4
; CGSCC-NEXT:    [[CALL:%.*]] = call i32 @noalias_args_argmem_rn(ptr noalias nocapture nofree noundef nonnull align 4 dereferenceable(4) [[B]]) #[[ATTR10:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[CALL]]
;
  %B = alloca i32, align 4
  store i32 5, ptr %B, align 4
  %call = call i32 @noalias_args_argmem_rn(ptr %B, ptr %B)
  ret i32 %call
}

attributes #0 = { noinline nounwind uwtable willreturn }
attributes #1 = { argmemonly noinline nounwind uwtable willreturn}
;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: read) uwtable }
; TUNIT: attributes #[[ATTR1]] = { mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: readwrite) uwtable }
; TUNIT: attributes #[[ATTR2]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR3]] = { mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: write) uwtable }
; TUNIT: attributes #[[ATTR4]] = { nofree nosync nounwind memory(read) }
; TUNIT: attributes #[[ATTR5]] = { nofree nosync nounwind willreturn memory(write) }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree noinline nosync nounwind willreturn memory(argmem: read) uwtable }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: read) uwtable }
; CGSCC: attributes #[[ATTR2]] = { mustprogress nofree noinline nosync nounwind willreturn memory(argmem: readwrite) uwtable }
; CGSCC: attributes #[[ATTR3]] = { mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable }
; CGSCC: attributes #[[ATTR4]] = { mustprogress nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR5]] = { mustprogress nofree noinline norecurse nosync nounwind willreturn memory(argmem: readwrite) uwtable }
; CGSCC: attributes #[[ATTR6]] = { nofree memory(read) }
; CGSCC: attributes #[[ATTR7]] = { nofree nounwind memory(read) }
; CGSCC: attributes #[[ATTR8]] = { nofree }
; CGSCC: attributes #[[ATTR9]] = { nofree nosync willreturn }
; CGSCC: attributes #[[ATTR10]] = { nofree nounwind willreturn }
;.
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
