
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileSimplePolylineAttributes.h
    \brief Definition of SimplePolyline Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef SimplePolylineAttributes_H
#define SimplePolylineAttributes_H

#include "magics.h"
#include "Colour.h"
#include "LevelSelection.h"
#include "ColourTechnique.h"
namespace magics {

class XmlNode;
class SimplePolylineAttributes :
    public ColourTechniqueInterface,
    public LevelSelectionInterface
{
public:
//  --  constructor
    SimplePolylineAttributes();
    
//  --  destructor
    virtual ~SimplePolylineAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const SimplePolylineAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	bool legend_;
	int thickness_;
	string method_;
	int pivot_;
	int factor_;
	int count_;
	int tolerance_;
	double reference_;
	double interval_;
	doublearray list_;
	bool shade_;
	double max_;
	double min_;
	string direction_;
	stringarray colours_;
	string priority_key_;
	string colour_key_;
	stringarray colour_list_;
	doublearray colour_level_list_;
	string style_key_;
	stringarray style_list_;
	doublearray style_level_list_;
	string thickness_key_;
	doublearray thickness_list_;
	doublearray thickness_level_list_;
	string transparency_key_;
	string pivot_key_;
	string pivot_marker_;
	string pivot_marker_name_;
	double pivot_marker_height_;
	doublearray transparency_level_list_;
	bool legend_only_;
	unique_ptr<Colour> colour_;
	LineStyle style_;
	unique_ptr<LevelSelection> levelSelection_;
	unique_ptr<ColourTechnique> colourMethod_;
	unique_ptr<Colour> maxColour_;
	unique_ptr<Colour> minColour_;
	ListPolicy colour_policy_;
	ListPolicy style_policy_;
	ListPolicy thickness_policy_;
	unique_ptr<Colour> pivot_marker_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const SimplePolylineAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

