-- $Id: q19-tpch19.sql 2657 2007-06-12 16:08:15Z rdempsey $
-- 19th query in 100 GB stream0 (tpch19).

SELECT 
	SUM(L_EXTENDEDPRICE * (1 - L_DISCOUNT)) AS REVENUE
FROM 
	LINEITEM,
	PART
WHERE 
	(
		P_PARTKEY = L_PARTKEY AND
		P_BRAND = 'Brand#41' AND 
		P_CONTAINER IN ( 'SM CASE', 'SM BOX', 'SM PACK', 'SM PKG') AND
		L_QUANTITY >= 3 AND L_QUANTITY <= 3 + 10 AND 
		P_SIZE BETWEEN 1 AND 5 AND
		L_SHIPMODE IN ('AIR', 'AIR REG') AND
		L_SHIPINSTRUCT = 'DELIVER IN PERSON'
	)
	OR
	( 
		P_PARTKEY = L_PARTKEY AND
		P_BRAND = 'Brand#33' AND
		P_CONTAINER IN ( 'MED BAG', 'MED BOX', 'MED PKG', 'MED PACK') AND
		L_QUANTITY >= 14 AND L_QUANTITY <= 14 + 10 AND
		P_SIZE BETWEEN 1 AND 10 AND
		L_SHIPMODE IN ('AIR', 'AIR REG') AND
		L_SHIPINSTRUCT = 'DELIVER IN PERSON'
	)
	OR
	( 
		P_PARTKEY = L_PARTKEY AND
		P_BRAND = 'Brand#45' AND
		P_CONTAINER IN ( 'LG CASE', 'LG BOX', 'LG PACK', 'LG PKG') AND
		L_QUANTITY >= 25 AND L_QUANTITY <= 25 + 10 AND
		P_SIZE BETWEEN 1 AND 15 AND
		L_SHIPMODE IN ('AIR', 'AIR REG') AND
		L_SHIPINSTRUCT = 'DELIVER IN PERSON'
	);
